/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.config.ConfigAsyncClient;
import software.amazon.awssdk.services.config.ConfigServiceClientConfiguration;
import software.amazon.awssdk.services.config.internal.ConfigServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.config.model.AssociateResourceTypesRequest;
import software.amazon.awssdk.services.config.model.AssociateResourceTypesResponse;
import software.amazon.awssdk.services.config.model.BatchGetAggregateResourceConfigRequest;
import software.amazon.awssdk.services.config.model.BatchGetAggregateResourceConfigResponse;
import software.amazon.awssdk.services.config.model.BatchGetResourceConfigRequest;
import software.amazon.awssdk.services.config.model.BatchGetResourceConfigResponse;
import software.amazon.awssdk.services.config.model.ConfigException;
import software.amazon.awssdk.services.config.model.ConflictException;
import software.amazon.awssdk.services.config.model.ConformancePackTemplateValidationException;
import software.amazon.awssdk.services.config.model.DeleteAggregationAuthorizationRequest;
import software.amazon.awssdk.services.config.model.DeleteAggregationAuthorizationResponse;
import software.amazon.awssdk.services.config.model.DeleteConfigRuleRequest;
import software.amazon.awssdk.services.config.model.DeleteConfigRuleResponse;
import software.amazon.awssdk.services.config.model.DeleteConfigurationAggregatorRequest;
import software.amazon.awssdk.services.config.model.DeleteConfigurationAggregatorResponse;
import software.amazon.awssdk.services.config.model.DeleteConfigurationRecorderRequest;
import software.amazon.awssdk.services.config.model.DeleteConfigurationRecorderResponse;
import software.amazon.awssdk.services.config.model.DeleteConformancePackRequest;
import software.amazon.awssdk.services.config.model.DeleteConformancePackResponse;
import software.amazon.awssdk.services.config.model.DeleteDeliveryChannelRequest;
import software.amazon.awssdk.services.config.model.DeleteDeliveryChannelResponse;
import software.amazon.awssdk.services.config.model.DeleteEvaluationResultsRequest;
import software.amazon.awssdk.services.config.model.DeleteEvaluationResultsResponse;
import software.amazon.awssdk.services.config.model.DeleteOrganizationConfigRuleRequest;
import software.amazon.awssdk.services.config.model.DeleteOrganizationConfigRuleResponse;
import software.amazon.awssdk.services.config.model.DeleteOrganizationConformancePackRequest;
import software.amazon.awssdk.services.config.model.DeleteOrganizationConformancePackResponse;
import software.amazon.awssdk.services.config.model.DeletePendingAggregationRequestRequest;
import software.amazon.awssdk.services.config.model.DeletePendingAggregationRequestResponse;
import software.amazon.awssdk.services.config.model.DeleteRemediationConfigurationRequest;
import software.amazon.awssdk.services.config.model.DeleteRemediationConfigurationResponse;
import software.amazon.awssdk.services.config.model.DeleteRemediationExceptionsRequest;
import software.amazon.awssdk.services.config.model.DeleteRemediationExceptionsResponse;
import software.amazon.awssdk.services.config.model.DeleteResourceConfigRequest;
import software.amazon.awssdk.services.config.model.DeleteResourceConfigResponse;
import software.amazon.awssdk.services.config.model.DeleteRetentionConfigurationRequest;
import software.amazon.awssdk.services.config.model.DeleteRetentionConfigurationResponse;
import software.amazon.awssdk.services.config.model.DeleteServiceLinkedConfigurationRecorderRequest;
import software.amazon.awssdk.services.config.model.DeleteServiceLinkedConfigurationRecorderResponse;
import software.amazon.awssdk.services.config.model.DeleteStoredQueryRequest;
import software.amazon.awssdk.services.config.model.DeleteStoredQueryResponse;
import software.amazon.awssdk.services.config.model.DeliverConfigSnapshotRequest;
import software.amazon.awssdk.services.config.model.DeliverConfigSnapshotResponse;
import software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConfigRulesRequest;
import software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConfigRulesResponse;
import software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConformancePacksRequest;
import software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConformancePacksResponse;
import software.amazon.awssdk.services.config.model.DescribeAggregationAuthorizationsRequest;
import software.amazon.awssdk.services.config.model.DescribeAggregationAuthorizationsResponse;
import software.amazon.awssdk.services.config.model.DescribeComplianceByConfigRuleRequest;
import software.amazon.awssdk.services.config.model.DescribeComplianceByConfigRuleResponse;
import software.amazon.awssdk.services.config.model.DescribeComplianceByResourceRequest;
import software.amazon.awssdk.services.config.model.DescribeComplianceByResourceResponse;
import software.amazon.awssdk.services.config.model.DescribeConfigRuleEvaluationStatusRequest;
import software.amazon.awssdk.services.config.model.DescribeConfigRuleEvaluationStatusResponse;
import software.amazon.awssdk.services.config.model.DescribeConfigRulesRequest;
import software.amazon.awssdk.services.config.model.DescribeConfigRulesResponse;
import software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorSourcesStatusRequest;
import software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorSourcesStatusResponse;
import software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorsRequest;
import software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorsResponse;
import software.amazon.awssdk.services.config.model.DescribeConfigurationRecorderStatusRequest;
import software.amazon.awssdk.services.config.model.DescribeConfigurationRecorderStatusResponse;
import software.amazon.awssdk.services.config.model.DescribeConfigurationRecordersRequest;
import software.amazon.awssdk.services.config.model.DescribeConfigurationRecordersResponse;
import software.amazon.awssdk.services.config.model.DescribeConformancePackComplianceRequest;
import software.amazon.awssdk.services.config.model.DescribeConformancePackComplianceResponse;
import software.amazon.awssdk.services.config.model.DescribeConformancePackStatusRequest;
import software.amazon.awssdk.services.config.model.DescribeConformancePackStatusResponse;
import software.amazon.awssdk.services.config.model.DescribeConformancePacksRequest;
import software.amazon.awssdk.services.config.model.DescribeConformancePacksResponse;
import software.amazon.awssdk.services.config.model.DescribeDeliveryChannelStatusRequest;
import software.amazon.awssdk.services.config.model.DescribeDeliveryChannelStatusResponse;
import software.amazon.awssdk.services.config.model.DescribeDeliveryChannelsRequest;
import software.amazon.awssdk.services.config.model.DescribeDeliveryChannelsResponse;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRuleStatusesRequest;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRuleStatusesResponse;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRulesRequest;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRulesResponse;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePackStatusesRequest;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePackStatusesResponse;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePacksRequest;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePacksResponse;
import software.amazon.awssdk.services.config.model.DescribePendingAggregationRequestsRequest;
import software.amazon.awssdk.services.config.model.DescribePendingAggregationRequestsResponse;
import software.amazon.awssdk.services.config.model.DescribeRemediationConfigurationsRequest;
import software.amazon.awssdk.services.config.model.DescribeRemediationConfigurationsResponse;
import software.amazon.awssdk.services.config.model.DescribeRemediationExceptionsRequest;
import software.amazon.awssdk.services.config.model.DescribeRemediationExceptionsResponse;
import software.amazon.awssdk.services.config.model.DescribeRemediationExecutionStatusRequest;
import software.amazon.awssdk.services.config.model.DescribeRemediationExecutionStatusResponse;
import software.amazon.awssdk.services.config.model.DescribeRetentionConfigurationsRequest;
import software.amazon.awssdk.services.config.model.DescribeRetentionConfigurationsResponse;
import software.amazon.awssdk.services.config.model.DisassociateResourceTypesRequest;
import software.amazon.awssdk.services.config.model.DisassociateResourceTypesResponse;
import software.amazon.awssdk.services.config.model.GetAggregateComplianceDetailsByConfigRuleRequest;
import software.amazon.awssdk.services.config.model.GetAggregateComplianceDetailsByConfigRuleResponse;
import software.amazon.awssdk.services.config.model.GetAggregateConfigRuleComplianceSummaryRequest;
import software.amazon.awssdk.services.config.model.GetAggregateConfigRuleComplianceSummaryResponse;
import software.amazon.awssdk.services.config.model.GetAggregateConformancePackComplianceSummaryRequest;
import software.amazon.awssdk.services.config.model.GetAggregateConformancePackComplianceSummaryResponse;
import software.amazon.awssdk.services.config.model.GetAggregateDiscoveredResourceCountsRequest;
import software.amazon.awssdk.services.config.model.GetAggregateDiscoveredResourceCountsResponse;
import software.amazon.awssdk.services.config.model.GetAggregateResourceConfigRequest;
import software.amazon.awssdk.services.config.model.GetAggregateResourceConfigResponse;
import software.amazon.awssdk.services.config.model.GetComplianceDetailsByConfigRuleRequest;
import software.amazon.awssdk.services.config.model.GetComplianceDetailsByConfigRuleResponse;
import software.amazon.awssdk.services.config.model.GetComplianceDetailsByResourceRequest;
import software.amazon.awssdk.services.config.model.GetComplianceDetailsByResourceResponse;
import software.amazon.awssdk.services.config.model.GetComplianceSummaryByConfigRuleRequest;
import software.amazon.awssdk.services.config.model.GetComplianceSummaryByConfigRuleResponse;
import software.amazon.awssdk.services.config.model.GetComplianceSummaryByResourceTypeRequest;
import software.amazon.awssdk.services.config.model.GetComplianceSummaryByResourceTypeResponse;
import software.amazon.awssdk.services.config.model.GetConformancePackComplianceDetailsRequest;
import software.amazon.awssdk.services.config.model.GetConformancePackComplianceDetailsResponse;
import software.amazon.awssdk.services.config.model.GetConformancePackComplianceSummaryRequest;
import software.amazon.awssdk.services.config.model.GetConformancePackComplianceSummaryResponse;
import software.amazon.awssdk.services.config.model.GetCustomRulePolicyRequest;
import software.amazon.awssdk.services.config.model.GetCustomRulePolicyResponse;
import software.amazon.awssdk.services.config.model.GetDiscoveredResourceCountsRequest;
import software.amazon.awssdk.services.config.model.GetDiscoveredResourceCountsResponse;
import software.amazon.awssdk.services.config.model.GetOrganizationConfigRuleDetailedStatusRequest;
import software.amazon.awssdk.services.config.model.GetOrganizationConfigRuleDetailedStatusResponse;
import software.amazon.awssdk.services.config.model.GetOrganizationConformancePackDetailedStatusRequest;
import software.amazon.awssdk.services.config.model.GetOrganizationConformancePackDetailedStatusResponse;
import software.amazon.awssdk.services.config.model.GetOrganizationCustomRulePolicyRequest;
import software.amazon.awssdk.services.config.model.GetOrganizationCustomRulePolicyResponse;
import software.amazon.awssdk.services.config.model.GetResourceConfigHistoryRequest;
import software.amazon.awssdk.services.config.model.GetResourceConfigHistoryResponse;
import software.amazon.awssdk.services.config.model.GetResourceEvaluationSummaryRequest;
import software.amazon.awssdk.services.config.model.GetResourceEvaluationSummaryResponse;
import software.amazon.awssdk.services.config.model.GetStoredQueryRequest;
import software.amazon.awssdk.services.config.model.GetStoredQueryResponse;
import software.amazon.awssdk.services.config.model.IdempotentParameterMismatchException;
import software.amazon.awssdk.services.config.model.InsufficientDeliveryPolicyException;
import software.amazon.awssdk.services.config.model.InsufficientPermissionsException;
import software.amazon.awssdk.services.config.model.InvalidConfigurationRecorderNameException;
import software.amazon.awssdk.services.config.model.InvalidDeliveryChannelNameException;
import software.amazon.awssdk.services.config.model.InvalidExpressionException;
import software.amazon.awssdk.services.config.model.InvalidLimitException;
import software.amazon.awssdk.services.config.model.InvalidNextTokenException;
import software.amazon.awssdk.services.config.model.InvalidParameterValueException;
import software.amazon.awssdk.services.config.model.InvalidRecordingGroupException;
import software.amazon.awssdk.services.config.model.InvalidResultTokenException;
import software.amazon.awssdk.services.config.model.InvalidRoleException;
import software.amazon.awssdk.services.config.model.InvalidS3KeyPrefixException;
import software.amazon.awssdk.services.config.model.InvalidS3KmsKeyArnException;
import software.amazon.awssdk.services.config.model.InvalidSnsTopicArnException;
import software.amazon.awssdk.services.config.model.InvalidTimeRangeException;
import software.amazon.awssdk.services.config.model.LastDeliveryChannelDeleteFailedException;
import software.amazon.awssdk.services.config.model.LimitExceededException;
import software.amazon.awssdk.services.config.model.ListAggregateDiscoveredResourcesRequest;
import software.amazon.awssdk.services.config.model.ListAggregateDiscoveredResourcesResponse;
import software.amazon.awssdk.services.config.model.ListConfigurationRecordersRequest;
import software.amazon.awssdk.services.config.model.ListConfigurationRecordersResponse;
import software.amazon.awssdk.services.config.model.ListConformancePackComplianceScoresRequest;
import software.amazon.awssdk.services.config.model.ListConformancePackComplianceScoresResponse;
import software.amazon.awssdk.services.config.model.ListDiscoveredResourcesRequest;
import software.amazon.awssdk.services.config.model.ListDiscoveredResourcesResponse;
import software.amazon.awssdk.services.config.model.ListResourceEvaluationsRequest;
import software.amazon.awssdk.services.config.model.ListResourceEvaluationsResponse;
import software.amazon.awssdk.services.config.model.ListStoredQueriesRequest;
import software.amazon.awssdk.services.config.model.ListStoredQueriesResponse;
import software.amazon.awssdk.services.config.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.config.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.config.model.MaxActiveResourcesExceededException;
import software.amazon.awssdk.services.config.model.MaxNumberOfConfigRulesExceededException;
import software.amazon.awssdk.services.config.model.MaxNumberOfConfigurationRecordersExceededException;
import software.amazon.awssdk.services.config.model.MaxNumberOfConformancePacksExceededException;
import software.amazon.awssdk.services.config.model.MaxNumberOfDeliveryChannelsExceededException;
import software.amazon.awssdk.services.config.model.MaxNumberOfOrganizationConfigRulesExceededException;
import software.amazon.awssdk.services.config.model.MaxNumberOfOrganizationConformancePacksExceededException;
import software.amazon.awssdk.services.config.model.MaxNumberOfRetentionConfigurationsExceededException;
import software.amazon.awssdk.services.config.model.NoAvailableConfigurationRecorderException;
import software.amazon.awssdk.services.config.model.NoAvailableDeliveryChannelException;
import software.amazon.awssdk.services.config.model.NoAvailableOrganizationException;
import software.amazon.awssdk.services.config.model.NoRunningConfigurationRecorderException;
import software.amazon.awssdk.services.config.model.NoSuchBucketException;
import software.amazon.awssdk.services.config.model.NoSuchConfigRuleException;
import software.amazon.awssdk.services.config.model.NoSuchConfigRuleInConformancePackException;
import software.amazon.awssdk.services.config.model.NoSuchConfigurationAggregatorException;
import software.amazon.awssdk.services.config.model.NoSuchConfigurationRecorderException;
import software.amazon.awssdk.services.config.model.NoSuchConformancePackException;
import software.amazon.awssdk.services.config.model.NoSuchDeliveryChannelException;
import software.amazon.awssdk.services.config.model.NoSuchOrganizationConfigRuleException;
import software.amazon.awssdk.services.config.model.NoSuchOrganizationConformancePackException;
import software.amazon.awssdk.services.config.model.NoSuchRemediationConfigurationException;
import software.amazon.awssdk.services.config.model.NoSuchRemediationExceptionException;
import software.amazon.awssdk.services.config.model.NoSuchRetentionConfigurationException;
import software.amazon.awssdk.services.config.model.OrganizationAccessDeniedException;
import software.amazon.awssdk.services.config.model.OrganizationAllFeaturesNotEnabledException;
import software.amazon.awssdk.services.config.model.OrganizationConformancePackTemplateValidationException;
import software.amazon.awssdk.services.config.model.OversizedConfigurationItemException;
import software.amazon.awssdk.services.config.model.PutAggregationAuthorizationRequest;
import software.amazon.awssdk.services.config.model.PutAggregationAuthorizationResponse;
import software.amazon.awssdk.services.config.model.PutConfigRuleRequest;
import software.amazon.awssdk.services.config.model.PutConfigRuleResponse;
import software.amazon.awssdk.services.config.model.PutConfigurationAggregatorRequest;
import software.amazon.awssdk.services.config.model.PutConfigurationAggregatorResponse;
import software.amazon.awssdk.services.config.model.PutConfigurationRecorderRequest;
import software.amazon.awssdk.services.config.model.PutConfigurationRecorderResponse;
import software.amazon.awssdk.services.config.model.PutConformancePackRequest;
import software.amazon.awssdk.services.config.model.PutConformancePackResponse;
import software.amazon.awssdk.services.config.model.PutDeliveryChannelRequest;
import software.amazon.awssdk.services.config.model.PutDeliveryChannelResponse;
import software.amazon.awssdk.services.config.model.PutEvaluationsRequest;
import software.amazon.awssdk.services.config.model.PutEvaluationsResponse;
import software.amazon.awssdk.services.config.model.PutExternalEvaluationRequest;
import software.amazon.awssdk.services.config.model.PutExternalEvaluationResponse;
import software.amazon.awssdk.services.config.model.PutOrganizationConfigRuleRequest;
import software.amazon.awssdk.services.config.model.PutOrganizationConfigRuleResponse;
import software.amazon.awssdk.services.config.model.PutOrganizationConformancePackRequest;
import software.amazon.awssdk.services.config.model.PutOrganizationConformancePackResponse;
import software.amazon.awssdk.services.config.model.PutRemediationConfigurationsRequest;
import software.amazon.awssdk.services.config.model.PutRemediationConfigurationsResponse;
import software.amazon.awssdk.services.config.model.PutRemediationExceptionsRequest;
import software.amazon.awssdk.services.config.model.PutRemediationExceptionsResponse;
import software.amazon.awssdk.services.config.model.PutResourceConfigRequest;
import software.amazon.awssdk.services.config.model.PutResourceConfigResponse;
import software.amazon.awssdk.services.config.model.PutRetentionConfigurationRequest;
import software.amazon.awssdk.services.config.model.PutRetentionConfigurationResponse;
import software.amazon.awssdk.services.config.model.PutServiceLinkedConfigurationRecorderRequest;
import software.amazon.awssdk.services.config.model.PutServiceLinkedConfigurationRecorderResponse;
import software.amazon.awssdk.services.config.model.PutStoredQueryRequest;
import software.amazon.awssdk.services.config.model.PutStoredQueryResponse;
import software.amazon.awssdk.services.config.model.RemediationInProgressException;
import software.amazon.awssdk.services.config.model.ResourceConcurrentModificationException;
import software.amazon.awssdk.services.config.model.ResourceInUseException;
import software.amazon.awssdk.services.config.model.ResourceNotDiscoveredException;
import software.amazon.awssdk.services.config.model.ResourceNotFoundException;
import software.amazon.awssdk.services.config.model.SelectAggregateResourceConfigRequest;
import software.amazon.awssdk.services.config.model.SelectAggregateResourceConfigResponse;
import software.amazon.awssdk.services.config.model.SelectResourceConfigRequest;
import software.amazon.awssdk.services.config.model.SelectResourceConfigResponse;
import software.amazon.awssdk.services.config.model.StartConfigRulesEvaluationRequest;
import software.amazon.awssdk.services.config.model.StartConfigRulesEvaluationResponse;
import software.amazon.awssdk.services.config.model.StartConfigurationRecorderRequest;
import software.amazon.awssdk.services.config.model.StartConfigurationRecorderResponse;
import software.amazon.awssdk.services.config.model.StartRemediationExecutionRequest;
import software.amazon.awssdk.services.config.model.StartRemediationExecutionResponse;
import software.amazon.awssdk.services.config.model.StartResourceEvaluationRequest;
import software.amazon.awssdk.services.config.model.StartResourceEvaluationResponse;
import software.amazon.awssdk.services.config.model.StopConfigurationRecorderRequest;
import software.amazon.awssdk.services.config.model.StopConfigurationRecorderResponse;
import software.amazon.awssdk.services.config.model.TagResourceRequest;
import software.amazon.awssdk.services.config.model.TagResourceResponse;
import software.amazon.awssdk.services.config.model.TooManyTagsException;
import software.amazon.awssdk.services.config.model.UnmodifiableEntityException;
import software.amazon.awssdk.services.config.model.UntagResourceRequest;
import software.amazon.awssdk.services.config.model.UntagResourceResponse;
import software.amazon.awssdk.services.config.model.ValidationException;
import software.amazon.awssdk.services.config.transform.AssociateResourceTypesRequestMarshaller;
import software.amazon.awssdk.services.config.transform.BatchGetAggregateResourceConfigRequestMarshaller;
import software.amazon.awssdk.services.config.transform.BatchGetResourceConfigRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteAggregationAuthorizationRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteConfigRuleRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteConfigurationAggregatorRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteConfigurationRecorderRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteConformancePackRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteDeliveryChannelRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteEvaluationResultsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteOrganizationConfigRuleRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteOrganizationConformancePackRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeletePendingAggregationRequestRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteRemediationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteRemediationExceptionsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteResourceConfigRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteRetentionConfigurationRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteServiceLinkedConfigurationRecorderRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteStoredQueryRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeliverConfigSnapshotRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeAggregateComplianceByConfigRulesRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeAggregateComplianceByConformancePacksRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeAggregationAuthorizationsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeComplianceByConfigRuleRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeComplianceByResourceRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeConfigRuleEvaluationStatusRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeConfigRulesRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeConfigurationAggregatorSourcesStatusRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeConfigurationAggregatorsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeConfigurationRecorderStatusRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeConfigurationRecordersRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeConformancePackComplianceRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeConformancePackStatusRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeConformancePacksRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeDeliveryChannelStatusRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeDeliveryChannelsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeOrganizationConfigRuleStatusesRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeOrganizationConfigRulesRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeOrganizationConformancePackStatusesRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeOrganizationConformancePacksRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribePendingAggregationRequestsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeRemediationConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeRemediationExceptionsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeRemediationExecutionStatusRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeRetentionConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DisassociateResourceTypesRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetAggregateComplianceDetailsByConfigRuleRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetAggregateConfigRuleComplianceSummaryRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetAggregateConformancePackComplianceSummaryRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetAggregateDiscoveredResourceCountsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetAggregateResourceConfigRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetComplianceDetailsByConfigRuleRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetComplianceDetailsByResourceRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetComplianceSummaryByConfigRuleRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetComplianceSummaryByResourceTypeRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetConformancePackComplianceDetailsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetConformancePackComplianceSummaryRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetCustomRulePolicyRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetDiscoveredResourceCountsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetOrganizationConfigRuleDetailedStatusRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetOrganizationConformancePackDetailedStatusRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetOrganizationCustomRulePolicyRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetResourceConfigHistoryRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetResourceEvaluationSummaryRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetStoredQueryRequestMarshaller;
import software.amazon.awssdk.services.config.transform.ListAggregateDiscoveredResourcesRequestMarshaller;
import software.amazon.awssdk.services.config.transform.ListConfigurationRecordersRequestMarshaller;
import software.amazon.awssdk.services.config.transform.ListConformancePackComplianceScoresRequestMarshaller;
import software.amazon.awssdk.services.config.transform.ListDiscoveredResourcesRequestMarshaller;
import software.amazon.awssdk.services.config.transform.ListResourceEvaluationsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.ListStoredQueriesRequestMarshaller;
import software.amazon.awssdk.services.config.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutAggregationAuthorizationRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutConfigRuleRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutConfigurationAggregatorRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutConfigurationRecorderRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutConformancePackRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutDeliveryChannelRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutEvaluationsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutExternalEvaluationRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutOrganizationConfigRuleRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutOrganizationConformancePackRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutRemediationConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutRemediationExceptionsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutResourceConfigRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutRetentionConfigurationRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutServiceLinkedConfigurationRecorderRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutStoredQueryRequestMarshaller;
import software.amazon.awssdk.services.config.transform.SelectAggregateResourceConfigRequestMarshaller;
import software.amazon.awssdk.services.config.transform.SelectResourceConfigRequestMarshaller;
import software.amazon.awssdk.services.config.transform.StartConfigRulesEvaluationRequestMarshaller;
import software.amazon.awssdk.services.config.transform.StartConfigurationRecorderRequestMarshaller;
import software.amazon.awssdk.services.config.transform.StartRemediationExecutionRequestMarshaller;
import software.amazon.awssdk.services.config.transform.StartResourceEvaluationRequestMarshaller;
import software.amazon.awssdk.services.config.transform.StopConfigurationRecorderRequestMarshaller;
import software.amazon.awssdk.services.config.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.config.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultConfigAsyncClient
implements ConfigAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultConfigAsyncClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultConfigAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"Config_Service#2.34.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public CompletableFuture<AssociateResourceTypesResponse> associateResourceTypes(AssociateResourceTypesRequest associateResourceTypesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)associateResourceTypesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigAsyncClient.resolveMetricPublishers(clientConfiguration, associateResourceTypesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateResourceTypes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateResourceTypesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "NoRunningConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                    }
                    case "OrganizationConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                    }
                    case "UnmodifiableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                    }
                    case "NoSuchRetentionConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                    }
                    case "ResourceConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                    }
                    case "NoSuchConfigurationAggregatorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                    }
                    case "RemediationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                    }
                    case "NoAvailableConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "OrganizationAllFeaturesNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                    }
                    case "InvalidLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                    }
                    case "NoSuchOrganizationConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                    }
                    case "MaxNumberOfDeliveryChannelsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "MaxNumberOfConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                    }
                    case "InvalidExpressionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                    }
                    case "NoSuchOrganizationConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRecordingGroupException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MaxNumberOfRetentionConfigurationsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                    }
                    case "InvalidDeliveryChannelNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                    }
                    case "ConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                    }
                    case "InvalidS3KeyPrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                    }
                    case "ResourceNotDiscoveredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                    }
                    case "NoSuchRemediationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                    }
                    case "NoAvailableDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                    }
                    case "NoSuchRemediationExceptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                    }
                    case "InvalidResultTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                    }
                    case "OversizedConfigurationItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                    }
                    case "InsufficientDeliveryPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                    }
                    case "OrganizationAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                    }
                    case "NoAvailableOrganizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                    }
                    case "NoSuchDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                    }
                    case "LastDeliveryChannelDeleteFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "IdempotentParameterMismatch": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "NoSuchConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "InvalidSNSTopicARNException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                    }
                    case "MaxActiveResourcesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "NoSuchConfigRuleInConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConfigurationRecordersExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                    }
                    case "NoSuchConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                    }
                    case "InvalidS3KmsKeyArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                    }
                    case "NoSuchBucketException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                    }
                    case "InvalidConfigurationRecorderNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "NoSuchConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                    }
                    case "InvalidRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateResourceTypes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AssociateResourceTypesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)associateResourceTypesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultConfigAsyncClient.lambda$associateResourceTypes$2(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultConfigAsyncClient.lambda$associateResourceTypes$3((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<BatchGetAggregateResourceConfigResponse> batchGetAggregateResourceConfig(BatchGetAggregateResourceConfigRequest batchGetAggregateResourceConfigRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchGetAggregateResourceConfigRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigAsyncClient.resolveMetricPublishers(clientConfiguration, batchGetAggregateResourceConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchGetAggregateResourceConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchGetAggregateResourceConfigResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "NoRunningConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                    }
                    case "OrganizationConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                    }
                    case "UnmodifiableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                    }
                    case "NoSuchRetentionConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                    }
                    case "ResourceConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                    }
                    case "NoSuchConfigurationAggregatorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                    }
                    case "RemediationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                    }
                    case "NoAvailableConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "OrganizationAllFeaturesNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                    }
                    case "InvalidLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                    }
                    case "NoSuchOrganizationConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                    }
                    case "MaxNumberOfDeliveryChannelsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "MaxNumberOfConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                    }
                    case "InvalidExpressionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                    }
                    case "NoSuchOrganizationConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRecordingGroupException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MaxNumberOfRetentionConfigurationsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                    }
                    case "InvalidDeliveryChannelNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                    }
                    case "ConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                    }
                    case "InvalidS3KeyPrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                    }
                    case "ResourceNotDiscoveredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                    }
                    case "NoSuchRemediationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                    }
                    case "NoAvailableDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                    }
                    case "NoSuchRemediationExceptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                    }
                    case "InvalidResultTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                    }
                    case "OversizedConfigurationItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                    }
                    case "InsufficientDeliveryPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                    }
                    case "OrganizationAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                    }
                    case "NoAvailableOrganizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                    }
                    case "NoSuchDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                    }
                    case "LastDeliveryChannelDeleteFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "IdempotentParameterMismatch": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "NoSuchConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "InvalidSNSTopicARNException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                    }
                    case "MaxActiveResourcesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "NoSuchConfigRuleInConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConfigurationRecordersExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                    }
                    case "NoSuchConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                    }
                    case "InvalidS3KmsKeyArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                    }
                    case "NoSuchBucketException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                    }
                    case "InvalidConfigurationRecorderNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "NoSuchConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                    }
                    case "InvalidRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchGetAggregateResourceConfig").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new BatchGetAggregateResourceConfigRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)batchGetAggregateResourceConfigRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultConfigAsyncClient.lambda$batchGetAggregateResourceConfig$6(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultConfigAsyncClient.lambda$batchGetAggregateResourceConfig$7((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<BatchGetResourceConfigResponse> batchGetResourceConfig(BatchGetResourceConfigRequest batchGetResourceConfigRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchGetResourceConfigRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigAsyncClient.resolveMetricPublishers(clientConfiguration, batchGetResourceConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchGetResourceConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchGetResourceConfigResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "NoRunningConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                    }
                    case "OrganizationConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                    }
                    case "UnmodifiableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                    }
                    case "NoSuchRetentionConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                    }
                    case "ResourceConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                    }
                    case "NoSuchConfigurationAggregatorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                    }
                    case "RemediationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                    }
                    case "NoAvailableConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "OrganizationAllFeaturesNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                    }
                    case "InvalidLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                    }
                    case "NoSuchOrganizationConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                    }
                    case "MaxNumberOfDeliveryChannelsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "MaxNumberOfConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                    }
                    case "InvalidExpressionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                    }
                    case "NoSuchOrganizationConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRecordingGroupException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MaxNumberOfRetentionConfigurationsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                    }
                    case "InvalidDeliveryChannelNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                    }
                    case "ConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                    }
                    case "InvalidS3KeyPrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                    }
                    case "ResourceNotDiscoveredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                    }
                    case "NoSuchRemediationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                    }
                    case "NoAvailableDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                    }
                    case "NoSuchRemediationExceptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                    }
                    case "InvalidResultTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                    }
                    case "OversizedConfigurationItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                    }
                    case "InsufficientDeliveryPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                    }
                    case "OrganizationAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                    }
                    case "NoAvailableOrganizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                    }
                    case "NoSuchDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                    }
                    case "LastDeliveryChannelDeleteFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "IdempotentParameterMismatch": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "NoSuchConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "InvalidSNSTopicARNException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                    }
                    case "MaxActiveResourcesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "NoSuchConfigRuleInConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConfigurationRecordersExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                    }
                    case "NoSuchConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                    }
                    case "InvalidS3KmsKeyArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                    }
                    case "NoSuchBucketException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                    }
                    case "InvalidConfigurationRecorderNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "NoSuchConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                    }
                    case "InvalidRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchGetResourceConfig").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new BatchGetResourceConfigRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)batchGetResourceConfigRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultConfigAsyncClient.lambda$batchGetResourceConfig$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultConfigAsyncClient.lambda$batchGetResourceConfig$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteAggregationAuthorizationResponse> deleteAggregationAuthorization(DeleteAggregationAuthorizationRequest deleteAggregationAuthorizationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteAggregationAuthorizationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigAsyncClient.resolveMetricPublishers(clientConfiguration, deleteAggregationAuthorizationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAggregationAuthorization");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAggregationAuthorizationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "NoRunningConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                    }
                    case "OrganizationConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                    }
                    case "UnmodifiableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                    }
                    case "NoSuchRetentionConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                    }
                    case "ResourceConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                    }
                    case "NoSuchConfigurationAggregatorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                    }
                    case "RemediationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                    }
                    case "NoAvailableConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "OrganizationAllFeaturesNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                    }
                    case "InvalidLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                    }
                    case "NoSuchOrganizationConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                    }
                    case "MaxNumberOfDeliveryChannelsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "MaxNumberOfConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                    }
                    case "InvalidExpressionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                    }
                    case "NoSuchOrganizationConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRecordingGroupException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MaxNumberOfRetentionConfigurationsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                    }
                    case "InvalidDeliveryChannelNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                    }
                    case "ConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                    }
                    case "InvalidS3KeyPrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                    }
                    case "ResourceNotDiscoveredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                    }
                    case "NoSuchRemediationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                    }
                    case "NoAvailableDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                    }
                    case "NoSuchRemediationExceptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                    }
                    case "InvalidResultTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                    }
                    case "OversizedConfigurationItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                    }
                    case "InsufficientDeliveryPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                    }
                    case "OrganizationAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                    }
                    case "NoAvailableOrganizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                    }
                    case "NoSuchDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                    }
                    case "LastDeliveryChannelDeleteFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "IdempotentParameterMismatch": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "NoSuchConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "InvalidSNSTopicARNException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                    }
                    case "MaxActiveResourcesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "NoSuchConfigRuleInConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConfigurationRecordersExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                    }
                    case "NoSuchConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                    }
                    case "InvalidS3KmsKeyArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                    }
                    case "NoSuchBucketException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                    }
                    case "InvalidConfigurationRecorderNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "NoSuchConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                    }
                    case "InvalidRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAggregationAuthorization").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteAggregationAuthorizationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteAggregationAuthorizationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultConfigAsyncClient.lambda$deleteAggregationAuthorization$14(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultConfigAsyncClient.lambda$deleteAggregationAuthorization$15((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteConfigRuleResponse> deleteConfigRule(DeleteConfigRuleRequest deleteConfigRuleRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteConfigRuleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigAsyncClient.resolveMetricPublishers(clientConfiguration, deleteConfigRuleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteConfigRule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteConfigRuleResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "NoRunningConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                    }
                    case "OrganizationConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                    }
                    case "UnmodifiableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                    }
                    case "NoSuchRetentionConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                    }
                    case "ResourceConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                    }
                    case "NoSuchConfigurationAggregatorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                    }
                    case "RemediationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                    }
                    case "NoAvailableConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "OrganizationAllFeaturesNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                    }
                    case "InvalidLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                    }
                    case "NoSuchOrganizationConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                    }
                    case "MaxNumberOfDeliveryChannelsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "MaxNumberOfConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                    }
                    case "InvalidExpressionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                    }
                    case "NoSuchOrganizationConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRecordingGroupException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MaxNumberOfRetentionConfigurationsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                    }
                    case "InvalidDeliveryChannelNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                    }
                    case "ConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                    }
                    case "InvalidS3KeyPrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                    }
                    case "ResourceNotDiscoveredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                    }
                    case "NoSuchRemediationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                    }
                    case "NoAvailableDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                    }
                    case "NoSuchRemediationExceptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                    }
                    case "InvalidResultTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                    }
                    case "OversizedConfigurationItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                    }
                    case "InsufficientDeliveryPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                    }
                    case "OrganizationAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                    }
                    case "NoAvailableOrganizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                    }
                    case "NoSuchDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                    }
                    case "LastDeliveryChannelDeleteFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "IdempotentParameterMismatch": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "NoSuchConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "InvalidSNSTopicARNException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                    }
                    case "MaxActiveResourcesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "NoSuchConfigRuleInConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConfigurationRecordersExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                    }
                    case "NoSuchConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                    }
                    case "InvalidS3KmsKeyArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                    }
                    case "NoSuchBucketException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                    }
                    case "InvalidConfigurationRecorderNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "NoSuchConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                    }
                    case "InvalidRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteConfigRule").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteConfigRuleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteConfigRuleRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultConfigAsyncClient.lambda$deleteConfigRule$18(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultConfigAsyncClient.lambda$deleteConfigRule$19((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteConfigurationAggregatorResponse> deleteConfigurationAggregator(DeleteConfigurationAggregatorRequest deleteConfigurationAggregatorRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteConfigurationAggregatorRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigAsyncClient.resolveMetricPublishers(clientConfiguration, deleteConfigurationAggregatorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteConfigurationAggregator");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteConfigurationAggregatorResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "NoRunningConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                    }
                    case "OrganizationConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                    }
                    case "UnmodifiableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                    }
                    case "NoSuchRetentionConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                    }
                    case "ResourceConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                    }
                    case "NoSuchConfigurationAggregatorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                    }
                    case "RemediationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                    }
                    case "NoAvailableConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "OrganizationAllFeaturesNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                    }
                    case "InvalidLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                    }
                    case "NoSuchOrganizationConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                    }
                    case "MaxNumberOfDeliveryChannelsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "MaxNumberOfConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                    }
                    case "InvalidExpressionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                    }
                    case "NoSuchOrganizationConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRecordingGroupException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MaxNumberOfRetentionConfigurationsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                    }
                    case "InvalidDeliveryChannelNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                    }
                    case "ConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                    }
                    case "InvalidS3KeyPrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                    }
                    case "ResourceNotDiscoveredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                    }
                    case "NoSuchRemediationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                    }
                    case "NoAvailableDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                    }
                    case "NoSuchRemediationExceptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                    }
                    case "InvalidResultTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                    }
                    case "OversizedConfigurationItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                    }
                    case "InsufficientDeliveryPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                    }
                    case "OrganizationAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                    }
                    case "NoAvailableOrganizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                    }
                    case "NoSuchDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                    }
                    case "LastDeliveryChannelDeleteFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "IdempotentParameterMismatch": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "NoSuchConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "InvalidSNSTopicARNException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                    }
                    case "MaxActiveResourcesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "NoSuchConfigRuleInConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConfigurationRecordersExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                    }
                    case "NoSuchConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                    }
                    case "InvalidS3KmsKeyArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                    }
                    case "NoSuchBucketException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                    }
                    case "InvalidConfigurationRecorderNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "NoSuchConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                    }
                    case "InvalidRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteConfigurationAggregator").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteConfigurationAggregatorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteConfigurationAggregatorRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultConfigAsyncClient.lambda$deleteConfigurationAggregator$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultConfigAsyncClient.lambda$deleteConfigurationAggregator$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteConfigurationRecorderResponse> deleteConfigurationRecorder(DeleteConfigurationRecorderRequest deleteConfigurationRecorderRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteConfigurationRecorderRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigAsyncClient.resolveMetricPublishers(clientConfiguration, deleteConfigurationRecorderRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteConfigurationRecorder");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteConfigurationRecorderResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "NoRunningConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                    }
                    case "OrganizationConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                    }
                    case "UnmodifiableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                    }
                    case "NoSuchRetentionConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                    }
                    case "ResourceConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                    }
                    case "NoSuchConfigurationAggregatorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                    }
                    case "RemediationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                    }
                    case "NoAvailableConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "OrganizationAllFeaturesNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                    }
                    case "InvalidLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                    }
                    case "NoSuchOrganizationConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                    }
                    case "MaxNumberOfDeliveryChannelsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "MaxNumberOfConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                    }
                    case "InvalidExpressionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                    }
                    case "NoSuchOrganizationConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRecordingGroupException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MaxNumberOfRetentionConfigurationsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                    }
                    case "InvalidDeliveryChannelNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                    }
                    case "ConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                    }
                    case "InvalidS3KeyPrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                    }
                    case "ResourceNotDiscoveredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                    }
                    case "NoSuchRemediationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                    }
                    case "NoAvailableDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                    }
                    case "NoSuchRemediationExceptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                    }
                    case "InvalidResultTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                    }
                    case "OversizedConfigurationItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                    }
                    case "InsufficientDeliveryPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                    }
                    case "OrganizationAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                    }
                    case "NoAvailableOrganizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                    }
                    case "NoSuchDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                    }
                    case "LastDeliveryChannelDeleteFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "IdempotentParameterMismatch": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "NoSuchConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "InvalidSNSTopicARNException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                    }
                    case "MaxActiveResourcesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "NoSuchConfigRuleInConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConfigurationRecordersExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                    }
                    case "NoSuchConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                    }
                    case "InvalidS3KmsKeyArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                    }
                    case "NoSuchBucketException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                    }
                    case "InvalidConfigurationRecorderNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "NoSuchConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                    }
                    case "InvalidRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteConfigurationRecorder").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteConfigurationRecorderRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteConfigurationRecorderRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultConfigAsyncClient.lambda$deleteConfigurationRecorder$26(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultConfigAsyncClient.lambda$deleteConfigurationRecorder$27((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteConformancePackResponse> deleteConformancePack(DeleteConformancePackRequest deleteConformancePackRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteConformancePackRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigAsyncClient.resolveMetricPublishers(clientConfiguration, deleteConformancePackRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteConformancePack");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteConformancePackResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "NoRunningConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                    }
                    case "OrganizationConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                    }
                    case "UnmodifiableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                    }
                    case "NoSuchRetentionConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                    }
                    case "ResourceConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                    }
                    case "NoSuchConfigurationAggregatorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                    }
                    case "RemediationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                    }
                    case "NoAvailableConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "OrganizationAllFeaturesNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                    }
                    case "InvalidLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                    }
                    case "NoSuchOrganizationConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                    }
                    case "MaxNumberOfDeliveryChannelsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "MaxNumberOfConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                    }
                    case "InvalidExpressionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                    }
                    case "NoSuchOrganizationConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRecordingGroupException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MaxNumberOfRetentionConfigurationsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                    }
                    case "InvalidDeliveryChannelNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                    }
                    case "ConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                    }
                    case "InvalidS3KeyPrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                    }
                    case "ResourceNotDiscoveredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                    }
                    case "NoSuchRemediationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                    }
                    case "NoAvailableDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                    }
                    case "NoSuchRemediationExceptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                    }
                    case "InvalidResultTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                    }
                    case "OversizedConfigurationItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                    }
                    case "InsufficientDeliveryPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                    }
                    case "OrganizationAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                    }
                    case "NoAvailableOrganizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                    }
                    case "NoSuchDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                    }
                    case "LastDeliveryChannelDeleteFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "IdempotentParameterMismatch": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "NoSuchConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "InvalidSNSTopicARNException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                    }
                    case "MaxActiveResourcesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "NoSuchConfigRuleInConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConfigurationRecordersExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                    }
                    case "NoSuchConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                    }
                    case "InvalidS3KmsKeyArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                    }
                    case "NoSuchBucketException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                    }
                    case "InvalidConfigurationRecorderNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "NoSuchConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                    }
                    case "InvalidRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteConformancePack").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteConformancePackRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteConformancePackRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultConfigAsyncClient.lambda$deleteConformancePack$30(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultConfigAsyncClient.lambda$deleteConformancePack$31((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteDeliveryChannelResponse> deleteDeliveryChannel(DeleteDeliveryChannelRequest deleteDeliveryChannelRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteDeliveryChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigAsyncClient.resolveMetricPublishers(clientConfiguration, deleteDeliveryChannelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDeliveryChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDeliveryChannelResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "NoRunningConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                    }
                    case "OrganizationConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                    }
                    case "UnmodifiableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                    }
                    case "NoSuchRetentionConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                    }
                    case "ResourceConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                    }
                    case "NoSuchConfigurationAggregatorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                    }
                    case "RemediationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                    }
                    case "NoAvailableConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "OrganizationAllFeaturesNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                    }
                    case "InvalidLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                    }
                    case "NoSuchOrganizationConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                    }
                    case "MaxNumberOfDeliveryChannelsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "MaxNumberOfConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                    }
                    case "InvalidExpressionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                    }
                    case "NoSuchOrganizationConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRecordingGroupException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MaxNumberOfRetentionConfigurationsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                    }
                    case "InvalidDeliveryChannelNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                    }
                    case "ConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                    }
                    case "InvalidS3KeyPrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                    }
                    case "ResourceNotDiscoveredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                    }
                    case "NoSuchRemediationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                    }
                    case "NoAvailableDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                    }
                    case "NoSuchRemediationExceptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                    }
                    case "InvalidResultTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                    }
                    case "OversizedConfigurationItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                    }
                    case "InsufficientDeliveryPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                    }
                    case "OrganizationAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                    }
                    case "NoAvailableOrganizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                    }
                    case "NoSuchDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                    }
                    case "LastDeliveryChannelDeleteFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "IdempotentParameterMismatch": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "NoSuchConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "InvalidSNSTopicARNException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                    }
                    case "MaxActiveResourcesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "NoSuchConfigRuleInConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConfigurationRecordersExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                    }
                    case "NoSuchConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                    }
                    case "InvalidS3KmsKeyArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                    }
                    case "NoSuchBucketException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                    }
                    case "InvalidConfigurationRecorderNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "NoSuchConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                    }
                    case "InvalidRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDeliveryChannel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteDeliveryChannelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteDeliveryChannelRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultConfigAsyncClient.lambda$deleteDeliveryChannel$34(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultConfigAsyncClient.lambda$deleteDeliveryChannel$35((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteEvaluationResultsResponse> deleteEvaluationResults(DeleteEvaluationResultsRequest deleteEvaluationResultsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteEvaluationResultsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigAsyncClient.resolveMetricPublishers(clientConfiguration, deleteEvaluationResultsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteEvaluationResults");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteEvaluationResultsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "NoRunningConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                    }
                    case "OrganizationConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                    }
                    case "UnmodifiableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                    }
                    case "NoSuchRetentionConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                    }
                    case "ResourceConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                    }
                    case "NoSuchConfigurationAggregatorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                    }
                    case "RemediationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                    }
                    case "NoAvailableConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "OrganizationAllFeaturesNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                    }
                    case "InvalidLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                    }
                    case "NoSuchOrganizationConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                    }
                    case "MaxNumberOfDeliveryChannelsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "MaxNumberOfConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                    }
                    case "InvalidExpressionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                    }
                    case "NoSuchOrganizationConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRecordingGroupException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MaxNumberOfRetentionConfigurationsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                    }
                    case "InvalidDeliveryChannelNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                    }
                    case "ConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                    }
                    case "InvalidS3KeyPrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                    }
                    case "ResourceNotDiscoveredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                    }
                    case "NoSuchRemediationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                    }
                    case "NoAvailableDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                    }
                    case "NoSuchRemediationExceptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                    }
                    case "InvalidResultTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                    }
                    case "OversizedConfigurationItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                    }
                    case "InsufficientDeliveryPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                    }
                    case "OrganizationAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                    }
                    case "NoAvailableOrganizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                    }
                    case "NoSuchDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                    }
                    case "LastDeliveryChannelDeleteFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "IdempotentParameterMismatch": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "NoSuchConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "InvalidSNSTopicARNException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                    }
                    case "MaxActiveResourcesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "NoSuchConfigRuleInConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConfigurationRecordersExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                    }
                    case "NoSuchConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                    }
                    case "InvalidS3KmsKeyArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                    }
                    case "NoSuchBucketException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                    }
                    case "InvalidConfigurationRecorderNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "NoSuchConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                    }
                    case "InvalidRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteEvaluationResults").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteEvaluationResultsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteEvaluationResultsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultConfigAsyncClient.lambda$deleteEvaluationResults$38(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultConfigAsyncClient.lambda$deleteEvaluationResults$39((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteOrganizationConfigRuleResponse> deleteOrganizationConfigRule(DeleteOrganizationConfigRuleRequest deleteOrganizationConfigRuleRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteOrganizationConfigRuleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigAsyncClient.resolveMetricPublishers(clientConfiguration, deleteOrganizationConfigRuleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteOrganizationConfigRule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteOrganizationConfigRuleResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "NoRunningConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                    }
                    case "OrganizationConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                    }
                    case "UnmodifiableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                    }
                    case "NoSuchRetentionConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                    }
                    case "ResourceConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                    }
                    case "NoSuchConfigurationAggregatorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                    }
                    case "RemediationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                    }
                    case "NoAvailableConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "OrganizationAllFeaturesNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                    }
                    case "InvalidLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                    }
                    case "NoSuchOrganizationConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                    }
                    case "MaxNumberOfDeliveryChannelsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "MaxNumberOfConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                    }
                    case "InvalidExpressionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                    }
                    case "NoSuchOrganizationConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRecordingGroupException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MaxNumberOfRetentionConfigurationsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                    }
                    case "InvalidDeliveryChannelNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                    }
                    case "ConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                    }
                    case "InvalidS3KeyPrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                    }
                    case "ResourceNotDiscoveredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                    }
                    case "NoSuchRemediationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                    }
                    case "NoAvailableDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                    }
                    case "NoSuchRemediationExceptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                    }
                    case "InvalidResultTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                    }
                    case "OversizedConfigurationItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                    }
                    case "InsufficientDeliveryPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                    }
                    case "OrganizationAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                    }
                    case "NoAvailableOrganizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                    }
                    case "NoSuchDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                    }
                    case "LastDeliveryChannelDeleteFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "IdempotentParameterMismatch": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "NoSuchConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "InvalidSNSTopicARNException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                    }
                    case "MaxActiveResourcesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "NoSuchConfigRuleInConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConfigurationRecordersExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                    }
                    case "NoSuchConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                    }
                    case "InvalidS3KmsKeyArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                    }
                    case "NoSuchBucketException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                    }
                    case "InvalidConfigurationRecorderNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "NoSuchConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                    }
                    case "InvalidRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteOrganizationConfigRule").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteOrganizationConfigRuleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteOrganizationConfigRuleRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultConfigAsyncClient.lambda$deleteOrganizationConfigRule$42(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultConfigAsyncClient.lambda$deleteOrganizationConfigRule$43((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteOrganizationConformancePackResponse> deleteOrganizationConformancePack(DeleteOrganizationConformancePackRequest deleteOrganizationConformancePackRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteOrganizationConformancePackRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigAsyncClient.resolveMetricPublishers(clientConfiguration, deleteOrganizationConformancePackRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteOrganizationConformancePack");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteOrganizationConformancePackResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "NoRunningConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                    }
                    case "OrganizationConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                    }
                    case "UnmodifiableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                    }
                    case "NoSuchRetentionConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                    }
                    case "ResourceConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                    }
                    case "NoSuchConfigurationAggregatorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                    }
                    case "RemediationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                    }
                    case "NoAvailableConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "OrganizationAllFeaturesNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                    }
                    case "InvalidLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                    }
                    case "NoSuchOrganizationConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                    }
                    case "MaxNumberOfDeliveryChannelsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "MaxNumberOfConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                    }
                    case "InvalidExpressionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                    }
                    case "NoSuchOrganizationConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRecordingGroupException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MaxNumberOfRetentionConfigurationsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                    }
                    case "InvalidDeliveryChannelNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                    }
                    case "ConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                    }
                    case "InvalidS3KeyPrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                    }
                    case "ResourceNotDiscoveredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                    }
                    case "NoSuchRemediationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                    }
                    case "NoAvailableDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                    }
                    case "NoSuchRemediationExceptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                    }
                    case "InvalidResultTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                    }
                    case "OversizedConfigurationItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                    }
                    case "InsufficientDeliveryPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                    }
                    case "OrganizationAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                    }
                    case "NoAvailableOrganizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                    }
                    case "NoSuchDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                    }
                    case "LastDeliveryChannelDeleteFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "IdempotentParameterMismatch": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "NoSuchConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "InvalidSNSTopicARNException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                    }
                    case "MaxActiveResourcesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "NoSuchConfigRuleInConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConfigurationRecordersExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                    }
                    case "NoSuchConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                    }
                    case "InvalidS3KmsKeyArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                    }
                    case "NoSuchBucketException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                    }
                    case "InvalidConfigurationRecorderNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "NoSuchConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                    }
                    case "InvalidRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteOrganizationConformancePack").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteOrganizationConformancePackRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteOrganizationConformancePackRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultConfigAsyncClient.lambda$deleteOrganizationConformancePack$46(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultConfigAsyncClient.lambda$deleteOrganizationConformancePack$47((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeletePendingAggregationRequestResponse> deletePendingAggregationRequest(DeletePendingAggregationRequestRequest deletePendingAggregationRequestRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deletePendingAggregationRequestRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigAsyncClient.resolveMetricPublishers(clientConfiguration, deletePendingAggregationRequestRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeletePendingAggregationRequest");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeletePendingAggregationRequestResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "NoRunningConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                    }
                    case "OrganizationConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                    }
                    case "UnmodifiableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                    }
                    case "NoSuchRetentionConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                    }
                    case "ResourceConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                    }
                    case "NoSuchConfigurationAggregatorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                    }
                    case "RemediationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                    }
                    case "NoAvailableConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "OrganizationAllFeaturesNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                    }
                    case "InvalidLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                    }
                    case "NoSuchOrganizationConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                    }
                    case "MaxNumberOfDeliveryChannelsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "MaxNumberOfConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                    }
                    case "InvalidExpressionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                    }
                    case "NoSuchOrganizationConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRecordingGroupException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MaxNumberOfRetentionConfigurationsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                    }
                    case "InvalidDeliveryChannelNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                    }
                    case "ConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                    }
                    case "InvalidS3KeyPrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                    }
                    case "ResourceNotDiscoveredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                    }
                    case "NoSuchRemediationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                    }
                    case "NoAvailableDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                    }
                    case "NoSuchRemediationExceptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                    }
                    case "InvalidResultTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                    }
                    case "OversizedConfigurationItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                    }
                    case "InsufficientDeliveryPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                    }
                    case "OrganizationAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                    }
                    case "NoAvailableOrganizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                    }
                    case "NoSuchDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                    }
                    case "LastDeliveryChannelDeleteFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "IdempotentParameterMismatch": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "NoSuchConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "InvalidSNSTopicARNException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                    }
                    case "MaxActiveResourcesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "NoSuchConfigRuleInConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConfigurationRecordersExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                    }
                    case "NoSuchConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                    }
                    case "InvalidS3KmsKeyArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                    }
                    case "NoSuchBucketException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                    }
                    case "InvalidConfigurationRecorderNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "NoSuchConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                    }
                    case "InvalidRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePendingAggregationRequest").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeletePendingAggregationRequestRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deletePendingAggregationRequestRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultConfigAsyncClient.lambda$deletePendingAggregationRequest$50(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultConfigAsyncClient.lambda$deletePendingAggregationRequest$51((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteRemediationConfigurationResponse> deleteRemediationConfiguration(DeleteRemediationConfigurationRequest deleteRemediationConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteRemediationConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigAsyncClient.resolveMetricPublishers(clientConfiguration, deleteRemediationConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteRemediationConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteRemediationConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "NoRunningConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                    }
                    case "OrganizationConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                    }
                    case "UnmodifiableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                    }
                    case "NoSuchRetentionConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                    }
                    case "ResourceConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                    }
                    case "NoSuchConfigurationAggregatorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                    }
                    case "RemediationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                    }
                    case "NoAvailableConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "OrganizationAllFeaturesNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                    }
                    case "InvalidLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                    }
                    case "NoSuchOrganizationConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                    }
                    case "MaxNumberOfDeliveryChannelsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "MaxNumberOfConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                    }
                    case "InvalidExpressionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                    }
                    case "NoSuchOrganizationConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRecordingGroupException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MaxNumberOfRetentionConfigurationsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                    }
                    case "InvalidDeliveryChannelNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                    }
                    case "ConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                    }
                    case "InvalidS3KeyPrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                    }
                    case "ResourceNotDiscoveredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                    }
                    case "NoSuchRemediationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                    }
                    case "NoAvailableDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                    }
                    case "NoSuchRemediationExceptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                    }
                    case "InvalidResultTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                    }
                    case "OversizedConfigurationItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                    }
                    case "InsufficientDeliveryPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                    }
                    case "OrganizationAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                    }
                    case "NoAvailableOrganizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                    }
                    case "NoSuchDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                    }
                    case "LastDeliveryChannelDeleteFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "IdempotentParameterMismatch": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "NoSuchConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "InvalidSNSTopicARNException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                    }
                    case "MaxActiveResourcesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "NoSuchConfigRuleInConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConfigurationRecordersExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                    }
                    case "NoSuchConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                    }
                    case "InvalidS3KmsKeyArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                    }
                    case "NoSuchBucketException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                    }
                    case "InvalidConfigurationRecorderNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "NoSuchConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                    }
                    case "InvalidRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteRemediationConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteRemediationConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteRemediationConfigurationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultConfigAsyncClient.lambda$deleteRemediationConfiguration$54(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultConfigAsyncClient.lambda$deleteRemediationConfiguration$55((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteRemediationExceptionsResponse> deleteRemediationExceptions(DeleteRemediationExceptionsRequest deleteRemediationExceptionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteRemediationExceptionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigAsyncClient.resolveMetricPublishers(clientConfiguration, deleteRemediationExceptionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteRemediationExceptions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteRemediationExceptionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "NoRunningConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                    }
                    case "OrganizationConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                    }
                    case "UnmodifiableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                    }
                    case "NoSuchRetentionConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                    }
                    case "ResourceConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                    }
                    case "NoSuchConfigurationAggregatorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                    }
                    case "RemediationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                    }
                    case "NoAvailableConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "OrganizationAllFeaturesNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                    }
                    case "InvalidLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                    }
                    case "NoSuchOrganizationConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                    }
                    case "MaxNumberOfDeliveryChannelsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "MaxNumberOfConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                    }
                    case "InvalidExpressionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                    }
                    case "NoSuchOrganizationConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRecordingGroupException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MaxNumberOfRetentionConfigurationsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                    }
                    case "InvalidDeliveryChannelNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                    }
                    case "ConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                    }
                    case "InvalidS3KeyPrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                    }
                    case "ResourceNotDiscoveredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                    }
                    case "NoSuchRemediationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                    }
                    case "NoAvailableDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                    }
                    case "NoSuchRemediationExceptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                    }
                    case "InvalidResultTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                    }
                    case "OversizedConfigurationItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                    }
                    case "InsufficientDeliveryPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                    }
                    case "OrganizationAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                    }
                    case "NoAvailableOrganizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                    }
                    case "NoSuchDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                    }
                    case "LastDeliveryChannelDeleteFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "IdempotentParameterMismatch": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "NoSuchConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "InvalidSNSTopicARNException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                    }
                    case "MaxActiveResourcesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "NoSuchConfigRuleInConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConfigurationRecordersExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                    }
                    case "NoSuchConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                    }
                    case "InvalidS3KmsKeyArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                    }
                    case "NoSuchBucketException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                    }
                    case "InvalidConfigurationRecorderNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "NoSuchConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                    }
                    case "InvalidRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteRemediationExceptions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteRemediationExceptionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteRemediationExceptionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultConfigAsyncClient.lambda$deleteRemediationExceptions$58(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultConfigAsyncClient.lambda$deleteRemediationExceptions$59((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteResourceConfigResponse> deleteResourceConfig(DeleteResourceConfigRequest deleteResourceConfigRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteResourceConfigRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigAsyncClient.resolveMetricPublishers(clientConfiguration, deleteResourceConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteResourceConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteResourceConfigResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "NoRunningConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                    }
                    case "OrganizationConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                    }
                    case "UnmodifiableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                    }
                    case "NoSuchRetentionConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                    }
                    case "ResourceConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                    }
                    case "NoSuchConfigurationAggregatorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                    }
                    case "RemediationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                    }
                    case "NoAvailableConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "OrganizationAllFeaturesNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                    }
                    case "InvalidLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                    }
                    case "NoSuchOrganizationConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                    }
                    case "MaxNumberOfDeliveryChannelsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "MaxNumberOfConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                    }
                    case "InvalidExpressionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                    }
                    case "NoSuchOrganizationConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRecordingGroupException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MaxNumberOfRetentionConfigurationsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                    }
                    case "InvalidDeliveryChannelNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                    }
                    case "ConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                    }
                    case "InvalidS3KeyPrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                    }
                    case "ResourceNotDiscoveredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                    }
                    case "NoSuchRemediationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                    }
                    case "NoAvailableDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                    }
                    case "NoSuchRemediationExceptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                    }
                    case "InvalidResultTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                    }
                    case "OversizedConfigurationItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                    }
                    case "InsufficientDeliveryPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                    }
                    case "OrganizationAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                    }
                    case "NoAvailableOrganizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                    }
                    case "NoSuchDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                    }
                    case "LastDeliveryChannelDeleteFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "IdempotentParameterMismatch": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "NoSuchConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "InvalidSNSTopicARNException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                    }
                    case "MaxActiveResourcesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "NoSuchConfigRuleInConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConfigurationRecordersExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                    }
                    case "NoSuchConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                    }
                    case "InvalidS3KmsKeyArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                    }
                    case "NoSuchBucketException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                    }
                    case "InvalidConfigurationRecorderNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "NoSuchConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                    }
                    case "InvalidRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteResourceConfig").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteResourceConfigRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteResourceConfigRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultConfigAsyncClient.lambda$deleteResourceConfig$62(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultConfigAsyncClient.lambda$deleteResourceConfig$63((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteRetentionConfigurationResponse> deleteRetentionConfiguration(DeleteRetentionConfigurationRequest deleteRetentionConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteRetentionConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigAsyncClient.resolveMetricPublishers(clientConfiguration, deleteRetentionConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteRetentionConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteRetentionConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "NoRunningConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                    }
                    case "OrganizationConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                    }
                    case "UnmodifiableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                    }
                    case "NoSuchRetentionConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                    }
                    case "ResourceConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                    }
                    case "NoSuchConfigurationAggregatorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                    }
                    case "RemediationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                    }
                    case "NoAvailableConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "OrganizationAllFeaturesNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                    }
                    case "InvalidLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                    }
                    case "NoSuchOrganizationConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                    }
                    case "MaxNumberOfDeliveryChannelsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "MaxNumberOfConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                    }
                    case "InvalidExpressionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                    }
                    case "NoSuchOrganizationConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRecordingGroupException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MaxNumberOfRetentionConfigurationsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                    }
                    case "InvalidDeliveryChannelNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                    }
                    case "ConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                    }
                    case "InvalidS3KeyPrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                    }
                    case "ResourceNotDiscoveredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                    }
                    case "NoSuchRemediationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                    }
                    case "NoAvailableDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                    }
                    case "NoSuchRemediationExceptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                    }
                    case "InvalidResultTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                    }
                    case "OversizedConfigurationItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                    }
                    case "InsufficientDeliveryPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                    }
                    case "OrganizationAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                    }
                    case "NoAvailableOrganizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                    }
                    case "NoSuchDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                    }
                    case "LastDeliveryChannelDeleteFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "IdempotentParameterMismatch": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "NoSuchConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "InvalidSNSTopicARNException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                    }
                    case "MaxActiveResourcesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "NoSuchConfigRuleInConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConfigurationRecordersExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                    }
                    case "NoSuchConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                    }
                    case "InvalidS3KmsKeyArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                    }
                    case "NoSuchBucketException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                    }
                    case "InvalidConfigurationRecorderNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "NoSuchConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                    }
                    case "InvalidRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteRetentionConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteRetentionConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteRetentionConfigurationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultConfigAsyncClient.lambda$deleteRetentionConfiguration$66(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultConfigAsyncClient.lambda$deleteRetentionConfiguration$67((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteServiceLinkedConfigurationRecorderResponse> deleteServiceLinkedConfigurationRecorder(DeleteServiceLinkedConfigurationRecorderRequest deleteServiceLinkedConfigurationRecorderRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteServiceLinkedConfigurationRecorderRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigAsyncClient.resolveMetricPublishers(clientConfiguration, deleteServiceLinkedConfigurationRecorderRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteServiceLinkedConfigurationRecorder");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteServiceLinkedConfigurationRecorderResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "NoRunningConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                    }
                    case "OrganizationConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                    }
                    case "UnmodifiableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                    }
                    case "NoSuchRetentionConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                    }
                    case "ResourceConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                    }
                    case "NoSuchConfigurationAggregatorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                    }
                    case "RemediationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                    }
                    case "NoAvailableConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "OrganizationAllFeaturesNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                    }
                    case "InvalidLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                    }
                    case "NoSuchOrganizationConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                    }
                    case "MaxNumberOfDeliveryChannelsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "MaxNumberOfConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                    }
                    case "InvalidExpressionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                    }
                    case "NoSuchOrganizationConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRecordingGroupException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MaxNumberOfRetentionConfigurationsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                    }
                    case "InvalidDeliveryChannelNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                    }
                    case "ConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                    }
                    case "InvalidS3KeyPrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                    }
                    case "ResourceNotDiscoveredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                    }
                    case "NoSuchRemediationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                    }
                    case "NoAvailableDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                    }
                    case "NoSuchRemediationExceptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                    }
                    case "InvalidResultTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                    }
                    case "OversizedConfigurationItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                    }
                    case "InsufficientDeliveryPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                    }
                    case "OrganizationAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                    }
                    case "NoAvailableOrganizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                    }
                    case "NoSuchDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                    }
                    case "LastDeliveryChannelDeleteFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "IdempotentParameterMismatch": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "NoSuchConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "InvalidSNSTopicARNException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                    }
                    case "MaxActiveResourcesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "NoSuchConfigRuleInConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConfigurationRecordersExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                    }
                    case "NoSuchConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                    }
                    case "InvalidS3KmsKeyArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                    }
                    case "NoSuchBucketException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                    }
                    case "InvalidConfigurationRecorderNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "NoSuchConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                    }
                    case "InvalidRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteServiceLinkedConfigurationRecorder").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteServiceLinkedConfigurationRecorderRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteServiceLinkedConfigurationRecorderRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultConfigAsyncClient.lambda$deleteServiceLinkedConfigurationRecorder$70(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultConfigAsyncClient.lambda$deleteServiceLinkedConfigurationRecorder$71((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteStoredQueryResponse> deleteStoredQuery(DeleteStoredQueryRequest deleteStoredQueryRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteStoredQueryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigAsyncClient.resolveMetricPublishers(clientConfiguration, deleteStoredQueryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteStoredQuery");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteStoredQueryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "NoRunningConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                    }
                    case "OrganizationConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                    }
                    case "UnmodifiableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                    }
                    case "NoSuchRetentionConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                    }
                    case "ResourceConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                    }
                    case "NoSuchConfigurationAggregatorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                    }
                    case "RemediationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                    }
                    case "NoAvailableConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "OrganizationAllFeaturesNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                    }
                    case "InvalidLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                    }
                    case "NoSuchOrganizationConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                    }
                    case "MaxNumberOfDeliveryChannelsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "MaxNumberOfConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                    }
                    case "InvalidExpressionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                    }
                    case "NoSuchOrganizationConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRecordingGroupException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MaxNumberOfRetentionConfigurationsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                    }
                    case "InvalidDeliveryChannelNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                    }
                    case "ConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                    }
                    case "InvalidS3KeyPrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                    }
                    case "ResourceNotDiscoveredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                    }
                    case "NoSuchRemediationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                    }
                    case "NoAvailableDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                    }
                    case "NoSuchRemediationExceptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                    }
                    case "InvalidResultTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                    }
                    case "OversizedConfigurationItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                    }
                    case "InsufficientDeliveryPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                    }
                    case "OrganizationAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                    }
                    case "NoAvailableOrganizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                    }
                    case "NoSuchDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                    }
                    case "LastDeliveryChannelDeleteFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "IdempotentParameterMismatch": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "NoSuchConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "InvalidSNSTopicARNException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                    }
                    case "MaxActiveResourcesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "NoSuchConfigRuleInConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConfigurationRecordersExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                    }
                    case "NoSuchConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                    }
                    case "InvalidS3KmsKeyArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                    }
                    case "NoSuchBucketException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                    }
                    case "InvalidConfigurationRecorderNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "NoSuchConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                    }
                    case "InvalidRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteStoredQuery").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteStoredQueryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteStoredQueryRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultConfigAsyncClient.lambda$deleteStoredQuery$74(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultConfigAsyncClient.lambda$deleteStoredQuery$75((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeliverConfigSnapshotResponse> deliverConfigSnapshot(DeliverConfigSnapshotRequest deliverConfigSnapshotRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deliverConfigSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigAsyncClient.resolveMetricPublishers(clientConfiguration, deliverConfigSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeliverConfigSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeliverConfigSnapshotResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "NoRunningConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                    }
                    case "OrganizationConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                    }
                    case "UnmodifiableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                    }
                    case "NoSuchRetentionConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                    }
                    case "ResourceConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                    }
                    case "NoSuchConfigurationAggregatorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                    }
                    case "RemediationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                    }
                    case "NoAvailableConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "OrganizationAllFeaturesNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                    }
                    case "InvalidLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                    }
                    case "NoSuchOrganizationConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                    }
                    case "MaxNumberOfDeliveryChannelsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "MaxNumberOfConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                    }
                    case "InvalidExpressionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                    }
                    case "NoSuchOrganizationConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRecordingGroupException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MaxNumberOfRetentionConfigurationsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                    }
                    case "InvalidDeliveryChannelNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                    }
                    case "ConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                    }
                    case "InvalidS3KeyPrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                    }
                    case "ResourceNotDiscoveredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                    }
                    case "NoSuchRemediationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                    }
                    case "NoAvailableDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                    }
                    case "NoSuchRemediationExceptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                    }
                    case "InvalidResultTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                    }
                    case "OversizedConfigurationItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                    }
                    case "InsufficientDeliveryPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                    }
                    case "OrganizationAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                    }
                    case "NoAvailableOrganizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                    }
                    case "NoSuchDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                    }
                    case "LastDeliveryChannelDeleteFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "IdempotentParameterMismatch": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "NoSuchConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "InvalidSNSTopicARNException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                    }
                    case "MaxActiveResourcesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "NoSuchConfigRuleInConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConfigurationRecordersExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                    }
                    case "NoSuchConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                    }
                    case "InvalidS3KmsKeyArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                    }
                    case "NoSuchBucketException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                    }
                    case "InvalidConfigurationRecorderNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "NoSuchConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                    }
                    case "InvalidRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeliverConfigSnapshot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeliverConfigSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deliverConfigSnapshotRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultConfigAsyncClient.lambda$deliverConfigSnapshot$78(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultConfigAsyncClient.lambda$deliverConfigSnapshot$79((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeAggregateComplianceByConfigRulesResponse> describeAggregateComplianceByConfigRules(DescribeAggregateComplianceByConfigRulesRequest describeAggregateComplianceByConfigRulesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeAggregateComplianceByConfigRulesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigAsyncClient.resolveMetricPublishers(clientConfiguration, describeAggregateComplianceByConfigRulesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAggregateComplianceByConfigRules");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAggregateComplianceByConfigRulesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "NoRunningConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                    }
                    case "OrganizationConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                    }
                    case "UnmodifiableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                    }
                    case "NoSuchRetentionConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                    }
                    case "ResourceConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                    }
                    case "NoSuchConfigurationAggregatorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                    }
                    case "RemediationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                    }
                    case "NoAvailableConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "OrganizationAllFeaturesNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                    }
                    case "InvalidLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                    }
                    case "NoSuchOrganizationConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                    }
                    case "MaxNumberOfDeliveryChannelsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "MaxNumberOfConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                    }
                    case "InvalidExpressionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                    }
                    case "NoSuchOrganizationConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRecordingGroupException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MaxNumberOfRetentionConfigurationsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                    }
                    case "InvalidDeliveryChannelNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                    }
                    case "ConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                    }
                    case "InvalidS3KeyPrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                    }
                    case "ResourceNotDiscoveredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                    }
                    case "NoSuchRemediationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                    }
                    case "NoAvailableDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                    }
                    case "NoSuchRemediationExceptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                    }
                    case "InvalidResultTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                    }
                    case "OversizedConfigurationItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                    }
                    case "InsufficientDeliveryPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                    }
                    case "OrganizationAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                    }
                    case "NoAvailableOrganizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                    }
                    case "NoSuchDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                    }
                    case "LastDeliveryChannelDeleteFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "IdempotentParameterMismatch": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "NoSuchConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "InvalidSNSTopicARNException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                    }
                    case "MaxActiveResourcesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "NoSuchConfigRuleInConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConfigurationRecordersExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                    }
                    case "NoSuchConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                    }
                    case "InvalidS3KmsKeyArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                    }
                    case "NoSuchBucketException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                    }
                    case "InvalidConfigurationRecorderNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "NoSuchConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                    }
                    case "InvalidRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAggregateComplianceByConfigRules").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeAggregateComplianceByConfigRulesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeAggregateComplianceByConfigRulesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultConfigAsyncClient.lambda$describeAggregateComplianceByConfigRules$82(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultConfigAsyncClient.lambda$describeAggregateComplianceByConfigRules$83((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeAggregateComplianceByConformancePacksResponse> describeAggregateComplianceByConformancePacks(DescribeAggregateComplianceByConformancePacksRequest describeAggregateComplianceByConformancePacksRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeAggregateComplianceByConformancePacksRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigAsyncClient.resolveMetricPublishers(clientConfiguration, describeAggregateComplianceByConformancePacksRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAggregateComplianceByConformancePacks");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAggregateComplianceByConformancePacksResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "NoRunningConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                    }
                    case "OrganizationConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                    }
                    case "UnmodifiableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                    }
                    case "NoSuchRetentionConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                    }
                    case "ResourceConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                    }
                    case "NoSuchConfigurationAggregatorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                    }
                    case "RemediationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                    }
                    case "NoAvailableConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "OrganizationAllFeaturesNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                    }
                    case "InvalidLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                    }
                    case "NoSuchOrganizationConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                    }
                    case "MaxNumberOfDeliveryChannelsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "MaxNumberOfConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                    }
                    case "InvalidExpressionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                    }
                    case "NoSuchOrganizationConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRecordingGroupException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MaxNumberOfRetentionConfigurationsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                    }
                    case "InvalidDeliveryChannelNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                    }
                    case "ConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                    }
                    case "InvalidS3KeyPrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                    }
                    case "ResourceNotDiscoveredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                    }
                    case "NoSuchRemediationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                    }
                    case "NoAvailableDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                    }
                    case "NoSuchRemediationExceptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                    }
                    case "InvalidResultTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                    }
                    case "OversizedConfigurationItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                    }
                    case "InsufficientDeliveryPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                    }
                    case "OrganizationAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                    }
                    case "NoAvailableOrganizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                    }
                    case "NoSuchDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                    }
                    case "LastDeliveryChannelDeleteFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "IdempotentParameterMismatch": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "NoSuchConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "InvalidSNSTopicARNException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                    }
                    case "MaxActiveResourcesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "NoSuchConfigRuleInConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConfigurationRecordersExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                    }
                    case "NoSuchConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                    }
                    case "InvalidS3KmsKeyArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                    }
                    case "NoSuchBucketException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                    }
                    case "InvalidConfigurationRecorderNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "NoSuchConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                    }
                    case "InvalidRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAggregateComplianceByConformancePacks").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeAggregateComplianceByConformancePacksRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeAggregateComplianceByConformancePacksRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultConfigAsyncClient.lambda$describeAggregateComplianceByConformancePacks$86(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultConfigAsyncClient.lambda$describeAggregateComplianceByConformancePacks$87((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeAggregationAuthorizationsResponse> describeAggregationAuthorizations(DescribeAggregationAuthorizationsRequest describeAggregationAuthorizationsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeAggregationAuthorizationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigAsyncClient.resolveMetricPublishers(clientConfiguration, describeAggregationAuthorizationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAggregationAuthorizations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAggregationAuthorizationsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "NoRunningConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                    }
                    case "OrganizationConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                    }
                    case "UnmodifiableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                    }
                    case "NoSuchRetentionConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                    }
                    case "ResourceConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                    }
                    case "NoSuchConfigurationAggregatorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                    }
                    case "RemediationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                    }
                    case "NoAvailableConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "OrganizationAllFeaturesNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                    }
                    case "InvalidLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                    }
                    case "NoSuchOrganizationConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                    }
                    case "MaxNumberOfDeliveryChannelsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "MaxNumberOfConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                    }
                    case "InvalidExpressionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                    }
                    case "NoSuchOrganizationConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRecordingGroupException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MaxNumberOfRetentionConfigurationsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                    }
                    case "InvalidDeliveryChannelNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                    }
                    case "ConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                    }
                    case "InvalidS3KeyPrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                    }
                    case "ResourceNotDiscoveredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                    }
                    case "NoSuchRemediationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                    }
                    case "NoAvailableDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                    }
                    case "NoSuchRemediationExceptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                    }
                    case "InvalidResultTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                    }
                    case "OversizedConfigurationItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                    }
                    case "InsufficientDeliveryPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                    }
                    case "OrganizationAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                    }
                    case "NoAvailableOrganizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                    }
                    case "NoSuchDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                    }
                    case "LastDeliveryChannelDeleteFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "IdempotentParameterMismatch": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "NoSuchConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "InvalidSNSTopicARNException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                    }
                    case "MaxActiveResourcesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "NoSuchConfigRuleInConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConfigurationRecordersExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                    }
                    case "NoSuchConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                    }
                    case "InvalidS3KmsKeyArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                    }
                    case "NoSuchBucketException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                    }
                    case "InvalidConfigurationRecorderNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "NoSuchConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                    }
                    case "InvalidRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAggregationAuthorizations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeAggregationAuthorizationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeAggregationAuthorizationsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultConfigAsyncClient.lambda$describeAggregationAuthorizations$90(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultConfigAsyncClient.lambda$describeAggregationAuthorizations$91((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeComplianceByConfigRuleResponse> describeComplianceByConfigRule(DescribeComplianceByConfigRuleRequest describeComplianceByConfigRuleRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeComplianceByConfigRuleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigAsyncClient.resolveMetricPublishers(clientConfiguration, describeComplianceByConfigRuleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeComplianceByConfigRule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeComplianceByConfigRuleResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "NoRunningConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                    }
                    case "OrganizationConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                    }
                    case "UnmodifiableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                    }
                    case "NoSuchRetentionConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                    }
                    case "ResourceConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                    }
                    case "NoSuchConfigurationAggregatorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                    }
                    case "RemediationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                    }
                    case "NoAvailableConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "OrganizationAllFeaturesNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                    }
                    case "InvalidLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                    }
                    case "NoSuchOrganizationConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                    }
                    case "MaxNumberOfDeliveryChannelsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "MaxNumberOfConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                    }
                    case "InvalidExpressionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                    }
                    case "NoSuchOrganizationConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRecordingGroupException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MaxNumberOfRetentionConfigurationsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                    }
                    case "InvalidDeliveryChannelNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                    }
                    case "ConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                    }
                    case "InvalidS3KeyPrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                    }
                    case "ResourceNotDiscoveredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                    }
                    case "NoSuchRemediationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                    }
                    case "NoAvailableDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                    }
                    case "NoSuchRemediationExceptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                    }
                    case "InvalidResultTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                    }
                    case "OversizedConfigurationItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                    }
                    case "InsufficientDeliveryPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                    }
                    case "OrganizationAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                    }
                    case "NoAvailableOrganizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                    }
                    case "NoSuchDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                    }
                    case "LastDeliveryChannelDeleteFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "IdempotentParameterMismatch": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "NoSuchConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "InvalidSNSTopicARNException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                    }
                    case "MaxActiveResourcesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "NoSuchConfigRuleInConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConfigurationRecordersExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                    }
                    case "NoSuchConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                    }
                    case "InvalidS3KmsKeyArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                    }
                    case "NoSuchBucketException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                    }
                    case "InvalidConfigurationRecorderNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "NoSuchConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                    }
                    case "InvalidRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeComplianceByConfigRule").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeComplianceByConfigRuleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeComplianceByConfigRuleRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultConfigAsyncClient.lambda$describeComplianceByConfigRule$94(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultConfigAsyncClient.lambda$describeComplianceByConfigRule$95((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeComplianceByResourceResponse> describeComplianceByResource(DescribeComplianceByResourceRequest describeComplianceByResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeComplianceByResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigAsyncClient.resolveMetricPublishers(clientConfiguration, describeComplianceByResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeComplianceByResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeComplianceByResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "NoRunningConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                    }
                    case "OrganizationConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                    }
                    case "UnmodifiableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                    }
                    case "NoSuchRetentionConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                    }
                    case "ResourceConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                    }
                    case "NoSuchConfigurationAggregatorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                    }
                    case "RemediationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                    }
                    case "NoAvailableConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "OrganizationAllFeaturesNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                    }
                    case "InvalidLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                    }
                    case "NoSuchOrganizationConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                    }
                    case "MaxNumberOfDeliveryChannelsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "MaxNumberOfConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                    }
                    case "InvalidExpressionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                    }
                    case "NoSuchOrganizationConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRecordingGroupException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MaxNumberOfRetentionConfigurationsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                    }
                    case "InvalidDeliveryChannelNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                    }
                    case "ConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                    }
                    case "InvalidS3KeyPrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                    }
                    case "ResourceNotDiscoveredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                    }
                    case "NoSuchRemediationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                    }
                    case "NoAvailableDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                    }
                    case "NoSuchRemediationExceptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                    }
                    case "InvalidResultTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                    }
                    case "OversizedConfigurationItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                    }
                    case "InsufficientDeliveryPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                    }
                    case "OrganizationAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                    }
                    case "NoAvailableOrganizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                    }
                    case "NoSuchDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                    }
                    case "LastDeliveryChannelDeleteFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "IdempotentParameterMismatch": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "NoSuchConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "InvalidSNSTopicARNException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                    }
                    case "MaxActiveResourcesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "NoSuchConfigRuleInConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConfigurationRecordersExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                    }
                    case "NoSuchConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                    }
                    case "InvalidS3KmsKeyArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                    }
                    case "NoSuchBucketException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                    }
                    case "InvalidConfigurationRecorderNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "NoSuchConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                    }
                    case "InvalidRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeComplianceByResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeComplianceByResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeComplianceByResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultConfigAsyncClient.lambda$describeComplianceByResource$98(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultConfigAsyncClient.lambda$describeComplianceByResource$99((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeConfigRuleEvaluationStatusResponse> describeConfigRuleEvaluationStatus(DescribeConfigRuleEvaluationStatusRequest describeConfigRuleEvaluationStatusRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeConfigRuleEvaluationStatusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigAsyncClient.resolveMetricPublishers(clientConfiguration, describeConfigRuleEvaluationStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeConfigRuleEvaluationStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeConfigRuleEvaluationStatusResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "NoRunningConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                    }
                    case "OrganizationConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                    }
                    case "UnmodifiableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                    }
                    case "NoSuchRetentionConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                    }
                    case "ResourceConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                    }
                    case "NoSuchConfigurationAggregatorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                    }
                    case "RemediationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                    }
                    case "NoAvailableConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "OrganizationAllFeaturesNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                    }
                    case "InvalidLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                    }
                    case "NoSuchOrganizationConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                    }
                    case "MaxNumberOfDeliveryChannelsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "MaxNumberOfConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                    }
                    case "InvalidExpressionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                    }
                    case "NoSuchOrganizationConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRecordingGroupException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MaxNumberOfRetentionConfigurationsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                    }
                    case "InvalidDeliveryChannelNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                    }
                    case "ConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                    }
                    case "InvalidS3KeyPrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                    }
                    case "ResourceNotDiscoveredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                    }
                    case "NoSuchRemediationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                    }
                    case "NoAvailableDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                    }
                    case "NoSuchRemediationExceptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                    }
                    case "InvalidResultTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                    }
                    case "OversizedConfigurationItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                    }
                    case "InsufficientDeliveryPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                    }
                    case "OrganizationAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                    }
                    case "NoAvailableOrganizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                    }
                    case "NoSuchDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                    }
                    case "LastDeliveryChannelDeleteFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "IdempotentParameterMismatch": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "NoSuchConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "InvalidSNSTopicARNException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                    }
                    case "MaxActiveResourcesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "NoSuchConfigRuleInConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConfigurationRecordersExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                    }
                    case "NoSuchConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                    }
                    case "InvalidS3KmsKeyArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                    }
                    case "NoSuchBucketException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                    }
                    case "InvalidConfigurationRecorderNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "NoSuchConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                    }
                    case "InvalidRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeConfigRuleEvaluationStatus").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeConfigRuleEvaluationStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeConfigRuleEvaluationStatusRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultConfigAsyncClient.lambda$describeConfigRuleEvaluationStatus$102(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultConfigAsyncClient.lambda$describeConfigRuleEvaluationStatus$103((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeConfigRulesResponse> describeConfigRules(DescribeConfigRulesRequest describeConfigRulesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeConfigRulesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigAsyncClient.resolveMetricPublishers(clientConfiguration, describeConfigRulesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeConfigRules");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeConfigRulesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "NoRunningConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                    }
                    case "OrganizationConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                    }
                    case "UnmodifiableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                    }
                    case "NoSuchRetentionConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                    }
                    case "ResourceConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                    }
                    case "NoSuchConfigurationAggregatorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                    }
                    case "RemediationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                    }
                    case "NoAvailableConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "OrganizationAllFeaturesNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                    }
                    case "InvalidLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                    }
                    case "NoSuchOrganizationConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                    }
                    case "MaxNumberOfDeliveryChannelsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "MaxNumberOfConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                    }
                    case "InvalidExpressionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                    }
                    case "NoSuchOrganizationConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRecordingGroupException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MaxNumberOfRetentionConfigurationsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                    }
                    case "InvalidDeliveryChannelNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                    }
                    case "ConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                    }
                    case "InvalidS3KeyPrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                    }
                    case "ResourceNotDiscoveredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                    }
                    case "NoSuchRemediationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                    }
                    case "NoAvailableDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                    }
                    case "NoSuchRemediationExceptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                    }
                    case "InvalidResultTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                    }
                    case "OversizedConfigurationItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                    }
                    case "InsufficientDeliveryPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                    }
                    case "OrganizationAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                    }
                    case "NoAvailableOrganizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                    }
                    case "NoSuchDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                    }
                    case "LastDeliveryChannelDeleteFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "IdempotentParameterMismatch": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "NoSuchConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "InvalidSNSTopicARNException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                    }
                    case "MaxActiveResourcesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "NoSuchConfigRuleInConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConfigurationRecordersExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                    }
                    case "NoSuchConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                    }
                    case "InvalidS3KmsKeyArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                    }
                    case "NoSuchBucketException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                    }
                    case "InvalidConfigurationRecorderNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "NoSuchConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                    }
                    case "InvalidRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeConfigRules").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeConfigRulesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeConfigRulesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultConfigAsyncClient.lambda$describeConfigRules$106(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultConfigAsyncClient.lambda$describeConfigRules$107((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeConfigurationAggregatorSourcesStatusResponse> describeConfigurationAggregatorSourcesStatus(DescribeConfigurationAggregatorSourcesStatusRequest describeConfigurationAggregatorSourcesStatusRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeConfigurationAggregatorSourcesStatusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigAsyncClient.resolveMetricPublishers(clientConfiguration, describeConfigurationAggregatorSourcesStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeConfigurationAggregatorSourcesStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeConfigurationAggregatorSourcesStatusResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "NoRunningConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                    }
                    case "OrganizationConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                    }
                    case "UnmodifiableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                    }
                    case "NoSuchRetentionConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                    }
                    case "ResourceConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                    }
                    case "NoSuchConfigurationAggregatorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                    }
                    case "RemediationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                    }
                    case "NoAvailableConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "OrganizationAllFeaturesNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                    }
                    case "InvalidLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                    }
                    case "NoSuchOrganizationConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                    }
                    case "MaxNumberOfDeliveryChannelsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "MaxNumberOfConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                    }
                    case "InvalidExpressionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                    }
                    case "NoSuchOrganizationConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRecordingGroupException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MaxNumberOfRetentionConfigurationsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                    }
                    case "InvalidDeliveryChannelNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                    }
                    case "ConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                    }
                    case "InvalidS3KeyPrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                    }
                    case "ResourceNotDiscoveredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                    }
                    case "NoSuchRemediationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                    }
                    case "NoAvailableDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                    }
                    case "NoSuchRemediationExceptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                    }
                    case "InvalidResultTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                    }
                    case "OversizedConfigurationItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                    }
                    case "InsufficientDeliveryPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                    }
                    case "OrganizationAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                    }
                    case "NoAvailableOrganizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                    }
                    case "NoSuchDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                    }
                    case "LastDeliveryChannelDeleteFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "IdempotentParameterMismatch": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "NoSuchConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "InvalidSNSTopicARNException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                    }
                    case "MaxActiveResourcesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "NoSuchConfigRuleInConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConfigurationRecordersExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                    }
                    case "NoSuchConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                    }
                    case "InvalidS3KmsKeyArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                    }
                    case "NoSuchBucketException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                    }
                    case "InvalidConfigurationRecorderNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "NoSuchConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                    }
                    case "InvalidRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeConfigurationAggregatorSourcesStatus").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeConfigurationAggregatorSourcesStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeConfigurationAggregatorSourcesStatusRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultConfigAsyncClient.lambda$describeConfigurationAggregatorSourcesStatus$110(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultConfigAsyncClient.lambda$describeConfigurationAggregatorSourcesStatus$111((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeConfigurationAggregatorsResponse> describeConfigurationAggregators(DescribeConfigurationAggregatorsRequest describeConfigurationAggregatorsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeConfigurationAggregatorsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigAsyncClient.resolveMetricPublishers(clientConfiguration, describeConfigurationAggregatorsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeConfigurationAggregators");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeConfigurationAggregatorsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "NoRunningConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                    }
                    case "OrganizationConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                    }
                    case "UnmodifiableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                    }
                    case "NoSuchRetentionConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                    }
                    case "ResourceConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                    }
                    case "NoSuchConfigurationAggregatorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                    }
                    case "RemediationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                    }
                    case "NoAvailableConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "OrganizationAllFeaturesNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                    }
                    case "InvalidLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                    }
                    case "NoSuchOrganizationConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                    }
                    case "MaxNumberOfDeliveryChannelsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "MaxNumberOfConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                    }
                    case "InvalidExpressionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                    }
                    case "NoSuchOrganizationConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRecordingGroupException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MaxNumberOfRetentionConfigurationsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                    }
                    case "InvalidDeliveryChannelNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                    }
                    case "ConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                    }
                    case "InvalidS3KeyPrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                    }
                    case "ResourceNotDiscoveredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                    }
                    case "NoSuchRemediationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                    }
                    case "NoAvailableDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                    }
                    case "NoSuchRemediationExceptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                    }
                    case "InvalidResultTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                    }
                    case "OversizedConfigurationItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                    }
                    case "InsufficientDeliveryPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                    }
                    case "OrganizationAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                    }
                    case "NoAvailableOrganizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                    }
                    case "NoSuchDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                    }
                    case "LastDeliveryChannelDeleteFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "IdempotentParameterMismatch": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "NoSuchConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "InvalidSNSTopicARNException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                    }
                    case "MaxActiveResourcesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "NoSuchConfigRuleInConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConfigurationRecordersExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                    }
                    case "NoSuchConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                    }
                    case "InvalidS3KmsKeyArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                    }
                    case "NoSuchBucketException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                    }
                    case "InvalidConfigurationRecorderNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "NoSuchConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                    }
                    case "InvalidRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeConfigurationAggregators").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeConfigurationAggregatorsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeConfigurationAggregatorsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultConfigAsyncClient.lambda$describeConfigurationAggregators$114(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultConfigAsyncClient.lambda$describeConfigurationAggregators$115((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeConfigurationRecorderStatusResponse> describeConfigurationRecorderStatus(DescribeConfigurationRecorderStatusRequest describeConfigurationRecorderStatusRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeConfigurationRecorderStatusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigAsyncClient.resolveMetricPublishers(clientConfiguration, describeConfigurationRecorderStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeConfigurationRecorderStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeConfigurationRecorderStatusResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "NoRunningConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                    }
                    case "OrganizationConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                    }
                    case "UnmodifiableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                    }
                    case "NoSuchRetentionConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                    }
                    case "ResourceConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                    }
                    case "NoSuchConfigurationAggregatorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                    }
                    case "RemediationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                    }
                    case "NoAvailableConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "OrganizationAllFeaturesNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                    }
                    case "InvalidLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                    }
                    case "NoSuchOrganizationConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                    }
                    case "MaxNumberOfDeliveryChannelsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "MaxNumberOfConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                    }
                    case "InvalidExpressionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                    }
                    case "NoSuchOrganizationConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRecordingGroupException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MaxNumberOfRetentionConfigurationsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                    }
                    case "InvalidDeliveryChannelNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                    }
                    case "ConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                    }
                    case "InvalidS3KeyPrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                    }
                    case "ResourceNotDiscoveredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                    }
                    case "NoSuchRemediationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                    }
                    case "NoAvailableDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                    }
                    case "NoSuchRemediationExceptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                    }
                    case "InvalidResultTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                    }
                    case "OversizedConfigurationItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                    }
                    case "InsufficientDeliveryPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                    }
                    case "OrganizationAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                    }
                    case "NoAvailableOrganizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                    }
                    case "NoSuchDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                    }
                    case "LastDeliveryChannelDeleteFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "IdempotentParameterMismatch": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "NoSuchConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "InvalidSNSTopicARNException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                    }
                    case "MaxActiveResourcesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "NoSuchConfigRuleInConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConfigurationRecordersExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                    }
                    case "NoSuchConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                    }
                    case "InvalidS3KmsKeyArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                    }
                    case "NoSuchBucketException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                    }
                    case "InvalidConfigurationRecorderNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "NoSuchConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                    }
                    case "InvalidRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeConfigurationRecorderStatus").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeConfigurationRecorderStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeConfigurationRecorderStatusRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultConfigAsyncClient.lambda$describeConfigurationRecorderStatus$118(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultConfigAsyncClient.lambda$describeConfigurationRecorderStatus$119((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeConfigurationRecordersResponse> describeConfigurationRecorders(DescribeConfigurationRecordersRequest describeConfigurationRecordersRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeConfigurationRecordersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigAsyncClient.resolveMetricPublishers(clientConfiguration, describeConfigurationRecordersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeConfigurationRecorders");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeConfigurationRecordersResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "NoRunningConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                    }
                    case "OrganizationConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                    }
                    case "UnmodifiableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                    }
                    case "NoSuchRetentionConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                    }
                    case "ResourceConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                    }
                    case "NoSuchConfigurationAggregatorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                    }
                    case "RemediationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                    }
                    case "NoAvailableConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "OrganizationAllFeaturesNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                    }
                    case "InvalidLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                    }
                    case "NoSuchOrganizationConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                    }
                    case "MaxNumberOfDeliveryChannelsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "MaxNumberOfConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                    }
                    case "InvalidExpressionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                    }
                    case "NoSuchOrganizationConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRecordingGroupException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MaxNumberOfRetentionConfigurationsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                    }
                    case "InvalidDeliveryChannelNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                    }
                    case "ConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                    }
                    case "InvalidS3KeyPrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                    }
                    case "ResourceNotDiscoveredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                    }
                    case "NoSuchRemediationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                    }
                    case "NoAvailableDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                    }
                    case "NoSuchRemediationExceptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                    }
                    case "InvalidResultTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                    }
                    case "OversizedConfigurationItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                    }
                    case "InsufficientDeliveryPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                    }
                    case "OrganizationAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                    }
                    case "NoAvailableOrganizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                    }
                    case "NoSuchDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                    }
                    case "LastDeliveryChannelDeleteFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "IdempotentParameterMismatch": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "NoSuchConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "InvalidSNSTopicARNException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                    }
                    case "MaxActiveResourcesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "NoSuchConfigRuleInConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConfigurationRecordersExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                    }
                    case "NoSuchConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                    }
                    case "InvalidS3KmsKeyArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                    }
                    case "NoSuchBucketException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                    }
                    case "InvalidConfigurationRecorderNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "NoSuchConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                    }
                    case "InvalidRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeConfigurationRecorders").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeConfigurationRecordersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeConfigurationRecordersRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultConfigAsyncClient.lambda$describeConfigurationRecorders$122(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultConfigAsyncClient.lambda$describeConfigurationRecorders$123((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeConformancePackComplianceResponse> describeConformancePackCompliance(DescribeConformancePackComplianceRequest describeConformancePackComplianceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeConformancePackComplianceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigAsyncClient.resolveMetricPublishers(clientConfiguration, describeConformancePackComplianceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeConformancePackCompliance");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeConformancePackComplianceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "NoRunningConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                    }
                    case "OrganizationConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                    }
                    case "UnmodifiableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                    }
                    case "NoSuchRetentionConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                    }
                    case "ResourceConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                    }
                    case "NoSuchConfigurationAggregatorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                    }
                    case "RemediationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                    }
                    case "NoAvailableConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "OrganizationAllFeaturesNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                    }
                    case "InvalidLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                    }
                    case "NoSuchOrganizationConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                    }
                    case "MaxNumberOfDeliveryChannelsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "MaxNumberOfConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                    }
                    case "InvalidExpressionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                    }
                    case "NoSuchOrganizationConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRecordingGroupException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MaxNumberOfRetentionConfigurationsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                    }
                    case "InvalidDeliveryChannelNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                    }
                    case "ConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                    }
                    case "InvalidS3KeyPrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                    }
                    case "ResourceNotDiscoveredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                    }
                    case "NoSuchRemediationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                    }
                    case "NoAvailableDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                    }
                    case "NoSuchRemediationExceptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                    }
                    case "InvalidResultTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                    }
                    case "OversizedConfigurationItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                    }
                    case "InsufficientDeliveryPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                    }
                    case "OrganizationAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                    }
                    case "NoAvailableOrganizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                    }
                    case "NoSuchDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                    }
                    case "LastDeliveryChannelDeleteFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "IdempotentParameterMismatch": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "NoSuchConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "InvalidSNSTopicARNException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                    }
                    case "MaxActiveResourcesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "NoSuchConfigRuleInConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConfigurationRecordersExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                    }
                    case "NoSuchConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                    }
                    case "InvalidS3KmsKeyArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                    }
                    case "NoSuchBucketException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                    }
                    case "InvalidConfigurationRecorderNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "NoSuchConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                    }
                    case "InvalidRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeConformancePackCompliance").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeConformancePackComplianceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeConformancePackComplianceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultConfigAsyncClient.lambda$describeConformancePackCompliance$126(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultConfigAsyncClient.lambda$describeConformancePackCompliance$127((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeConformancePackStatusResponse> describeConformancePackStatus(DescribeConformancePackStatusRequest describeConformancePackStatusRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeConformancePackStatusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigAsyncClient.resolveMetricPublishers(clientConfiguration, describeConformancePackStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeConformancePackStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeConformancePackStatusResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "NoRunningConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                    }
                    case "OrganizationConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                    }
                    case "UnmodifiableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                    }
                    case "NoSuchRetentionConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                    }
                    case "ResourceConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                    }
                    case "NoSuchConfigurationAggregatorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                    }
                    case "RemediationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                    }
                    case "NoAvailableConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "OrganizationAllFeaturesNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                    }
                    case "InvalidLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                    }
                    case "NoSuchOrganizationConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                    }
                    case "MaxNumberOfDeliveryChannelsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "MaxNumberOfConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                    }
                    case "InvalidExpressionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                    }
                    case "NoSuchOrganizationConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRecordingGroupException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MaxNumberOfRetentionConfigurationsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                    }
                    case "InvalidDeliveryChannelNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                    }
                    case "ConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                    }
                    case "InvalidS3KeyPrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                    }
                    case "ResourceNotDiscoveredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                    }
                    case "NoSuchRemediationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                    }
                    case "NoAvailableDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                    }
                    case "NoSuchRemediationExceptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                    }
                    case "InvalidResultTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                    }
                    case "OversizedConfigurationItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                    }
                    case "InsufficientDeliveryPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                    }
                    case "OrganizationAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                    }
                    case "NoAvailableOrganizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                    }
                    case "NoSuchDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                    }
                    case "LastDeliveryChannelDeleteFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "IdempotentParameterMismatch": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "NoSuchConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "InvalidSNSTopicARNException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                    }
                    case "MaxActiveResourcesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "NoSuchConfigRuleInConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConfigurationRecordersExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                    }
                    case "NoSuchConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                    }
                    case "InvalidS3KmsKeyArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                    }
                    case "NoSuchBucketException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                    }
                    case "InvalidConfigurationRecorderNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "NoSuchConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                    }
                    case "InvalidRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeConformancePackStatus").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeConformancePackStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeConformancePackStatusRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultConfigAsyncClient.lambda$describeConformancePackStatus$130(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultConfigAsyncClient.lambda$describeConformancePackStatus$131((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeConformancePacksResponse> describeConformancePacks(DescribeConformancePacksRequest describeConformancePacksRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeConformancePacksRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigAsyncClient.resolveMetricPublishers(clientConfiguration, describeConformancePacksRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeConformancePacks");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeConformancePacksResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "NoRunningConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                    }
                    case "OrganizationConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                    }
                    case "UnmodifiableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                    }
                    case "NoSuchRetentionConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                    }
                    case "ResourceConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                    }
                    case "NoSuchConfigurationAggregatorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                    }
                    case "RemediationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                    }
                    case "NoAvailableConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "OrganizationAllFeaturesNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                    }
                    case "InvalidLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                    }
                    case "NoSuchOrganizationConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                    }
                    case "MaxNumberOfDeliveryChannelsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "MaxNumberOfConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                    }
                    case "InvalidExpressionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                    }
                    case "NoSuchOrganizationConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRecordingGroupException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MaxNumberOfRetentionConfigurationsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                    }
                    case "InvalidDeliveryChannelNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                    }
                    case "ConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                    }
                    case "InvalidS3KeyPrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                    }
                    case "ResourceNotDiscoveredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                    }
                    case "NoSuchRemediationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                    }
                    case "NoAvailableDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                    }
                    case "NoSuchRemediationExceptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                    }
                    case "InvalidResultTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                    }
                    case "OversizedConfigurationItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                    }
                    case "InsufficientDeliveryPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                    }
                    case "OrganizationAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                    }
                    case "NoAvailableOrganizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                    }
                    case "NoSuchDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                    }
                    case "LastDeliveryChannelDeleteFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "IdempotentParameterMismatch": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "NoSuchConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "InvalidSNSTopicARNException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                    }
                    case "MaxActiveResourcesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "NoSuchConfigRuleInConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConfigurationRecordersExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                    }
                    case "NoSuchConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                    }
                    case "InvalidS3KmsKeyArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                    }
                    case "NoSuchBucketException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                    }
                    case "InvalidConfigurationRecorderNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "NoSuchConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                    }
                    case "InvalidRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeConformancePacks").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeConformancePacksRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeConformancePacksRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultConfigAsyncClient.lambda$describeConformancePacks$134(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultConfigAsyncClient.lambda$describeConformancePacks$135((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeDeliveryChannelStatusResponse> describeDeliveryChannelStatus(DescribeDeliveryChannelStatusRequest describeDeliveryChannelStatusRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeDeliveryChannelStatusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigAsyncClient.resolveMetricPublishers(clientConfiguration, describeDeliveryChannelStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDeliveryChannelStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDeliveryChannelStatusResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "NoRunningConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                    }
                    case "OrganizationConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                    }
                    case "UnmodifiableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                    }
                    case "NoSuchRetentionConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                    }
                    case "ResourceConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                    }
                    case "NoSuchConfigurationAggregatorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                    }
                    case "RemediationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                    }
                    case "NoAvailableConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "OrganizationAllFeaturesNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                    }
                    case "InvalidLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                    }
                    case "NoSuchOrganizationConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                    }
                    case "MaxNumberOfDeliveryChannelsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "MaxNumberOfConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                    }
                    case "InvalidExpressionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                    }
                    case "NoSuchOrganizationConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRecordingGroupException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MaxNumberOfRetentionConfigurationsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                    }
                    case "InvalidDeliveryChannelNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                    }
                    case "ConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                    }
                    case "InvalidS3KeyPrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                    }
                    case "ResourceNotDiscoveredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                    }
                    case "NoSuchRemediationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                    }
                    case "NoAvailableDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                    }
                    case "NoSuchRemediationExceptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                    }
                    case "InvalidResultTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                    }
                    case "OversizedConfigurationItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                    }
                    case "InsufficientDeliveryPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                    }
                    case "OrganizationAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                    }
                    case "NoAvailableOrganizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                    }
                    case "NoSuchDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                    }
                    case "LastDeliveryChannelDeleteFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "IdempotentParameterMismatch": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "NoSuchConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "InvalidSNSTopicARNException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                    }
                    case "MaxActiveResourcesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "NoSuchConfigRuleInConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConfigurationRecordersExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                    }
                    case "NoSuchConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                    }
                    case "InvalidS3KmsKeyArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                    }
                    case "NoSuchBucketException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                    }
                    case "InvalidConfigurationRecorderNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "NoSuchConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                    }
                    case "InvalidRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDeliveryChannelStatus").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeDeliveryChannelStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeDeliveryChannelStatusRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultConfigAsyncClient.lambda$describeDeliveryChannelStatus$138(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultConfigAsyncClient.lambda$describeDeliveryChannelStatus$139((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeDeliveryChannelsResponse> describeDeliveryChannels(DescribeDeliveryChannelsRequest describeDeliveryChannelsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeDeliveryChannelsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigAsyncClient.resolveMetricPublishers(clientConfiguration, describeDeliveryChannelsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDeliveryChannels");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDeliveryChannelsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "NoRunningConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                    }
                    case "OrganizationConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                    }
                    case "UnmodifiableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                    }
                    case "NoSuchRetentionConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                    }
                    case "ResourceConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                    }
                    case "NoSuchConfigurationAggregatorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                    }
                    case "RemediationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                    }
                    case "NoAvailableConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "OrganizationAllFeaturesNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                    }
                    case "InvalidLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                    }
                    case "NoSuchOrganizationConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                    }
                    case "MaxNumberOfDeliveryChannelsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "MaxNumberOfConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                    }
                    case "InvalidExpressionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                    }
                    case "NoSuchOrganizationConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRecordingGroupException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MaxNumberOfRetentionConfigurationsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                    }
                    case "InvalidDeliveryChannelNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                    }
                    case "ConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                    }
                    case "InvalidS3KeyPrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                    }
                    case "ResourceNotDiscoveredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                    }
                    case "NoSuchRemediationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                    }
                    case "NoAvailableDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                    }
                    case "NoSuchRemediationExceptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                    }
                    case "InvalidResultTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                    }
                    case "OversizedConfigurationItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                    }
                    case "InsufficientDeliveryPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                    }
                    case "OrganizationAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                    }
                    case "NoAvailableOrganizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                    }
                    case "NoSuchDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                    }
                    case "LastDeliveryChannelDeleteFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "IdempotentParameterMismatch": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "NoSuchConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "InvalidSNSTopicARNException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                    }
                    case "MaxActiveResourcesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "NoSuchConfigRuleInConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConfigurationRecordersExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                    }
                    case "NoSuchConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                    }
                    case "InvalidS3KmsKeyArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                    }
                    case "NoSuchBucketException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                    }
                    case "InvalidConfigurationRecorderNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "NoSuchConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                    }
                    case "InvalidRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDeliveryChannels").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeDeliveryChannelsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeDeliveryChannelsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultConfigAsyncClient.lambda$describeDeliveryChannels$142(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultConfigAsyncClient.lambda$describeDeliveryChannels$143((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeOrganizationConfigRuleStatusesResponse> describeOrganizationConfigRuleStatuses(DescribeOrganizationConfigRuleStatusesRequest describeOrganizationConfigRuleStatusesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeOrganizationConfigRuleStatusesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigAsyncClient.resolveMetricPublishers(clientConfiguration, describeOrganizationConfigRuleStatusesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeOrganizationConfigRuleStatuses");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeOrganizationConfigRuleStatusesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "NoRunningConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                    }
                    case "OrganizationConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                    }
                    case "UnmodifiableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                    }
                    case "NoSuchRetentionConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                    }
                    case "ResourceConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                    }
                    case "NoSuchConfigurationAggregatorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                    }
                    case "RemediationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                    }
                    case "NoAvailableConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "OrganizationAllFeaturesNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                    }
                    case "InvalidLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                    }
                    case "NoSuchOrganizationConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                    }
                    case "MaxNumberOfDeliveryChannelsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "MaxNumberOfConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                    }
                    case "InvalidExpressionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                    }
                    case "NoSuchOrganizationConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRecordingGroupException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MaxNumberOfRetentionConfigurationsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                    }
                    case "InvalidDeliveryChannelNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                    }
                    case "ConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                    }
                    case "InvalidS3KeyPrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                    }
                    case "ResourceNotDiscoveredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                    }
                    case "NoSuchRemediationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                    }
                    case "NoAvailableDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                    }
                    case "NoSuchRemediationExceptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                    }
                    case "InvalidResultTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                    }
                    case "OversizedConfigurationItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                    }
                    case "InsufficientDeliveryPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                    }
                    case "OrganizationAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                    }
                    case "NoAvailableOrganizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                    }
                    case "NoSuchDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                    }
                    case "LastDeliveryChannelDeleteFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "IdempotentParameterMismatch": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "NoSuchConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "InvalidSNSTopicARNException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                    }
                    case "MaxActiveResourcesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "NoSuchConfigRuleInConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConfigurationRecordersExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                    }
                    case "NoSuchConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                    }
                    case "InvalidS3KmsKeyArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                    }
                    case "NoSuchBucketException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                    }
                    case "InvalidConfigurationRecorderNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "NoSuchConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                    }
                    case "InvalidRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeOrganizationConfigRuleStatuses").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeOrganizationConfigRuleStatusesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeOrganizationConfigRuleStatusesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultConfigAsyncClient.lambda$describeOrganizationConfigRuleStatuses$146(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultConfigAsyncClient.lambda$describeOrganizationConfigRuleStatuses$147((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeOrganizationConfigRulesResponse> describeOrganizationConfigRules(DescribeOrganizationConfigRulesRequest describeOrganizationConfigRulesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeOrganizationConfigRulesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigAsyncClient.resolveMetricPublishers(clientConfiguration, describeOrganizationConfigRulesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeOrganizationConfigRules");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeOrganizationConfigRulesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "NoRunningConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                    }
                    case "OrganizationConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                    }
                    case "UnmodifiableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                    }
                    case "NoSuchRetentionConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                    }
                    case "ResourceConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                    }
                    case "NoSuchConfigurationAggregatorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                    }
                    case "RemediationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                    }
                    case "NoAvailableConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "OrganizationAllFeaturesNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                    }
                    case "InvalidLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                    }
                    case "NoSuchOrganizationConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                    }
                    case "MaxNumberOfDeliveryChannelsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "MaxNumberOfConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                    }
                    case "InvalidExpressionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                    }
                    case "NoSuchOrganizationConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRecordingGroupException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MaxNumberOfRetentionConfigurationsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                    }
                    case "InvalidDeliveryChannelNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                    }
                    case "ConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                    }
                    case "InvalidS3KeyPrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                    }
                    case "ResourceNotDiscoveredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                    }
                    case "NoSuchRemediationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                    }
                    case "NoAvailableDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                    }
                    case "NoSuchRemediationExceptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                    }
                    case "InvalidResultTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                    }
                    case "OversizedConfigurationItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                    }
                    case "InsufficientDeliveryPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                    }
                    case "OrganizationAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                    }
                    case "NoAvailableOrganizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                    }
                    case "NoSuchDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                    }
                    case "LastDeliveryChannelDeleteFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "IdempotentParameterMismatch": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "NoSuchConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "InvalidSNSTopicARNException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                    }
                    case "MaxActiveResourcesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "NoSuchConfigRuleInConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConfigurationRecordersExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                    }
                    case "NoSuchConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                    }
                    case "InvalidS3KmsKeyArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                    }
                    case "NoSuchBucketException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                    }
                    case "InvalidConfigurationRecorderNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "NoSuchConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                    }
                    case "InvalidRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeOrganizationConfigRules").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeOrganizationConfigRulesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeOrganizationConfigRulesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultConfigAsyncClient.lambda$describeOrganizationConfigRules$150(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultConfigAsyncClient.lambda$describeOrganizationConfigRules$151((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeOrganizationConformancePackStatusesResponse> describeOrganizationConformancePackStatuses(DescribeOrganizationConformancePackStatusesRequest describeOrganizationConformancePackStatusesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeOrganizationConformancePackStatusesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigAsyncClient.resolveMetricPublishers(clientConfiguration, describeOrganizationConformancePackStatusesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeOrganizationConformancePackStatuses");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeOrganizationConformancePackStatusesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "NoRunningConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                    }
                    case "OrganizationConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                    }
                    case "UnmodifiableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                    }
                    case "NoSuchRetentionConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                    }
                    case "ResourceConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                    }
                    case "NoSuchConfigurationAggregatorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                    }
                    case "RemediationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                    }
                    case "NoAvailableConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "OrganizationAllFeaturesNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                    }
                    case "InvalidLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                    }
                    case "NoSuchOrganizationConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                    }
                    case "MaxNumberOfDeliveryChannelsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "MaxNumberOfConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                    }
                    case "InvalidExpressionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                    }
                    case "NoSuchOrganizationConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRecordingGroupException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MaxNumberOfRetentionConfigurationsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                    }
                    case "InvalidDeliveryChannelNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                    }
                    case "ConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                    }
                    case "InvalidS3KeyPrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                    }
                    case "ResourceNotDiscoveredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                    }
                    case "NoSuchRemediationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                    }
                    case "NoAvailableDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                    }
                    case "NoSuchRemediationExceptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                    }
                    case "InvalidResultTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                    }
                    case "OversizedConfigurationItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                    }
                    case "InsufficientDeliveryPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                    }
                    case "OrganizationAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                    }
                    case "NoAvailableOrganizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                    }
                    case "NoSuchDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                    }
                    case "LastDeliveryChannelDeleteFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "IdempotentParameterMismatch": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "NoSuchConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "InvalidSNSTopicARNException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                    }
                    case "MaxActiveResourcesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "NoSuchConfigRuleInConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConfigurationRecordersExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                    }
                    case "NoSuchConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                    }
                    case "InvalidS3KmsKeyArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                    }
                    case "NoSuchBucketException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                    }
                    case "InvalidConfigurationRecorderNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "NoSuchConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                    }
                    case "InvalidRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeOrganizationConformancePackStatuses").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeOrganizationConformancePackStatusesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeOrganizationConformancePackStatusesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultConfigAsyncClient.lambda$describeOrganizationConformancePackStatuses$154(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultConfigAsyncClient.lambda$describeOrganizationConformancePackStatuses$155((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeOrganizationConformancePacksResponse> describeOrganizationConformancePacks(DescribeOrganizationConformancePacksRequest describeOrganizationConformancePacksRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeOrganizationConformancePacksRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigAsyncClient.resolveMetricPublishers(clientConfiguration, describeOrganizationConformancePacksRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeOrganizationConformancePacks");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeOrganizationConformancePacksResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "NoRunningConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                    }
                    case "OrganizationConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                    }
                    case "UnmodifiableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                    }
                    case "NoSuchRetentionConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                    }
                    case "ResourceConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                    }
                    case "NoSuchConfigurationAggregatorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                    }
                    case "RemediationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                    }
                    case "NoAvailableConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "OrganizationAllFeaturesNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                    }
                    case "InvalidLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                    }
                    case "NoSuchOrganizationConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                    }
                    case "MaxNumberOfDeliveryChannelsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "MaxNumberOfConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                    }
                    case "InvalidExpressionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                    }
                    case "NoSuchOrganizationConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRecordingGroupException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MaxNumberOfRetentionConfigurationsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                    }
                    case "InvalidDeliveryChannelNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                    }
                    case "ConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                    }
                    case "InvalidS3KeyPrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                    }
                    case "ResourceNotDiscoveredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                    }
                    case "NoSuchRemediationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                    }
                    case "NoAvailableDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                    }
                    case "NoSuchRemediationExceptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                    }
                    case "InvalidResultTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                    }
                    case "OversizedConfigurationItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                    }
                    case "InsufficientDeliveryPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                    }
                    case "OrganizationAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                    }
                    case "NoAvailableOrganizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                    }
                    case "NoSuchDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                    }
                    case "LastDeliveryChannelDeleteFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "IdempotentParameterMismatch": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "NoSuchConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "InvalidSNSTopicARNException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                    }
                    case "MaxActiveResourcesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "NoSuchConfigRuleInConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConfigurationRecordersExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                    }
                    case "NoSuchConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                    }
                    case "InvalidS3KmsKeyArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                    }
                    case "NoSuchBucketException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                    }
                    case "InvalidConfigurationRecorderNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "NoSuchConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                    }
                    case "InvalidRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeOrganizationConformancePacks").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeOrganizationConformancePacksRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeOrganizationConformancePacksRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultConfigAsyncClient.lambda$describeOrganizationConformancePacks$158(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultConfigAsyncClient.lambda$describeOrganizationConformancePacks$159((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribePendingAggregationRequestsResponse> describePendingAggregationRequests(DescribePendingAggregationRequestsRequest describePendingAggregationRequestsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describePendingAggregationRequestsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigAsyncClient.resolveMetricPublishers(clientConfiguration, describePendingAggregationRequestsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribePendingAggregationRequests");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribePendingAggregationRequestsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "NoRunningConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                    }
                    case "OrganizationConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                    }
                    case "UnmodifiableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                    }
                    case "NoSuchRetentionConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                    }
                    case "ResourceConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                    }
                    case "NoSuchConfigurationAggregatorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                    }
                    case "RemediationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                    }
                    case "NoAvailableConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "OrganizationAllFeaturesNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                    }
                    case "InvalidLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                    }
                    case "NoSuchOrganizationConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                    }
                    case "MaxNumberOfDeliveryChannelsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "MaxNumberOfConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                    }
                    case "InvalidExpressionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                    }
                    case "NoSuchOrganizationConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRecordingGroupException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MaxNumberOfRetentionConfigurationsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                    }
                    case "InvalidDeliveryChannelNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                    }
                    case "ConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                    }
                    case "InvalidS3KeyPrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                    }
                    case "ResourceNotDiscoveredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                    }
                    case "NoSuchRemediationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                    }
                    case "NoAvailableDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                    }
                    case "NoSuchRemediationExceptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                    }
                    case "InvalidResultTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                    }
                    case "OversizedConfigurationItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                    }
                    case "InsufficientDeliveryPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                    }
                    case "OrganizationAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                    }
                    case "NoAvailableOrganizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                    }
                    case "NoSuchDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                    }
                    case "LastDeliveryChannelDeleteFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "IdempotentParameterMismatch": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "NoSuchConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "InvalidSNSTopicARNException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                    }
                    case "MaxActiveResourcesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "NoSuchConfigRuleInConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConfigurationRecordersExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                    }
                    case "NoSuchConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                    }
                    case "InvalidS3KmsKeyArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                    }
                    case "NoSuchBucketException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                    }
                    case "InvalidConfigurationRecorderNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "NoSuchConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                    }
                    case "InvalidRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribePendingAggregationRequests").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribePendingAggregationRequestsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describePendingAggregationRequestsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultConfigAsyncClient.lambda$describePendingAggregationRequests$162(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultConfigAsyncClient.lambda$describePendingAggregationRequests$163((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeRemediationConfigurationsResponse> describeRemediationConfigurations(DescribeRemediationConfigurationsRequest describeRemediationConfigurationsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeRemediationConfigurationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigAsyncClient.resolveMetricPublishers(clientConfiguration, describeRemediationConfigurationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeRemediationConfigurations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeRemediationConfigurationsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "NoRunningConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                    }
                    case "OrganizationConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                    }
                    case "UnmodifiableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                    }
                    case "NoSuchRetentionConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                    }
                    case "ResourceConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                    }
                    case "NoSuchConfigurationAggregatorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                    }
                    case "RemediationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                    }
                    case "NoAvailableConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "OrganizationAllFeaturesNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                    }
                    case "InvalidLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                    }
                    case "NoSuchOrganizationConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                    }
                    case "MaxNumberOfDeliveryChannelsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "MaxNumberOfConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                    }
                    case "InvalidExpressionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                    }
                    case "NoSuchOrganizationConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRecordingGroupException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MaxNumberOfRetentionConfigurationsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                    }
                    case "InvalidDeliveryChannelNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                    }
                    case "ConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                    }
                    case "InvalidS3KeyPrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                    }
                    case "ResourceNotDiscoveredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                    }
                    case "NoSuchRemediationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                    }
                    case "NoAvailableDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                    }
                    case "NoSuchRemediationExceptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                    }
                    case "InvalidResultTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                    }
                    case "OversizedConfigurationItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                    }
                    case "InsufficientDeliveryPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                    }
                    case "OrganizationAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                    }
                    case "NoAvailableOrganizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                    }
                    case "NoSuchDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                    }
                    case "LastDeliveryChannelDeleteFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "IdempotentParameterMismatch": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "NoSuchConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "InvalidSNSTopicARNException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                    }
                    case "MaxActiveResourcesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "NoSuchConfigRuleInConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConfigurationRecordersExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                    }
                    case "NoSuchConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                    }
                    case "InvalidS3KmsKeyArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                    }
                    case "NoSuchBucketException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                    }
                    case "InvalidConfigurationRecorderNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "NoSuchConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                    }
                    case "InvalidRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeRemediationConfigurations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeRemediationConfigurationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeRemediationConfigurationsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultConfigAsyncClient.lambda$describeRemediationConfigurations$166(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultConfigAsyncClient.lambda$describeRemediationConfigurations$167((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeRemediationExceptionsResponse> describeRemediationExceptions(DescribeRemediationExceptionsRequest describeRemediationExceptionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeRemediationExceptionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigAsyncClient.resolveMetricPublishers(clientConfiguration, describeRemediationExceptionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeRemediationExceptions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeRemediationExceptionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "NoRunningConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                    }
                    case "OrganizationConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                    }
                    case "UnmodifiableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                    }
                    case "NoSuchRetentionConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                    }
                    case "ResourceConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                    }
                    case "NoSuchConfigurationAggregatorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                    }
                    case "RemediationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                    }
                    case "NoAvailableConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "OrganizationAllFeaturesNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                    }
                    case "InvalidLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                    }
                    case "NoSuchOrganizationConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                    }
                    case "MaxNumberOfDeliveryChannelsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "MaxNumberOfConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                    }
                    case "InvalidExpressionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                    }
                    case "NoSuchOrganizationConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRecordingGroupException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MaxNumberOfRetentionConfigurationsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                    }
                    case "InvalidDeliveryChannelNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                    }
                    case "ConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                    }
                    case "InvalidS3KeyPrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                    }
                    case "ResourceNotDiscoveredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                    }
                    case "NoSuchRemediationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                    }
                    case "NoAvailableDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                    }
                    case "NoSuchRemediationExceptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                    }
                    case "InvalidResultTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                    }
                    case "OversizedConfigurationItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                    }
                    case "InsufficientDeliveryPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                    }
                    case "OrganizationAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                    }
                    case "NoAvailableOrganizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                    }
                    case "NoSuchDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                    }
                    case "LastDeliveryChannelDeleteFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "IdempotentParameterMismatch": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "NoSuchConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "InvalidSNSTopicARNException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                    }
                    case "MaxActiveResourcesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "NoSuchConfigRuleInConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConfigurationRecordersExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                    }
                    case "NoSuchConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                    }
                    case "InvalidS3KmsKeyArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                    }
                    case "NoSuchBucketException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                    }
                    case "InvalidConfigurationRecorderNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "NoSuchConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                    }
                    case "InvalidRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeRemediationExceptions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeRemediationExceptionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeRemediationExceptionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultConfigAsyncClient.lambda$describeRemediationExceptions$170(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultConfigAsyncClient.lambda$describeRemediationExceptions$171((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeRemediationExecutionStatusResponse> describeRemediationExecutionStatus(DescribeRemediationExecutionStatusRequest describeRemediationExecutionStatusRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeRemediationExecutionStatusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigAsyncClient.resolveMetricPublishers(clientConfiguration, describeRemediationExecutionStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeRemediationExecutionStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeRemediationExecutionStatusResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "NoRunningConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                    }
                    case "OrganizationConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                    }
                    case "UnmodifiableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                    }
                    case "NoSuchRetentionConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                    }
                    case "ResourceConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                    }
                    case "NoSuchConfigurationAggregatorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                    }
                    case "RemediationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                    }
                    case "NoAvailableConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "OrganizationAllFeaturesNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                    }
                    case "InvalidLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                    }
                    case "NoSuchOrganizationConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                    }
                    case "MaxNumberOfDeliveryChannelsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "MaxNumberOfConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                    }
                    case "InvalidExpressionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                    }
                    case "NoSuchOrganizationConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRecordingGroupException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MaxNumberOfRetentionConfigurationsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                    }
                    case "InvalidDeliveryChannelNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                    }
                    case "ConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                    }
                    case "InvalidS3KeyPrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                    }
                    case "ResourceNotDiscoveredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                    }
                    case "NoSuchRemediationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                    }
                    case "NoAvailableDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                    }
                    case "NoSuchRemediationExceptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                    }
                    case "InvalidResultTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                    }
                    case "OversizedConfigurationItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                    }
                    case "InsufficientDeliveryPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                    }
                    case "OrganizationAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                    }
                    case "NoAvailableOrganizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                    }
                    case "NoSuchDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                    }
                    case "LastDeliveryChannelDeleteFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "IdempotentParameterMismatch": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "NoSuchConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "InvalidSNSTopicARNException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                    }
                    case "MaxActiveResourcesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "NoSuchConfigRuleInConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConfigurationRecordersExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                    }
                    case "NoSuchConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                    }
                    case "InvalidS3KmsKeyArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                    }
                    case "NoSuchBucketException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                    }
                    case "InvalidConfigurationRecorderNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "NoSuchConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                    }
                    case "InvalidRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeRemediationExecutionStatus").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeRemediationExecutionStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeRemediationExecutionStatusRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultConfigAsyncClient.lambda$describeRemediationExecutionStatus$174(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultConfigAsyncClient.lambda$describeRemediationExecutionStatus$175((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeRetentionConfigurationsResponse> describeRetentionConfigurations(DescribeRetentionConfigurationsRequest describeRetentionConfigurationsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeRetentionConfigurationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigAsyncClient.resolveMetricPublishers(clientConfiguration, describeRetentionConfigurationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeRetentionConfigurations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeRetentionConfigurationsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "NoRunningConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                    }
                    case "OrganizationConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                    }
                    case "UnmodifiableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                    }
                    case "NoSuchRetentionConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                    }
                    case "ResourceConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                    }
                    case "NoSuchConfigurationAggregatorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                    }
                    case "RemediationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                    }
                    case "NoAvailableConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "OrganizationAllFeaturesNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                    }
                    case "InvalidLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                    }
                    case "NoSuchOrganizationConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                    }
                    case "MaxNumberOfDeliveryChannelsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "MaxNumberOfConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                    }
                    case "InvalidExpressionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                    }
                    case "NoSuchOrganizationConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRecordingGroupException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MaxNumberOfRetentionConfigurationsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                    }
                    case "InvalidDeliveryChannelNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                    }
                    case "ConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                    }
                    case "InvalidS3KeyPrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                    }
                    case "ResourceNotDiscoveredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                    }
                    case "NoSuchRemediationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                    }
                    case "NoAvailableDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                    }
                    case "NoSuchRemediationExceptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                    }
                    case "InvalidResultTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                    }
                    case "OversizedConfigurationItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                    }
                    case "InsufficientDeliveryPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                    }
                    case "OrganizationAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                    }
                    case "NoAvailableOrganizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                    }
                    case "NoSuchDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                    }
                    case "LastDeliveryChannelDeleteFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "IdempotentParameterMismatch": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "NoSuchConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "InvalidSNSTopicARNException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                    }
                    case "MaxActiveResourcesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "NoSuchConfigRuleInConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConfigurationRecordersExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                    }
                    case "NoSuchConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                    }
                    case "InvalidS3KmsKeyArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                    }
                    case "NoSuchBucketException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                    }
                    case "InvalidConfigurationRecorderNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                    }
                    case "InvalidTimeRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                    }
                    case "NoSuchConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                    }
                    case "InvalidRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeRetentionConfigurations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeRetentionConfigurationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeRetentionConfigurationsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultConfigAsyncClient.lambda$describeRetentionConfigurations$178(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultConfigAsyncClient.lambda$describeRetentionConfigurations$179((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DisassociateResourceTypesResponse> disassociateResourceTypes(DisassociateResourceTypesRequest disassociateResourceTypesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disassociateResourceTypesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigAsyncClient.resolveMetricPublishers(clientConfiguration, disassociateResourceTypesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateResourceTypes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateResourceTypesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "NoRunningConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                    }
                    case "OrganizationConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                    }
                    case "UnmodifiableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                    }
                    case "NoSuchRetentionConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                    }
                    case "ResourceConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                    }
                    case "NoSuchConfigurationAggregatorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                    }
                    case "RemediationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                    }
                    case "NoAvailableConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "OrganizationAllFeaturesNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                    }
                    case "InvalidLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                    }
                    case "NoSuchOrganizationConfigRuleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                    }
                    case "MaxNumberOfDeliveryChannelsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "MaxNumberOfConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                    }
                    case "InvalidExpressionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                    }
                    case "NoSuchOrganizationConformancePackException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                    }
                    case "MaxNumberOfConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConfigRulesExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidRecordingGroupException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "MaxNumberOfRetentionConfigurationsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                    }
                    case "InvalidDeliveryChannelNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                    }
                    case "ConformancePackTemplateValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                    }
                    case "MaxNumberOfOrganizationConformancePacksExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                    }
                    case "InvalidS3KeyPrefixException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                    }
                    case "ResourceNotDiscoveredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                    }
                    case "NoSuchRemediationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                    }
                    case "NoAvailableDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                    }
                    case "NoSuchRemediationExceptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                    }
                    case "InvalidResultTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                    }
                    case "OversizedConfigurationItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                    }
                    case "InsufficientDeliveryPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                    }
                    case "OrganizationAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                    }
                    case "NoAvailableOrganizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                    }
                    case "NoSuchDeliveryChannelException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                    }
                    case "LastDeliveryChannelDeleteFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "IdempotentParameterMismatch": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "NoSuchConfigurationRecorderException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                    }
                    case "Insuffi