/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output for the <a>DeliverConfigSnapshot</a> action, in JSON format.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeliverConfigSnapshotResponse extends ConfigResponse implements
        ToCopyableBuilder<DeliverConfigSnapshotResponse.Builder, DeliverConfigSnapshotResponse> {
    private static final SdkField<String> CONFIG_SNAPSHOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("configSnapshotId").getter(getter(DeliverConfigSnapshotResponse::configSnapshotId))
            .setter(setter(Builder::configSnapshotId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configSnapshotId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIG_SNAPSHOT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String configSnapshotId;

    private DeliverConfigSnapshotResponse(BuilderImpl builder) {
        super(builder);
        this.configSnapshotId = builder.configSnapshotId;
    }

    /**
     * <p>
     * The ID of the snapshot that is being created.
     * </p>
     * 
     * @return The ID of the snapshot that is being created.
     */
    public final String configSnapshotId() {
        return configSnapshotId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configSnapshotId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeliverConfigSnapshotResponse)) {
            return false;
        }
        DeliverConfigSnapshotResponse other = (DeliverConfigSnapshotResponse) obj;
        return Objects.equals(configSnapshotId(), other.configSnapshotId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeliverConfigSnapshotResponse").add("ConfigSnapshotId", configSnapshotId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "configSnapshotId":
            return Optional.ofNullable(clazz.cast(configSnapshotId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("configSnapshotId", CONFIG_SNAPSHOT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeliverConfigSnapshotResponse, T> g) {
        return obj -> g.apply((DeliverConfigSnapshotResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConfigResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeliverConfigSnapshotResponse> {
        /**
         * <p>
         * The ID of the snapshot that is being created.
         * </p>
         * 
         * @param configSnapshotId
         *        The ID of the snapshot that is being created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configSnapshotId(String configSnapshotId);
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private String configSnapshotId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeliverConfigSnapshotResponse model) {
            super(model);
            configSnapshotId(model.configSnapshotId);
        }

        public final String getConfigSnapshotId() {
            return configSnapshotId;
        }

        public final void setConfigSnapshotId(String configSnapshotId) {
            this.configSnapshotId = configSnapshotId;
        }

        @Override
        public final Builder configSnapshotId(String configSnapshotId) {
            this.configSnapshotId = configSnapshotId;
            return this;
        }

        @Override
        public DeliverConfigSnapshotResponse build() {
            return new DeliverConfigSnapshotResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
