/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDiscoveredResourceCountsResponse extends ConfigResponse implements
        ToCopyableBuilder<GetDiscoveredResourceCountsResponse.Builder, GetDiscoveredResourceCountsResponse> {
    private static final SdkField<Long> TOTAL_DISCOVERED_RESOURCES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("totalDiscoveredResources").getter(getter(GetDiscoveredResourceCountsResponse::totalDiscoveredResources))
            .setter(setter(Builder::totalDiscoveredResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalDiscoveredResources").build())
            .build();

    private static final SdkField<List<ResourceCount>> RESOURCE_COUNTS_FIELD = SdkField
            .<List<ResourceCount>> builder(MarshallingType.LIST)
            .memberName("resourceCounts")
            .getter(getter(GetDiscoveredResourceCountsResponse::resourceCounts))
            .setter(setter(Builder::resourceCounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceCounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceCount> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceCount::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(GetDiscoveredResourceCountsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TOTAL_DISCOVERED_RESOURCES_FIELD, RESOURCE_COUNTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Long totalDiscoveredResources;

    private final List<ResourceCount> resourceCounts;

    private final String nextToken;

    private GetDiscoveredResourceCountsResponse(BuilderImpl builder) {
        super(builder);
        this.totalDiscoveredResources = builder.totalDiscoveredResources;
        this.resourceCounts = builder.resourceCounts;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The total number of resources that Config is recording in the region for your account. If you specify resource
     * types in the request, Config returns only the total number of resources for those resource types.
     * </p>
     * <p class="title">
     * <b>Example</b>
     * </p>
     * <ol>
     * <li>
     * <p>
     * Config is recording three resource types in the US East (Ohio) Region for your account: 25 EC2 instances, 20 IAM
     * users, and 15 S3 buckets, for a total of 60 resources.
     * </p>
     * </li>
     * <li>
     * <p>
     * You make a call to the <code>GetDiscoveredResourceCounts</code> action and specify the resource type,
     * <code>"AWS::EC2::Instances"</code>, in the request.
     * </p>
     * </li>
     * <li>
     * <p>
     * Config returns 25 for <code>totalDiscoveredResources</code>.
     * </p>
     * </li>
     * </ol>
     * 
     * @return The total number of resources that Config is recording in the region for your account. If you specify
     *         resource types in the request, Config returns only the total number of resources for those resource
     *         types.</p>
     *         <p class="title">
     *         <b>Example</b>
     *         </p>
     *         <ol>
     *         <li>
     *         <p>
     *         Config is recording three resource types in the US East (Ohio) Region for your account: 25 EC2 instances,
     *         20 IAM users, and 15 S3 buckets, for a total of 60 resources.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You make a call to the <code>GetDiscoveredResourceCounts</code> action and specify the resource type,
     *         <code>"AWS::EC2::Instances"</code>, in the request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Config returns 25 for <code>totalDiscoveredResources</code>.
     *         </p>
     *         </li>
     */
    public final Long totalDiscoveredResources() {
        return totalDiscoveredResources;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceCounts property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceCounts() {
        return resourceCounts != null && !(resourceCounts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of <code>ResourceCount</code> objects. Each object is listed in descending order by the number of
     * resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceCounts} method.
     * </p>
     * 
     * @return The list of <code>ResourceCount</code> objects. Each object is listed in descending order by the number
     *         of resources.
     */
    public final List<ResourceCount> resourceCounts() {
        return resourceCounts;
    }

    /**
     * <p>
     * The string that you use in a subsequent request to get the next page of results in a paginated response.
     * </p>
     * 
     * @return The string that you use in a subsequent request to get the next page of results in a paginated response.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(totalDiscoveredResources());
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceCounts() ? resourceCounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDiscoveredResourceCountsResponse)) {
            return false;
        }
        GetDiscoveredResourceCountsResponse other = (GetDiscoveredResourceCountsResponse) obj;
        return Objects.equals(totalDiscoveredResources(), other.totalDiscoveredResources())
                && hasResourceCounts() == other.hasResourceCounts() && Objects.equals(resourceCounts(), other.resourceCounts())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDiscoveredResourceCountsResponse")
                .add("TotalDiscoveredResources", totalDiscoveredResources())
                .add("ResourceCounts", hasResourceCounts() ? resourceCounts() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "totalDiscoveredResources":
            return Optional.ofNullable(clazz.cast(totalDiscoveredResources()));
        case "resourceCounts":
            return Optional.ofNullable(clazz.cast(resourceCounts()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("totalDiscoveredResources", TOTAL_DISCOVERED_RESOURCES_FIELD);
        map.put("resourceCounts", RESOURCE_COUNTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDiscoveredResourceCountsResponse, T> g) {
        return obj -> g.apply((GetDiscoveredResourceCountsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConfigResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetDiscoveredResourceCountsResponse> {
        /**
         * <p>
         * The total number of resources that Config is recording in the region for your account. If you specify
         * resource types in the request, Config returns only the total number of resources for those resource types.
         * </p>
         * <p class="title">
         * <b>Example</b>
         * </p>
         * <ol>
         * <li>
         * <p>
         * Config is recording three resource types in the US East (Ohio) Region for your account: 25 EC2 instances, 20
         * IAM users, and 15 S3 buckets, for a total of 60 resources.
         * </p>
         * </li>
         * <li>
         * <p>
         * You make a call to the <code>GetDiscoveredResourceCounts</code> action and specify the resource type,
         * <code>"AWS::EC2::Instances"</code>, in the request.
         * </p>
         * </li>
         * <li>
         * <p>
         * Config returns 25 for <code>totalDiscoveredResources</code>.
         * </p>
         * </li>
         * </ol>
         * 
         * @param totalDiscoveredResources
         *        The total number of resources that Config is recording in the region for your account. If you specify
         *        resource types in the request, Config returns only the total number of resources for those resource
         *        types.</p>
         *        <p class="title">
         *        <b>Example</b>
         *        </p>
         *        <ol>
         *        <li>
         *        <p>
         *        Config is recording three resource types in the US East (Ohio) Region for your account: 25 EC2
         *        instances, 20 IAM users, and 15 S3 buckets, for a total of 60 resources.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        You make a call to the <code>GetDiscoveredResourceCounts</code> action and specify the resource type,
         *        <code>"AWS::EC2::Instances"</code>, in the request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Config returns 25 for <code>totalDiscoveredResources</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalDiscoveredResources(Long totalDiscoveredResources);

        /**
         * <p>
         * The list of <code>ResourceCount</code> objects. Each object is listed in descending order by the number of
         * resources.
         * </p>
         * 
         * @param resourceCounts
         *        The list of <code>ResourceCount</code> objects. Each object is listed in descending order by the
         *        number of resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceCounts(Collection<ResourceCount> resourceCounts);

        /**
         * <p>
         * The list of <code>ResourceCount</code> objects. Each object is listed in descending order by the number of
         * resources.
         * </p>
         * 
         * @param resourceCounts
         *        The list of <code>ResourceCount</code> objects. Each object is listed in descending order by the
         *        number of resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceCounts(ResourceCount... resourceCounts);

        /**
         * <p>
         * The list of <code>ResourceCount</code> objects. Each object is listed in descending order by the number of
         * resources.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.config.model.ResourceCount.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.config.model.ResourceCount#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.config.model.ResourceCount.Builder#build()} is called immediately and
         * its result is passed to {@link #resourceCounts(List<ResourceCount>)}.
         * 
         * @param resourceCounts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.config.model.ResourceCount.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceCounts(java.util.Collection<ResourceCount>)
         */
        Builder resourceCounts(Consumer<ResourceCount.Builder>... resourceCounts);

        /**
         * <p>
         * The string that you use in a subsequent request to get the next page of results in a paginated response.
         * </p>
         * 
         * @param nextToken
         *        The string that you use in a subsequent request to get the next page of results in a paginated
         *        response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private Long totalDiscoveredResources;

        private List<ResourceCount> resourceCounts = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDiscoveredResourceCountsResponse model) {
            super(model);
            totalDiscoveredResources(model.totalDiscoveredResources);
            resourceCounts(model.resourceCounts);
            nextToken(model.nextToken);
        }

        public final Long getTotalDiscoveredResources() {
            return totalDiscoveredResources;
        }

        public final void setTotalDiscoveredResources(Long totalDiscoveredResources) {
            this.totalDiscoveredResources = totalDiscoveredResources;
        }

        @Override
        public final Builder totalDiscoveredResources(Long totalDiscoveredResources) {
            this.totalDiscoveredResources = totalDiscoveredResources;
            return this;
        }

        public final List<ResourceCount.Builder> getResourceCounts() {
            List<ResourceCount.Builder> result = ResourceCountsCopier.copyToBuilder(this.resourceCounts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceCounts(Collection<ResourceCount.BuilderImpl> resourceCounts) {
            this.resourceCounts = ResourceCountsCopier.copyFromBuilder(resourceCounts);
        }

        @Override
        public final Builder resourceCounts(Collection<ResourceCount> resourceCounts) {
            this.resourceCounts = ResourceCountsCopier.copy(resourceCounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceCounts(ResourceCount... resourceCounts) {
            resourceCounts(Arrays.asList(resourceCounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceCounts(Consumer<ResourceCount.Builder>... resourceCounts) {
            resourceCounts(Stream.of(resourceCounts).map(c -> ResourceCount.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetDiscoveredResourceCountsResponse build() {
            return new GetDiscoveredResourceCountsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
