/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetComplianceSummaryByConfigRuleResponse extends ConfigResponse implements
        ToCopyableBuilder<GetComplianceSummaryByConfigRuleResponse.Builder, GetComplianceSummaryByConfigRuleResponse> {
    private static final SdkField<ComplianceSummary> COMPLIANCE_SUMMARY_FIELD = SdkField
            .<ComplianceSummary> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetComplianceSummaryByConfigRuleResponse::complianceSummary))
            .setter(setter(Builder::complianceSummary)).constructor(ComplianceSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceSummary").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPLIANCE_SUMMARY_FIELD));

    private final ComplianceSummary complianceSummary;

    private GetComplianceSummaryByConfigRuleResponse(BuilderImpl builder) {
        super(builder);
        this.complianceSummary = builder.complianceSummary;
    }

    /**
     * <p>
     * The number of AWS Config rules that are compliant and the number that are noncompliant, up to a maximum of 25 for
     * each.
     * </p>
     * 
     * @return The number of AWS Config rules that are compliant and the number that are noncompliant, up to a maximum
     *         of 25 for each.
     */
    public ComplianceSummary complianceSummary() {
        return complianceSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(complianceSummary());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetComplianceSummaryByConfigRuleResponse)) {
            return false;
        }
        GetComplianceSummaryByConfigRuleResponse other = (GetComplianceSummaryByConfigRuleResponse) obj;
        return Objects.equals(complianceSummary(), other.complianceSummary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetComplianceSummaryByConfigRuleResponse").add("ComplianceSummary", complianceSummary()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ComplianceSummary":
            return Optional.ofNullable(clazz.cast(complianceSummary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetComplianceSummaryByConfigRuleResponse, T> g) {
        return obj -> g.apply((GetComplianceSummaryByConfigRuleResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetComplianceSummaryByConfigRuleResponse> {
        /**
         * <p>
         * The number of AWS Config rules that are compliant and the number that are noncompliant, up to a maximum of 25
         * for each.
         * </p>
         * 
         * @param complianceSummary
         *        The number of AWS Config rules that are compliant and the number that are noncompliant, up to a
         *        maximum of 25 for each.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceSummary(ComplianceSummary complianceSummary);

        /**
         * <p>
         * The number of AWS Config rules that are compliant and the number that are noncompliant, up to a maximum of 25
         * for each.
         * </p>
         * This is a convenience that creates an instance of the {@link ComplianceSummary.Builder} avoiding the need to
         * create one manually via {@link ComplianceSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link ComplianceSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #complianceSummary(ComplianceSummary)}.
         * 
         * @param complianceSummary
         *        a consumer that will call methods on {@link ComplianceSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #complianceSummary(ComplianceSummary)
         */
        default Builder complianceSummary(Consumer<ComplianceSummary.Builder> complianceSummary) {
            return complianceSummary(ComplianceSummary.builder().applyMutation(complianceSummary).build());
        }
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private ComplianceSummary complianceSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(GetComplianceSummaryByConfigRuleResponse model) {
            super(model);
            complianceSummary(model.complianceSummary);
        }

        public final ComplianceSummary.Builder getComplianceSummary() {
            return complianceSummary != null ? complianceSummary.toBuilder() : null;
        }

        @Override
        public final Builder complianceSummary(ComplianceSummary complianceSummary) {
            this.complianceSummary = complianceSummary;
            return this;
        }

        public final void setComplianceSummary(ComplianceSummary.BuilderImpl complianceSummary) {
            this.complianceSummary = complianceSummary != null ? complianceSummary.build() : null;
        }

        @Override
        public GetComplianceSummaryByConfigRuleResponse build() {
            return new GetComplianceSummaryByConfigRuleResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
