/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents the details about the remediation configuration that includes the remediation action,
 * parameters, and data to execute the action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RemediationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<RemediationConfiguration.Builder, RemediationConfiguration> {
    private static final SdkField<String> CONFIG_RULE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RemediationConfiguration::configRuleName)).setter(setter(Builder::configRuleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigRuleName").build()).build();

    private static final SdkField<String> TARGET_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RemediationConfiguration::targetTypeAsString)).setter(setter(Builder::targetType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetType").build()).build();

    private static final SdkField<String> TARGET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RemediationConfiguration::targetId)).setter(setter(Builder::targetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetId").build()).build();

    private static final SdkField<String> TARGET_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RemediationConfiguration::targetVersion)).setter(setter(Builder::targetVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetVersion").build()).build();

    private static final SdkField<Map<String, RemediationParameterValue>> PARAMETERS_FIELD = SdkField
            .<Map<String, RemediationParameterValue>> builder(MarshallingType.MAP)
            .getter(getter(RemediationConfiguration::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<RemediationParameterValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(RemediationParameterValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RemediationConfiguration::resourceType)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIG_RULE_NAME_FIELD,
            TARGET_TYPE_FIELD, TARGET_ID_FIELD, TARGET_VERSION_FIELD, PARAMETERS_FIELD, RESOURCE_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String configRuleName;

    private final String targetType;

    private final String targetId;

    private final String targetVersion;

    private final Map<String, RemediationParameterValue> parameters;

    private final String resourceType;

    private RemediationConfiguration(BuilderImpl builder) {
        this.configRuleName = builder.configRuleName;
        this.targetType = builder.targetType;
        this.targetId = builder.targetId;
        this.targetVersion = builder.targetVersion;
        this.parameters = builder.parameters;
        this.resourceType = builder.resourceType;
    }

    /**
     * <p>
     * The name of the AWS Config rule.
     * </p>
     * 
     * @return The name of the AWS Config rule.
     */
    public String configRuleName() {
        return configRuleName;
    }

    /**
     * <p>
     * The type of the target. Target executes remediation. For example, SSM document.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetType} will
     * return {@link RemediationTargetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #targetTypeAsString}.
     * </p>
     * 
     * @return The type of the target. Target executes remediation. For example, SSM document.
     * @see RemediationTargetType
     */
    public RemediationTargetType targetType() {
        return RemediationTargetType.fromValue(targetType);
    }

    /**
     * <p>
     * The type of the target. Target executes remediation. For example, SSM document.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetType} will
     * return {@link RemediationTargetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #targetTypeAsString}.
     * </p>
     * 
     * @return The type of the target. Target executes remediation. For example, SSM document.
     * @see RemediationTargetType
     */
    public String targetTypeAsString() {
        return targetType;
    }

    /**
     * <p>
     * Target ID is the name of the public document.
     * </p>
     * 
     * @return Target ID is the name of the public document.
     */
    public String targetId() {
        return targetId;
    }

    /**
     * <p>
     * Version of the target. For example, version of the SSM document.
     * </p>
     * 
     * @return Version of the target. For example, version of the SSM document.
     */
    public String targetVersion() {
        return targetVersion;
    }

    /**
     * <p>
     * An object of the RemediationParameterValue.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An object of the RemediationParameterValue.
     */
    public Map<String, RemediationParameterValue> parameters() {
        return parameters;
    }

    /**
     * <p>
     * The type of a resource.
     * </p>
     * 
     * @return The type of a resource.
     */
    public String resourceType() {
        return resourceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configRuleName());
        hashCode = 31 * hashCode + Objects.hashCode(targetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(targetId());
        hashCode = 31 * hashCode + Objects.hashCode(targetVersion());
        hashCode = 31 * hashCode + Objects.hashCode(parameters());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemediationConfiguration)) {
            return false;
        }
        RemediationConfiguration other = (RemediationConfiguration) obj;
        return Objects.equals(configRuleName(), other.configRuleName())
                && Objects.equals(targetTypeAsString(), other.targetTypeAsString())
                && Objects.equals(targetId(), other.targetId()) && Objects.equals(targetVersion(), other.targetVersion())
                && Objects.equals(parameters(), other.parameters()) && Objects.equals(resourceType(), other.resourceType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RemediationConfiguration").add("ConfigRuleName", configRuleName())
                .add("TargetType", targetTypeAsString()).add("TargetId", targetId()).add("TargetVersion", targetVersion())
                .add("Parameters", parameters()).add("ResourceType", resourceType()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigRuleName":
            return Optional.ofNullable(clazz.cast(configRuleName()));
        case "TargetType":
            return Optional.ofNullable(clazz.cast(targetTypeAsString()));
        case "TargetId":
            return Optional.ofNullable(clazz.cast(targetId()));
        case "TargetVersion":
            return Optional.ofNullable(clazz.cast(targetVersion()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RemediationConfiguration, T> g) {
        return obj -> g.apply((RemediationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RemediationConfiguration> {
        /**
         * <p>
         * The name of the AWS Config rule.
         * </p>
         * 
         * @param configRuleName
         *        The name of the AWS Config rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configRuleName(String configRuleName);

        /**
         * <p>
         * The type of the target. Target executes remediation. For example, SSM document.
         * </p>
         * 
         * @param targetType
         *        The type of the target. Target executes remediation. For example, SSM document.
         * @see RemediationTargetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RemediationTargetType
         */
        Builder targetType(String targetType);

        /**
         * <p>
         * The type of the target. Target executes remediation. For example, SSM document.
         * </p>
         * 
         * @param targetType
         *        The type of the target. Target executes remediation. For example, SSM document.
         * @see RemediationTargetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RemediationTargetType
         */
        Builder targetType(RemediationTargetType targetType);

        /**
         * <p>
         * Target ID is the name of the public document.
         * </p>
         * 
         * @param targetId
         *        Target ID is the name of the public document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetId(String targetId);

        /**
         * <p>
         * Version of the target. For example, version of the SSM document.
         * </p>
         * 
         * @param targetVersion
         *        Version of the target. For example, version of the SSM document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetVersion(String targetVersion);

        /**
         * <p>
         * An object of the RemediationParameterValue.
         * </p>
         * 
         * @param parameters
         *        An object of the RemediationParameterValue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, RemediationParameterValue> parameters);

        /**
         * <p>
         * The type of a resource.
         * </p>
         * 
         * @param resourceType
         *        The type of a resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);
    }

    static final class BuilderImpl implements Builder {
        private String configRuleName;

        private String targetType;

        private String targetId;

        private String targetVersion;

        private Map<String, RemediationParameterValue> parameters = DefaultSdkAutoConstructMap.getInstance();

        private String resourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(RemediationConfiguration model) {
            configRuleName(model.configRuleName);
            targetType(model.targetType);
            targetId(model.targetId);
            targetVersion(model.targetVersion);
            parameters(model.parameters);
            resourceType(model.resourceType);
        }

        public final String getConfigRuleName() {
            return configRuleName;
        }

        @Override
        public final Builder configRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
            return this;
        }

        public final void setConfigRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
        }

        public final String getTargetTypeAsString() {
            return targetType;
        }

        @Override
        public final Builder targetType(String targetType) {
            this.targetType = targetType;
            return this;
        }

        @Override
        public final Builder targetType(RemediationTargetType targetType) {
            this.targetType(targetType.toString());
            return this;
        }

        public final void setTargetType(String targetType) {
            this.targetType = targetType;
        }

        public final String getTargetId() {
            return targetId;
        }

        @Override
        public final Builder targetId(String targetId) {
            this.targetId = targetId;
            return this;
        }

        public final void setTargetId(String targetId) {
            this.targetId = targetId;
        }

        public final String getTargetVersion() {
            return targetVersion;
        }

        @Override
        public final Builder targetVersion(String targetVersion) {
            this.targetVersion = targetVersion;
            return this;
        }

        public final void setTargetVersion(String targetVersion) {
            this.targetVersion = targetVersion;
        }

        public final Map<String, RemediationParameterValue.Builder> getParameters() {
            return parameters != null ? CollectionUtils.mapValues(parameters, RemediationParameterValue::toBuilder) : null;
        }

        @Override
        public final Builder parameters(Map<String, RemediationParameterValue> parameters) {
            this.parameters = RemediationParametersCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, RemediationParameterValue.BuilderImpl> parameters) {
            this.parameters = RemediationParametersCopier.copyFromBuilder(parameters);
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public RemediationConfiguration build() {
            return new RemediationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
