/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutConfigurationAggregatorRequest extends ConfigRequest implements
        ToCopyableBuilder<PutConfigurationAggregatorRequest.Builder, PutConfigurationAggregatorRequest> {
    private static final SdkField<String> CONFIGURATION_AGGREGATOR_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(PutConfigurationAggregatorRequest::configurationAggregatorName))
            .setter(setter(Builder::configurationAggregatorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationAggregatorName")
                    .build()).build();

    private static final SdkField<List<AccountAggregationSource>> ACCOUNT_AGGREGATION_SOURCES_FIELD = SdkField
            .<List<AccountAggregationSource>> builder(MarshallingType.LIST)
            .getter(getter(PutConfigurationAggregatorRequest::accountAggregationSources))
            .setter(setter(Builder::accountAggregationSources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountAggregationSources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AccountAggregationSource> builder(MarshallingType.SDK_POJO)
                                            .constructor(AccountAggregationSource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<OrganizationAggregationSource> ORGANIZATION_AGGREGATION_SOURCE_FIELD = SdkField
            .<OrganizationAggregationSource> builder(MarshallingType.SDK_POJO)
            .getter(getter(PutConfigurationAggregatorRequest::organizationAggregationSource))
            .setter(setter(Builder::organizationAggregationSource))
            .constructor(OrganizationAggregationSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationAggregationSource")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONFIGURATION_AGGREGATOR_NAME_FIELD, ACCOUNT_AGGREGATION_SOURCES_FIELD, ORGANIZATION_AGGREGATION_SOURCE_FIELD));

    private final String configurationAggregatorName;

    private final List<AccountAggregationSource> accountAggregationSources;

    private final OrganizationAggregationSource organizationAggregationSource;

    private PutConfigurationAggregatorRequest(BuilderImpl builder) {
        super(builder);
        this.configurationAggregatorName = builder.configurationAggregatorName;
        this.accountAggregationSources = builder.accountAggregationSources;
        this.organizationAggregationSource = builder.organizationAggregationSource;
    }

    /**
     * <p>
     * The name of the configuration aggregator.
     * </p>
     * 
     * @return The name of the configuration aggregator.
     */
    public String configurationAggregatorName() {
        return configurationAggregatorName;
    }

    /**
     * <p>
     * A list of AccountAggregationSource object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of AccountAggregationSource object.
     */
    public List<AccountAggregationSource> accountAggregationSources() {
        return accountAggregationSources;
    }

    /**
     * <p>
     * An OrganizationAggregationSource object.
     * </p>
     * 
     * @return An OrganizationAggregationSource object.
     */
    public OrganizationAggregationSource organizationAggregationSource() {
        return organizationAggregationSource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configurationAggregatorName());
        hashCode = 31 * hashCode + Objects.hashCode(accountAggregationSources());
        hashCode = 31 * hashCode + Objects.hashCode(organizationAggregationSource());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutConfigurationAggregatorRequest)) {
            return false;
        }
        PutConfigurationAggregatorRequest other = (PutConfigurationAggregatorRequest) obj;
        return Objects.equals(configurationAggregatorName(), other.configurationAggregatorName())
                && Objects.equals(accountAggregationSources(), other.accountAggregationSources())
                && Objects.equals(organizationAggregationSource(), other.organizationAggregationSource());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutConfigurationAggregatorRequest")
                .add("ConfigurationAggregatorName", configurationAggregatorName())
                .add("AccountAggregationSources", accountAggregationSources())
                .add("OrganizationAggregationSource", organizationAggregationSource()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationAggregatorName":
            return Optional.ofNullable(clazz.cast(configurationAggregatorName()));
        case "AccountAggregationSources":
            return Optional.ofNullable(clazz.cast(accountAggregationSources()));
        case "OrganizationAggregationSource":
            return Optional.ofNullable(clazz.cast(organizationAggregationSource()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutConfigurationAggregatorRequest, T> g) {
        return obj -> g.apply((PutConfigurationAggregatorRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutConfigurationAggregatorRequest> {
        /**
         * <p>
         * The name of the configuration aggregator.
         * </p>
         * 
         * @param configurationAggregatorName
         *        The name of the configuration aggregator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationAggregatorName(String configurationAggregatorName);

        /**
         * <p>
         * A list of AccountAggregationSource object.
         * </p>
         * 
         * @param accountAggregationSources
         *        A list of AccountAggregationSource object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountAggregationSources(Collection<AccountAggregationSource> accountAggregationSources);

        /**
         * <p>
         * A list of AccountAggregationSource object.
         * </p>
         * 
         * @param accountAggregationSources
         *        A list of AccountAggregationSource object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountAggregationSources(AccountAggregationSource... accountAggregationSources);

        /**
         * <p>
         * A list of AccountAggregationSource object.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AccountAggregationSource>.Builder} avoiding
         * the need to create one manually via {@link List<AccountAggregationSource>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AccountAggregationSource>.Builder#build()} is called
         * immediately and its result is passed to {@link #accountAggregationSources(List<AccountAggregationSource>)}.
         * 
         * @param accountAggregationSources
         *        a consumer that will call methods on {@link List<AccountAggregationSource>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accountAggregationSources(List<AccountAggregationSource>)
         */
        Builder accountAggregationSources(Consumer<AccountAggregationSource.Builder>... accountAggregationSources);

        /**
         * <p>
         * An OrganizationAggregationSource object.
         * </p>
         * 
         * @param organizationAggregationSource
         *        An OrganizationAggregationSource object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationAggregationSource(OrganizationAggregationSource organizationAggregationSource);

        /**
         * <p>
         * An OrganizationAggregationSource object.
         * </p>
         * This is a convenience that creates an instance of the {@link OrganizationAggregationSource.Builder} avoiding
         * the need to create one manually via {@link OrganizationAggregationSource#builder()}.
         *
         * When the {@link Consumer} completes, {@link OrganizationAggregationSource.Builder#build()} is called
         * immediately and its result is passed to {@link #organizationAggregationSource(OrganizationAggregationSource)}
         * .
         * 
         * @param organizationAggregationSource
         *        a consumer that will call methods on {@link OrganizationAggregationSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #organizationAggregationSource(OrganizationAggregationSource)
         */
        default Builder organizationAggregationSource(
                Consumer<OrganizationAggregationSource.Builder> organizationAggregationSource) {
            return organizationAggregationSource(OrganizationAggregationSource.builder()
                    .applyMutation(organizationAggregationSource).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConfigRequest.BuilderImpl implements Builder {
        private String configurationAggregatorName;

        private List<AccountAggregationSource> accountAggregationSources = DefaultSdkAutoConstructList.getInstance();

        private OrganizationAggregationSource organizationAggregationSource;

        private BuilderImpl() {
        }

        private BuilderImpl(PutConfigurationAggregatorRequest model) {
            super(model);
            configurationAggregatorName(model.configurationAggregatorName);
            accountAggregationSources(model.accountAggregationSources);
            organizationAggregationSource(model.organizationAggregationSource);
        }

        public final String getConfigurationAggregatorName() {
            return configurationAggregatorName;
        }

        @Override
        public final Builder configurationAggregatorName(String configurationAggregatorName) {
            this.configurationAggregatorName = configurationAggregatorName;
            return this;
        }

        public final void setConfigurationAggregatorName(String configurationAggregatorName) {
            this.configurationAggregatorName = configurationAggregatorName;
        }

        public final Collection<AccountAggregationSource.Builder> getAccountAggregationSources() {
            return accountAggregationSources != null ? accountAggregationSources.stream()
                    .map(AccountAggregationSource::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder accountAggregationSources(Collection<AccountAggregationSource> accountAggregationSources) {
            this.accountAggregationSources = AccountAggregationSourceListCopier.copy(accountAggregationSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountAggregationSources(AccountAggregationSource... accountAggregationSources) {
            accountAggregationSources(Arrays.asList(accountAggregationSources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountAggregationSources(Consumer<AccountAggregationSource.Builder>... accountAggregationSources) {
            accountAggregationSources(Stream.of(accountAggregationSources)
                    .map(c -> AccountAggregationSource.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAccountAggregationSources(Collection<AccountAggregationSource.BuilderImpl> accountAggregationSources) {
            this.accountAggregationSources = AccountAggregationSourceListCopier.copyFromBuilder(accountAggregationSources);
        }

        public final OrganizationAggregationSource.Builder getOrganizationAggregationSource() {
            return organizationAggregationSource != null ? organizationAggregationSource.toBuilder() : null;
        }

        @Override
        public final Builder organizationAggregationSource(OrganizationAggregationSource organizationAggregationSource) {
            this.organizationAggregationSource = organizationAggregationSource;
            return this;
        }

        public final void setOrganizationAggregationSource(OrganizationAggregationSource.BuilderImpl organizationAggregationSource) {
            this.organizationAggregationSource = organizationAggregationSource != null ? organizationAggregationSource.build()
                    : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutConfigurationAggregatorRequest build() {
            return new PutConfigurationAggregatorRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
