/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeRemediationConfigurationsRequest extends ConfigRequest implements
        ToCopyableBuilder<DescribeRemediationConfigurationsRequest.Builder, DescribeRemediationConfigurationsRequest> {
    private static final SdkField<List<String>> CONFIG_RULE_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeRemediationConfigurationsRequest::configRuleNames))
            .setter(setter(Builder::configRuleNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigRuleNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIG_RULE_NAMES_FIELD));

    private final List<String> configRuleNames;

    private DescribeRemediationConfigurationsRequest(BuilderImpl builder) {
        super(builder);
        this.configRuleNames = builder.configRuleNames;
    }

    /**
     * <p>
     * A list of AWS Config rule names of remediation configurations for which you want details.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of AWS Config rule names of remediation configurations for which you want details.
     */
    public List<String> configRuleNames() {
        return configRuleNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configRuleNames());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRemediationConfigurationsRequest)) {
            return false;
        }
        DescribeRemediationConfigurationsRequest other = (DescribeRemediationConfigurationsRequest) obj;
        return Objects.equals(configRuleNames(), other.configRuleNames());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeRemediationConfigurationsRequest").add("ConfigRuleNames", configRuleNames()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigRuleNames":
            return Optional.ofNullable(clazz.cast(configRuleNames()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeRemediationConfigurationsRequest, T> g) {
        return obj -> g.apply((DescribeRemediationConfigurationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeRemediationConfigurationsRequest> {
        /**
         * <p>
         * A list of AWS Config rule names of remediation configurations for which you want details.
         * </p>
         * 
         * @param configRuleNames
         *        A list of AWS Config rule names of remediation configurations for which you want details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configRuleNames(Collection<String> configRuleNames);

        /**
         * <p>
         * A list of AWS Config rule names of remediation configurations for which you want details.
         * </p>
         * 
         * @param configRuleNames
         *        A list of AWS Config rule names of remediation configurations for which you want details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configRuleNames(String... configRuleNames);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConfigRequest.BuilderImpl implements Builder {
        private List<String> configRuleNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRemediationConfigurationsRequest model) {
            super(model);
            configRuleNames(model.configRuleNames);
        }

        public final Collection<String> getConfigRuleNames() {
            return configRuleNames;
        }

        @Override
        public final Builder configRuleNames(Collection<String> configRuleNames) {
            this.configRuleNames = ConfigRuleNamesCopier.copy(configRuleNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configRuleNames(String... configRuleNames) {
            configRuleNames(Arrays.asList(configRuleNames));
            return this;
        }

        public final void setConfigRuleNames(Collection<String> configRuleNames) {
            this.configRuleNames = ConfigRuleNamesCopier.copy(configRuleNames);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeRemediationConfigurationsRequest build() {
            return new DescribeRemediationConfigurationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
