/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAggregateConfigRuleComplianceSummaryRequest extends ConfigRequest implements
        ToCopyableBuilder<GetAggregateConfigRuleComplianceSummaryRequest.Builder, GetAggregateConfigRuleComplianceSummaryRequest> {
    private static final SdkField<String> CONFIGURATION_AGGREGATOR_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(GetAggregateConfigRuleComplianceSummaryRequest::configurationAggregatorName))
            .setter(setter(Builder::configurationAggregatorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationAggregatorName")
                    .build()).build();

    private static final SdkField<ConfigRuleComplianceSummaryFilters> FILTERS_FIELD = SdkField
            .<ConfigRuleComplianceSummaryFilters> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetAggregateConfigRuleComplianceSummaryRequest::filters)).setter(setter(Builder::filters))
            .constructor(ConfigRuleComplianceSummaryFilters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build()).build();

    private static final SdkField<String> GROUP_BY_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetAggregateConfigRuleComplianceSummaryRequest::groupByKeyAsString))
            .setter(setter(Builder::groupByKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupByKey").build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(GetAggregateConfigRuleComplianceSummaryRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetAggregateConfigRuleComplianceSummaryRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONFIGURATION_AGGREGATOR_NAME_FIELD, FILTERS_FIELD, GROUP_BY_KEY_FIELD, LIMIT_FIELD, NEXT_TOKEN_FIELD));

    private final String configurationAggregatorName;

    private final ConfigRuleComplianceSummaryFilters filters;

    private final String groupByKey;

    private final Integer limit;

    private final String nextToken;

    private GetAggregateConfigRuleComplianceSummaryRequest(BuilderImpl builder) {
        super(builder);
        this.configurationAggregatorName = builder.configurationAggregatorName;
        this.filters = builder.filters;
        this.groupByKey = builder.groupByKey;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The name of the configuration aggregator.
     * </p>
     * 
     * @return The name of the configuration aggregator.
     */
    public String configurationAggregatorName() {
        return configurationAggregatorName;
    }

    /**
     * <p>
     * Filters the results based on the ConfigRuleComplianceSummaryFilters object.
     * </p>
     * 
     * @return Filters the results based on the ConfigRuleComplianceSummaryFilters object.
     */
    public ConfigRuleComplianceSummaryFilters filters() {
        return filters;
    }

    /**
     * <p>
     * Groups the result based on ACCOUNT_ID or AWS_REGION.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #groupByKey} will
     * return {@link ConfigRuleComplianceSummaryGroupKey#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #groupByKeyAsString}.
     * </p>
     * 
     * @return Groups the result based on ACCOUNT_ID or AWS_REGION.
     * @see ConfigRuleComplianceSummaryGroupKey
     */
    public ConfigRuleComplianceSummaryGroupKey groupByKey() {
        return ConfigRuleComplianceSummaryGroupKey.fromValue(groupByKey);
    }

    /**
     * <p>
     * Groups the result based on ACCOUNT_ID or AWS_REGION.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #groupByKey} will
     * return {@link ConfigRuleComplianceSummaryGroupKey#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #groupByKeyAsString}.
     * </p>
     * 
     * @return Groups the result based on ACCOUNT_ID or AWS_REGION.
     * @see ConfigRuleComplianceSummaryGroupKey
     */
    public String groupByKeyAsString() {
        return groupByKey;
    }

    /**
     * <p>
     * The maximum number of evaluation results returned on each page. The default is 1000. You cannot specify a number
     * greater than 1000. If you specify 0, AWS Config uses the default.
     * </p>
     * 
     * @return The maximum number of evaluation results returned on each page. The default is 1000. You cannot specify a
     *         number greater than 1000. If you specify 0, AWS Config uses the default.
     */
    public Integer limit() {
        return limit;
    }

    /**
     * <p>
     * The nextToken string returned on a previous page that you use to get the next page of results in a paginated
     * response.
     * </p>
     * 
     * @return The nextToken string returned on a previous page that you use to get the next page of results in a
     *         paginated response.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configurationAggregatorName());
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(groupByKeyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAggregateConfigRuleComplianceSummaryRequest)) {
            return false;
        }
        GetAggregateConfigRuleComplianceSummaryRequest other = (GetAggregateConfigRuleComplianceSummaryRequest) obj;
        return Objects.equals(configurationAggregatorName(), other.configurationAggregatorName())
                && Objects.equals(filters(), other.filters()) && Objects.equals(groupByKeyAsString(), other.groupByKeyAsString())
                && Objects.equals(limit(), other.limit()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetAggregateConfigRuleComplianceSummaryRequest")
                .add("ConfigurationAggregatorName", configurationAggregatorName()).add("Filters", filters())
                .add("GroupByKey", groupByKeyAsString()).add("Limit", limit()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationAggregatorName":
            return Optional.ofNullable(clazz.cast(configurationAggregatorName()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "GroupByKey":
            return Optional.ofNullable(clazz.cast(groupByKeyAsString()));
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAggregateConfigRuleComplianceSummaryRequest, T> g) {
        return obj -> g.apply((GetAggregateConfigRuleComplianceSummaryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetAggregateConfigRuleComplianceSummaryRequest> {
        /**
         * <p>
         * The name of the configuration aggregator.
         * </p>
         * 
         * @param configurationAggregatorName
         *        The name of the configuration aggregator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationAggregatorName(String configurationAggregatorName);

        /**
         * <p>
         * Filters the results based on the ConfigRuleComplianceSummaryFilters object.
         * </p>
         * 
         * @param filters
         *        Filters the results based on the ConfigRuleComplianceSummaryFilters object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(ConfigRuleComplianceSummaryFilters filters);

        /**
         * <p>
         * Filters the results based on the ConfigRuleComplianceSummaryFilters object.
         * </p>
         * This is a convenience that creates an instance of the {@link ConfigRuleComplianceSummaryFilters.Builder}
         * avoiding the need to create one manually via {@link ConfigRuleComplianceSummaryFilters#builder()}.
         *
         * When the {@link Consumer} completes, {@link ConfigRuleComplianceSummaryFilters.Builder#build()} is called
         * immediately and its result is passed to {@link #filters(ConfigRuleComplianceSummaryFilters)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link ConfigRuleComplianceSummaryFilters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(ConfigRuleComplianceSummaryFilters)
         */
        default Builder filters(Consumer<ConfigRuleComplianceSummaryFilters.Builder> filters) {
            return filters(ConfigRuleComplianceSummaryFilters.builder().applyMutation(filters).build());
        }

        /**
         * <p>
         * Groups the result based on ACCOUNT_ID or AWS_REGION.
         * </p>
         * 
         * @param groupByKey
         *        Groups the result based on ACCOUNT_ID or AWS_REGION.
         * @see ConfigRuleComplianceSummaryGroupKey
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigRuleComplianceSummaryGroupKey
         */
        Builder groupByKey(String groupByKey);

        /**
         * <p>
         * Groups the result based on ACCOUNT_ID or AWS_REGION.
         * </p>
         * 
         * @param groupByKey
         *        Groups the result based on ACCOUNT_ID or AWS_REGION.
         * @see ConfigRuleComplianceSummaryGroupKey
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigRuleComplianceSummaryGroupKey
         */
        Builder groupByKey(ConfigRuleComplianceSummaryGroupKey groupByKey);

        /**
         * <p>
         * The maximum number of evaluation results returned on each page. The default is 1000. You cannot specify a
         * number greater than 1000. If you specify 0, AWS Config uses the default.
         * </p>
         * 
         * @param limit
         *        The maximum number of evaluation results returned on each page. The default is 1000. You cannot
         *        specify a number greater than 1000. If you specify 0, AWS Config uses the default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * The nextToken string returned on a previous page that you use to get the next page of results in a paginated
         * response.
         * </p>
         * 
         * @param nextToken
         *        The nextToken string returned on a previous page that you use to get the next page of results in a
         *        paginated response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConfigRequest.BuilderImpl implements Builder {
        private String configurationAggregatorName;

        private ConfigRuleComplianceSummaryFilters filters;

        private String groupByKey;

        private Integer limit;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAggregateConfigRuleComplianceSummaryRequest model) {
            super(model);
            configurationAggregatorName(model.configurationAggregatorName);
            filters(model.filters);
            groupByKey(model.groupByKey);
            limit(model.limit);
            nextToken(model.nextToken);
        }

        public final String getConfigurationAggregatorName() {
            return configurationAggregatorName;
        }

        @Override
        public final Builder configurationAggregatorName(String configurationAggregatorName) {
            this.configurationAggregatorName = configurationAggregatorName;
            return this;
        }

        public final void setConfigurationAggregatorName(String configurationAggregatorName) {
            this.configurationAggregatorName = configurationAggregatorName;
        }

        public final ConfigRuleComplianceSummaryFilters.Builder getFilters() {
            return filters != null ? filters.toBuilder() : null;
        }

        @Override
        public final Builder filters(ConfigRuleComplianceSummaryFilters filters) {
            this.filters = filters;
            return this;
        }

        public final void setFilters(ConfigRuleComplianceSummaryFilters.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        public final String getGroupByKeyAsString() {
            return groupByKey;
        }

        @Override
        public final Builder groupByKey(String groupByKey) {
            this.groupByKey = groupByKey;
            return this;
        }

        @Override
        public final Builder groupByKey(ConfigRuleComplianceSummaryGroupKey groupByKey) {
            this.groupByKey(groupByKey == null ? null : groupByKey.toString());
            return this;
        }

        public final void setGroupByKey(String groupByKey) {
            this.groupByKey = groupByKey;
        }

        public final Integer getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetAggregateConfigRuleComplianceSummaryRequest build() {
            return new GetAggregateConfigRuleComplianceSummaryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
