/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetComplianceDetailsByConfigRuleResponse extends ConfigResponse implements
        ToCopyableBuilder<GetComplianceDetailsByConfigRuleResponse.Builder, GetComplianceDetailsByConfigRuleResponse> {
    private static final SdkField<List<EvaluationResult>> EVALUATION_RESULTS_FIELD = SdkField
            .<List<EvaluationResult>> builder(MarshallingType.LIST)
            .getter(getter(GetComplianceDetailsByConfigRuleResponse::evaluationResults))
            .setter(setter(Builder::evaluationResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationResults").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EvaluationResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(EvaluationResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetComplianceDetailsByConfigRuleResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVALUATION_RESULTS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<EvaluationResult> evaluationResults;

    private final String nextToken;

    private GetComplianceDetailsByConfigRuleResponse(BuilderImpl builder) {
        super(builder);
        this.evaluationResults = builder.evaluationResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Indicates whether the AWS resource complies with the specified AWS Config rule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Indicates whether the AWS resource complies with the specified AWS Config rule.
     */
    public List<EvaluationResult> evaluationResults() {
        return evaluationResults;
    }

    /**
     * <p>
     * The string that you use in a subsequent request to get the next page of results in a paginated response.
     * </p>
     * 
     * @return The string that you use in a subsequent request to get the next page of results in a paginated response.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(evaluationResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetComplianceDetailsByConfigRuleResponse)) {
            return false;
        }
        GetComplianceDetailsByConfigRuleResponse other = (GetComplianceDetailsByConfigRuleResponse) obj;
        return Objects.equals(evaluationResults(), other.evaluationResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetComplianceDetailsByConfigRuleResponse").add("EvaluationResults", evaluationResults())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EvaluationResults":
            return Optional.ofNullable(clazz.cast(evaluationResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetComplianceDetailsByConfigRuleResponse, T> g) {
        return obj -> g.apply((GetComplianceDetailsByConfigRuleResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetComplianceDetailsByConfigRuleResponse> {
        /**
         * <p>
         * Indicates whether the AWS resource complies with the specified AWS Config rule.
         * </p>
         * 
         * @param evaluationResults
         *        Indicates whether the AWS resource complies with the specified AWS Config rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationResults(Collection<EvaluationResult> evaluationResults);

        /**
         * <p>
         * Indicates whether the AWS resource complies with the specified AWS Config rule.
         * </p>
         * 
         * @param evaluationResults
         *        Indicates whether the AWS resource complies with the specified AWS Config rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationResults(EvaluationResult... evaluationResults);

        /**
         * <p>
         * Indicates whether the AWS resource complies with the specified AWS Config rule.
         * </p>
         * This is a convenience that creates an instance of the {@link List<EvaluationResult>.Builder} avoiding the
         * need to create one manually via {@link List<EvaluationResult>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EvaluationResult>.Builder#build()} is called immediately and
         * its result is passed to {@link #evaluationResults(List<EvaluationResult>)}.
         * 
         * @param evaluationResults
         *        a consumer that will call methods on {@link List<EvaluationResult>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #evaluationResults(List<EvaluationResult>)
         */
        Builder evaluationResults(Consumer<EvaluationResult.Builder>... evaluationResults);

        /**
         * <p>
         * The string that you use in a subsequent request to get the next page of results in a paginated response.
         * </p>
         * 
         * @param nextToken
         *        The string that you use in a subsequent request to get the next page of results in a paginated
         *        response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private List<EvaluationResult> evaluationResults = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetComplianceDetailsByConfigRuleResponse model) {
            super(model);
            evaluationResults(model.evaluationResults);
            nextToken(model.nextToken);
        }

        public final Collection<EvaluationResult.Builder> getEvaluationResults() {
            return evaluationResults != null ? evaluationResults.stream().map(EvaluationResult::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder evaluationResults(Collection<EvaluationResult> evaluationResults) {
            this.evaluationResults = EvaluationResultsCopier.copy(evaluationResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evaluationResults(EvaluationResult... evaluationResults) {
            evaluationResults(Arrays.asList(evaluationResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evaluationResults(Consumer<EvaluationResult.Builder>... evaluationResults) {
            evaluationResults(Stream.of(evaluationResults).map(c -> EvaluationResult.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setEvaluationResults(Collection<EvaluationResult.BuilderImpl> evaluationResults) {
            this.evaluationResults = EvaluationResultsCopier.copyFromBuilder(evaluationResults);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetComplianceDetailsByConfigRuleResponse build() {
            return new GetComplianceDetailsByConfigRuleResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
