/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.config.model.AggregateEvaluationResult;
import software.amazon.awssdk.services.config.model.AggregateEvaluationResultListCopier;
import software.amazon.awssdk.services.config.model.ConfigResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAggregateComplianceDetailsByConfigRuleResponse
extends ConfigResponse
implements ToCopyableBuilder<Builder, GetAggregateComplianceDetailsByConfigRuleResponse> {
    private static final SdkField<List<AggregateEvaluationResult>> AGGREGATE_EVALUATION_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetAggregateComplianceDetailsByConfigRuleResponse.getter(GetAggregateComplianceDetailsByConfigRuleResponse::aggregateEvaluationResults)).setter(GetAggregateComplianceDetailsByConfigRuleResponse.setter(Builder::aggregateEvaluationResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregateEvaluationResults").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AggregateEvaluationResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetAggregateComplianceDetailsByConfigRuleResponse.getter(GetAggregateComplianceDetailsByConfigRuleResponse::nextToken)).setter(GetAggregateComplianceDetailsByConfigRuleResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGGREGATE_EVALUATION_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<AggregateEvaluationResult> aggregateEvaluationResults;
    private final String nextToken;

    private GetAggregateComplianceDetailsByConfigRuleResponse(BuilderImpl builder) {
        super(builder);
        this.aggregateEvaluationResults = builder.aggregateEvaluationResults;
        this.nextToken = builder.nextToken;
    }

    public List<AggregateEvaluationResult> aggregateEvaluationResults() {
        return this.aggregateEvaluationResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregateEvaluationResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAggregateComplianceDetailsByConfigRuleResponse)) {
            return false;
        }
        GetAggregateComplianceDetailsByConfigRuleResponse other = (GetAggregateComplianceDetailsByConfigRuleResponse)((Object)obj);
        return Objects.equals(this.aggregateEvaluationResults(), other.aggregateEvaluationResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"GetAggregateComplianceDetailsByConfigRuleResponse").add("AggregateEvaluationResults", this.aggregateEvaluationResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AggregateEvaluationResults": {
                return Optional.ofNullable(clazz.cast(this.aggregateEvaluationResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAggregateComplianceDetailsByConfigRuleResponse, T> g) {
        return obj -> g.apply((GetAggregateComplianceDetailsByConfigRuleResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConfigResponse.BuilderImpl
    implements Builder {
        private List<AggregateEvaluationResult> aggregateEvaluationResults = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAggregateComplianceDetailsByConfigRuleResponse model) {
            super(model);
            this.aggregateEvaluationResults(model.aggregateEvaluationResults);
            this.nextToken(model.nextToken);
        }

        public final Collection<AggregateEvaluationResult.Builder> getAggregateEvaluationResults() {
            return this.aggregateEvaluationResults != null ? (Collection)this.aggregateEvaluationResults.stream().map(AggregateEvaluationResult::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder aggregateEvaluationResults(Collection<AggregateEvaluationResult> aggregateEvaluationResults) {
            this.aggregateEvaluationResults = AggregateEvaluationResultListCopier.copy(aggregateEvaluationResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregateEvaluationResults(AggregateEvaluationResult ... aggregateEvaluationResults) {
            this.aggregateEvaluationResults(Arrays.asList(aggregateEvaluationResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregateEvaluationResults(Consumer<AggregateEvaluationResult.Builder> ... aggregateEvaluationResults) {
            this.aggregateEvaluationResults(Stream.of(aggregateEvaluationResults).map(c -> (AggregateEvaluationResult)((AggregateEvaluationResult.Builder)AggregateEvaluationResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAggregateEvaluationResults(Collection<AggregateEvaluationResult.BuilderImpl> aggregateEvaluationResults) {
            this.aggregateEvaluationResults = AggregateEvaluationResultListCopier.copyFromBuilder(aggregateEvaluationResults);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetAggregateComplianceDetailsByConfigRuleResponse build() {
            return new GetAggregateComplianceDetailsByConfigRuleResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConfigResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAggregateComplianceDetailsByConfigRuleResponse> {
        public Builder aggregateEvaluationResults(Collection<AggregateEvaluationResult> var1);

        public Builder aggregateEvaluationResults(AggregateEvaluationResult ... var1);

        public Builder aggregateEvaluationResults(Consumer<AggregateEvaluationResult.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

