/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeConfigurationAggregatorSourcesStatusRequest extends ConfigRequest
        implements
        ToCopyableBuilder<DescribeConfigurationAggregatorSourcesStatusRequest.Builder, DescribeConfigurationAggregatorSourcesStatusRequest> {
    private static final SdkField<String> CONFIGURATION_AGGREGATOR_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeConfigurationAggregatorSourcesStatusRequest::configurationAggregatorName))
            .setter(setter(Builder::configurationAggregatorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationAggregatorName")
                    .build()).build();

    private static final SdkField<List<String>> UPDATE_STATUS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeConfigurationAggregatorSourcesStatusRequest::updateStatusAsStrings))
            .setter(setter(Builder::updateStatusWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateStatus").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeConfigurationAggregatorSourcesStatusRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DescribeConfigurationAggregatorSourcesStatusRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONFIGURATION_AGGREGATOR_NAME_FIELD, UPDATE_STATUS_FIELD, NEXT_TOKEN_FIELD, LIMIT_FIELD));

    private final String configurationAggregatorName;

    private final List<String> updateStatus;

    private final String nextToken;

    private final Integer limit;

    private DescribeConfigurationAggregatorSourcesStatusRequest(BuilderImpl builder) {
        super(builder);
        this.configurationAggregatorName = builder.configurationAggregatorName;
        this.updateStatus = builder.updateStatus;
        this.nextToken = builder.nextToken;
        this.limit = builder.limit;
    }

    /**
     * <p>
     * The name of the configuration aggregator.
     * </p>
     * 
     * @return The name of the configuration aggregator.
     */
    public String configurationAggregatorName() {
        return configurationAggregatorName;
    }

    /**
     * <p>
     * Filters the status type.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Valid value FAILED indicates errors while moving data.
     * </p>
     * </li>
     * <li>
     * <p>
     * Valid value SUCCEEDED indicates the data was successfully moved.
     * </p>
     * </li>
     * <li>
     * <p>
     * Valid value OUTDATED indicates the data is not the most recent.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Filters the status type.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Valid value FAILED indicates errors while moving data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Valid value SUCCEEDED indicates the data was successfully moved.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Valid value OUTDATED indicates the data is not the most recent.
     *         </p>
     *         </li>
     */
    public List<AggregatedSourceStatusType> updateStatus() {
        return AggregatedSourceStatusTypeListCopier.copyStringToEnum(updateStatus);
    }

    /**
     * <p>
     * Filters the status type.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Valid value FAILED indicates errors while moving data.
     * </p>
     * </li>
     * <li>
     * <p>
     * Valid value SUCCEEDED indicates the data was successfully moved.
     * </p>
     * </li>
     * <li>
     * <p>
     * Valid value OUTDATED indicates the data is not the most recent.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Filters the status type.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Valid value FAILED indicates errors while moving data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Valid value SUCCEEDED indicates the data was successfully moved.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Valid value OUTDATED indicates the data is not the most recent.
     *         </p>
     *         </li>
     */
    public List<String> updateStatusAsStrings() {
        return updateStatus;
    }

    /**
     * <p>
     * The nextToken string returned on a previous page that you use to get the next page of results in a paginated
     * response.
     * </p>
     * 
     * @return The nextToken string returned on a previous page that you use to get the next page of results in a
     *         paginated response.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of AggregatorSourceStatus returned on each page. The default is maximum. If you specify 0, AWS
     * Config uses the default.
     * </p>
     * 
     * @return The maximum number of AggregatorSourceStatus returned on each page. The default is maximum. If you
     *         specify 0, AWS Config uses the default.
     */
    public Integer limit() {
        return limit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configurationAggregatorName());
        hashCode = 31 * hashCode + Objects.hashCode(updateStatusAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigurationAggregatorSourcesStatusRequest)) {
            return false;
        }
        DescribeConfigurationAggregatorSourcesStatusRequest other = (DescribeConfigurationAggregatorSourcesStatusRequest) obj;
        return Objects.equals(configurationAggregatorName(), other.configurationAggregatorName())
                && Objects.equals(updateStatusAsStrings(), other.updateStatusAsStrings())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(limit(), other.limit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeConfigurationAggregatorSourcesStatusRequest")
                .add("ConfigurationAggregatorName", configurationAggregatorName()).add("UpdateStatus", updateStatusAsStrings())
                .add("NextToken", nextToken()).add("Limit", limit()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationAggregatorName":
            return Optional.ofNullable(clazz.cast(configurationAggregatorName()));
        case "UpdateStatus":
            return Optional.ofNullable(clazz.cast(updateStatusAsStrings()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeConfigurationAggregatorSourcesStatusRequest, T> g) {
        return obj -> g.apply((DescribeConfigurationAggregatorSourcesStatusRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeConfigurationAggregatorSourcesStatusRequest> {
        /**
         * <p>
         * The name of the configuration aggregator.
         * </p>
         * 
         * @param configurationAggregatorName
         *        The name of the configuration aggregator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationAggregatorName(String configurationAggregatorName);

        /**
         * <p>
         * Filters the status type.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Valid value FAILED indicates errors while moving data.
         * </p>
         * </li>
         * <li>
         * <p>
         * Valid value SUCCEEDED indicates the data was successfully moved.
         * </p>
         * </li>
         * <li>
         * <p>
         * Valid value OUTDATED indicates the data is not the most recent.
         * </p>
         * </li>
         * </ul>
         * 
         * @param updateStatus
         *        Filters the status type.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Valid value FAILED indicates errors while moving data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Valid value SUCCEEDED indicates the data was successfully moved.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Valid value OUTDATED indicates the data is not the most recent.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateStatusWithStrings(Collection<String> updateStatus);

        /**
         * <p>
         * Filters the status type.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Valid value FAILED indicates errors while moving data.
         * </p>
         * </li>
         * <li>
         * <p>
         * Valid value SUCCEEDED indicates the data was successfully moved.
         * </p>
         * </li>
         * <li>
         * <p>
         * Valid value OUTDATED indicates the data is not the most recent.
         * </p>
         * </li>
         * </ul>
         * 
         * @param updateStatus
         *        Filters the status type.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Valid value FAILED indicates errors while moving data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Valid value SUCCEEDED indicates the data was successfully moved.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Valid value OUTDATED indicates the data is not the most recent.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateStatusWithStrings(String... updateStatus);

        /**
         * <p>
         * Filters the status type.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Valid value FAILED indicates errors while moving data.
         * </p>
         * </li>
         * <li>
         * <p>
         * Valid value SUCCEEDED indicates the data was successfully moved.
         * </p>
         * </li>
         * <li>
         * <p>
         * Valid value OUTDATED indicates the data is not the most recent.
         * </p>
         * </li>
         * </ul>
         * 
         * @param updateStatus
         *        Filters the status type.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Valid value FAILED indicates errors while moving data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Valid value SUCCEEDED indicates the data was successfully moved.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Valid value OUTDATED indicates the data is not the most recent.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateStatus(Collection<AggregatedSourceStatusType> updateStatus);

        /**
         * <p>
         * Filters the status type.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Valid value FAILED indicates errors while moving data.
         * </p>
         * </li>
         * <li>
         * <p>
         * Valid value SUCCEEDED indicates the data was successfully moved.
         * </p>
         * </li>
         * <li>
         * <p>
         * Valid value OUTDATED indicates the data is not the most recent.
         * </p>
         * </li>
         * </ul>
         * 
         * @param updateStatus
         *        Filters the status type.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Valid value FAILED indicates errors while moving data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Valid value SUCCEEDED indicates the data was successfully moved.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Valid value OUTDATED indicates the data is not the most recent.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateStatus(AggregatedSourceStatusType... updateStatus);

        /**
         * <p>
         * The nextToken string returned on a previous page that you use to get the next page of results in a paginated
         * response.
         * </p>
         * 
         * @param nextToken
         *        The nextToken string returned on a previous page that you use to get the next page of results in a
         *        paginated response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of AggregatorSourceStatus returned on each page. The default is maximum. If you specify 0,
         * AWS Config uses the default.
         * </p>
         * 
         * @param limit
         *        The maximum number of AggregatorSourceStatus returned on each page. The default is maximum. If you
         *        specify 0, AWS Config uses the default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConfigRequest.BuilderImpl implements Builder {
        private String configurationAggregatorName;

        private List<String> updateStatus = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer limit;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConfigurationAggregatorSourcesStatusRequest model) {
            super(model);
            configurationAggregatorName(model.configurationAggregatorName);
            updateStatusWithStrings(model.updateStatus);
            nextToken(model.nextToken);
            limit(model.limit);
        }

        public final String getConfigurationAggregatorName() {
            return configurationAggregatorName;
        }

        @Override
        public final Builder configurationAggregatorName(String configurationAggregatorName) {
            this.configurationAggregatorName = configurationAggregatorName;
            return this;
        }

        public final void setConfigurationAggregatorName(String configurationAggregatorName) {
            this.configurationAggregatorName = configurationAggregatorName;
        }

        public final Collection<String> getUpdateStatusAsStrings() {
            return updateStatus;
        }

        @Override
        public final Builder updateStatusWithStrings(Collection<String> updateStatus) {
            this.updateStatus = AggregatedSourceStatusTypeListCopier.copy(updateStatus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updateStatusWithStrings(String... updateStatus) {
            updateStatusWithStrings(Arrays.asList(updateStatus));
            return this;
        }

        @Override
        public final Builder updateStatus(Collection<AggregatedSourceStatusType> updateStatus) {
            this.updateStatus = AggregatedSourceStatusTypeListCopier.copyEnumToString(updateStatus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updateStatus(AggregatedSourceStatusType... updateStatus) {
            updateStatus(Arrays.asList(updateStatus));
            return this;
        }

        public final void setUpdateStatusWithStrings(Collection<String> updateStatus) {
            this.updateStatus = AggregatedSourceStatusTypeListCopier.copy(updateStatus);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeConfigurationAggregatorSourcesStatusRequest build() {
            return new DescribeConfigurationAggregatorSourcesStatusRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
