/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeComplianceByResourceResponse extends ConfigResponse implements
        ToCopyableBuilder<DescribeComplianceByResourceResponse.Builder, DescribeComplianceByResourceResponse> {
    private static final SdkField<List<ComplianceByResource>> COMPLIANCE_BY_RESOURCES_FIELD = SdkField
            .<List<ComplianceByResource>> builder(MarshallingType.LIST)
            .getter(getter(DescribeComplianceByResourceResponse::complianceByResources))
            .setter(setter(Builder::complianceByResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceByResources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ComplianceByResource> builder(MarshallingType.SDK_POJO)
                                            .constructor(ComplianceByResource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeComplianceByResourceResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPLIANCE_BY_RESOURCES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ComplianceByResource> complianceByResources;

    private final String nextToken;

    private DescribeComplianceByResourceResponse(BuilderImpl builder) {
        super(builder);
        this.complianceByResources = builder.complianceByResources;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Indicates whether the specified AWS resource complies with all of the AWS Config rules that evaluate it.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Indicates whether the specified AWS resource complies with all of the AWS Config rules that evaluate it.
     */
    public List<ComplianceByResource> complianceByResources() {
        return complianceByResources;
    }

    /**
     * <p>
     * The string that you use in a subsequent request to get the next page of results in a paginated response.
     * </p>
     * 
     * @return The string that you use in a subsequent request to get the next page of results in a paginated response.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(complianceByResources());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeComplianceByResourceResponse)) {
            return false;
        }
        DescribeComplianceByResourceResponse other = (DescribeComplianceByResourceResponse) obj;
        return Objects.equals(complianceByResources(), other.complianceByResources())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeComplianceByResourceResponse").add("ComplianceByResources", complianceByResources())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ComplianceByResources":
            return Optional.ofNullable(clazz.cast(complianceByResources()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeComplianceByResourceResponse, T> g) {
        return obj -> g.apply((DescribeComplianceByResourceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeComplianceByResourceResponse> {
        /**
         * <p>
         * Indicates whether the specified AWS resource complies with all of the AWS Config rules that evaluate it.
         * </p>
         * 
         * @param complianceByResources
         *        Indicates whether the specified AWS resource complies with all of the AWS Config rules that evaluate
         *        it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceByResources(Collection<ComplianceByResource> complianceByResources);

        /**
         * <p>
         * Indicates whether the specified AWS resource complies with all of the AWS Config rules that evaluate it.
         * </p>
         * 
         * @param complianceByResources
         *        Indicates whether the specified AWS resource complies with all of the AWS Config rules that evaluate
         *        it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceByResources(ComplianceByResource... complianceByResources);

        /**
         * <p>
         * Indicates whether the specified AWS resource complies with all of the AWS Config rules that evaluate it.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ComplianceByResource>.Builder} avoiding the
         * need to create one manually via {@link List<ComplianceByResource>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ComplianceByResource>.Builder#build()} is called immediately
         * and its result is passed to {@link #complianceByResources(List<ComplianceByResource>)}.
         * 
         * @param complianceByResources
         *        a consumer that will call methods on {@link List<ComplianceByResource>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #complianceByResources(List<ComplianceByResource>)
         */
        Builder complianceByResources(Consumer<ComplianceByResource.Builder>... complianceByResources);

        /**
         * <p>
         * The string that you use in a subsequent request to get the next page of results in a paginated response.
         * </p>
         * 
         * @param nextToken
         *        The string that you use in a subsequent request to get the next page of results in a paginated
         *        response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private List<ComplianceByResource> complianceByResources = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeComplianceByResourceResponse model) {
            super(model);
            complianceByResources(model.complianceByResources);
            nextToken(model.nextToken);
        }

        public final Collection<ComplianceByResource.Builder> getComplianceByResources() {
            return complianceByResources != null ? complianceByResources.stream().map(ComplianceByResource::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder complianceByResources(Collection<ComplianceByResource> complianceByResources) {
            this.complianceByResources = ComplianceByResourcesCopier.copy(complianceByResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder complianceByResources(ComplianceByResource... complianceByResources) {
            complianceByResources(Arrays.asList(complianceByResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder complianceByResources(Consumer<ComplianceByResource.Builder>... complianceByResources) {
            complianceByResources(Stream.of(complianceByResources)
                    .map(c -> ComplianceByResource.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setComplianceByResources(Collection<ComplianceByResource.BuilderImpl> complianceByResources) {
            this.complianceByResources = ComplianceByResourcesCopier.copyFromBuilder(complianceByResources);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeComplianceByResourceResponse build() {
            return new DescribeComplianceByResourceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
