/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutConfigurationAggregatorResponse extends ConfigResponse implements
        ToCopyableBuilder<PutConfigurationAggregatorResponse.Builder, PutConfigurationAggregatorResponse> {
    private static final SdkField<ConfigurationAggregator> CONFIGURATION_AGGREGATOR_FIELD = SdkField
            .<ConfigurationAggregator> builder(MarshallingType.SDK_POJO)
            .getter(getter(PutConfigurationAggregatorResponse::configurationAggregator))
            .setter(setter(Builder::configurationAggregator)).constructor(ConfigurationAggregator::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationAggregator").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CONFIGURATION_AGGREGATOR_FIELD));

    private final ConfigurationAggregator configurationAggregator;

    private PutConfigurationAggregatorResponse(BuilderImpl builder) {
        super(builder);
        this.configurationAggregator = builder.configurationAggregator;
    }

    /**
     * <p>
     * Returns a ConfigurationAggregator object.
     * </p>
     * 
     * @return Returns a ConfigurationAggregator object.
     */
    public ConfigurationAggregator configurationAggregator() {
        return configurationAggregator;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configurationAggregator());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutConfigurationAggregatorResponse)) {
            return false;
        }
        PutConfigurationAggregatorResponse other = (PutConfigurationAggregatorResponse) obj;
        return Objects.equals(configurationAggregator(), other.configurationAggregator());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutConfigurationAggregatorResponse").add("ConfigurationAggregator", configurationAggregator())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationAggregator":
            return Optional.ofNullable(clazz.cast(configurationAggregator()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutConfigurationAggregatorResponse, T> g) {
        return obj -> g.apply((PutConfigurationAggregatorResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, PutConfigurationAggregatorResponse> {
        /**
         * <p>
         * Returns a ConfigurationAggregator object.
         * </p>
         * 
         * @param configurationAggregator
         *        Returns a ConfigurationAggregator object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationAggregator(ConfigurationAggregator configurationAggregator);

        /**
         * <p>
         * Returns a ConfigurationAggregator object.
         * </p>
         * This is a convenience that creates an instance of the {@link ConfigurationAggregator.Builder} avoiding the
         * need to create one manually via {@link ConfigurationAggregator#builder()}.
         *
         * When the {@link Consumer} completes, {@link ConfigurationAggregator.Builder#build()} is called immediately
         * and its result is passed to {@link #configurationAggregator(ConfigurationAggregator)}.
         * 
         * @param configurationAggregator
         *        a consumer that will call methods on {@link ConfigurationAggregator.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configurationAggregator(ConfigurationAggregator)
         */
        default Builder configurationAggregator(Consumer<ConfigurationAggregator.Builder> configurationAggregator) {
            return configurationAggregator(ConfigurationAggregator.builder().applyMutation(configurationAggregator).build());
        }
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private ConfigurationAggregator configurationAggregator;

        private BuilderImpl() {
        }

        private BuilderImpl(PutConfigurationAggregatorResponse model) {
            super(model);
            configurationAggregator(model.configurationAggregator);
        }

        public final ConfigurationAggregator.Builder getConfigurationAggregator() {
            return configurationAggregator != null ? configurationAggregator.toBuilder() : null;
        }

        @Override
        public final Builder configurationAggregator(ConfigurationAggregator configurationAggregator) {
            this.configurationAggregator = configurationAggregator;
            return this;
        }

        public final void setConfigurationAggregator(ConfigurationAggregator.BuilderImpl configurationAggregator) {
            this.configurationAggregator = configurationAggregator != null ? configurationAggregator.build() : null;
        }

        @Override
        public PutConfigurationAggregatorResponse build() {
            return new PutConfigurationAggregatorResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
