/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutOrganizationConfigRuleResponse extends ConfigResponse implements
        ToCopyableBuilder<PutOrganizationConfigRuleResponse.Builder, PutOrganizationConfigRuleResponse> {
    private static final SdkField<String> ORGANIZATION_CONFIG_RULE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutOrganizationConfigRuleResponse::organizationConfigRuleArn))
            .setter(setter(Builder::organizationConfigRuleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationConfigRuleArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ORGANIZATION_CONFIG_RULE_ARN_FIELD));

    private final String organizationConfigRuleArn;

    private PutOrganizationConfigRuleResponse(BuilderImpl builder) {
        super(builder);
        this.organizationConfigRuleArn = builder.organizationConfigRuleArn;
    }

    /**
     * Returns the value of the OrganizationConfigRuleArn property for this object.
     * 
     * @return The value of the OrganizationConfigRuleArn property for this object.
     */
    public String organizationConfigRuleArn() {
        return organizationConfigRuleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(organizationConfigRuleArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutOrganizationConfigRuleResponse)) {
            return false;
        }
        PutOrganizationConfigRuleResponse other = (PutOrganizationConfigRuleResponse) obj;
        return Objects.equals(organizationConfigRuleArn(), other.organizationConfigRuleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutOrganizationConfigRuleResponse")
                .add("OrganizationConfigRuleArn", organizationConfigRuleArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrganizationConfigRuleArn":
            return Optional.ofNullable(clazz.cast(organizationConfigRuleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutOrganizationConfigRuleResponse, T> g) {
        return obj -> g.apply((PutOrganizationConfigRuleResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigResponse.Builder, SdkPojo, CopyableBuilder<Builder, PutOrganizationConfigRuleResponse> {
        /**
         * Sets the value of the OrganizationConfigRuleArn property for this object.
         *
         * @param organizationConfigRuleArn
         *        The new value for the OrganizationConfigRuleArn property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationConfigRuleArn(String organizationConfigRuleArn);
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private String organizationConfigRuleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(PutOrganizationConfigRuleResponse model) {
            super(model);
            organizationConfigRuleArn(model.organizationConfigRuleArn);
        }

        public final String getOrganizationConfigRuleArn() {
            return organizationConfigRuleArn;
        }

        @Override
        public final Builder organizationConfigRuleArn(String organizationConfigRuleArn) {
            this.organizationConfigRuleArn = organizationConfigRuleArn;
            return this;
        }

        public final void setOrganizationConfigRuleArn(String organizationConfigRuleArn) {
            this.organizationConfigRuleArn = organizationConfigRuleArn;
        }

        @Override
        public PutOrganizationConfigRuleResponse build() {
            return new PutOrganizationConfigRuleResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
