/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The current sync status between the source and the aggregator account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AggregatedSourceStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<AggregatedSourceStatus.Builder, AggregatedSourceStatus> {
    private static final SdkField<String> SOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AggregatedSourceStatus::sourceId)).setter(setter(Builder::sourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceId").build()).build();

    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AggregatedSourceStatus::sourceTypeAsString)).setter(setter(Builder::sourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceType").build()).build();

    private static final SdkField<String> AWS_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AggregatedSourceStatus::awsRegion)).setter(setter(Builder::awsRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsRegion").build()).build();

    private static final SdkField<String> LAST_UPDATE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AggregatedSourceStatus::lastUpdateStatusAsString)).setter(setter(Builder::lastUpdateStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateStatus").build()).build();

    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(AggregatedSourceStatus::lastUpdateTime)).setter(setter(Builder::lastUpdateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateTime").build()).build();

    private static final SdkField<String> LAST_ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AggregatedSourceStatus::lastErrorCode)).setter(setter(Builder::lastErrorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastErrorCode").build()).build();

    private static final SdkField<String> LAST_ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AggregatedSourceStatus::lastErrorMessage)).setter(setter(Builder::lastErrorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastErrorMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_ID_FIELD,
            SOURCE_TYPE_FIELD, AWS_REGION_FIELD, LAST_UPDATE_STATUS_FIELD, LAST_UPDATE_TIME_FIELD, LAST_ERROR_CODE_FIELD,
            LAST_ERROR_MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String sourceId;

    private final String sourceType;

    private final String awsRegion;

    private final String lastUpdateStatus;

    private final Instant lastUpdateTime;

    private final String lastErrorCode;

    private final String lastErrorMessage;

    private AggregatedSourceStatus(BuilderImpl builder) {
        this.sourceId = builder.sourceId;
        this.sourceType = builder.sourceType;
        this.awsRegion = builder.awsRegion;
        this.lastUpdateStatus = builder.lastUpdateStatus;
        this.lastUpdateTime = builder.lastUpdateTime;
        this.lastErrorCode = builder.lastErrorCode;
        this.lastErrorMessage = builder.lastErrorMessage;
    }

    /**
     * <p>
     * The source account ID or an organization.
     * </p>
     * 
     * @return The source account ID or an organization.
     */
    public String sourceId() {
        return sourceId;
    }

    /**
     * <p>
     * The source account or an organization.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceType} will
     * return {@link AggregatedSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sourceTypeAsString}.
     * </p>
     * 
     * @return The source account or an organization.
     * @see AggregatedSourceType
     */
    public AggregatedSourceType sourceType() {
        return AggregatedSourceType.fromValue(sourceType);
    }

    /**
     * <p>
     * The source account or an organization.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceType} will
     * return {@link AggregatedSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sourceTypeAsString}.
     * </p>
     * 
     * @return The source account or an organization.
     * @see AggregatedSourceType
     */
    public String sourceTypeAsString() {
        return sourceType;
    }

    /**
     * <p>
     * The region authorized to collect aggregated data.
     * </p>
     * 
     * @return The region authorized to collect aggregated data.
     */
    public String awsRegion() {
        return awsRegion;
    }

    /**
     * <p>
     * Filters the last updated status type.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Valid value FAILED indicates errors while moving data.
     * </p>
     * </li>
     * <li>
     * <p>
     * Valid value SUCCEEDED indicates the data was successfully moved.
     * </p>
     * </li>
     * <li>
     * <p>
     * Valid value OUTDATED indicates the data is not the most recent.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lastUpdateStatus}
     * will return {@link AggregatedSourceStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #lastUpdateStatusAsString}.
     * </p>
     * 
     * @return Filters the last updated status type.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Valid value FAILED indicates errors while moving data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Valid value SUCCEEDED indicates the data was successfully moved.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Valid value OUTDATED indicates the data is not the most recent.
     *         </p>
     *         </li>
     * @see AggregatedSourceStatusType
     */
    public AggregatedSourceStatusType lastUpdateStatus() {
        return AggregatedSourceStatusType.fromValue(lastUpdateStatus);
    }

    /**
     * <p>
     * Filters the last updated status type.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Valid value FAILED indicates errors while moving data.
     * </p>
     * </li>
     * <li>
     * <p>
     * Valid value SUCCEEDED indicates the data was successfully moved.
     * </p>
     * </li>
     * <li>
     * <p>
     * Valid value OUTDATED indicates the data is not the most recent.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lastUpdateStatus}
     * will return {@link AggregatedSourceStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #lastUpdateStatusAsString}.
     * </p>
     * 
     * @return Filters the last updated status type.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Valid value FAILED indicates errors while moving data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Valid value SUCCEEDED indicates the data was successfully moved.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Valid value OUTDATED indicates the data is not the most recent.
     *         </p>
     *         </li>
     * @see AggregatedSourceStatusType
     */
    public String lastUpdateStatusAsString() {
        return lastUpdateStatus;
    }

    /**
     * <p>
     * The time of the last update.
     * </p>
     * 
     * @return The time of the last update.
     */
    public Instant lastUpdateTime() {
        return lastUpdateTime;
    }

    /**
     * <p>
     * The error code that AWS Config returned when the source account aggregation last failed.
     * </p>
     * 
     * @return The error code that AWS Config returned when the source account aggregation last failed.
     */
    public String lastErrorCode() {
        return lastErrorCode;
    }

    /**
     * <p>
     * The message indicating that the source account aggregation failed due to an error.
     * </p>
     * 
     * @return The message indicating that the source account aggregation failed due to an error.
     */
    public String lastErrorMessage() {
        return lastErrorMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceId());
        hashCode = 31 * hashCode + Objects.hashCode(sourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(awsRegion());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastErrorCode());
        hashCode = 31 * hashCode + Objects.hashCode(lastErrorMessage());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggregatedSourceStatus)) {
            return false;
        }
        AggregatedSourceStatus other = (AggregatedSourceStatus) obj;
        return Objects.equals(sourceId(), other.sourceId()) && Objects.equals(sourceTypeAsString(), other.sourceTypeAsString())
                && Objects.equals(awsRegion(), other.awsRegion())
                && Objects.equals(lastUpdateStatusAsString(), other.lastUpdateStatusAsString())
                && Objects.equals(lastUpdateTime(), other.lastUpdateTime())
                && Objects.equals(lastErrorCode(), other.lastErrorCode())
                && Objects.equals(lastErrorMessage(), other.lastErrorMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AggregatedSourceStatus").add("SourceId", sourceId()).add("SourceType", sourceTypeAsString())
                .add("AwsRegion", awsRegion()).add("LastUpdateStatus", lastUpdateStatusAsString())
                .add("LastUpdateTime", lastUpdateTime()).add("LastErrorCode", lastErrorCode())
                .add("LastErrorMessage", lastErrorMessage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceId":
            return Optional.ofNullable(clazz.cast(sourceId()));
        case "SourceType":
            return Optional.ofNullable(clazz.cast(sourceTypeAsString()));
        case "AwsRegion":
            return Optional.ofNullable(clazz.cast(awsRegion()));
        case "LastUpdateStatus":
            return Optional.ofNullable(clazz.cast(lastUpdateStatusAsString()));
        case "LastUpdateTime":
            return Optional.ofNullable(clazz.cast(lastUpdateTime()));
        case "LastErrorCode":
            return Optional.ofNullable(clazz.cast(lastErrorCode()));
        case "LastErrorMessage":
            return Optional.ofNullable(clazz.cast(lastErrorMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AggregatedSourceStatus, T> g) {
        return obj -> g.apply((AggregatedSourceStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AggregatedSourceStatus> {
        /**
         * <p>
         * The source account ID or an organization.
         * </p>
         * 
         * @param sourceId
         *        The source account ID or an organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceId(String sourceId);

        /**
         * <p>
         * The source account or an organization.
         * </p>
         * 
         * @param sourceType
         *        The source account or an organization.
         * @see AggregatedSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AggregatedSourceType
         */
        Builder sourceType(String sourceType);

        /**
         * <p>
         * The source account or an organization.
         * </p>
         * 
         * @param sourceType
         *        The source account or an organization.
         * @see AggregatedSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AggregatedSourceType
         */
        Builder sourceType(AggregatedSourceType sourceType);

        /**
         * <p>
         * The region authorized to collect aggregated data.
         * </p>
         * 
         * @param awsRegion
         *        The region authorized to collect aggregated data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsRegion(String awsRegion);

        /**
         * <p>
         * Filters the last updated status type.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Valid value FAILED indicates errors while moving data.
         * </p>
         * </li>
         * <li>
         * <p>
         * Valid value SUCCEEDED indicates the data was successfully moved.
         * </p>
         * </li>
         * <li>
         * <p>
         * Valid value OUTDATED indicates the data is not the most recent.
         * </p>
         * </li>
         * </ul>
         * 
         * @param lastUpdateStatus
         *        Filters the last updated status type.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Valid value FAILED indicates errors while moving data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Valid value SUCCEEDED indicates the data was successfully moved.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Valid value OUTDATED indicates the data is not the most recent.
         *        </p>
         *        </li>
         * @see AggregatedSourceStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AggregatedSourceStatusType
         */
        Builder lastUpdateStatus(String lastUpdateStatus);

        /**
         * <p>
         * Filters the last updated status type.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Valid value FAILED indicates errors while moving data.
         * </p>
         * </li>
         * <li>
         * <p>
         * Valid value SUCCEEDED indicates the data was successfully moved.
         * </p>
         * </li>
         * <li>
         * <p>
         * Valid value OUTDATED indicates the data is not the most recent.
         * </p>
         * </li>
         * </ul>
         * 
         * @param lastUpdateStatus
         *        Filters the last updated status type.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Valid value FAILED indicates errors while moving data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Valid value SUCCEEDED indicates the data was successfully moved.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Valid value OUTDATED indicates the data is not the most recent.
         *        </p>
         *        </li>
         * @see AggregatedSourceStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AggregatedSourceStatusType
         */
        Builder lastUpdateStatus(AggregatedSourceStatusType lastUpdateStatus);

        /**
         * <p>
         * The time of the last update.
         * </p>
         * 
         * @param lastUpdateTime
         *        The time of the last update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateTime(Instant lastUpdateTime);

        /**
         * <p>
         * The error code that AWS Config returned when the source account aggregation last failed.
         * </p>
         * 
         * @param lastErrorCode
         *        The error code that AWS Config returned when the source account aggregation last failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastErrorCode(String lastErrorCode);

        /**
         * <p>
         * The message indicating that the source account aggregation failed due to an error.
         * </p>
         * 
         * @param lastErrorMessage
         *        The message indicating that the source account aggregation failed due to an error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastErrorMessage(String lastErrorMessage);
    }

    static final class BuilderImpl implements Builder {
        private String sourceId;

        private String sourceType;

        private String awsRegion;

        private String lastUpdateStatus;

        private Instant lastUpdateTime;

        private String lastErrorCode;

        private String lastErrorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(AggregatedSourceStatus model) {
            sourceId(model.sourceId);
            sourceType(model.sourceType);
            awsRegion(model.awsRegion);
            lastUpdateStatus(model.lastUpdateStatus);
            lastUpdateTime(model.lastUpdateTime);
            lastErrorCode(model.lastErrorCode);
            lastErrorMessage(model.lastErrorMessage);
        }

        public final String getSourceId() {
            return sourceId;
        }

        @Override
        public final Builder sourceId(String sourceId) {
            this.sourceId = sourceId;
            return this;
        }

        public final void setSourceId(String sourceId) {
            this.sourceId = sourceId;
        }

        public final String getSourceTypeAsString() {
            return sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        @Override
        public final Builder sourceType(AggregatedSourceType sourceType) {
            this.sourceType(sourceType == null ? null : sourceType.toString());
            return this;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        public final String getAwsRegion() {
            return awsRegion;
        }

        @Override
        public final Builder awsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
            return this;
        }

        public final void setAwsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
        }

        public final String getLastUpdateStatusAsString() {
            return lastUpdateStatus;
        }

        @Override
        public final Builder lastUpdateStatus(String lastUpdateStatus) {
            this.lastUpdateStatus = lastUpdateStatus;
            return this;
        }

        @Override
        public final Builder lastUpdateStatus(AggregatedSourceStatusType lastUpdateStatus) {
            this.lastUpdateStatus(lastUpdateStatus == null ? null : lastUpdateStatus.toString());
            return this;
        }

        public final void setLastUpdateStatus(String lastUpdateStatus) {
            this.lastUpdateStatus = lastUpdateStatus;
        }

        public final Instant getLastUpdateTime() {
            return lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        public final String getLastErrorCode() {
            return lastErrorCode;
        }

        @Override
        public final Builder lastErrorCode(String lastErrorCode) {
            this.lastErrorCode = lastErrorCode;
            return this;
        }

        public final void setLastErrorCode(String lastErrorCode) {
            this.lastErrorCode = lastErrorCode;
        }

        public final String getLastErrorMessage() {
            return lastErrorMessage;
        }

        @Override
        public final Builder lastErrorMessage(String lastErrorMessage) {
            this.lastErrorMessage = lastErrorMessage;
            return this;
        }

        public final void setLastErrorMessage(String lastErrorMessage) {
            this.lastErrorMessage = lastErrorMessage;
        }

        @Override
        public AggregatedSourceStatus build() {
            return new AggregatedSourceStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
