/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class OrganizationConfigRule implements SdkPojo, Serializable,
        ToCopyableBuilder<OrganizationConfigRule.Builder, OrganizationConfigRule> {
    private static final SdkField<String> ORGANIZATION_CONFIG_RULE_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(OrganizationConfigRule::organizationConfigRuleName))
            .setter(setter(Builder::organizationConfigRuleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationConfigRuleName").build())
            .build();

    private static final SdkField<String> ORGANIZATION_CONFIG_RULE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(OrganizationConfigRule::organizationConfigRuleArn)).setter(setter(Builder::organizationConfigRuleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationConfigRuleArn").build())
            .build();

    private static final SdkField<OrganizationManagedRuleMetadata> ORGANIZATION_MANAGED_RULE_METADATA_FIELD = SdkField
            .<OrganizationManagedRuleMetadata> builder(MarshallingType.SDK_POJO)
            .getter(getter(OrganizationConfigRule::organizationManagedRuleMetadata))
            .setter(setter(Builder::organizationManagedRuleMetadata))
            .constructor(OrganizationManagedRuleMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationManagedRuleMetadata")
                    .build()).build();

    private static final SdkField<OrganizationCustomRuleMetadata> ORGANIZATION_CUSTOM_RULE_METADATA_FIELD = SdkField
            .<OrganizationCustomRuleMetadata> builder(MarshallingType.SDK_POJO)
            .getter(getter(OrganizationConfigRule::organizationCustomRuleMetadata))
            .setter(setter(Builder::organizationCustomRuleMetadata))
            .constructor(OrganizationCustomRuleMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationCustomRuleMetadata")
                    .build()).build();

    private static final SdkField<List<String>> EXCLUDED_ACCOUNTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(OrganizationConfigRule::excludedAccounts))
            .setter(setter(Builder::excludedAccounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludedAccounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(OrganizationConfigRule::lastUpdateTime)).setter(setter(Builder::lastUpdateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ORGANIZATION_CONFIG_RULE_NAME_FIELD, ORGANIZATION_CONFIG_RULE_ARN_FIELD, ORGANIZATION_MANAGED_RULE_METADATA_FIELD,
            ORGANIZATION_CUSTOM_RULE_METADATA_FIELD, EXCLUDED_ACCOUNTS_FIELD, LAST_UPDATE_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String organizationConfigRuleName;

    private final String organizationConfigRuleArn;

    private final OrganizationManagedRuleMetadata organizationManagedRuleMetadata;

    private final OrganizationCustomRuleMetadata organizationCustomRuleMetadata;

    private final List<String> excludedAccounts;

    private final Instant lastUpdateTime;

    private OrganizationConfigRule(BuilderImpl builder) {
        this.organizationConfigRuleName = builder.organizationConfigRuleName;
        this.organizationConfigRuleArn = builder.organizationConfigRuleArn;
        this.organizationManagedRuleMetadata = builder.organizationManagedRuleMetadata;
        this.organizationCustomRuleMetadata = builder.organizationCustomRuleMetadata;
        this.excludedAccounts = builder.excludedAccounts;
        this.lastUpdateTime = builder.lastUpdateTime;
    }

    /**
     * Returns the value of the OrganizationConfigRuleName property for this object.
     * 
     * @return The value of the OrganizationConfigRuleName property for this object.
     */
    public String organizationConfigRuleName() {
        return organizationConfigRuleName;
    }

    /**
     * Returns the value of the OrganizationConfigRuleArn property for this object.
     * 
     * @return The value of the OrganizationConfigRuleArn property for this object.
     */
    public String organizationConfigRuleArn() {
        return organizationConfigRuleArn;
    }

    /**
     * Returns the value of the OrganizationManagedRuleMetadata property for this object.
     * 
     * @return The value of the OrganizationManagedRuleMetadata property for this object.
     */
    public OrganizationManagedRuleMetadata organizationManagedRuleMetadata() {
        return organizationManagedRuleMetadata;
    }

    /**
     * Returns the value of the OrganizationCustomRuleMetadata property for this object.
     * 
     * @return The value of the OrganizationCustomRuleMetadata property for this object.
     */
    public OrganizationCustomRuleMetadata organizationCustomRuleMetadata() {
        return organizationCustomRuleMetadata;
    }

    /**
     * Returns the value of the ExcludedAccounts property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the ExcludedAccounts property for this object.
     */
    public List<String> excludedAccounts() {
        return excludedAccounts;
    }

    /**
     * Returns the value of the LastUpdateTime property for this object.
     * 
     * @return The value of the LastUpdateTime property for this object.
     */
    public Instant lastUpdateTime() {
        return lastUpdateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(organizationConfigRuleName());
        hashCode = 31 * hashCode + Objects.hashCode(organizationConfigRuleArn());
        hashCode = 31 * hashCode + Objects.hashCode(organizationManagedRuleMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(organizationCustomRuleMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(excludedAccounts());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrganizationConfigRule)) {
            return false;
        }
        OrganizationConfigRule other = (OrganizationConfigRule) obj;
        return Objects.equals(organizationConfigRuleName(), other.organizationConfigRuleName())
                && Objects.equals(organizationConfigRuleArn(), other.organizationConfigRuleArn())
                && Objects.equals(organizationManagedRuleMetadata(), other.organizationManagedRuleMetadata())
                && Objects.equals(organizationCustomRuleMetadata(), other.organizationCustomRuleMetadata())
                && Objects.equals(excludedAccounts(), other.excludedAccounts())
                && Objects.equals(lastUpdateTime(), other.lastUpdateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("OrganizationConfigRule").add("OrganizationConfigRuleName", organizationConfigRuleName())
                .add("OrganizationConfigRuleArn", organizationConfigRuleArn())
                .add("OrganizationManagedRuleMetadata", organizationManagedRuleMetadata())
                .add("OrganizationCustomRuleMetadata", organizationCustomRuleMetadata())
                .add("ExcludedAccounts", excludedAccounts()).add("LastUpdateTime", lastUpdateTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrganizationConfigRuleName":
            return Optional.ofNullable(clazz.cast(organizationConfigRuleName()));
        case "OrganizationConfigRuleArn":
            return Optional.ofNullable(clazz.cast(organizationConfigRuleArn()));
        case "OrganizationManagedRuleMetadata":
            return Optional.ofNullable(clazz.cast(organizationManagedRuleMetadata()));
        case "OrganizationCustomRuleMetadata":
            return Optional.ofNullable(clazz.cast(organizationCustomRuleMetadata()));
        case "ExcludedAccounts":
            return Optional.ofNullable(clazz.cast(excludedAccounts()));
        case "LastUpdateTime":
            return Optional.ofNullable(clazz.cast(lastUpdateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OrganizationConfigRule, T> g) {
        return obj -> g.apply((OrganizationConfigRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OrganizationConfigRule> {
        /**
         * Sets the value of the OrganizationConfigRuleName property for this object.
         *
         * @param organizationConfigRuleName
         *        The new value for the OrganizationConfigRuleName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationConfigRuleName(String organizationConfigRuleName);

        /**
         * Sets the value of the OrganizationConfigRuleArn property for this object.
         *
         * @param organizationConfigRuleArn
         *        The new value for the OrganizationConfigRuleArn property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationConfigRuleArn(String organizationConfigRuleArn);

        /**
         * Sets the value of the OrganizationManagedRuleMetadata property for this object.
         *
         * @param organizationManagedRuleMetadata
         *        The new value for the OrganizationManagedRuleMetadata property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationManagedRuleMetadata(OrganizationManagedRuleMetadata organizationManagedRuleMetadata);

        /**
         * Sets the value of the OrganizationManagedRuleMetadata property for this object.
         *
         * This is a convenience that creates an instance of the {@link OrganizationManagedRuleMetadata.Builder}
         * avoiding the need to create one manually via {@link OrganizationManagedRuleMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link OrganizationManagedRuleMetadata.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #organizationManagedRuleMetadata(OrganizationManagedRuleMetadata)}.
         * 
         * @param organizationManagedRuleMetadata
         *        a consumer that will call methods on {@link OrganizationManagedRuleMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #organizationManagedRuleMetadata(OrganizationManagedRuleMetadata)
         */
        default Builder organizationManagedRuleMetadata(
                Consumer<OrganizationManagedRuleMetadata.Builder> organizationManagedRuleMetadata) {
            return organizationManagedRuleMetadata(OrganizationManagedRuleMetadata.builder()
                    .applyMutation(organizationManagedRuleMetadata).build());
        }

        /**
         * Sets the value of the OrganizationCustomRuleMetadata property for this object.
         *
         * @param organizationCustomRuleMetadata
         *        The new value for the OrganizationCustomRuleMetadata property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationCustomRuleMetadata(OrganizationCustomRuleMetadata organizationCustomRuleMetadata);

        /**
         * Sets the value of the OrganizationCustomRuleMetadata property for this object.
         *
         * This is a convenience that creates an instance of the {@link OrganizationCustomRuleMetadata.Builder} avoiding
         * the need to create one manually via {@link OrganizationCustomRuleMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link OrganizationCustomRuleMetadata.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #organizationCustomRuleMetadata(OrganizationCustomRuleMetadata)}.
         * 
         * @param organizationCustomRuleMetadata
         *        a consumer that will call methods on {@link OrganizationCustomRuleMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #organizationCustomRuleMetadata(OrganizationCustomRuleMetadata)
         */
        default Builder organizationCustomRuleMetadata(
                Consumer<OrganizationCustomRuleMetadata.Builder> organizationCustomRuleMetadata) {
            return organizationCustomRuleMetadata(OrganizationCustomRuleMetadata.builder()
                    .applyMutation(organizationCustomRuleMetadata).build());
        }

        /**
         * Sets the value of the ExcludedAccounts property for this object.
         *
         * @param excludedAccounts
         *        The new value for the ExcludedAccounts property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludedAccounts(Collection<String> excludedAccounts);

        /**
         * Sets the value of the ExcludedAccounts property for this object.
         *
         * @param excludedAccounts
         *        The new value for the ExcludedAccounts property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludedAccounts(String... excludedAccounts);

        /**
         * Sets the value of the LastUpdateTime property for this object.
         *
         * @param lastUpdateTime
         *        The new value for the LastUpdateTime property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateTime(Instant lastUpdateTime);
    }

    static final class BuilderImpl implements Builder {
        private String organizationConfigRuleName;

        private String organizationConfigRuleArn;

        private OrganizationManagedRuleMetadata organizationManagedRuleMetadata;

        private OrganizationCustomRuleMetadata organizationCustomRuleMetadata;

        private List<String> excludedAccounts = DefaultSdkAutoConstructList.getInstance();

        private Instant lastUpdateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(OrganizationConfigRule model) {
            organizationConfigRuleName(model.organizationConfigRuleName);
            organizationConfigRuleArn(model.organizationConfigRuleArn);
            organizationManagedRuleMetadata(model.organizationManagedRuleMetadata);
            organizationCustomRuleMetadata(model.organizationCustomRuleMetadata);
            excludedAccounts(model.excludedAccounts);
            lastUpdateTime(model.lastUpdateTime);
        }

        public final String getOrganizationConfigRuleName() {
            return organizationConfigRuleName;
        }

        @Override
        public final Builder organizationConfigRuleName(String organizationConfigRuleName) {
            this.organizationConfigRuleName = organizationConfigRuleName;
            return this;
        }

        public final void setOrganizationConfigRuleName(String organizationConfigRuleName) {
            this.organizationConfigRuleName = organizationConfigRuleName;
        }

        public final String getOrganizationConfigRuleArn() {
            return organizationConfigRuleArn;
        }

        @Override
        public final Builder organizationConfigRuleArn(String organizationConfigRuleArn) {
            this.organizationConfigRuleArn = organizationConfigRuleArn;
            return this;
        }

        public final void setOrganizationConfigRuleArn(String organizationConfigRuleArn) {
            this.organizationConfigRuleArn = organizationConfigRuleArn;
        }

        public final OrganizationManagedRuleMetadata.Builder getOrganizationManagedRuleMetadata() {
            return organizationManagedRuleMetadata != null ? organizationManagedRuleMetadata.toBuilder() : null;
        }

        @Override
        public final Builder organizationManagedRuleMetadata(OrganizationManagedRuleMetadata organizationManagedRuleMetadata) {
            this.organizationManagedRuleMetadata = organizationManagedRuleMetadata;
            return this;
        }

        public final void setOrganizationManagedRuleMetadata(
                OrganizationManagedRuleMetadata.BuilderImpl organizationManagedRuleMetadata) {
            this.organizationManagedRuleMetadata = organizationManagedRuleMetadata != null ? organizationManagedRuleMetadata
                    .build() : null;
        }

        public final OrganizationCustomRuleMetadata.Builder getOrganizationCustomRuleMetadata() {
            return organizationCustomRuleMetadata != null ? organizationCustomRuleMetadata.toBuilder() : null;
        }

        @Override
        public final Builder organizationCustomRuleMetadata(OrganizationCustomRuleMetadata organizationCustomRuleMetadata) {
            this.organizationCustomRuleMetadata = organizationCustomRuleMetadata;
            return this;
        }

        public final void setOrganizationCustomRuleMetadata(
                OrganizationCustomRuleMetadata.BuilderImpl organizationCustomRuleMetadata) {
            this.organizationCustomRuleMetadata = organizationCustomRuleMetadata != null ? organizationCustomRuleMetadata.build()
                    : null;
        }

        public final Collection<String> getExcludedAccounts() {
            return excludedAccounts;
        }

        @Override
        public final Builder excludedAccounts(Collection<String> excludedAccounts) {
            this.excludedAccounts = ExcludedAccountsCopier.copy(excludedAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludedAccounts(String... excludedAccounts) {
            excludedAccounts(Arrays.asList(excludedAccounts));
            return this;
        }

        public final void setExcludedAccounts(Collection<String> excludedAccounts) {
            this.excludedAccounts = ExcludedAccountsCopier.copy(excludedAccounts);
        }

        public final Instant getLastUpdateTime() {
            return lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        public OrganizationConfigRule build() {
            return new OrganizationConfigRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
