/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutRemediationConfigurationsResponse extends ConfigResponse implements
        ToCopyableBuilder<PutRemediationConfigurationsResponse.Builder, PutRemediationConfigurationsResponse> {
    private static final SdkField<List<FailedRemediationBatch>> FAILED_BATCHES_FIELD = SdkField
            .<List<FailedRemediationBatch>> builder(MarshallingType.LIST)
            .getter(getter(PutRemediationConfigurationsResponse::failedBatches))
            .setter(setter(Builder::failedBatches))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedBatches").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FailedRemediationBatch> builder(MarshallingType.SDK_POJO)
                                            .constructor(FailedRemediationBatch::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILED_BATCHES_FIELD));

    private final List<FailedRemediationBatch> failedBatches;

    private PutRemediationConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.failedBatches = builder.failedBatches;
    }

    /**
     * <p>
     * Returns a list of failed remediation batch objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Returns a list of failed remediation batch objects.
     */
    public List<FailedRemediationBatch> failedBatches() {
        return failedBatches;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(failedBatches());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRemediationConfigurationsResponse)) {
            return false;
        }
        PutRemediationConfigurationsResponse other = (PutRemediationConfigurationsResponse) obj;
        return Objects.equals(failedBatches(), other.failedBatches());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutRemediationConfigurationsResponse").add("FailedBatches", failedBatches()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FailedBatches":
            return Optional.ofNullable(clazz.cast(failedBatches()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutRemediationConfigurationsResponse, T> g) {
        return obj -> g.apply((PutRemediationConfigurationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, PutRemediationConfigurationsResponse> {
        /**
         * <p>
         * Returns a list of failed remediation batch objects.
         * </p>
         * 
         * @param failedBatches
         *        Returns a list of failed remediation batch objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedBatches(Collection<FailedRemediationBatch> failedBatches);

        /**
         * <p>
         * Returns a list of failed remediation batch objects.
         * </p>
         * 
         * @param failedBatches
         *        Returns a list of failed remediation batch objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedBatches(FailedRemediationBatch... failedBatches);

        /**
         * <p>
         * Returns a list of failed remediation batch objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<FailedRemediationBatch>.Builder} avoiding
         * the need to create one manually via {@link List<FailedRemediationBatch>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FailedRemediationBatch>.Builder#build()} is called
         * immediately and its result is passed to {@link #failedBatches(List<FailedRemediationBatch>)}.
         * 
         * @param failedBatches
         *        a consumer that will call methods on {@link List<FailedRemediationBatch>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failedBatches(List<FailedRemediationBatch>)
         */
        Builder failedBatches(Consumer<FailedRemediationBatch.Builder>... failedBatches);
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private List<FailedRemediationBatch> failedBatches = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutRemediationConfigurationsResponse model) {
            super(model);
            failedBatches(model.failedBatches);
        }

        public final Collection<FailedRemediationBatch.Builder> getFailedBatches() {
            return failedBatches != null ? failedBatches.stream().map(FailedRemediationBatch::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder failedBatches(Collection<FailedRemediationBatch> failedBatches) {
            this.failedBatches = FailedRemediationBatchesCopier.copy(failedBatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedBatches(FailedRemediationBatch... failedBatches) {
            failedBatches(Arrays.asList(failedBatches));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedBatches(Consumer<FailedRemediationBatch.Builder>... failedBatches) {
            failedBatches(Stream.of(failedBatches).map(c -> FailedRemediationBatch.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setFailedBatches(Collection<FailedRemediationBatch.BuilderImpl> failedBatches) {
            this.failedBatches = FailedRemediationBatchesCopier.copyFromBuilder(failedBatches);
        }

        @Override
        public PutRemediationConfigurationsResponse build() {
            return new PutRemediationConfigurationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
