/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class OrganizationManagedRuleMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<OrganizationManagedRuleMetadata.Builder, OrganizationManagedRuleMetadata> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(OrganizationManagedRuleMetadata::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> RULE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(OrganizationManagedRuleMetadata::ruleIdentifier)).setter(setter(Builder::ruleIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleIdentifier").build()).build();

    private static final SdkField<String> INPUT_PARAMETERS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(OrganizationManagedRuleMetadata::inputParameters)).setter(setter(Builder::inputParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputParameters").build()).build();

    private static final SdkField<String> MAXIMUM_EXECUTION_FREQUENCY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(OrganizationManagedRuleMetadata::maximumExecutionFrequencyAsString))
            .setter(setter(Builder::maximumExecutionFrequency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumExecutionFrequency").build())
            .build();

    private static final SdkField<List<String>> RESOURCE_TYPES_SCOPE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(OrganizationManagedRuleMetadata::resourceTypesScope))
            .setter(setter(Builder::resourceTypesScope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTypesScope").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> RESOURCE_ID_SCOPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(OrganizationManagedRuleMetadata::resourceIdScope)).setter(setter(Builder::resourceIdScope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceIdScope").build()).build();

    private static final SdkField<String> TAG_KEY_SCOPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(OrganizationManagedRuleMetadata::tagKeyScope)).setter(setter(Builder::tagKeyScope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagKeyScope").build()).build();

    private static final SdkField<String> TAG_VALUE_SCOPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(OrganizationManagedRuleMetadata::tagValueScope)).setter(setter(Builder::tagValueScope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagValueScope").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            RULE_IDENTIFIER_FIELD, INPUT_PARAMETERS_FIELD, MAXIMUM_EXECUTION_FREQUENCY_FIELD, RESOURCE_TYPES_SCOPE_FIELD,
            RESOURCE_ID_SCOPE_FIELD, TAG_KEY_SCOPE_FIELD, TAG_VALUE_SCOPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String description;

    private final String ruleIdentifier;

    private final String inputParameters;

    private final String maximumExecutionFrequency;

    private final List<String> resourceTypesScope;

    private final String resourceIdScope;

    private final String tagKeyScope;

    private final String tagValueScope;

    private OrganizationManagedRuleMetadata(BuilderImpl builder) {
        this.description = builder.description;
        this.ruleIdentifier = builder.ruleIdentifier;
        this.inputParameters = builder.inputParameters;
        this.maximumExecutionFrequency = builder.maximumExecutionFrequency;
        this.resourceTypesScope = builder.resourceTypesScope;
        this.resourceIdScope = builder.resourceIdScope;
        this.tagKeyScope = builder.tagKeyScope;
        this.tagValueScope = builder.tagValueScope;
    }

    /**
     * Returns the value of the Description property for this object.
     * 
     * @return The value of the Description property for this object.
     */
    public String description() {
        return description;
    }

    /**
     * Returns the value of the RuleIdentifier property for this object.
     * 
     * @return The value of the RuleIdentifier property for this object.
     */
    public String ruleIdentifier() {
        return ruleIdentifier;
    }

    /**
     * Returns the value of the InputParameters property for this object.
     * 
     * @return The value of the InputParameters property for this object.
     */
    public String inputParameters() {
        return inputParameters;
    }

    /**
     * Returns the value of the MaximumExecutionFrequency property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #maximumExecutionFrequency} will return {@link MaximumExecutionFrequency#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #maximumExecutionFrequencyAsString}.
     * </p>
     * 
     * @return The value of the MaximumExecutionFrequency property for this object.
     * @see MaximumExecutionFrequency
     */
    public MaximumExecutionFrequency maximumExecutionFrequency() {
        return MaximumExecutionFrequency.fromValue(maximumExecutionFrequency);
    }

    /**
     * Returns the value of the MaximumExecutionFrequency property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #maximumExecutionFrequency} will return {@link MaximumExecutionFrequency#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #maximumExecutionFrequencyAsString}.
     * </p>
     * 
     * @return The value of the MaximumExecutionFrequency property for this object.
     * @see MaximumExecutionFrequency
     */
    public String maximumExecutionFrequencyAsString() {
        return maximumExecutionFrequency;
    }

    /**
     * Returns the value of the ResourceTypesScope property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the ResourceTypesScope property for this object.
     */
    public List<String> resourceTypesScope() {
        return resourceTypesScope;
    }

    /**
     * Returns the value of the ResourceIdScope property for this object.
     * 
     * @return The value of the ResourceIdScope property for this object.
     */
    public String resourceIdScope() {
        return resourceIdScope;
    }

    /**
     * Returns the value of the TagKeyScope property for this object.
     * 
     * @return The value of the TagKeyScope property for this object.
     */
    public String tagKeyScope() {
        return tagKeyScope;
    }

    /**
     * Returns the value of the TagValueScope property for this object.
     * 
     * @return The value of the TagValueScope property for this object.
     */
    public String tagValueScope() {
        return tagValueScope;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(ruleIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(inputParameters());
        hashCode = 31 * hashCode + Objects.hashCode(maximumExecutionFrequencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypesScope());
        hashCode = 31 * hashCode + Objects.hashCode(resourceIdScope());
        hashCode = 31 * hashCode + Objects.hashCode(tagKeyScope());
        hashCode = 31 * hashCode + Objects.hashCode(tagValueScope());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrganizationManagedRuleMetadata)) {
            return false;
        }
        OrganizationManagedRuleMetadata other = (OrganizationManagedRuleMetadata) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(ruleIdentifier(), other.ruleIdentifier())
                && Objects.equals(inputParameters(), other.inputParameters())
                && Objects.equals(maximumExecutionFrequencyAsString(), other.maximumExecutionFrequencyAsString())
                && Objects.equals(resourceTypesScope(), other.resourceTypesScope())
                && Objects.equals(resourceIdScope(), other.resourceIdScope())
                && Objects.equals(tagKeyScope(), other.tagKeyScope()) && Objects.equals(tagValueScope(), other.tagValueScope());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("OrganizationManagedRuleMetadata").add("Description", description())
                .add("RuleIdentifier", ruleIdentifier()).add("InputParameters", inputParameters())
                .add("MaximumExecutionFrequency", maximumExecutionFrequencyAsString())
                .add("ResourceTypesScope", resourceTypesScope()).add("ResourceIdScope", resourceIdScope())
                .add("TagKeyScope", tagKeyScope()).add("TagValueScope", tagValueScope()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "RuleIdentifier":
            return Optional.ofNullable(clazz.cast(ruleIdentifier()));
        case "InputParameters":
            return Optional.ofNullable(clazz.cast(inputParameters()));
        case "MaximumExecutionFrequency":
            return Optional.ofNullable(clazz.cast(maximumExecutionFrequencyAsString()));
        case "ResourceTypesScope":
            return Optional.ofNullable(clazz.cast(resourceTypesScope()));
        case "ResourceIdScope":
            return Optional.ofNullable(clazz.cast(resourceIdScope()));
        case "TagKeyScope":
            return Optional.ofNullable(clazz.cast(tagKeyScope()));
        case "TagValueScope":
            return Optional.ofNullable(clazz.cast(tagValueScope()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OrganizationManagedRuleMetadata, T> g) {
        return obj -> g.apply((OrganizationManagedRuleMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OrganizationManagedRuleMetadata> {
        /**
         * Sets the value of the Description property for this object.
         *
         * @param description
         *        The new value for the Description property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * Sets the value of the RuleIdentifier property for this object.
         *
         * @param ruleIdentifier
         *        The new value for the RuleIdentifier property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleIdentifier(String ruleIdentifier);

        /**
         * Sets the value of the InputParameters property for this object.
         *
         * @param inputParameters
         *        The new value for the InputParameters property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputParameters(String inputParameters);

        /**
         * Sets the value of the MaximumExecutionFrequency property for this object.
         *
         * @param maximumExecutionFrequency
         *        The new value for the MaximumExecutionFrequency property for this object.
         * @see MaximumExecutionFrequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MaximumExecutionFrequency
         */
        Builder maximumExecutionFrequency(String maximumExecutionFrequency);

        /**
         * Sets the value of the MaximumExecutionFrequency property for this object.
         *
         * @param maximumExecutionFrequency
         *        The new value for the MaximumExecutionFrequency property for this object.
         * @see MaximumExecutionFrequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MaximumExecutionFrequency
         */
        Builder maximumExecutionFrequency(MaximumExecutionFrequency maximumExecutionFrequency);

        /**
         * Sets the value of the ResourceTypesScope property for this object.
         *
         * @param resourceTypesScope
         *        The new value for the ResourceTypesScope property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypesScope(Collection<String> resourceTypesScope);

        /**
         * Sets the value of the ResourceTypesScope property for this object.
         *
         * @param resourceTypesScope
         *        The new value for the ResourceTypesScope property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypesScope(String... resourceTypesScope);

        /**
         * Sets the value of the ResourceIdScope property for this object.
         *
         * @param resourceIdScope
         *        The new value for the ResourceIdScope property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIdScope(String resourceIdScope);

        /**
         * Sets the value of the TagKeyScope property for this object.
         *
         * @param tagKeyScope
         *        The new value for the TagKeyScope property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagKeyScope(String tagKeyScope);

        /**
         * Sets the value of the TagValueScope property for this object.
         *
         * @param tagValueScope
         *        The new value for the TagValueScope property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagValueScope(String tagValueScope);
    }

    static final class BuilderImpl implements Builder {
        private String description;

        private String ruleIdentifier;

        private String inputParameters;

        private String maximumExecutionFrequency;

        private List<String> resourceTypesScope = DefaultSdkAutoConstructList.getInstance();

        private String resourceIdScope;

        private String tagKeyScope;

        private String tagValueScope;

        private BuilderImpl() {
        }

        private BuilderImpl(OrganizationManagedRuleMetadata model) {
            description(model.description);
            ruleIdentifier(model.ruleIdentifier);
            inputParameters(model.inputParameters);
            maximumExecutionFrequency(model.maximumExecutionFrequency);
            resourceTypesScope(model.resourceTypesScope);
            resourceIdScope(model.resourceIdScope);
            tagKeyScope(model.tagKeyScope);
            tagValueScope(model.tagValueScope);
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getRuleIdentifier() {
            return ruleIdentifier;
        }

        @Override
        public final Builder ruleIdentifier(String ruleIdentifier) {
            this.ruleIdentifier = ruleIdentifier;
            return this;
        }

        public final void setRuleIdentifier(String ruleIdentifier) {
            this.ruleIdentifier = ruleIdentifier;
        }

        public final String getInputParameters() {
            return inputParameters;
        }

        @Override
        public final Builder inputParameters(String inputParameters) {
            this.inputParameters = inputParameters;
            return this;
        }

        public final void setInputParameters(String inputParameters) {
            this.inputParameters = inputParameters;
        }

        public final String getMaximumExecutionFrequencyAsString() {
            return maximumExecutionFrequency;
        }

        @Override
        public final Builder maximumExecutionFrequency(String maximumExecutionFrequency) {
            this.maximumExecutionFrequency = maximumExecutionFrequency;
            return this;
        }

        @Override
        public final Builder maximumExecutionFrequency(MaximumExecutionFrequency maximumExecutionFrequency) {
            this.maximumExecutionFrequency(maximumExecutionFrequency == null ? null : maximumExecutionFrequency.toString());
            return this;
        }

        public final void setMaximumExecutionFrequency(String maximumExecutionFrequency) {
            this.maximumExecutionFrequency = maximumExecutionFrequency;
        }

        public final Collection<String> getResourceTypesScope() {
            return resourceTypesScope;
        }

        @Override
        public final Builder resourceTypesScope(Collection<String> resourceTypesScope) {
            this.resourceTypesScope = ResourceTypesScopeCopier.copy(resourceTypesScope);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypesScope(String... resourceTypesScope) {
            resourceTypesScope(Arrays.asList(resourceTypesScope));
            return this;
        }

        public final void setResourceTypesScope(Collection<String> resourceTypesScope) {
            this.resourceTypesScope = ResourceTypesScopeCopier.copy(resourceTypesScope);
        }

        public final String getResourceIdScope() {
            return resourceIdScope;
        }

        @Override
        public final Builder resourceIdScope(String resourceIdScope) {
            this.resourceIdScope = resourceIdScope;
            return this;
        }

        public final void setResourceIdScope(String resourceIdScope) {
            this.resourceIdScope = resourceIdScope;
        }

        public final String getTagKeyScope() {
            return tagKeyScope;
        }

        @Override
        public final Builder tagKeyScope(String tagKeyScope) {
            this.tagKeyScope = tagKeyScope;
            return this;
        }

        public final void setTagKeyScope(String tagKeyScope) {
            this.tagKeyScope = tagKeyScope;
        }

        public final String getTagValueScope() {
            return tagValueScope;
        }

        @Override
        public final Builder tagValueScope(String tagValueScope) {
            this.tagValueScope = tagValueScope;
            return this;
        }

        public final void setTagValueScope(String tagValueScope) {
            this.tagValueScope = tagValueScope;
        }

        @Override
        public OrganizationManagedRuleMetadata build() {
            return new OrganizationManagedRuleMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
