/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeletePendingAggregationRequestRequest extends ConfigRequest implements
        ToCopyableBuilder<DeletePendingAggregationRequestRequest.Builder, DeletePendingAggregationRequestRequest> {
    private static final SdkField<String> REQUESTER_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeletePendingAggregationRequestRequest::requesterAccountId))
            .setter(setter(Builder::requesterAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequesterAccountId").build())
            .build();

    private static final SdkField<String> REQUESTER_AWS_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeletePendingAggregationRequestRequest::requesterAwsRegion))
            .setter(setter(Builder::requesterAwsRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequesterAwsRegion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUESTER_ACCOUNT_ID_FIELD,
            REQUESTER_AWS_REGION_FIELD));

    private final String requesterAccountId;

    private final String requesterAwsRegion;

    private DeletePendingAggregationRequestRequest(BuilderImpl builder) {
        super(builder);
        this.requesterAccountId = builder.requesterAccountId;
        this.requesterAwsRegion = builder.requesterAwsRegion;
    }

    /**
     * <p>
     * The 12-digit account ID of the account requesting to aggregate data.
     * </p>
     * 
     * @return The 12-digit account ID of the account requesting to aggregate data.
     */
    public String requesterAccountId() {
        return requesterAccountId;
    }

    /**
     * <p>
     * The region requesting to aggregate data.
     * </p>
     * 
     * @return The region requesting to aggregate data.
     */
    public String requesterAwsRegion() {
        return requesterAwsRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(requesterAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(requesterAwsRegion());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeletePendingAggregationRequestRequest)) {
            return false;
        }
        DeletePendingAggregationRequestRequest other = (DeletePendingAggregationRequestRequest) obj;
        return Objects.equals(requesterAccountId(), other.requesterAccountId())
                && Objects.equals(requesterAwsRegion(), other.requesterAwsRegion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeletePendingAggregationRequestRequest").add("RequesterAccountId", requesterAccountId())
                .add("RequesterAwsRegion", requesterAwsRegion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RequesterAccountId":
            return Optional.ofNullable(clazz.cast(requesterAccountId()));
        case "RequesterAwsRegion":
            return Optional.ofNullable(clazz.cast(requesterAwsRegion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeletePendingAggregationRequestRequest, T> g) {
        return obj -> g.apply((DeletePendingAggregationRequestRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeletePendingAggregationRequestRequest> {
        /**
         * <p>
         * The 12-digit account ID of the account requesting to aggregate data.
         * </p>
         * 
         * @param requesterAccountId
         *        The 12-digit account ID of the account requesting to aggregate data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requesterAccountId(String requesterAccountId);

        /**
         * <p>
         * The region requesting to aggregate data.
         * </p>
         * 
         * @param requesterAwsRegion
         *        The region requesting to aggregate data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requesterAwsRegion(String requesterAwsRegion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConfigRequest.BuilderImpl implements Builder {
        private String requesterAccountId;

        private String requesterAwsRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(DeletePendingAggregationRequestRequest model) {
            super(model);
            requesterAccountId(model.requesterAccountId);
            requesterAwsRegion(model.requesterAwsRegion);
        }

        public final String getRequesterAccountId() {
            return requesterAccountId;
        }

        @Override
        public final Builder requesterAccountId(String requesterAccountId) {
            this.requesterAccountId = requesterAccountId;
            return this;
        }

        public final void setRequesterAccountId(String requesterAccountId) {
            this.requesterAccountId = requesterAccountId;
        }

        public final String getRequesterAwsRegion() {
            return requesterAwsRegion;
        }

        @Override
        public final Builder requesterAwsRegion(String requesterAwsRegion) {
            this.requesterAwsRegion = requesterAwsRegion;
            return this;
        }

        public final void setRequesterAwsRegion(String requesterAwsRegion) {
            this.requesterAwsRegion = requesterAwsRegion;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeletePendingAggregationRequestRequest build() {
            return new DeletePendingAggregationRequestRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
