/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The current status of the configuration recorder.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfigurationRecorderStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<ConfigurationRecorderStatus.Builder, ConfigurationRecorderStatus> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ConfigurationRecorderStatus::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Instant> LAST_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ConfigurationRecorderStatus::lastStartTime)).setter(setter(Builder::lastStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastStartTime").build()).build();

    private static final SdkField<Instant> LAST_STOP_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ConfigurationRecorderStatus::lastStopTime)).setter(setter(Builder::lastStopTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastStopTime").build()).build();

    private static final SdkField<Boolean> RECORDING_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ConfigurationRecorderStatus::recording)).setter(setter(Builder::recording))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recording").build()).build();

    private static final SdkField<String> LAST_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ConfigurationRecorderStatus::lastStatusAsString)).setter(setter(Builder::lastStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastStatus").build()).build();

    private static final SdkField<String> LAST_ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ConfigurationRecorderStatus::lastErrorCode)).setter(setter(Builder::lastErrorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastErrorCode").build()).build();

    private static final SdkField<String> LAST_ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ConfigurationRecorderStatus::lastErrorMessage)).setter(setter(Builder::lastErrorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastErrorMessage").build()).build();

    private static final SdkField<Instant> LAST_STATUS_CHANGE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ConfigurationRecorderStatus::lastStatusChangeTime)).setter(setter(Builder::lastStatusChangeTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastStatusChangeTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            LAST_START_TIME_FIELD, LAST_STOP_TIME_FIELD, RECORDING_FIELD, LAST_STATUS_FIELD, LAST_ERROR_CODE_FIELD,
            LAST_ERROR_MESSAGE_FIELD, LAST_STATUS_CHANGE_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final Instant lastStartTime;

    private final Instant lastStopTime;

    private final Boolean recording;

    private final String lastStatus;

    private final String lastErrorCode;

    private final String lastErrorMessage;

    private final Instant lastStatusChangeTime;

    private ConfigurationRecorderStatus(BuilderImpl builder) {
        this.name = builder.name;
        this.lastStartTime = builder.lastStartTime;
        this.lastStopTime = builder.lastStopTime;
        this.recording = builder.recording;
        this.lastStatus = builder.lastStatus;
        this.lastErrorCode = builder.lastErrorCode;
        this.lastErrorMessage = builder.lastErrorMessage;
        this.lastStatusChangeTime = builder.lastStatusChangeTime;
    }

    /**
     * <p>
     * The name of the configuration recorder.
     * </p>
     * 
     * @return The name of the configuration recorder.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The time the recorder was last started.
     * </p>
     * 
     * @return The time the recorder was last started.
     */
    public Instant lastStartTime() {
        return lastStartTime;
    }

    /**
     * <p>
     * The time the recorder was last stopped.
     * </p>
     * 
     * @return The time the recorder was last stopped.
     */
    public Instant lastStopTime() {
        return lastStopTime;
    }

    /**
     * <p>
     * Specifies whether or not the recorder is currently recording.
     * </p>
     * 
     * @return Specifies whether or not the recorder is currently recording.
     */
    public Boolean recording() {
        return recording;
    }

    /**
     * <p>
     * The last (previous) status of the recorder.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lastStatus} will
     * return {@link RecorderStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lastStatusAsString}.
     * </p>
     * 
     * @return The last (previous) status of the recorder.
     * @see RecorderStatus
     */
    public RecorderStatus lastStatus() {
        return RecorderStatus.fromValue(lastStatus);
    }

    /**
     * <p>
     * The last (previous) status of the recorder.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lastStatus} will
     * return {@link RecorderStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lastStatusAsString}.
     * </p>
     * 
     * @return The last (previous) status of the recorder.
     * @see RecorderStatus
     */
    public String lastStatusAsString() {
        return lastStatus;
    }

    /**
     * <p>
     * The error code indicating that the recording failed.
     * </p>
     * 
     * @return The error code indicating that the recording failed.
     */
    public String lastErrorCode() {
        return lastErrorCode;
    }

    /**
     * <p>
     * The message indicating that the recording failed due to an error.
     * </p>
     * 
     * @return The message indicating that the recording failed due to an error.
     */
    public String lastErrorMessage() {
        return lastErrorMessage;
    }

    /**
     * <p>
     * The time when the status was last changed.
     * </p>
     * 
     * @return The time when the status was last changed.
     */
    public Instant lastStatusChangeTime() {
        return lastStatusChangeTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(lastStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastStopTime());
        hashCode = 31 * hashCode + Objects.hashCode(recording());
        hashCode = 31 * hashCode + Objects.hashCode(lastStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastErrorCode());
        hashCode = 31 * hashCode + Objects.hashCode(lastErrorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(lastStatusChangeTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationRecorderStatus)) {
            return false;
        }
        ConfigurationRecorderStatus other = (ConfigurationRecorderStatus) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(lastStartTime(), other.lastStartTime())
                && Objects.equals(lastStopTime(), other.lastStopTime()) && Objects.equals(recording(), other.recording())
                && Objects.equals(lastStatusAsString(), other.lastStatusAsString())
                && Objects.equals(lastErrorCode(), other.lastErrorCode())
                && Objects.equals(lastErrorMessage(), other.lastErrorMessage())
                && Objects.equals(lastStatusChangeTime(), other.lastStatusChangeTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ConfigurationRecorderStatus").add("Name", name()).add("LastStartTime", lastStartTime())
                .add("LastStopTime", lastStopTime()).add("Recording", recording()).add("LastStatus", lastStatusAsString())
                .add("LastErrorCode", lastErrorCode()).add("LastErrorMessage", lastErrorMessage())
                .add("LastStatusChangeTime", lastStatusChangeTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "lastStartTime":
            return Optional.ofNullable(clazz.cast(lastStartTime()));
        case "lastStopTime":
            return Optional.ofNullable(clazz.cast(lastStopTime()));
        case "recording":
            return Optional.ofNullable(clazz.cast(recording()));
        case "lastStatus":
            return Optional.ofNullable(clazz.cast(lastStatusAsString()));
        case "lastErrorCode":
            return Optional.ofNullable(clazz.cast(lastErrorCode()));
        case "lastErrorMessage":
            return Optional.ofNullable(clazz.cast(lastErrorMessage()));
        case "lastStatusChangeTime":
            return Optional.ofNullable(clazz.cast(lastStatusChangeTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConfigurationRecorderStatus, T> g) {
        return obj -> g.apply((ConfigurationRecorderStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConfigurationRecorderStatus> {
        /**
         * <p>
         * The name of the configuration recorder.
         * </p>
         * 
         * @param name
         *        The name of the configuration recorder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The time the recorder was last started.
         * </p>
         * 
         * @param lastStartTime
         *        The time the recorder was last started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastStartTime(Instant lastStartTime);

        /**
         * <p>
         * The time the recorder was last stopped.
         * </p>
         * 
         * @param lastStopTime
         *        The time the recorder was last stopped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastStopTime(Instant lastStopTime);

        /**
         * <p>
         * Specifies whether or not the recorder is currently recording.
         * </p>
         * 
         * @param recording
         *        Specifies whether or not the recorder is currently recording.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recording(Boolean recording);

        /**
         * <p>
         * The last (previous) status of the recorder.
         * </p>
         * 
         * @param lastStatus
         *        The last (previous) status of the recorder.
         * @see RecorderStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecorderStatus
         */
        Builder lastStatus(String lastStatus);

        /**
         * <p>
         * The last (previous) status of the recorder.
         * </p>
         * 
         * @param lastStatus
         *        The last (previous) status of the recorder.
         * @see RecorderStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecorderStatus
         */
        Builder lastStatus(RecorderStatus lastStatus);

        /**
         * <p>
         * The error code indicating that the recording failed.
         * </p>
         * 
         * @param lastErrorCode
         *        The error code indicating that the recording failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastErrorCode(String lastErrorCode);

        /**
         * <p>
         * The message indicating that the recording failed due to an error.
         * </p>
         * 
         * @param lastErrorMessage
         *        The message indicating that the recording failed due to an error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastErrorMessage(String lastErrorMessage);

        /**
         * <p>
         * The time when the status was last changed.
         * </p>
         * 
         * @param lastStatusChangeTime
         *        The time when the status was last changed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastStatusChangeTime(Instant lastStatusChangeTime);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private Instant lastStartTime;

        private Instant lastStopTime;

        private Boolean recording;

        private String lastStatus;

        private String lastErrorCode;

        private String lastErrorMessage;

        private Instant lastStatusChangeTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurationRecorderStatus model) {
            name(model.name);
            lastStartTime(model.lastStartTime);
            lastStopTime(model.lastStopTime);
            recording(model.recording);
            lastStatus(model.lastStatus);
            lastErrorCode(model.lastErrorCode);
            lastErrorMessage(model.lastErrorMessage);
            lastStatusChangeTime(model.lastStatusChangeTime);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Instant getLastStartTime() {
            return lastStartTime;
        }

        @Override
        public final Builder lastStartTime(Instant lastStartTime) {
            this.lastStartTime = lastStartTime;
            return this;
        }

        public final void setLastStartTime(Instant lastStartTime) {
            this.lastStartTime = lastStartTime;
        }

        public final Instant getLastStopTime() {
            return lastStopTime;
        }

        @Override
        public final Builder lastStopTime(Instant lastStopTime) {
            this.lastStopTime = lastStopTime;
            return this;
        }

        public final void setLastStopTime(Instant lastStopTime) {
            this.lastStopTime = lastStopTime;
        }

        public final Boolean getRecording() {
            return recording;
        }

        @Override
        public final Builder recording(Boolean recording) {
            this.recording = recording;
            return this;
        }

        public final void setRecording(Boolean recording) {
            this.recording = recording;
        }

        public final String getLastStatusAsString() {
            return lastStatus;
        }

        @Override
        public final Builder lastStatus(String lastStatus) {
            this.lastStatus = lastStatus;
            return this;
        }

        @Override
        public final Builder lastStatus(RecorderStatus lastStatus) {
            this.lastStatus(lastStatus.toString());
            return this;
        }

        public final void setLastStatus(String lastStatus) {
            this.lastStatus = lastStatus;
        }

        public final String getLastErrorCode() {
            return lastErrorCode;
        }

        @Override
        public final Builder lastErrorCode(String lastErrorCode) {
            this.lastErrorCode = lastErrorCode;
            return this;
        }

        public final void setLastErrorCode(String lastErrorCode) {
            this.lastErrorCode = lastErrorCode;
        }

        public final String getLastErrorMessage() {
            return lastErrorMessage;
        }

        @Override
        public final Builder lastErrorMessage(String lastErrorMessage) {
            this.lastErrorMessage = lastErrorMessage;
            return this;
        }

        public final void setLastErrorMessage(String lastErrorMessage) {
            this.lastErrorMessage = lastErrorMessage;
        }

        public final Instant getLastStatusChangeTime() {
            return lastStatusChangeTime;
        }

        @Override
        public final Builder lastStatusChangeTime(Instant lastStatusChangeTime) {
            this.lastStatusChangeTime = lastStatusChangeTime;
            return this;
        }

        public final void setLastStatusChangeTime(Instant lastStatusChangeTime) {
            this.lastStatusChangeTime = lastStatusChangeTime;
        }

        @Override
        public ConfigurationRecorderStatus build() {
            return new ConfigurationRecorderStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
