/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Identifies an AWS resource and indicates whether it complies with the AWS Config rule that it was evaluated against.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Evaluation implements SdkPojo, Serializable, ToCopyableBuilder<Evaluation.Builder, Evaluation> {
    private static final SdkField<String> COMPLIANCE_RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Evaluation::complianceResourceType)).setter(setter(Builder::complianceResourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceResourceType").build())
            .build();

    private static final SdkField<String> COMPLIANCE_RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Evaluation::complianceResourceId)).setter(setter(Builder::complianceResourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceResourceId").build())
            .build();

    private static final SdkField<String> COMPLIANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Evaluation::complianceTypeAsString)).setter(setter(Builder::complianceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceType").build()).build();

    private static final SdkField<String> ANNOTATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Evaluation::annotation)).setter(setter(Builder::annotation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Annotation").build()).build();

    private static final SdkField<Instant> ORDERING_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Evaluation::orderingTimestamp)).setter(setter(Builder::orderingTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrderingTimestamp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            COMPLIANCE_RESOURCE_TYPE_FIELD, COMPLIANCE_RESOURCE_ID_FIELD, COMPLIANCE_TYPE_FIELD, ANNOTATION_FIELD,
            ORDERING_TIMESTAMP_FIELD));

    private static final long serialVersionUID = 1L;

    private final String complianceResourceType;

    private final String complianceResourceId;

    private final String complianceType;

    private final String annotation;

    private final Instant orderingTimestamp;

    private Evaluation(BuilderImpl builder) {
        this.complianceResourceType = builder.complianceResourceType;
        this.complianceResourceId = builder.complianceResourceId;
        this.complianceType = builder.complianceType;
        this.annotation = builder.annotation;
        this.orderingTimestamp = builder.orderingTimestamp;
    }

    /**
     * <p>
     * The type of AWS resource that was evaluated.
     * </p>
     * 
     * @return The type of AWS resource that was evaluated.
     */
    public String complianceResourceType() {
        return complianceResourceType;
    }

    /**
     * <p>
     * The ID of the AWS resource that was evaluated.
     * </p>
     * 
     * @return The ID of the AWS resource that was evaluated.
     */
    public String complianceResourceId() {
        return complianceResourceId;
    }

    /**
     * <p>
     * Indicates whether the AWS resource complies with the AWS Config rule that it was evaluated against.
     * </p>
     * <p>
     * For the <code>Evaluation</code> data type, AWS Config supports only the <code>COMPLIANT</code>,
     * <code>NON_COMPLIANT</code>, and <code>NOT_APPLICABLE</code> values. AWS Config does not support the
     * <code>INSUFFICIENT_DATA</code> value for this data type.
     * </p>
     * <p>
     * Similarly, AWS Config does not accept <code>INSUFFICIENT_DATA</code> as the value for <code>ComplianceType</code>
     * from a <code>PutEvaluations</code> request. For example, an AWS Lambda function for a custom AWS Config rule
     * cannot pass an <code>INSUFFICIENT_DATA</code> value to AWS Config.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #complianceType}
     * will return {@link ComplianceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #complianceTypeAsString}.
     * </p>
     * 
     * @return Indicates whether the AWS resource complies with the AWS Config rule that it was evaluated against.</p>
     *         <p>
     *         For the <code>Evaluation</code> data type, AWS Config supports only the <code>COMPLIANT</code>,
     *         <code>NON_COMPLIANT</code>, and <code>NOT_APPLICABLE</code> values. AWS Config does not support the
     *         <code>INSUFFICIENT_DATA</code> value for this data type.
     *         </p>
     *         <p>
     *         Similarly, AWS Config does not accept <code>INSUFFICIENT_DATA</code> as the value for
     *         <code>ComplianceType</code> from a <code>PutEvaluations</code> request. For example, an AWS Lambda
     *         function for a custom AWS Config rule cannot pass an <code>INSUFFICIENT_DATA</code> value to AWS Config.
     * @see ComplianceType
     */
    public ComplianceType complianceType() {
        return ComplianceType.fromValue(complianceType);
    }

    /**
     * <p>
     * Indicates whether the AWS resource complies with the AWS Config rule that it was evaluated against.
     * </p>
     * <p>
     * For the <code>Evaluation</code> data type, AWS Config supports only the <code>COMPLIANT</code>,
     * <code>NON_COMPLIANT</code>, and <code>NOT_APPLICABLE</code> values. AWS Config does not support the
     * <code>INSUFFICIENT_DATA</code> value for this data type.
     * </p>
     * <p>
     * Similarly, AWS Config does not accept <code>INSUFFICIENT_DATA</code> as the value for <code>ComplianceType</code>
     * from a <code>PutEvaluations</code> request. For example, an AWS Lambda function for a custom AWS Config rule
     * cannot pass an <code>INSUFFICIENT_DATA</code> value to AWS Config.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #complianceType}
     * will return {@link ComplianceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #complianceTypeAsString}.
     * </p>
     * 
     * @return Indicates whether the AWS resource complies with the AWS Config rule that it was evaluated against.</p>
     *         <p>
     *         For the <code>Evaluation</code> data type, AWS Config supports only the <code>COMPLIANT</code>,
     *         <code>NON_COMPLIANT</code>, and <code>NOT_APPLICABLE</code> values. AWS Config does not support the
     *         <code>INSUFFICIENT_DATA</code> value for this data type.
     *         </p>
     *         <p>
     *         Similarly, AWS Config does not accept <code>INSUFFICIENT_DATA</code> as the value for
     *         <code>ComplianceType</code> from a <code>PutEvaluations</code> request. For example, an AWS Lambda
     *         function for a custom AWS Config rule cannot pass an <code>INSUFFICIENT_DATA</code> value to AWS Config.
     * @see ComplianceType
     */
    public String complianceTypeAsString() {
        return complianceType;
    }

    /**
     * <p>
     * Supplementary information about how the evaluation determined the compliance.
     * </p>
     * 
     * @return Supplementary information about how the evaluation determined the compliance.
     */
    public String annotation() {
        return annotation;
    }

    /**
     * <p>
     * The time of the event in AWS Config that triggered the evaluation. For event-based evaluations, the time
     * indicates when AWS Config created the configuration item that triggered the evaluation. For periodic evaluations,
     * the time indicates when AWS Config triggered the evaluation at the frequency that you specified (for example,
     * every 24 hours).
     * </p>
     * 
     * @return The time of the event in AWS Config that triggered the evaluation. For event-based evaluations, the time
     *         indicates when AWS Config created the configuration item that triggered the evaluation. For periodic
     *         evaluations, the time indicates when AWS Config triggered the evaluation at the frequency that you
     *         specified (for example, every 24 hours).
     */
    public Instant orderingTimestamp() {
        return orderingTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(complianceResourceType());
        hashCode = 31 * hashCode + Objects.hashCode(complianceResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(complianceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(annotation());
        hashCode = 31 * hashCode + Objects.hashCode(orderingTimestamp());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Evaluation)) {
            return false;
        }
        Evaluation other = (Evaluation) obj;
        return Objects.equals(complianceResourceType(), other.complianceResourceType())
                && Objects.equals(complianceResourceId(), other.complianceResourceId())
                && Objects.equals(complianceTypeAsString(), other.complianceTypeAsString())
                && Objects.equals(annotation(), other.annotation())
                && Objects.equals(orderingTimestamp(), other.orderingTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Evaluation").add("ComplianceResourceType", complianceResourceType())
                .add("ComplianceResourceId", complianceResourceId()).add("ComplianceType", complianceTypeAsString())
                .add("Annotation", annotation()).add("OrderingTimestamp", orderingTimestamp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ComplianceResourceType":
            return Optional.ofNullable(clazz.cast(complianceResourceType()));
        case "ComplianceResourceId":
            return Optional.ofNullable(clazz.cast(complianceResourceId()));
        case "ComplianceType":
            return Optional.ofNullable(clazz.cast(complianceTypeAsString()));
        case "Annotation":
            return Optional.ofNullable(clazz.cast(annotation()));
        case "OrderingTimestamp":
            return Optional.ofNullable(clazz.cast(orderingTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Evaluation, T> g) {
        return obj -> g.apply((Evaluation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Evaluation> {
        /**
         * <p>
         * The type of AWS resource that was evaluated.
         * </p>
         * 
         * @param complianceResourceType
         *        The type of AWS resource that was evaluated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceResourceType(String complianceResourceType);

        /**
         * <p>
         * The ID of the AWS resource that was evaluated.
         * </p>
         * 
         * @param complianceResourceId
         *        The ID of the AWS resource that was evaluated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceResourceId(String complianceResourceId);

        /**
         * <p>
         * Indicates whether the AWS resource complies with the AWS Config rule that it was evaluated against.
         * </p>
         * <p>
         * For the <code>Evaluation</code> data type, AWS Config supports only the <code>COMPLIANT</code>,
         * <code>NON_COMPLIANT</code>, and <code>NOT_APPLICABLE</code> values. AWS Config does not support the
         * <code>INSUFFICIENT_DATA</code> value for this data type.
         * </p>
         * <p>
         * Similarly, AWS Config does not accept <code>INSUFFICIENT_DATA</code> as the value for
         * <code>ComplianceType</code> from a <code>PutEvaluations</code> request. For example, an AWS Lambda function
         * for a custom AWS Config rule cannot pass an <code>INSUFFICIENT_DATA</code> value to AWS Config.
         * </p>
         * 
         * @param complianceType
         *        Indicates whether the AWS resource complies with the AWS Config rule that it was evaluated
         *        against.</p>
         *        <p>
         *        For the <code>Evaluation</code> data type, AWS Config supports only the <code>COMPLIANT</code>,
         *        <code>NON_COMPLIANT</code>, and <code>NOT_APPLICABLE</code> values. AWS Config does not support the
         *        <code>INSUFFICIENT_DATA</code> value for this data type.
         *        </p>
         *        <p>
         *        Similarly, AWS Config does not accept <code>INSUFFICIENT_DATA</code> as the value for
         *        <code>ComplianceType</code> from a <code>PutEvaluations</code> request. For example, an AWS Lambda
         *        function for a custom AWS Config rule cannot pass an <code>INSUFFICIENT_DATA</code> value to AWS
         *        Config.
         * @see ComplianceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComplianceType
         */
        Builder complianceType(String complianceType);

        /**
         * <p>
         * Indicates whether the AWS resource complies with the AWS Config rule that it was evaluated against.
         * </p>
         * <p>
         * For the <code>Evaluation</code> data type, AWS Config supports only the <code>COMPLIANT</code>,
         * <code>NON_COMPLIANT</code>, and <code>NOT_APPLICABLE</code> values. AWS Config does not support the
         * <code>INSUFFICIENT_DATA</code> value for this data type.
         * </p>
         * <p>
         * Similarly, AWS Config does not accept <code>INSUFFICIENT_DATA</code> as the value for
         * <code>ComplianceType</code> from a <code>PutEvaluations</code> request. For example, an AWS Lambda function
         * for a custom AWS Config rule cannot pass an <code>INSUFFICIENT_DATA</code> value to AWS Config.
         * </p>
         * 
         * @param complianceType
         *        Indicates whether the AWS resource complies with the AWS Config rule that it was evaluated
         *        against.</p>
         *        <p>
         *        For the <code>Evaluation</code> data type, AWS Config supports only the <code>COMPLIANT</code>,
         *        <code>NON_COMPLIANT</code>, and <code>NOT_APPLICABLE</code> values. AWS Config does not support the
         *        <code>INSUFFICIENT_DATA</code> value for this data type.
         *        </p>
         *        <p>
         *        Similarly, AWS Config does not accept <code>INSUFFICIENT_DATA</code> as the value for
         *        <code>ComplianceType</code> from a <code>PutEvaluations</code> request. For example, an AWS Lambda
         *        function for a custom AWS Config rule cannot pass an <code>INSUFFICIENT_DATA</code> value to AWS
         *        Config.
         * @see ComplianceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComplianceType
         */
        Builder complianceType(ComplianceType complianceType);

        /**
         * <p>
         * Supplementary information about how the evaluation determined the compliance.
         * </p>
         * 
         * @param annotation
         *        Supplementary information about how the evaluation determined the compliance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder annotation(String annotation);

        /**
         * <p>
         * The time of the event in AWS Config that triggered the evaluation. For event-based evaluations, the time
         * indicates when AWS Config created the configuration item that triggered the evaluation. For periodic
         * evaluations, the time indicates when AWS Config triggered the evaluation at the frequency that you specified
         * (for example, every 24 hours).
         * </p>
         * 
         * @param orderingTimestamp
         *        The time of the event in AWS Config that triggered the evaluation. For event-based evaluations, the
         *        time indicates when AWS Config created the configuration item that triggered the evaluation. For
         *        periodic evaluations, the time indicates when AWS Config triggered the evaluation at the frequency
         *        that you specified (for example, every 24 hours).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orderingTimestamp(Instant orderingTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String complianceResourceType;

        private String complianceResourceId;

        private String complianceType;

        private String annotation;

        private Instant orderingTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(Evaluation model) {
            complianceResourceType(model.complianceResourceType);
            complianceResourceId(model.complianceResourceId);
            complianceType(model.complianceType);
            annotation(model.annotation);
            orderingTimestamp(model.orderingTimestamp);
        }

        public final String getComplianceResourceType() {
            return complianceResourceType;
        }

        @Override
        public final Builder complianceResourceType(String complianceResourceType) {
            this.complianceResourceType = complianceResourceType;
            return this;
        }

        public final void setComplianceResourceType(String complianceResourceType) {
            this.complianceResourceType = complianceResourceType;
        }

        public final String getComplianceResourceId() {
            return complianceResourceId;
        }

        @Override
        public final Builder complianceResourceId(String complianceResourceId) {
            this.complianceResourceId = complianceResourceId;
            return this;
        }

        public final void setComplianceResourceId(String complianceResourceId) {
            this.complianceResourceId = complianceResourceId;
        }

        public final String getComplianceTypeAsString() {
            return complianceType;
        }

        @Override
        public final Builder complianceType(String complianceType) {
            this.complianceType = complianceType;
            return this;
        }

        @Override
        public final Builder complianceType(ComplianceType complianceType) {
            this.complianceType(complianceType.toString());
            return this;
        }

        public final void setComplianceType(String complianceType) {
            this.complianceType = complianceType;
        }

        public final String getAnnotation() {
            return annotation;
        }

        @Override
        public final Builder annotation(String annotation) {
            this.annotation = annotation;
            return this;
        }

        public final void setAnnotation(String annotation) {
            this.annotation = annotation;
        }

        public final Instant getOrderingTimestamp() {
            return orderingTimestamp;
        }

        @Override
        public final Builder orderingTimestamp(Instant orderingTimestamp) {
            this.orderingTimestamp = orderingTimestamp;
            return this;
        }

        public final void setOrderingTimestamp(Instant orderingTimestamp) {
            this.orderingTimestamp = orderingTimestamp;
        }

        @Override
        public Evaluation build() {
            return new Evaluation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
