/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeOrganizationConfigRulesRequest extends ConfigRequest implements
        ToCopyableBuilder<DescribeOrganizationConfigRulesRequest.Builder, DescribeOrganizationConfigRulesRequest> {
    private static final SdkField<List<String>> ORGANIZATION_CONFIG_RULE_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeOrganizationConfigRulesRequest::organizationConfigRuleNames))
            .setter(setter(Builder::organizationConfigRuleNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationConfigRuleNames")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DescribeOrganizationConfigRulesRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeOrganizationConfigRulesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ORGANIZATION_CONFIG_RULE_NAMES_FIELD, LIMIT_FIELD, NEXT_TOKEN_FIELD));

    private final List<String> organizationConfigRuleNames;

    private final Integer limit;

    private final String nextToken;

    private DescribeOrganizationConfigRulesRequest(BuilderImpl builder) {
        super(builder);
        this.organizationConfigRuleNames = builder.organizationConfigRuleNames;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The names of organization config rules for which you want details. If you do not specify any names, AWS Config
     * returns details for all your organization config rules.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The names of organization config rules for which you want details. If you do not specify any names, AWS
     *         Config returns details for all your organization config rules.
     */
    public List<String> organizationConfigRuleNames() {
        return organizationConfigRuleNames;
    }

    /**
     * <p>
     * The maximum number of organization config rules returned on each page. If you do no specify a number, AWS Config
     * uses the default. The default is 100.
     * </p>
     * 
     * @return The maximum number of organization config rules returned on each page. If you do no specify a number, AWS
     *         Config uses the default. The default is 100.
     */
    public Integer limit() {
        return limit;
    }

    /**
     * <p>
     * The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a
     * paginated response.
     * </p>
     * 
     * @return The <code>nextToken</code> string returned on a previous page that you use to get the next page of
     *         results in a paginated response.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(organizationConfigRuleNames());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOrganizationConfigRulesRequest)) {
            return false;
        }
        DescribeOrganizationConfigRulesRequest other = (DescribeOrganizationConfigRulesRequest) obj;
        return Objects.equals(organizationConfigRuleNames(), other.organizationConfigRuleNames())
                && Objects.equals(limit(), other.limit()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeOrganizationConfigRulesRequest")
                .add("OrganizationConfigRuleNames", organizationConfigRuleNames()).add("Limit", limit())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrganizationConfigRuleNames":
            return Optional.ofNullable(clazz.cast(organizationConfigRuleNames()));
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeOrganizationConfigRulesRequest, T> g) {
        return obj -> g.apply((DescribeOrganizationConfigRulesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeOrganizationConfigRulesRequest> {
        /**
         * <p>
         * The names of organization config rules for which you want details. If you do not specify any names, AWS
         * Config returns details for all your organization config rules.
         * </p>
         * 
         * @param organizationConfigRuleNames
         *        The names of organization config rules for which you want details. If you do not specify any names,
         *        AWS Config returns details for all your organization config rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationConfigRuleNames(Collection<String> organizationConfigRuleNames);

        /**
         * <p>
         * The names of organization config rules for which you want details. If you do not specify any names, AWS
         * Config returns details for all your organization config rules.
         * </p>
         * 
         * @param organizationConfigRuleNames
         *        The names of organization config rules for which you want details. If you do not specify any names,
         *        AWS Config returns details for all your organization config rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationConfigRuleNames(String... organizationConfigRuleNames);

        /**
         * <p>
         * The maximum number of organization config rules returned on each page. If you do no specify a number, AWS
         * Config uses the default. The default is 100.
         * </p>
         * 
         * @param limit
         *        The maximum number of organization config rules returned on each page. If you do no specify a number,
         *        AWS Config uses the default. The default is 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in
         * a paginated response.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> string returned on a previous page that you use to get the next page of
         *        results in a paginated response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConfigRequest.BuilderImpl implements Builder {
        private List<String> organizationConfigRuleNames = DefaultSdkAutoConstructList.getInstance();

        private Integer limit;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOrganizationConfigRulesRequest model) {
            super(model);
            organizationConfigRuleNames(model.organizationConfigRuleNames);
            limit(model.limit);
            nextToken(model.nextToken);
        }

        public final Collection<String> getOrganizationConfigRuleNames() {
            return organizationConfigRuleNames;
        }

        @Override
        public final Builder organizationConfigRuleNames(Collection<String> organizationConfigRuleNames) {
            this.organizationConfigRuleNames = OrganizationConfigRuleNamesCopier.copy(organizationConfigRuleNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationConfigRuleNames(String... organizationConfigRuleNames) {
            organizationConfigRuleNames(Arrays.asList(organizationConfigRuleNames));
            return this;
        }

        public final void setOrganizationConfigRuleNames(Collection<String> organizationConfigRuleNames) {
            this.organizationConfigRuleNames = OrganizationConfigRuleNamesCopier.copy(organizationConfigRuleNames);
        }

        public final Integer getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeOrganizationConfigRulesRequest build() {
            return new DescribeOrganizationConfigRulesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
