/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteOrganizationConfigRuleRequest extends ConfigRequest implements
        ToCopyableBuilder<DeleteOrganizationConfigRuleRequest.Builder, DeleteOrganizationConfigRuleRequest> {
    private static final SdkField<String> ORGANIZATION_CONFIG_RULE_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteOrganizationConfigRuleRequest::organizationConfigRuleName))
            .setter(setter(Builder::organizationConfigRuleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationConfigRuleName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ORGANIZATION_CONFIG_RULE_NAME_FIELD));

    private final String organizationConfigRuleName;

    private DeleteOrganizationConfigRuleRequest(BuilderImpl builder) {
        super(builder);
        this.organizationConfigRuleName = builder.organizationConfigRuleName;
    }

    /**
     * <p>
     * The name of organization config rule that you want to delete.
     * </p>
     * 
     * @return The name of organization config rule that you want to delete.
     */
    public String organizationConfigRuleName() {
        return organizationConfigRuleName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(organizationConfigRuleName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteOrganizationConfigRuleRequest)) {
            return false;
        }
        DeleteOrganizationConfigRuleRequest other = (DeleteOrganizationConfigRuleRequest) obj;
        return Objects.equals(organizationConfigRuleName(), other.organizationConfigRuleName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteOrganizationConfigRuleRequest")
                .add("OrganizationConfigRuleName", organizationConfigRuleName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrganizationConfigRuleName":
            return Optional.ofNullable(clazz.cast(organizationConfigRuleName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteOrganizationConfigRuleRequest, T> g) {
        return obj -> g.apply((DeleteOrganizationConfigRuleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteOrganizationConfigRuleRequest> {
        /**
         * <p>
         * The name of organization config rule that you want to delete.
         * </p>
         * 
         * @param organizationConfigRuleName
         *        The name of organization config rule that you want to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationConfigRuleName(String organizationConfigRuleName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConfigRequest.BuilderImpl implements Builder {
        private String organizationConfigRuleName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteOrganizationConfigRuleRequest model) {
            super(model);
            organizationConfigRuleName(model.organizationConfigRuleName);
        }

        public final String getOrganizationConfigRuleName() {
            return organizationConfigRuleName;
        }

        @Override
        public final Builder organizationConfigRuleName(String organizationConfigRuleName) {
            this.organizationConfigRuleName = organizationConfigRuleName;
            return this;
        }

        public final void setOrganizationConfigRuleName(String organizationConfigRuleName) {
            this.organizationConfigRuleName = organizationConfigRuleName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteOrganizationConfigRuleRequest build() {
            return new DeleteOrganizationConfigRuleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
