/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the <a>PutDeliveryChannel</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutDeliveryChannelRequest extends ConfigRequest implements
        ToCopyableBuilder<PutDeliveryChannelRequest.Builder, PutDeliveryChannelRequest> {
    private static final SdkField<DeliveryChannel> DELIVERY_CHANNEL_FIELD = SdkField
            .<DeliveryChannel> builder(MarshallingType.SDK_POJO).getter(getter(PutDeliveryChannelRequest::deliveryChannel))
            .setter(setter(Builder::deliveryChannel)).constructor(DeliveryChannel::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryChannel").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELIVERY_CHANNEL_FIELD));

    private final DeliveryChannel deliveryChannel;

    private PutDeliveryChannelRequest(BuilderImpl builder) {
        super(builder);
        this.deliveryChannel = builder.deliveryChannel;
    }

    /**
     * <p>
     * The configuration delivery channel object that delivers the configuration information to an Amazon S3 bucket and
     * to an Amazon SNS topic.
     * </p>
     * 
     * @return The configuration delivery channel object that delivers the configuration information to an Amazon S3
     *         bucket and to an Amazon SNS topic.
     */
    public DeliveryChannel deliveryChannel() {
        return deliveryChannel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deliveryChannel());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutDeliveryChannelRequest)) {
            return false;
        }
        PutDeliveryChannelRequest other = (PutDeliveryChannelRequest) obj;
        return Objects.equals(deliveryChannel(), other.deliveryChannel());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutDeliveryChannelRequest").add("DeliveryChannel", deliveryChannel()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeliveryChannel":
            return Optional.ofNullable(clazz.cast(deliveryChannel()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutDeliveryChannelRequest, T> g) {
        return obj -> g.apply((PutDeliveryChannelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutDeliveryChannelRequest> {
        /**
         * <p>
         * The configuration delivery channel object that delivers the configuration information to an Amazon S3 bucket
         * and to an Amazon SNS topic.
         * </p>
         * 
         * @param deliveryChannel
         *        The configuration delivery channel object that delivers the configuration information to an Amazon S3
         *        bucket and to an Amazon SNS topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryChannel(DeliveryChannel deliveryChannel);

        /**
         * <p>
         * The configuration delivery channel object that delivers the configuration information to an Amazon S3 bucket
         * and to an Amazon SNS topic.
         * </p>
         * This is a convenience that creates an instance of the {@link DeliveryChannel.Builder} avoiding the need to
         * create one manually via {@link DeliveryChannel#builder()}.
         *
         * When the {@link Consumer} completes, {@link DeliveryChannel.Builder#build()} is called immediately and its
         * result is passed to {@link #deliveryChannel(DeliveryChannel)}.
         * 
         * @param deliveryChannel
         *        a consumer that will call methods on {@link DeliveryChannel.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deliveryChannel(DeliveryChannel)
         */
        default Builder deliveryChannel(Consumer<DeliveryChannel.Builder> deliveryChannel) {
            return deliveryChannel(DeliveryChannel.builder().applyMutation(deliveryChannel).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConfigRequest.BuilderImpl implements Builder {
        private DeliveryChannel deliveryChannel;

        private BuilderImpl() {
        }

        private BuilderImpl(PutDeliveryChannelRequest model) {
            super(model);
            deliveryChannel(model.deliveryChannel);
        }

        public final DeliveryChannel.Builder getDeliveryChannel() {
            return deliveryChannel != null ? deliveryChannel.toBuilder() : null;
        }

        @Override
        public final Builder deliveryChannel(DeliveryChannel deliveryChannel) {
            this.deliveryChannel = deliveryChannel;
            return this;
        }

        public final void setDeliveryChannel(DeliveryChannel.BuilderImpl deliveryChannel) {
            this.deliveryChannel = deliveryChannel != null ? deliveryChannel.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutDeliveryChannelRequest build() {
            return new PutDeliveryChannelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
