/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A collection of accounts and regions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccountAggregationSource implements SdkPojo, Serializable,
        ToCopyableBuilder<AccountAggregationSource.Builder, AccountAggregationSource> {
    private static final SdkField<List<String>> ACCOUNT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(AccountAggregationSource::accountIds))
            .setter(setter(Builder::accountIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> ALL_AWS_REGIONS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(AccountAggregationSource::allAwsRegions)).setter(setter(Builder::allAwsRegions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllAwsRegions").build()).build();

    private static final SdkField<List<String>> AWS_REGIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(AccountAggregationSource::awsRegions))
            .setter(setter(Builder::awsRegions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsRegions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_IDS_FIELD,
            ALL_AWS_REGIONS_FIELD, AWS_REGIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> accountIds;

    private final Boolean allAwsRegions;

    private final List<String> awsRegions;

    private AccountAggregationSource(BuilderImpl builder) {
        this.accountIds = builder.accountIds;
        this.allAwsRegions = builder.allAwsRegions;
        this.awsRegions = builder.awsRegions;
    }

    /**
     * <p>
     * The 12-digit account ID of the account being aggregated.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The 12-digit account ID of the account being aggregated.
     */
    public List<String> accountIds() {
        return accountIds;
    }

    /**
     * <p>
     * If true, aggregate existing AWS Config regions and future regions.
     * </p>
     * 
     * @return If true, aggregate existing AWS Config regions and future regions.
     */
    public Boolean allAwsRegions() {
        return allAwsRegions;
    }

    /**
     * <p>
     * The source regions being aggregated.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The source regions being aggregated.
     */
    public List<String> awsRegions() {
        return awsRegions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountIds());
        hashCode = 31 * hashCode + Objects.hashCode(allAwsRegions());
        hashCode = 31 * hashCode + Objects.hashCode(awsRegions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountAggregationSource)) {
            return false;
        }
        AccountAggregationSource other = (AccountAggregationSource) obj;
        return Objects.equals(accountIds(), other.accountIds()) && Objects.equals(allAwsRegions(), other.allAwsRegions())
                && Objects.equals(awsRegions(), other.awsRegions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AccountAggregationSource").add("AccountIds", accountIds()).add("AllAwsRegions", allAwsRegions())
                .add("AwsRegions", awsRegions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountIds":
            return Optional.ofNullable(clazz.cast(accountIds()));
        case "AllAwsRegions":
            return Optional.ofNullable(clazz.cast(allAwsRegions()));
        case "AwsRegions":
            return Optional.ofNullable(clazz.cast(awsRegions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccountAggregationSource, T> g) {
        return obj -> g.apply((AccountAggregationSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccountAggregationSource> {
        /**
         * <p>
         * The 12-digit account ID of the account being aggregated.
         * </p>
         * 
         * @param accountIds
         *        The 12-digit account ID of the account being aggregated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIds(Collection<String> accountIds);

        /**
         * <p>
         * The 12-digit account ID of the account being aggregated.
         * </p>
         * 
         * @param accountIds
         *        The 12-digit account ID of the account being aggregated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIds(String... accountIds);

        /**
         * <p>
         * If true, aggregate existing AWS Config regions and future regions.
         * </p>
         * 
         * @param allAwsRegions
         *        If true, aggregate existing AWS Config regions and future regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allAwsRegions(Boolean allAwsRegions);

        /**
         * <p>
         * The source regions being aggregated.
         * </p>
         * 
         * @param awsRegions
         *        The source regions being aggregated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsRegions(Collection<String> awsRegions);

        /**
         * <p>
         * The source regions being aggregated.
         * </p>
         * 
         * @param awsRegions
         *        The source regions being aggregated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsRegions(String... awsRegions);
    }

    static final class BuilderImpl implements Builder {
        private List<String> accountIds = DefaultSdkAutoConstructList.getInstance();

        private Boolean allAwsRegions;

        private List<String> awsRegions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AccountAggregationSource model) {
            accountIds(model.accountIds);
            allAwsRegions(model.allAwsRegions);
            awsRegions(model.awsRegions);
        }

        public final Collection<String> getAccountIds() {
            return accountIds;
        }

        @Override
        public final Builder accountIds(Collection<String> accountIds) {
            this.accountIds = AccountAggregationSourceAccountListCopier.copy(accountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIds(String... accountIds) {
            accountIds(Arrays.asList(accountIds));
            return this;
        }

        public final void setAccountIds(Collection<String> accountIds) {
            this.accountIds = AccountAggregationSourceAccountListCopier.copy(accountIds);
        }

        public final Boolean getAllAwsRegions() {
            return allAwsRegions;
        }

        @Override
        public final Builder allAwsRegions(Boolean allAwsRegions) {
            this.allAwsRegions = allAwsRegions;
            return this;
        }

        public final void setAllAwsRegions(Boolean allAwsRegions) {
            this.allAwsRegions = allAwsRegions;
        }

        public final Collection<String> getAwsRegions() {
            return awsRegions;
        }

        @Override
        public final Builder awsRegions(Collection<String> awsRegions) {
            this.awsRegions = AggregatorRegionListCopier.copy(awsRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder awsRegions(String... awsRegions) {
            awsRegions(Arrays.asList(awsRegions));
            return this;
        }

        public final void setAwsRegions(Collection<String> awsRegions) {
            this.awsRegions = AggregatorRegionListCopier.copy(awsRegions);
        }

        @Override
        public AccountAggregationSource build() {
            return new AccountAggregationSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
