/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeUserHierarchyGroupResponse extends ConnectResponse implements
        ToCopyableBuilder<DescribeUserHierarchyGroupResponse.Builder, DescribeUserHierarchyGroupResponse> {
    private static final SdkField<HierarchyGroup> HIERARCHY_GROUP_FIELD = SdkField
            .<HierarchyGroup> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeUserHierarchyGroupResponse::hierarchyGroup)).setter(setter(Builder::hierarchyGroup))
            .constructor(HierarchyGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HierarchyGroup").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HIERARCHY_GROUP_FIELD));

    private final HierarchyGroup hierarchyGroup;

    private DescribeUserHierarchyGroupResponse(BuilderImpl builder) {
        super(builder);
        this.hierarchyGroup = builder.hierarchyGroup;
    }

    /**
     * <p>
     * Information about the hierarchy group.
     * </p>
     * 
     * @return Information about the hierarchy group.
     */
    public HierarchyGroup hierarchyGroup() {
        return hierarchyGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hierarchyGroup());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeUserHierarchyGroupResponse)) {
            return false;
        }
        DescribeUserHierarchyGroupResponse other = (DescribeUserHierarchyGroupResponse) obj;
        return Objects.equals(hierarchyGroup(), other.hierarchyGroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeUserHierarchyGroupResponse").add("HierarchyGroup", hierarchyGroup()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HierarchyGroup":
            return Optional.ofNullable(clazz.cast(hierarchyGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeUserHierarchyGroupResponse, T> g) {
        return obj -> g.apply((DescribeUserHierarchyGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeUserHierarchyGroupResponse> {
        /**
         * <p>
         * Information about the hierarchy group.
         * </p>
         * 
         * @param hierarchyGroup
         *        Information about the hierarchy group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hierarchyGroup(HierarchyGroup hierarchyGroup);

        /**
         * <p>
         * Information about the hierarchy group.
         * </p>
         * This is a convenience that creates an instance of the {@link HierarchyGroup.Builder} avoiding the need to
         * create one manually via {@link HierarchyGroup#builder()}.
         *
         * When the {@link Consumer} completes, {@link HierarchyGroup.Builder#build()} is called immediately and its
         * result is passed to {@link #hierarchyGroup(HierarchyGroup)}.
         * 
         * @param hierarchyGroup
         *        a consumer that will call methods on {@link HierarchyGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hierarchyGroup(HierarchyGroup)
         */
        default Builder hierarchyGroup(Consumer<HierarchyGroup.Builder> hierarchyGroup) {
            return hierarchyGroup(HierarchyGroup.builder().applyMutation(hierarchyGroup).build());
        }
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private HierarchyGroup hierarchyGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeUserHierarchyGroupResponse model) {
            super(model);
            hierarchyGroup(model.hierarchyGroup);
        }

        public final HierarchyGroup.Builder getHierarchyGroup() {
            return hierarchyGroup != null ? hierarchyGroup.toBuilder() : null;
        }

        @Override
        public final Builder hierarchyGroup(HierarchyGroup hierarchyGroup) {
            this.hierarchyGroup = hierarchyGroup;
            return this;
        }

        public final void setHierarchyGroup(HierarchyGroup.BuilderImpl hierarchyGroup) {
            this.hierarchyGroup = hierarchyGroup != null ? hierarchyGroup.build() : null;
        }

        @Override
        public DescribeUserHierarchyGroupResponse build() {
            return new DescribeUserHierarchyGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
