/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the filter to apply when retrieving metrics.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Filters implements SdkPojo, Serializable, ToCopyableBuilder<Filters.Builder, Filters> {
    private static final SdkField<List<String>> QUEUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(Filters::queues))
            .setter(setter(Builder::queues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Queues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> CHANNELS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(Filters::channelsAsStrings))
            .setter(setter(Builder::channelsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Channels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUEUES_FIELD, CHANNELS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> queues;

    private final List<String> channels;

    private Filters(BuilderImpl builder) {
        this.queues = builder.queues;
        this.channels = builder.channels;
    }

    /**
     * Returns true if the Queues property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasQueues() {
        return queues != null && !(queues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The queues to use to filter the metrics. You can specify up to 100 queues per request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasQueues()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The queues to use to filter the metrics. You can specify up to 100 queues per request.
     */
    public List<String> queues() {
        return queues;
    }

    /**
     * <p>
     * The channel to use to filter the metrics.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasChannels()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The channel to use to filter the metrics.
     */
    public List<Channel> channels() {
        return ChannelsCopier.copyStringToEnum(channels);
    }

    /**
     * Returns true if the Channels property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasChannels() {
        return channels != null && !(channels instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The channel to use to filter the metrics.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasChannels()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The channel to use to filter the metrics.
     */
    public List<String> channelsAsStrings() {
        return channels;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(queues());
        hashCode = 31 * hashCode + Objects.hashCode(channelsAsStrings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Filters)) {
            return false;
        }
        Filters other = (Filters) obj;
        return Objects.equals(queues(), other.queues()) && Objects.equals(channelsAsStrings(), other.channelsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Filters").add("Queues", queues()).add("Channels", channelsAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Queues":
            return Optional.ofNullable(clazz.cast(queues()));
        case "Channels":
            return Optional.ofNullable(clazz.cast(channelsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Filters, T> g) {
        return obj -> g.apply((Filters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Filters> {
        /**
         * <p>
         * The queues to use to filter the metrics. You can specify up to 100 queues per request.
         * </p>
         * 
         * @param queues
         *        The queues to use to filter the metrics. You can specify up to 100 queues per request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queues(Collection<String> queues);

        /**
         * <p>
         * The queues to use to filter the metrics. You can specify up to 100 queues per request.
         * </p>
         * 
         * @param queues
         *        The queues to use to filter the metrics. You can specify up to 100 queues per request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queues(String... queues);

        /**
         * <p>
         * The channel to use to filter the metrics.
         * </p>
         * 
         * @param channels
         *        The channel to use to filter the metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelsWithStrings(Collection<String> channels);

        /**
         * <p>
         * The channel to use to filter the metrics.
         * </p>
         * 
         * @param channels
         *        The channel to use to filter the metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelsWithStrings(String... channels);

        /**
         * <p>
         * The channel to use to filter the metrics.
         * </p>
         * 
         * @param channels
         *        The channel to use to filter the metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channels(Collection<Channel> channels);

        /**
         * <p>
         * The channel to use to filter the metrics.
         * </p>
         * 
         * @param channels
         *        The channel to use to filter the metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channels(Channel... channels);
    }

    static final class BuilderImpl implements Builder {
        private List<String> queues = DefaultSdkAutoConstructList.getInstance();

        private List<String> channels = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Filters model) {
            queues(model.queues);
            channelsWithStrings(model.channels);
        }

        public final Collection<String> getQueues() {
            return queues;
        }

        @Override
        public final Builder queues(Collection<String> queues) {
            this.queues = QueuesCopier.copy(queues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queues(String... queues) {
            queues(Arrays.asList(queues));
            return this;
        }

        public final void setQueues(Collection<String> queues) {
            this.queues = QueuesCopier.copy(queues);
        }

        public final Collection<String> getChannels() {
            return channels;
        }

        @Override
        public final Builder channelsWithStrings(Collection<String> channels) {
            this.channels = ChannelsCopier.copy(channels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelsWithStrings(String... channels) {
            channelsWithStrings(Arrays.asList(channels));
            return this;
        }

        @Override
        public final Builder channels(Collection<Channel> channels) {
            this.channels = ChannelsCopier.copyEnumToString(channels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channels(Channel... channels) {
            channels(Arrays.asList(channels));
            return this;
        }

        public final void setChannels(Collection<String> channels) {
            this.channels = ChannelsCopier.copy(channels);
        }

        @Override
        public Filters build() {
            return new Filters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
