/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCurrentMetricDataRequest extends ConnectRequest implements
        ToCopyableBuilder<GetCurrentMetricDataRequest.Builder, GetCurrentMetricDataRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetCurrentMetricDataRequest::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final SdkField<Filters> FILTERS_FIELD = SdkField.<Filters> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetCurrentMetricDataRequest::filters)).setter(setter(Builder::filters)).constructor(Filters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build()).build();

    private static final SdkField<List<String>> GROUPINGS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(GetCurrentMetricDataRequest::groupingsAsStrings))
            .setter(setter(Builder::groupingsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Groupings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CurrentMetric>> CURRENT_METRICS_FIELD = SdkField
            .<List<CurrentMetric>> builder(MarshallingType.LIST)
            .getter(getter(GetCurrentMetricDataRequest::currentMetrics))
            .setter(setter(Builder::currentMetrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentMetrics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CurrentMetric> builder(MarshallingType.SDK_POJO)
                                            .constructor(CurrentMetric::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetCurrentMetricDataRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(GetCurrentMetricDataRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            FILTERS_FIELD, GROUPINGS_FIELD, CURRENT_METRICS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final String instanceId;

    private final Filters filters;

    private final List<String> groupings;

    private final List<CurrentMetric> currentMetrics;

    private final String nextToken;

    private final Integer maxResults;

    private GetCurrentMetricDataRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.filters = builder.filters;
        this.groupings = builder.groupings;
        this.currentMetrics = builder.currentMetrics;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The queues, up to 100, or channels, to use to filter the metrics returned. Metric data is retrieved only for the
     * resources associated with the queues or channels included in the filter. You can include both queue IDs and queue
     * ARNs in the same request. The only supported channel is <code>VOICE</code>.
     * </p>
     * 
     * @return The queues, up to 100, or channels, to use to filter the metrics returned. Metric data is retrieved only
     *         for the resources associated with the queues or channels included in the filter. You can include both
     *         queue IDs and queue ARNs in the same request. The only supported channel is <code>VOICE</code>.
     */
    public Filters filters() {
        return filters;
    }

    /**
     * <p>
     * The grouping applied to the metrics returned. For example, when grouped by <code>QUEUE</code>, the metrics
     * returned apply to each queue rather than aggregated for all queues. If you group by <code>CHANNEL</code>, you
     * should include a Channels filter. The only supported channel is <code>VOICE</code>.
     * </p>
     * <p>
     * If no <code>Grouping</code> is included in the request, a summary of metrics is returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasGroupings()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The grouping applied to the metrics returned. For example, when grouped by <code>QUEUE</code>, the
     *         metrics returned apply to each queue rather than aggregated for all queues. If you group by
     *         <code>CHANNEL</code>, you should include a Channels filter. The only supported channel is
     *         <code>VOICE</code>.</p>
     *         <p>
     *         If no <code>Grouping</code> is included in the request, a summary of metrics is returned.
     */
    public List<Grouping> groupings() {
        return GroupingsCopier.copyStringToEnum(groupings);
    }

    /**
     * Returns true if the Groupings property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasGroupings() {
        return groupings != null && !(groupings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The grouping applied to the metrics returned. For example, when grouped by <code>QUEUE</code>, the metrics
     * returned apply to each queue rather than aggregated for all queues. If you group by <code>CHANNEL</code>, you
     * should include a Channels filter. The only supported channel is <code>VOICE</code>.
     * </p>
     * <p>
     * If no <code>Grouping</code> is included in the request, a summary of metrics is returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasGroupings()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The grouping applied to the metrics returned. For example, when grouped by <code>QUEUE</code>, the
     *         metrics returned apply to each queue rather than aggregated for all queues. If you group by
     *         <code>CHANNEL</code>, you should include a Channels filter. The only supported channel is
     *         <code>VOICE</code>.</p>
     *         <p>
     *         If no <code>Grouping</code> is included in the request, a summary of metrics is returned.
     */
    public List<String> groupingsAsStrings() {
        return groupings;
    }

    /**
     * Returns true if the CurrentMetrics property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasCurrentMetrics() {
        return currentMetrics != null && !(currentMetrics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The metrics to retrieve. Specify the name and unit for each metric. The following metrics are available. For a
     * description of each metric, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html">Real-time Metrics
     * Definitions</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <dl>
     * <dt>AGENTS_AFTER_CONTACT_WORK</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * </dd>
     * <dt>AGENTS_AVAILABLE</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * </dd>
     * <dt>AGENTS_ERROR</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * </dd>
     * <dt>AGENTS_NON_PRODUCTIVE</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * </dd>
     * <dt>AGENTS_ON_CALL</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * </dd>
     * <dt>AGENTS_ON_CONTACT</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * </dd>
     * <dt>AGENTS_ONLINE</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * </dd>
     * <dt>AGENTS_STAFFED</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * </dd>
     * <dt>CONTACTS_IN_QUEUE</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * </dd>
     * <dt>CONTACTS_SCHEDULED</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * </dd>
     * <dt>OLDEST_CONTACT_AGE</dt>
     * <dd>
     * <p>
     * Unit: SECONDS
     * </p>
     * </dd>
     * <dt>SLOTS_ACTIVE</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * </dd>
     * <dt>SLOTS_AVAILABLE</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * </dd>
     * </dl>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCurrentMetrics()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The metrics to retrieve. Specify the name and unit for each metric. The following metrics are available.
     *         For a description of each metric, see <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html">Real-time
     *         Metrics Definitions</a> in the <i>Amazon Connect Administrator Guide</i>.</p>
     *         <dl>
     *         <dt>AGENTS_AFTER_CONTACT_WORK</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         </dd>
     *         <dt>AGENTS_AVAILABLE</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         </dd>
     *         <dt>AGENTS_ERROR</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         </dd>
     *         <dt>AGENTS_NON_PRODUCTIVE</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         </dd>
     *         <dt>AGENTS_ON_CALL</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         </dd>
     *         <dt>AGENTS_ON_CONTACT</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         </dd>
     *         <dt>AGENTS_ONLINE</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         </dd>
     *         <dt>AGENTS_STAFFED</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_IN_QUEUE</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_SCHEDULED</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         </dd>
     *         <dt>OLDEST_CONTACT_AGE</dt>
     *         <dd>
     *         <p>
     *         Unit: SECONDS
     *         </p>
     *         </dd>
     *         <dt>SLOTS_ACTIVE</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         </dd>
     *         <dt>SLOTS_AVAILABLE</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         </dd>
     */
    public List<CurrentMetric> currentMetrics() {
        return currentMetrics;
    }

    /**
     * <p>
     * The token for the next set of results. Use the value returned in the previous response in the next request to
     * retrieve the next set of results.
     * </p>
     * <p>
     * The token expires after 5 minutes from the time it is created. Subsequent requests that use the token must use
     * the same request parameters as the request that generated the token.
     * </p>
     * 
     * @return The token for the next set of results. Use the value returned in the previous response in the next
     *         request to retrieve the next set of results.</p>
     *         <p>
     *         The token expires after 5 minutes from the time it is created. Subsequent requests that use the token
     *         must use the same request parameters as the request that generated the token.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximimum number of results to return per page.
     * </p>
     * 
     * @return The maximimum number of results to return per page.
     */
    public Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(groupingsAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(currentMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCurrentMetricDataRequest)) {
            return false;
        }
        GetCurrentMetricDataRequest other = (GetCurrentMetricDataRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(filters(), other.filters())
                && Objects.equals(groupingsAsStrings(), other.groupingsAsStrings())
                && Objects.equals(currentMetrics(), other.currentMetrics()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetCurrentMetricDataRequest").add("InstanceId", instanceId()).add("Filters", filters())
                .add("Groupings", groupingsAsStrings()).add("CurrentMetrics", currentMetrics()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "Groupings":
            return Optional.ofNullable(clazz.cast(groupingsAsStrings()));
        case "CurrentMetrics":
            return Optional.ofNullable(clazz.cast(currentMetrics()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCurrentMetricDataRequest, T> g) {
        return obj -> g.apply((GetCurrentMetricDataRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetCurrentMetricDataRequest> {
        /**
         * <p>
         * The identifier of the Amazon Connect instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The queues, up to 100, or channels, to use to filter the metrics returned. Metric data is retrieved only for
         * the resources associated with the queues or channels included in the filter. You can include both queue IDs
         * and queue ARNs in the same request. The only supported channel is <code>VOICE</code>.
         * </p>
         * 
         * @param filters
         *        The queues, up to 100, or channels, to use to filter the metrics returned. Metric data is retrieved
         *        only for the resources associated with the queues or channels included in the filter. You can include
         *        both queue IDs and queue ARNs in the same request. The only supported channel is <code>VOICE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filters filters);

        /**
         * <p>
         * The queues, up to 100, or channels, to use to filter the metrics returned. Metric data is retrieved only for
         * the resources associated with the queues or channels included in the filter. You can include both queue IDs
         * and queue ARNs in the same request. The only supported channel is <code>VOICE</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link Filters.Builder} avoiding the need to create one
         * manually via {@link Filters#builder()}.
         *
         * When the {@link Consumer} completes, {@link Filters.Builder#build()} is called immediately and its result is
         * passed to {@link #filters(Filters)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link Filters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(Filters)
         */
        default Builder filters(Consumer<Filters.Builder> filters) {
            return filters(Filters.builder().applyMutation(filters).build());
        }

        /**
         * <p>
         * The grouping applied to the metrics returned. For example, when grouped by <code>QUEUE</code>, the metrics
         * returned apply to each queue rather than aggregated for all queues. If you group by <code>CHANNEL</code>, you
         * should include a Channels filter. The only supported channel is <code>VOICE</code>.
         * </p>
         * <p>
         * If no <code>Grouping</code> is included in the request, a summary of metrics is returned.
         * </p>
         * 
         * @param groupings
         *        The grouping applied to the metrics returned. For example, when grouped by <code>QUEUE</code>, the
         *        metrics returned apply to each queue rather than aggregated for all queues. If you group by
         *        <code>CHANNEL</code>, you should include a Channels filter. The only supported channel is
         *        <code>VOICE</code>.</p>
         *        <p>
         *        If no <code>Grouping</code> is included in the request, a summary of metrics is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupingsWithStrings(Collection<String> groupings);

        /**
         * <p>
         * The grouping applied to the metrics returned. For example, when grouped by <code>QUEUE</code>, the metrics
         * returned apply to each queue rather than aggregated for all queues. If you group by <code>CHANNEL</code>, you
         * should include a Channels filter. The only supported channel is <code>VOICE</code>.
         * </p>
         * <p>
         * If no <code>Grouping</code> is included in the request, a summary of metrics is returned.
         * </p>
         * 
         * @param groupings
         *        The grouping applied to the metrics returned. For example, when grouped by <code>QUEUE</code>, the
         *        metrics returned apply to each queue rather than aggregated for all queues. If you group by
         *        <code>CHANNEL</code>, you should include a Channels filter. The only supported channel is
         *        <code>VOICE</code>.</p>
         *        <p>
         *        If no <code>Grouping</code> is included in the request, a summary of metrics is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupingsWithStrings(String... groupings);

        /**
         * <p>
         * The grouping applied to the metrics returned. For example, when grouped by <code>QUEUE</code>, the metrics
         * returned apply to each queue rather than aggregated for all queues. If you group by <code>CHANNEL</code>, you
         * should include a Channels filter. The only supported channel is <code>VOICE</code>.
         * </p>
         * <p>
         * If no <code>Grouping</code> is included in the request, a summary of metrics is returned.
         * </p>
         * 
         * @param groupings
         *        The grouping applied to the metrics returned. For example, when grouped by <code>QUEUE</code>, the
         *        metrics returned apply to each queue rather than aggregated for all queues. If you group by
         *        <code>CHANNEL</code>, you should include a Channels filter. The only supported channel is
         *        <code>VOICE</code>.</p>
         *        <p>
         *        If no <code>Grouping</code> is included in the request, a summary of metrics is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupings(Collection<Grouping> groupings);

        /**
         * <p>
         * The grouping applied to the metrics returned. For example, when grouped by <code>QUEUE</code>, the metrics
         * returned apply to each queue rather than aggregated for all queues. If you group by <code>CHANNEL</code>, you
         * should include a Channels filter. The only supported channel is <code>VOICE</code>.
         * </p>
         * <p>
         * If no <code>Grouping</code> is included in the request, a summary of metrics is returned.
         * </p>
         * 
         * @param groupings
         *        The grouping applied to the metrics returned. For example, when grouped by <code>QUEUE</code>, the
         *        metrics returned apply to each queue rather than aggregated for all queues. If you group by
         *        <code>CHANNEL</code>, you should include a Channels filter. The only supported channel is
         *        <code>VOICE</code>.</p>
         *        <p>
         *        If no <code>Grouping</code> is included in the request, a summary of metrics is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupings(Grouping... groupings);

        /**
         * <p>
         * The metrics to retrieve. Specify the name and unit for each metric. The following metrics are available. For
         * a description of each metric, see <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html">Real-time
         * Metrics Definitions</a> in the <i>Amazon Connect Administrator Guide</i>.
         * </p>
         * <dl>
         * <dt>AGENTS_AFTER_CONTACT_WORK</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * </dd>
         * <dt>AGENTS_AVAILABLE</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * </dd>
         * <dt>AGENTS_ERROR</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * </dd>
         * <dt>AGENTS_NON_PRODUCTIVE</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * </dd>
         * <dt>AGENTS_ON_CALL</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * </dd>
         * <dt>AGENTS_ON_CONTACT</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * </dd>
         * <dt>AGENTS_ONLINE</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * </dd>
         * <dt>AGENTS_STAFFED</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * </dd>
         * <dt>CONTACTS_IN_QUEUE</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * </dd>
         * <dt>CONTACTS_SCHEDULED</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * </dd>
         * <dt>OLDEST_CONTACT_AGE</dt>
         * <dd>
         * <p>
         * Unit: SECONDS
         * </p>
         * </dd>
         * <dt>SLOTS_ACTIVE</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * </dd>
         * <dt>SLOTS_AVAILABLE</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * </dd>
         * </dl>
         * 
         * @param currentMetrics
         *        The metrics to retrieve. Specify the name and unit for each metric. The following metrics are
         *        available. For a description of each metric, see <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html"
         *        >Real-time Metrics Definitions</a> in the <i>Amazon Connect Administrator Guide</i>.</p>
         *        <dl>
         *        <dt>AGENTS_AFTER_CONTACT_WORK</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        </dd>
         *        <dt>AGENTS_AVAILABLE</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        </dd>
         *        <dt>AGENTS_ERROR</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        </dd>
         *        <dt>AGENTS_NON_PRODUCTIVE</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        </dd>
         *        <dt>AGENTS_ON_CALL</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        </dd>
         *        <dt>AGENTS_ON_CONTACT</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        </dd>
         *        <dt>AGENTS_ONLINE</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        </dd>
         *        <dt>AGENTS_STAFFED</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_IN_QUEUE</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_SCHEDULED</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        </dd>
         *        <dt>OLDEST_CONTACT_AGE</dt>
         *        <dd>
         *        <p>
         *        Unit: SECONDS
         *        </p>
         *        </dd>
         *        <dt>SLOTS_ACTIVE</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        </dd>
         *        <dt>SLOTS_AVAILABLE</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        </dd>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentMetrics(Collection<CurrentMetric> currentMetrics);

        /**
         * <p>
         * The metrics to retrieve. Specify the name and unit for each metric. The following metrics are available. For
         * a description of each metric, see <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html">Real-time
         * Metrics Definitions</a> in the <i>Amazon Connect Administrator Guide</i>.
         * </p>
         * <dl>
         * <dt>AGENTS_AFTER_CONTACT_WORK</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * </dd>
         * <dt>AGENTS_AVAILABLE</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * </dd>
         * <dt>AGENTS_ERROR</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * </dd>
         * <dt>AGENTS_NON_PRODUCTIVE</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * </dd>
         * <dt>AGENTS_ON_CALL</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * </dd>
         * <dt>AGENTS_ON_CONTACT</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * </dd>
         * <dt>AGENTS_ONLINE</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * </dd>
         * <dt>AGENTS_STAFFED</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * </dd>
         * <dt>CONTACTS_IN_QUEUE</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * </dd>
         * <dt>CONTACTS_SCHEDULED</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * </dd>
         * <dt>OLDEST_CONTACT_AGE</dt>
         * <dd>
         * <p>
         * Unit: SECONDS
         * </p>
         * </dd>
         * <dt>SLOTS_ACTIVE</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * </dd>
         * <dt>SLOTS_AVAILABLE</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * </dd>
         * </dl>
         * 
         * @param currentMetrics
         *        The metrics to retrieve. Specify the name and unit for each metric. The following metrics are
         *        available. For a description of each metric, see <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html"
         *        >Real-time Metrics Definitions</a> in the <i>Amazon Connect Administrator Guide</i>.</p>
         *        <dl>
         *        <dt>AGENTS_AFTER_CONTACT_WORK</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        </dd>
         *        <dt>AGENTS_AVAILABLE</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        </dd>
         *        <dt>AGENTS_ERROR</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        </dd>
         *        <dt>AGENTS_NON_PRODUCTIVE</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        </dd>
         *        <dt>AGENTS_ON_CALL</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        </dd>
         *        <dt>AGENTS_ON_CONTACT</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        </dd>
         *        <dt>AGENTS_ONLINE</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        </dd>
         *        <dt>AGENTS_STAFFED</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_IN_QUEUE</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_SCHEDULED</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        </dd>
         *        <dt>OLDEST_CONTACT_AGE</dt>
         *        <dd>
         *        <p>
         *        Unit: SECONDS
         *        </p>
         *        </dd>
         *        <dt>SLOTS_ACTIVE</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        </dd>
         *        <dt>SLOTS_AVAILABLE</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        </dd>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentMetrics(CurrentMetric... currentMetrics);

        /**
         * <p>
         * The metrics to retrieve. Specify the name and unit for each metric. The following metrics are available. For
         * a description of each metric, see <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html">Real-time
         * Metrics Definitions</a> in the <i>Amazon Connect Administrator Guide</i>.
         * </p>
         * <dl>
         * <dt>AGENTS_AFTER_CONTACT_WORK</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * </dd>
         * <dt>AGENTS_AVAILABLE</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * </dd>
         * <dt>AGENTS_ERROR</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * </dd>
         * <dt>AGENTS_NON_PRODUCTIVE</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * </dd>
         * <dt>AGENTS_ON_CALL</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * </dd>
         * <dt>AGENTS_ON_CONTACT</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * </dd>
         * <dt>AGENTS_ONLINE</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * </dd>
         * <dt>AGENTS_STAFFED</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * </dd>
         * <dt>CONTACTS_IN_QUEUE</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * </dd>
         * <dt>CONTACTS_SCHEDULED</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * </dd>
         * <dt>OLDEST_CONTACT_AGE</dt>
         * <dd>
         * <p>
         * Unit: SECONDS
         * </p>
         * </dd>
         * <dt>SLOTS_ACTIVE</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * </dd>
         * <dt>SLOTS_AVAILABLE</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * </dd>
         * </dl>
         * This is a convenience that creates an instance of the {@link List<CurrentMetric>.Builder} avoiding the need
         * to create one manually via {@link List<CurrentMetric>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CurrentMetric>.Builder#build()} is called immediately and
         * its result is passed to {@link #currentMetrics(List<CurrentMetric>)}.
         * 
         * @param currentMetrics
         *        a consumer that will call methods on {@link List<CurrentMetric>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #currentMetrics(List<CurrentMetric>)
         */
        Builder currentMetrics(Consumer<CurrentMetric.Builder>... currentMetrics);

        /**
         * <p>
         * The token for the next set of results. Use the value returned in the previous response in the next request to
         * retrieve the next set of results.
         * </p>
         * <p>
         * The token expires after 5 minutes from the time it is created. Subsequent requests that use the token must
         * use the same request parameters as the request that generated the token.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results. Use the value returned in the previous response in the next
         *        request to retrieve the next set of results.</p>
         *        <p>
         *        The token expires after 5 minutes from the time it is created. Subsequent requests that use the token
         *        must use the same request parameters as the request that generated the token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximimum number of results to return per page.
         * </p>
         * 
         * @param maxResults
         *        The maximimum number of results to return per page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private Filters filters;

        private List<String> groupings = DefaultSdkAutoConstructList.getInstance();

        private List<CurrentMetric> currentMetrics = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCurrentMetricDataRequest model) {
            super(model);
            instanceId(model.instanceId);
            filters(model.filters);
            groupingsWithStrings(model.groupings);
            currentMetrics(model.currentMetrics);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final Filters.Builder getFilters() {
            return filters != null ? filters.toBuilder() : null;
        }

        @Override
        public final Builder filters(Filters filters) {
            this.filters = filters;
            return this;
        }

        public final void setFilters(Filters.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        public final Collection<String> getGroupings() {
            return groupings;
        }

        @Override
        public final Builder groupingsWithStrings(Collection<String> groupings) {
            this.groupings = GroupingsCopier.copy(groupings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupingsWithStrings(String... groupings) {
            groupingsWithStrings(Arrays.asList(groupings));
            return this;
        }

        @Override
        public final Builder groupings(Collection<Grouping> groupings) {
            this.groupings = GroupingsCopier.copyEnumToString(groupings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupings(Grouping... groupings) {
            groupings(Arrays.asList(groupings));
            return this;
        }

        public final void setGroupings(Collection<String> groupings) {
            this.groupings = GroupingsCopier.copy(groupings);
        }

        public final Collection<CurrentMetric.Builder> getCurrentMetrics() {
            return currentMetrics != null ? currentMetrics.stream().map(CurrentMetric::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder currentMetrics(Collection<CurrentMetric> currentMetrics) {
            this.currentMetrics = CurrentMetricsCopier.copy(currentMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder currentMetrics(CurrentMetric... currentMetrics) {
            currentMetrics(Arrays.asList(currentMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder currentMetrics(Consumer<CurrentMetric.Builder>... currentMetrics) {
            currentMetrics(Stream.of(currentMetrics).map(c -> CurrentMetric.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setCurrentMetrics(Collection<CurrentMetric.BuilderImpl> currentMetrics) {
            this.currentMetrics = CurrentMetricsCopier.copyFromBuilder(currentMetrics);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetCurrentMetricDataRequest build() {
            return new GetCurrentMetricDataRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
