/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a historical metric. For a description of each metric, see <a
 * href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html">Historical Metrics
 * Definitions</a> in the <i>Amazon Connect Administrator Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HistoricalMetric implements SdkPojo, Serializable,
        ToCopyableBuilder<HistoricalMetric.Builder, HistoricalMetric> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HistoricalMetric::nameAsString)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Threshold> THRESHOLD_FIELD = SdkField.<Threshold> builder(MarshallingType.SDK_POJO)
            .getter(getter(HistoricalMetric::threshold)).setter(setter(Builder::threshold)).constructor(Threshold::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Threshold").build()).build();

    private static final SdkField<String> STATISTIC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HistoricalMetric::statisticAsString)).setter(setter(Builder::statistic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Statistic").build()).build();

    private static final SdkField<String> UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HistoricalMetric::unitAsString)).setter(setter(Builder::unit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, THRESHOLD_FIELD,
            STATISTIC_FIELD, UNIT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final Threshold threshold;

    private final String statistic;

    private final String unit;

    private HistoricalMetric(BuilderImpl builder) {
        this.name = builder.name;
        this.threshold = builder.threshold;
        this.statistic = builder.statistic;
        this.unit = builder.unit;
    }

    /**
     * <p>
     * The name of the metric.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link HistoricalMetricName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The name of the metric.
     * @see HistoricalMetricName
     */
    public HistoricalMetricName name() {
        return HistoricalMetricName.fromValue(name);
    }

    /**
     * <p>
     * The name of the metric.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link HistoricalMetricName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The name of the metric.
     * @see HistoricalMetricName
     */
    public String nameAsString() {
        return name;
    }

    /**
     * <p>
     * The threshold for the metric, used with service level metrics.
     * </p>
     * 
     * @return The threshold for the metric, used with service level metrics.
     */
    public Threshold threshold() {
        return threshold;
    }

    /**
     * <p>
     * The statistic for the metric.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statistic} will
     * return {@link Statistic#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statisticAsString}.
     * </p>
     * 
     * @return The statistic for the metric.
     * @see Statistic
     */
    public Statistic statistic() {
        return Statistic.fromValue(statistic);
    }

    /**
     * <p>
     * The statistic for the metric.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statistic} will
     * return {@link Statistic#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statisticAsString}.
     * </p>
     * 
     * @return The statistic for the metric.
     * @see Statistic
     */
    public String statisticAsString() {
        return statistic;
    }

    /**
     * <p>
     * The unit for the metric.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unit} will return
     * {@link Unit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unitAsString}.
     * </p>
     * 
     * @return The unit for the metric.
     * @see Unit
     */
    public Unit unit() {
        return Unit.fromValue(unit);
    }

    /**
     * <p>
     * The unit for the metric.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unit} will return
     * {@link Unit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unitAsString}.
     * </p>
     * 
     * @return The unit for the metric.
     * @see Unit
     */
    public String unitAsString() {
        return unit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(threshold());
        hashCode = 31 * hashCode + Objects.hashCode(statisticAsString());
        hashCode = 31 * hashCode + Objects.hashCode(unitAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HistoricalMetric)) {
            return false;
        }
        HistoricalMetric other = (HistoricalMetric) obj;
        return Objects.equals(nameAsString(), other.nameAsString()) && Objects.equals(threshold(), other.threshold())
                && Objects.equals(statisticAsString(), other.statisticAsString())
                && Objects.equals(unitAsString(), other.unitAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("HistoricalMetric").add("Name", nameAsString()).add("Threshold", threshold())
                .add("Statistic", statisticAsString()).add("Unit", unitAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(nameAsString()));
        case "Threshold":
            return Optional.ofNullable(clazz.cast(threshold()));
        case "Statistic":
            return Optional.ofNullable(clazz.cast(statisticAsString()));
        case "Unit":
            return Optional.ofNullable(clazz.cast(unitAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HistoricalMetric, T> g) {
        return obj -> g.apply((HistoricalMetric) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HistoricalMetric> {
        /**
         * <p>
         * The name of the metric.
         * </p>
         * 
         * @param name
         *        The name of the metric.
         * @see HistoricalMetricName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HistoricalMetricName
         */
        Builder name(String name);

        /**
         * <p>
         * The name of the metric.
         * </p>
         * 
         * @param name
         *        The name of the metric.
         * @see HistoricalMetricName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HistoricalMetricName
         */
        Builder name(HistoricalMetricName name);

        /**
         * <p>
         * The threshold for the metric, used with service level metrics.
         * </p>
         * 
         * @param threshold
         *        The threshold for the metric, used with service level metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder threshold(Threshold threshold);

        /**
         * <p>
         * The threshold for the metric, used with service level metrics.
         * </p>
         * This is a convenience that creates an instance of the {@link Threshold.Builder} avoiding the need to create
         * one manually via {@link Threshold#builder()}.
         *
         * When the {@link Consumer} completes, {@link Threshold.Builder#build()} is called immediately and its result
         * is passed to {@link #threshold(Threshold)}.
         * 
         * @param threshold
         *        a consumer that will call methods on {@link Threshold.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #threshold(Threshold)
         */
        default Builder threshold(Consumer<Threshold.Builder> threshold) {
            return threshold(Threshold.builder().applyMutation(threshold).build());
        }

        /**
         * <p>
         * The statistic for the metric.
         * </p>
         * 
         * @param statistic
         *        The statistic for the metric.
         * @see Statistic
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Statistic
         */
        Builder statistic(String statistic);

        /**
         * <p>
         * The statistic for the metric.
         * </p>
         * 
         * @param statistic
         *        The statistic for the metric.
         * @see Statistic
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Statistic
         */
        Builder statistic(Statistic statistic);

        /**
         * <p>
         * The unit for the metric.
         * </p>
         * 
         * @param unit
         *        The unit for the metric.
         * @see Unit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Unit
         */
        Builder unit(String unit);

        /**
         * <p>
         * The unit for the metric.
         * </p>
         * 
         * @param unit
         *        The unit for the metric.
         * @see Unit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Unit
         */
        Builder unit(Unit unit);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private Threshold threshold;

        private String statistic;

        private String unit;

        private BuilderImpl() {
        }

        private BuilderImpl(HistoricalMetric model) {
            name(model.name);
            threshold(model.threshold);
            statistic(model.statistic);
            unit(model.unit);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(HistoricalMetricName name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Threshold.Builder getThreshold() {
            return threshold != null ? threshold.toBuilder() : null;
        }

        @Override
        public final Builder threshold(Threshold threshold) {
            this.threshold = threshold;
            return this;
        }

        public final void setThreshold(Threshold.BuilderImpl threshold) {
            this.threshold = threshold != null ? threshold.build() : null;
        }

        public final String getStatistic() {
            return statistic;
        }

        @Override
        public final Builder statistic(String statistic) {
            this.statistic = statistic;
            return this;
        }

        @Override
        public final Builder statistic(Statistic statistic) {
            this.statistic(statistic == null ? null : statistic.toString());
            return this;
        }

        public final void setStatistic(String statistic) {
            this.statistic = statistic;
        }

        public final String getUnit() {
            return unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(Unit unit) {
            this.unit(unit == null ? null : unit.toString());
            return this;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public HistoricalMetric build() {
            return new HistoricalMetric(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
