/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains summary information about a contact flow.
 * </p>
 * <p>
 * You can also create and update contact flows using the <a
 * href="https://docs.aws.amazon.com/connect/latest/adminguide/flow-language.html">Amazon Connect Flow language</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContactFlowSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ContactFlowSummary.Builder, ContactFlowSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(ContactFlowSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(ContactFlowSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ContactFlowSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> CONTACT_FLOW_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactFlowType").getter(getter(ContactFlowSummary::contactFlowTypeAsString))
            .setter(setter(Builder::contactFlowType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactFlowType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            NAME_FIELD, CONTACT_FLOW_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String arn;

    private final String name;

    private final String contactFlowType;

    private ContactFlowSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.name = builder.name;
        this.contactFlowType = builder.contactFlowType;
    }

    /**
     * <p>
     * The identifier of the contact flow.
     * </p>
     * 
     * @return The identifier of the contact flow.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the contact flow.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the contact flow.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the contact flow.
     * </p>
     * 
     * @return The name of the contact flow.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The type of contact flow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #contactFlowType}
     * will return {@link ContactFlowType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #contactFlowTypeAsString}.
     * </p>
     * 
     * @return The type of contact flow.
     * @see ContactFlowType
     */
    public ContactFlowType contactFlowType() {
        return ContactFlowType.fromValue(contactFlowType);
    }

    /**
     * <p>
     * The type of contact flow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #contactFlowType}
     * will return {@link ContactFlowType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #contactFlowTypeAsString}.
     * </p>
     * 
     * @return The type of contact flow.
     * @see ContactFlowType
     */
    public String contactFlowTypeAsString() {
        return contactFlowType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(contactFlowTypeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContactFlowSummary)) {
            return false;
        }
        ContactFlowSummary other = (ContactFlowSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(contactFlowTypeAsString(), other.contactFlowTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ContactFlowSummary").add("Id", id()).add("Arn", arn()).add("Name", name())
                .add("ContactFlowType", contactFlowTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ContactFlowType":
            return Optional.ofNullable(clazz.cast(contactFlowTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContactFlowSummary, T> g) {
        return obj -> g.apply((ContactFlowSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContactFlowSummary> {
        /**
         * <p>
         * The identifier of the contact flow.
         * </p>
         * 
         * @param id
         *        The identifier of the contact flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the contact flow.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the contact flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the contact flow.
         * </p>
         * 
         * @param name
         *        The name of the contact flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of contact flow.
         * </p>
         * 
         * @param contactFlowType
         *        The type of contact flow.
         * @see ContactFlowType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactFlowType
         */
        Builder contactFlowType(String contactFlowType);

        /**
         * <p>
         * The type of contact flow.
         * </p>
         * 
         * @param contactFlowType
         *        The type of contact flow.
         * @see ContactFlowType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactFlowType
         */
        Builder contactFlowType(ContactFlowType contactFlowType);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String name;

        private String contactFlowType;

        private BuilderImpl() {
        }

        private BuilderImpl(ContactFlowSummary model) {
            id(model.id);
            arn(model.arn);
            name(model.name);
            contactFlowType(model.contactFlowType);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getContactFlowType() {
            return contactFlowType;
        }

        @Override
        public final Builder contactFlowType(String contactFlowType) {
            this.contactFlowType = contactFlowType;
            return this;
        }

        @Override
        public final Builder contactFlowType(ContactFlowType contactFlowType) {
            this.contactFlowType(contactFlowType == null ? null : contactFlowType.toString());
            return this;
        }

        public final void setContactFlowType(String contactFlowType) {
            this.contactFlowType = contactFlowType;
        }

        @Override
        public ContactFlowSummary build() {
            return new ContactFlowSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
