/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateInstanceRequest extends ConnectRequest implements
        ToCopyableBuilder<CreateInstanceRequest.Builder, CreateInstanceRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientToken").getter(getter(CreateInstanceRequest::clientToken)).setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()).build();

    private static final SdkField<String> IDENTITY_MANAGEMENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentityManagementType").getter(getter(CreateInstanceRequest::identityManagementTypeAsString))
            .setter(setter(Builder::identityManagementType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityManagementType").build())
            .build();

    private static final SdkField<String> INSTANCE_ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceAlias").getter(getter(CreateInstanceRequest::instanceAlias))
            .setter(setter(Builder::instanceAlias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceAlias").build()).build();

    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryId").getter(getter(CreateInstanceRequest::directoryId)).setter(setter(Builder::directoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()).build();

    private static final SdkField<Boolean> INBOUND_CALLS_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("InboundCallsEnabled").getter(getter(CreateInstanceRequest::inboundCallsEnabled))
            .setter(setter(Builder::inboundCallsEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InboundCallsEnabled").build())
            .build();

    private static final SdkField<Boolean> OUTBOUND_CALLS_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("OutboundCallsEnabled").getter(getter(CreateInstanceRequest::outboundCallsEnabled))
            .setter(setter(Builder::outboundCallsEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutboundCallsEnabled").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            IDENTITY_MANAGEMENT_TYPE_FIELD, INSTANCE_ALIAS_FIELD, DIRECTORY_ID_FIELD, INBOUND_CALLS_ENABLED_FIELD,
            OUTBOUND_CALLS_ENABLED_FIELD));

    private final String clientToken;

    private final String identityManagementType;

    private final String instanceAlias;

    private final String directoryId;

    private final Boolean inboundCallsEnabled;

    private final Boolean outboundCallsEnabled;

    private CreateInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.identityManagementType = builder.identityManagementType;
        this.instanceAlias = builder.instanceAlias;
        this.directoryId = builder.directoryId;
        this.inboundCallsEnabled = builder.inboundCallsEnabled;
        this.outboundCallsEnabled = builder.outboundCallsEnabled;
    }

    /**
     * <p>
     * The idempotency token.
     * </p>
     * 
     * @return The idempotency token.
     */
    public String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The type of identity management for your Amazon Connect users.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #identityManagementType} will return {@link DirectoryType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #identityManagementTypeAsString}.
     * </p>
     * 
     * @return The type of identity management for your Amazon Connect users.
     * @see DirectoryType
     */
    public DirectoryType identityManagementType() {
        return DirectoryType.fromValue(identityManagementType);
    }

    /**
     * <p>
     * The type of identity management for your Amazon Connect users.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #identityManagementType} will return {@link DirectoryType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #identityManagementTypeAsString}.
     * </p>
     * 
     * @return The type of identity management for your Amazon Connect users.
     * @see DirectoryType
     */
    public String identityManagementTypeAsString() {
        return identityManagementType;
    }

    /**
     * <p>
     * The name for your instance.
     * </p>
     * 
     * @return The name for your instance.
     */
    public String instanceAlias() {
        return instanceAlias;
    }

    /**
     * <p>
     * The identifier for the directory.
     * </p>
     * 
     * @return The identifier for the directory.
     */
    public String directoryId() {
        return directoryId;
    }

    /**
     * <p>
     * Whether your contact center handles incoming contacts.
     * </p>
     * 
     * @return Whether your contact center handles incoming contacts.
     */
    public Boolean inboundCallsEnabled() {
        return inboundCallsEnabled;
    }

    /**
     * <p>
     * Whether your contact center allows outbound calls.
     * </p>
     * 
     * @return Whether your contact center allows outbound calls.
     */
    public Boolean outboundCallsEnabled() {
        return outboundCallsEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(identityManagementTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(instanceAlias());
        hashCode = 31 * hashCode + Objects.hashCode(directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(inboundCallsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(outboundCallsEnabled());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInstanceRequest)) {
            return false;
        }
        CreateInstanceRequest other = (CreateInstanceRequest) obj;
        return Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(identityManagementTypeAsString(), other.identityManagementTypeAsString())
                && Objects.equals(instanceAlias(), other.instanceAlias()) && Objects.equals(directoryId(), other.directoryId())
                && Objects.equals(inboundCallsEnabled(), other.inboundCallsEnabled())
                && Objects.equals(outboundCallsEnabled(), other.outboundCallsEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateInstanceRequest").add("ClientToken", clientToken())
                .add("IdentityManagementType", identityManagementTypeAsString())
                .add("InstanceAlias", instanceAlias() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DirectoryId", directoryId()).add("InboundCallsEnabled", inboundCallsEnabled())
                .add("OutboundCallsEnabled", outboundCallsEnabled()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "IdentityManagementType":
            return Optional.ofNullable(clazz.cast(identityManagementTypeAsString()));
        case "InstanceAlias":
            return Optional.ofNullable(clazz.cast(instanceAlias()));
        case "DirectoryId":
            return Optional.ofNullable(clazz.cast(directoryId()));
        case "InboundCallsEnabled":
            return Optional.ofNullable(clazz.cast(inboundCallsEnabled()));
        case "OutboundCallsEnabled":
            return Optional.ofNullable(clazz.cast(outboundCallsEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateInstanceRequest, T> g) {
        return obj -> g.apply((CreateInstanceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateInstanceRequest> {
        /**
         * <p>
         * The idempotency token.
         * </p>
         * 
         * @param clientToken
         *        The idempotency token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The type of identity management for your Amazon Connect users.
         * </p>
         * 
         * @param identityManagementType
         *        The type of identity management for your Amazon Connect users.
         * @see DirectoryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DirectoryType
         */
        Builder identityManagementType(String identityManagementType);

        /**
         * <p>
         * The type of identity management for your Amazon Connect users.
         * </p>
         * 
         * @param identityManagementType
         *        The type of identity management for your Amazon Connect users.
         * @see DirectoryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DirectoryType
         */
        Builder identityManagementType(DirectoryType identityManagementType);

        /**
         * <p>
         * The name for your instance.
         * </p>
         * 
         * @param instanceAlias
         *        The name for your instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceAlias(String instanceAlias);

        /**
         * <p>
         * The identifier for the directory.
         * </p>
         * 
         * @param directoryId
         *        The identifier for the directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryId(String directoryId);

        /**
         * <p>
         * Whether your contact center handles incoming contacts.
         * </p>
         * 
         * @param inboundCallsEnabled
         *        Whether your contact center handles incoming contacts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inboundCallsEnabled(Boolean inboundCallsEnabled);

        /**
         * <p>
         * Whether your contact center allows outbound calls.
         * </p>
         * 
         * @param outboundCallsEnabled
         *        Whether your contact center allows outbound calls.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outboundCallsEnabled(Boolean outboundCallsEnabled);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String identityManagementType;

        private String instanceAlias;

        private String directoryId;

        private Boolean inboundCallsEnabled;

        private Boolean outboundCallsEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInstanceRequest model) {
            super(model);
            clientToken(model.clientToken);
            identityManagementType(model.identityManagementType);
            instanceAlias(model.instanceAlias);
            directoryId(model.directoryId);
            inboundCallsEnabled(model.inboundCallsEnabled);
            outboundCallsEnabled(model.outboundCallsEnabled);
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getIdentityManagementType() {
            return identityManagementType;
        }

        @Override
        public final Builder identityManagementType(String identityManagementType) {
            this.identityManagementType = identityManagementType;
            return this;
        }

        @Override
        public final Builder identityManagementType(DirectoryType identityManagementType) {
            this.identityManagementType(identityManagementType == null ? null : identityManagementType.toString());
            return this;
        }

        public final void setIdentityManagementType(String identityManagementType) {
            this.identityManagementType = identityManagementType;
        }

        public final String getInstanceAlias() {
            return instanceAlias;
        }

        @Override
        public final Builder instanceAlias(String instanceAlias) {
            this.instanceAlias = instanceAlias;
            return this;
        }

        public final void setInstanceAlias(String instanceAlias) {
            this.instanceAlias = instanceAlias;
        }

        public final String getDirectoryId() {
            return directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        public final Boolean getInboundCallsEnabled() {
            return inboundCallsEnabled;
        }

        @Override
        public final Builder inboundCallsEnabled(Boolean inboundCallsEnabled) {
            this.inboundCallsEnabled = inboundCallsEnabled;
            return this;
        }

        public final void setInboundCallsEnabled(Boolean inboundCallsEnabled) {
            this.inboundCallsEnabled = inboundCallsEnabled;
        }

        public final Boolean getOutboundCallsEnabled() {
            return outboundCallsEnabled;
        }

        @Override
        public final Builder outboundCallsEnabled(Boolean outboundCallsEnabled) {
            this.outboundCallsEnabled = outboundCallsEnabled;
            return this;
        }

        public final void setOutboundCallsEnabled(Boolean outboundCallsEnabled) {
            this.outboundCallsEnabled = outboundCallsEnabled;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateInstanceRequest build() {
            return new CreateInstanceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
