/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateIntegrationAssociationRequest extends ConnectRequest implements
        ToCopyableBuilder<CreateIntegrationAssociationRequest.Builder, CreateIntegrationAssociationRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(CreateIntegrationAssociationRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final SdkField<String> INTEGRATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IntegrationType").getter(getter(CreateIntegrationAssociationRequest::integrationTypeAsString))
            .setter(setter(Builder::integrationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegrationType").build()).build();

    private static final SdkField<String> INTEGRATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IntegrationArn").getter(getter(CreateIntegrationAssociationRequest::integrationArn))
            .setter(setter(Builder::integrationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegrationArn").build()).build();

    private static final SdkField<String> SOURCE_APPLICATION_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceApplicationUrl").getter(getter(CreateIntegrationAssociationRequest::sourceApplicationUrl))
            .setter(setter(Builder::sourceApplicationUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceApplicationUrl").build())
            .build();

    private static final SdkField<String> SOURCE_APPLICATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceApplicationName").getter(getter(CreateIntegrationAssociationRequest::sourceApplicationName))
            .setter(setter(Builder::sourceApplicationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceApplicationName").build())
            .build();

    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceType").getter(getter(CreateIntegrationAssociationRequest::sourceTypeAsString))
            .setter(setter(Builder::sourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            INTEGRATION_TYPE_FIELD, INTEGRATION_ARN_FIELD, SOURCE_APPLICATION_URL_FIELD, SOURCE_APPLICATION_NAME_FIELD,
            SOURCE_TYPE_FIELD));

    private final String instanceId;

    private final String integrationType;

    private final String integrationArn;

    private final String sourceApplicationUrl;

    private final String sourceApplicationName;

    private final String sourceType;

    private CreateIntegrationAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.integrationType = builder.integrationType;
        this.integrationArn = builder.integrationArn;
        this.sourceApplicationUrl = builder.sourceApplicationUrl;
        this.sourceApplicationName = builder.sourceApplicationName;
        this.sourceType = builder.sourceType;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The type of information to be ingested.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #integrationType}
     * will return {@link IntegrationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #integrationTypeAsString}.
     * </p>
     * 
     * @return The type of information to be ingested.
     * @see IntegrationType
     */
    public IntegrationType integrationType() {
        return IntegrationType.fromValue(integrationType);
    }

    /**
     * <p>
     * The type of information to be ingested.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #integrationType}
     * will return {@link IntegrationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #integrationTypeAsString}.
     * </p>
     * 
     * @return The type of information to be ingested.
     * @see IntegrationType
     */
    public String integrationTypeAsString() {
        return integrationType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the integration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the integration.
     */
    public String integrationArn() {
        return integrationArn;
    }

    /**
     * <p>
     * The URL for the external application.
     * </p>
     * 
     * @return The URL for the external application.
     */
    public String sourceApplicationUrl() {
        return sourceApplicationUrl;
    }

    /**
     * <p>
     * The name of the external application.
     * </p>
     * 
     * @return The name of the external application.
     */
    public String sourceApplicationName() {
        return sourceApplicationName;
    }

    /**
     * <p>
     * The type of the data source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceType} will
     * return {@link SourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceTypeAsString}.
     * </p>
     * 
     * @return The type of the data source.
     * @see SourceType
     */
    public SourceType sourceType() {
        return SourceType.fromValue(sourceType);
    }

    /**
     * <p>
     * The type of the data source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceType} will
     * return {@link SourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceTypeAsString}.
     * </p>
     * 
     * @return The type of the data source.
     * @see SourceType
     */
    public String sourceTypeAsString() {
        return sourceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(integrationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(integrationArn());
        hashCode = 31 * hashCode + Objects.hashCode(sourceApplicationUrl());
        hashCode = 31 * hashCode + Objects.hashCode(sourceApplicationName());
        hashCode = 31 * hashCode + Objects.hashCode(sourceTypeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIntegrationAssociationRequest)) {
            return false;
        }
        CreateIntegrationAssociationRequest other = (CreateIntegrationAssociationRequest) obj;
        return Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(integrationTypeAsString(), other.integrationTypeAsString())
                && Objects.equals(integrationArn(), other.integrationArn())
                && Objects.equals(sourceApplicationUrl(), other.sourceApplicationUrl())
                && Objects.equals(sourceApplicationName(), other.sourceApplicationName())
                && Objects.equals(sourceTypeAsString(), other.sourceTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateIntegrationAssociationRequest").add("InstanceId", instanceId())
                .add("IntegrationType", integrationTypeAsString()).add("IntegrationArn", integrationArn())
                .add("SourceApplicationUrl", sourceApplicationUrl()).add("SourceApplicationName", sourceApplicationName())
                .add("SourceType", sourceTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "IntegrationType":
            return Optional.ofNullable(clazz.cast(integrationTypeAsString()));
        case "IntegrationArn":
            return Optional.ofNullable(clazz.cast(integrationArn()));
        case "SourceApplicationUrl":
            return Optional.ofNullable(clazz.cast(sourceApplicationUrl()));
        case "SourceApplicationName":
            return Optional.ofNullable(clazz.cast(sourceApplicationName()));
        case "SourceType":
            return Optional.ofNullable(clazz.cast(sourceTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateIntegrationAssociationRequest, T> g) {
        return obj -> g.apply((CreateIntegrationAssociationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateIntegrationAssociationRequest> {
        /**
         * <p>
         * The identifier of the Amazon Connect instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The type of information to be ingested.
         * </p>
         * 
         * @param integrationType
         *        The type of information to be ingested.
         * @see IntegrationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IntegrationType
         */
        Builder integrationType(String integrationType);

        /**
         * <p>
         * The type of information to be ingested.
         * </p>
         * 
         * @param integrationType
         *        The type of information to be ingested.
         * @see IntegrationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IntegrationType
         */
        Builder integrationType(IntegrationType integrationType);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the integration.
         * </p>
         * 
         * @param integrationArn
         *        The Amazon Resource Name (ARN) of the integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integrationArn(String integrationArn);

        /**
         * <p>
         * The URL for the external application.
         * </p>
         * 
         * @param sourceApplicationUrl
         *        The URL for the external application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceApplicationUrl(String sourceApplicationUrl);

        /**
         * <p>
         * The name of the external application.
         * </p>
         * 
         * @param sourceApplicationName
         *        The name of the external application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceApplicationName(String sourceApplicationName);

        /**
         * <p>
         * The type of the data source.
         * </p>
         * 
         * @param sourceType
         *        The type of the data source.
         * @see SourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SourceType
         */
        Builder sourceType(String sourceType);

        /**
         * <p>
         * The type of the data source.
         * </p>
         * 
         * @param sourceType
         *        The type of the data source.
         * @see SourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SourceType
         */
        Builder sourceType(SourceType sourceType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String integrationType;

        private String integrationArn;

        private String sourceApplicationUrl;

        private String sourceApplicationName;

        private String sourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIntegrationAssociationRequest model) {
            super(model);
            instanceId(model.instanceId);
            integrationType(model.integrationType);
            integrationArn(model.integrationArn);
            sourceApplicationUrl(model.sourceApplicationUrl);
            sourceApplicationName(model.sourceApplicationName);
            sourceType(model.sourceType);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getIntegrationType() {
            return integrationType;
        }

        @Override
        public final Builder integrationType(String integrationType) {
            this.integrationType = integrationType;
            return this;
        }

        @Override
        public final Builder integrationType(IntegrationType integrationType) {
            this.integrationType(integrationType == null ? null : integrationType.toString());
            return this;
        }

        public final void setIntegrationType(String integrationType) {
            this.integrationType = integrationType;
        }

        public final String getIntegrationArn() {
            return integrationArn;
        }

        @Override
        public final Builder integrationArn(String integrationArn) {
            this.integrationArn = integrationArn;
            return this;
        }

        public final void setIntegrationArn(String integrationArn) {
            this.integrationArn = integrationArn;
        }

        public final String getSourceApplicationUrl() {
            return sourceApplicationUrl;
        }

        @Override
        public final Builder sourceApplicationUrl(String sourceApplicationUrl) {
            this.sourceApplicationUrl = sourceApplicationUrl;
            return this;
        }

        public final void setSourceApplicationUrl(String sourceApplicationUrl) {
            this.sourceApplicationUrl = sourceApplicationUrl;
        }

        public final String getSourceApplicationName() {
            return sourceApplicationName;
        }

        @Override
        public final Builder sourceApplicationName(String sourceApplicationName) {
            this.sourceApplicationName = sourceApplicationName;
            return this;
        }

        public final void setSourceApplicationName(String sourceApplicationName) {
            this.sourceApplicationName = sourceApplicationName;
        }

        public final String getSourceType() {
            return sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        @Override
        public final Builder sourceType(SourceType sourceType) {
            this.sourceType(sourceType == null ? null : sourceType.toString());
            return this;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateIntegrationAssociationRequest build() {
            return new CreateIntegrationAssociationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
