/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceSummary implements SdkPojo, Serializable, ToCopyableBuilder<InstanceSummary.Builder, InstanceSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(InstanceSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(InstanceSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> IDENTITY_MANAGEMENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentityManagementType").getter(getter(InstanceSummary::identityManagementTypeAsString))
            .setter(setter(Builder::identityManagementType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityManagementType").build())
            .build();

    private static final SdkField<String> INSTANCE_ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceAlias").getter(getter(InstanceSummary::instanceAlias)).setter(setter(Builder::instanceAlias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceAlias").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime").getter(getter(InstanceSummary::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<String> SERVICE_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceRole").getter(getter(InstanceSummary::serviceRole)).setter(setter(Builder::serviceRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceRole").build()).build();

    private static final SdkField<String> INSTANCE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceStatus").getter(getter(InstanceSummary::instanceStatusAsString))
            .setter(setter(Builder::instanceStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceStatus").build()).build();

    private static final SdkField<Boolean> INBOUND_CALLS_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("InboundCallsEnabled").getter(getter(InstanceSummary::inboundCallsEnabled))
            .setter(setter(Builder::inboundCallsEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InboundCallsEnabled").build())
            .build();

    private static final SdkField<Boolean> OUTBOUND_CALLS_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("OutboundCallsEnabled").getter(getter(InstanceSummary::outboundCallsEnabled))
            .setter(setter(Builder::outboundCallsEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutboundCallsEnabled").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            IDENTITY_MANAGEMENT_TYPE_FIELD, INSTANCE_ALIAS_FIELD, CREATED_TIME_FIELD, SERVICE_ROLE_FIELD, INSTANCE_STATUS_FIELD,
            INBOUND_CALLS_ENABLED_FIELD, OUTBOUND_CALLS_ENABLED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String arn;

    private final String identityManagementType;

    private final String instanceAlias;

    private final Instant createdTime;

    private final String serviceRole;

    private final String instanceStatus;

    private final Boolean inboundCallsEnabled;

    private final Boolean outboundCallsEnabled;

    private InstanceSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.identityManagementType = builder.identityManagementType;
        this.instanceAlias = builder.instanceAlias;
        this.createdTime = builder.createdTime;
        this.serviceRole = builder.serviceRole;
        this.instanceStatus = builder.instanceStatus;
        this.inboundCallsEnabled = builder.inboundCallsEnabled;
        this.outboundCallsEnabled = builder.outboundCallsEnabled;
    }

    /**
     * <p>
     * The identifier of the instance.
     * </p>
     * 
     * @return The identifier of the instance.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the instance.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the instance.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The identity management type of the instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #identityManagementType} will return {@link DirectoryType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #identityManagementTypeAsString}.
     * </p>
     * 
     * @return The identity management type of the instance.
     * @see DirectoryType
     */
    public DirectoryType identityManagementType() {
        return DirectoryType.fromValue(identityManagementType);
    }

    /**
     * <p>
     * The identity management type of the instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #identityManagementType} will return {@link DirectoryType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #identityManagementTypeAsString}.
     * </p>
     * 
     * @return The identity management type of the instance.
     * @see DirectoryType
     */
    public String identityManagementTypeAsString() {
        return identityManagementType;
    }

    /**
     * <p>
     * The alias of the instance.
     * </p>
     * 
     * @return The alias of the instance.
     */
    public String instanceAlias() {
        return instanceAlias;
    }

    /**
     * <p>
     * When the instance was created.
     * </p>
     * 
     * @return When the instance was created.
     */
    public Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The service role of the instance.
     * </p>
     * 
     * @return The service role of the instance.
     */
    public String serviceRole() {
        return serviceRole;
    }

    /**
     * <p>
     * The state of the instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceStatus}
     * will return {@link InstanceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #instanceStatusAsString}.
     * </p>
     * 
     * @return The state of the instance.
     * @see InstanceStatus
     */
    public InstanceStatus instanceStatus() {
        return InstanceStatus.fromValue(instanceStatus);
    }

    /**
     * <p>
     * The state of the instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceStatus}
     * will return {@link InstanceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #instanceStatusAsString}.
     * </p>
     * 
     * @return The state of the instance.
     * @see InstanceStatus
     */
    public String instanceStatusAsString() {
        return instanceStatus;
    }

    /**
     * <p>
     * Whether inbound calls are enabled.
     * </p>
     * 
     * @return Whether inbound calls are enabled.
     */
    public Boolean inboundCallsEnabled() {
        return inboundCallsEnabled;
    }

    /**
     * <p>
     * Whether outbound calls are enabled.
     * </p>
     * 
     * @return Whether outbound calls are enabled.
     */
    public Boolean outboundCallsEnabled() {
        return outboundCallsEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(identityManagementTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(instanceAlias());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(serviceRole());
        hashCode = 31 * hashCode + Objects.hashCode(instanceStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(inboundCallsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(outboundCallsEnabled());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceSummary)) {
            return false;
        }
        InstanceSummary other = (InstanceSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn())
                && Objects.equals(identityManagementTypeAsString(), other.identityManagementTypeAsString())
                && Objects.equals(instanceAlias(), other.instanceAlias()) && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(serviceRole(), other.serviceRole())
                && Objects.equals(instanceStatusAsString(), other.instanceStatusAsString())
                && Objects.equals(inboundCallsEnabled(), other.inboundCallsEnabled())
                && Objects.equals(outboundCallsEnabled(), other.outboundCallsEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("InstanceSummary").add("Id", id()).add("Arn", arn())
                .add("IdentityManagementType", identityManagementTypeAsString())
                .add("InstanceAlias", instanceAlias() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CreatedTime", createdTime()).add("ServiceRole", serviceRole())
                .add("InstanceStatus", instanceStatusAsString()).add("InboundCallsEnabled", inboundCallsEnabled())
                .add("OutboundCallsEnabled", outboundCallsEnabled()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "IdentityManagementType":
            return Optional.ofNullable(clazz.cast(identityManagementTypeAsString()));
        case "InstanceAlias":
            return Optional.ofNullable(clazz.cast(instanceAlias()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "ServiceRole":
            return Optional.ofNullable(clazz.cast(serviceRole()));
        case "InstanceStatus":
            return Optional.ofNullable(clazz.cast(instanceStatusAsString()));
        case "InboundCallsEnabled":
            return Optional.ofNullable(clazz.cast(inboundCallsEnabled()));
        case "OutboundCallsEnabled":
            return Optional.ofNullable(clazz.cast(outboundCallsEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceSummary, T> g) {
        return obj -> g.apply((InstanceSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceSummary> {
        /**
         * <p>
         * The identifier of the instance.
         * </p>
         * 
         * @param id
         *        The identifier of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the instance.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The identity management type of the instance.
         * </p>
         * 
         * @param identityManagementType
         *        The identity management type of the instance.
         * @see DirectoryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DirectoryType
         */
        Builder identityManagementType(String identityManagementType);

        /**
         * <p>
         * The identity management type of the instance.
         * </p>
         * 
         * @param identityManagementType
         *        The identity management type of the instance.
         * @see DirectoryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DirectoryType
         */
        Builder identityManagementType(DirectoryType identityManagementType);

        /**
         * <p>
         * The alias of the instance.
         * </p>
         * 
         * @param instanceAlias
         *        The alias of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceAlias(String instanceAlias);

        /**
         * <p>
         * When the instance was created.
         * </p>
         * 
         * @param createdTime
         *        When the instance was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The service role of the instance.
         * </p>
         * 
         * @param serviceRole
         *        The service role of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRole(String serviceRole);

        /**
         * <p>
         * The state of the instance.
         * </p>
         * 
         * @param instanceStatus
         *        The state of the instance.
         * @see InstanceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceStatus
         */
        Builder instanceStatus(String instanceStatus);

        /**
         * <p>
         * The state of the instance.
         * </p>
         * 
         * @param instanceStatus
         *        The state of the instance.
         * @see InstanceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceStatus
         */
        Builder instanceStatus(InstanceStatus instanceStatus);

        /**
         * <p>
         * Whether inbound calls are enabled.
         * </p>
         * 
         * @param inboundCallsEnabled
         *        Whether inbound calls are enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inboundCallsEnabled(Boolean inboundCallsEnabled);

        /**
         * <p>
         * Whether outbound calls are enabled.
         * </p>
         * 
         * @param outboundCallsEnabled
         *        Whether outbound calls are enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outboundCallsEnabled(Boolean outboundCallsEnabled);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String identityManagementType;

        private String instanceAlias;

        private Instant createdTime;

        private String serviceRole;

        private String instanceStatus;

        private Boolean inboundCallsEnabled;

        private Boolean outboundCallsEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceSummary model) {
            id(model.id);
            arn(model.arn);
            identityManagementType(model.identityManagementType);
            instanceAlias(model.instanceAlias);
            createdTime(model.createdTime);
            serviceRole(model.serviceRole);
            instanceStatus(model.instanceStatus);
            inboundCallsEnabled(model.inboundCallsEnabled);
            outboundCallsEnabled(model.outboundCallsEnabled);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getIdentityManagementType() {
            return identityManagementType;
        }

        @Override
        public final Builder identityManagementType(String identityManagementType) {
            this.identityManagementType = identityManagementType;
            return this;
        }

        @Override
        public final Builder identityManagementType(DirectoryType identityManagementType) {
            this.identityManagementType(identityManagementType == null ? null : identityManagementType.toString());
            return this;
        }

        public final void setIdentityManagementType(String identityManagementType) {
            this.identityManagementType = identityManagementType;
        }

        public final String getInstanceAlias() {
            return instanceAlias;
        }

        @Override
        public final Builder instanceAlias(String instanceAlias) {
            this.instanceAlias = instanceAlias;
            return this;
        }

        public final void setInstanceAlias(String instanceAlias) {
            this.instanceAlias = instanceAlias;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        public final String getServiceRole() {
            return serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        public final String getInstanceStatus() {
            return instanceStatus;
        }

        @Override
        public final Builder instanceStatus(String instanceStatus) {
            this.instanceStatus = instanceStatus;
            return this;
        }

        @Override
        public final Builder instanceStatus(InstanceStatus instanceStatus) {
            this.instanceStatus(instanceStatus == null ? null : instanceStatus.toString());
            return this;
        }

        public final void setInstanceStatus(String instanceStatus) {
            this.instanceStatus = instanceStatus;
        }

        public final Boolean getInboundCallsEnabled() {
            return inboundCallsEnabled;
        }

        @Override
        public final Builder inboundCallsEnabled(Boolean inboundCallsEnabled) {
            this.inboundCallsEnabled = inboundCallsEnabled;
            return this;
        }

        public final void setInboundCallsEnabled(Boolean inboundCallsEnabled) {
            this.inboundCallsEnabled = inboundCallsEnabled;
        }

        public final Boolean getOutboundCallsEnabled() {
            return outboundCallsEnabled;
        }

        @Override
        public final Builder outboundCallsEnabled(Boolean outboundCallsEnabled) {
            this.outboundCallsEnabled = outboundCallsEnabled;
            return this;
        }

        public final void setOutboundCallsEnabled(Boolean outboundCallsEnabled) {
            this.outboundCallsEnabled = outboundCallsEnabled;
        }

        @Override
        public InstanceSummary build() {
            return new InstanceSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
