/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListInstanceStorageConfigsResponse extends ConnectResponse implements
        ToCopyableBuilder<ListInstanceStorageConfigsResponse.Builder, ListInstanceStorageConfigsResponse> {
    private static final SdkField<List<InstanceStorageConfig>> STORAGE_CONFIGS_FIELD = SdkField
            .<List<InstanceStorageConfig>> builder(MarshallingType.LIST)
            .memberName("StorageConfigs")
            .getter(getter(ListInstanceStorageConfigsResponse::storageConfigs))
            .setter(setter(Builder::storageConfigs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageConfigs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InstanceStorageConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceStorageConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListInstanceStorageConfigsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORAGE_CONFIGS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<InstanceStorageConfig> storageConfigs;

    private final String nextToken;

    private ListInstanceStorageConfigsResponse(BuilderImpl builder) {
        super(builder);
        this.storageConfigs = builder.storageConfigs;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the StorageConfigs property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasStorageConfigs() {
        return storageConfigs != null && !(storageConfigs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A valid storage type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStorageConfigs()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A valid storage type.
     */
    public List<InstanceStorageConfig> storageConfigs() {
        return storageConfigs;
    }

    /**
     * <p>
     * If there are additional results, this is the token for the next set of results.
     * </p>
     * 
     * @return If there are additional results, this is the token for the next set of results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasStorageConfigs() ? storageConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInstanceStorageConfigsResponse)) {
            return false;
        }
        ListInstanceStorageConfigsResponse other = (ListInstanceStorageConfigsResponse) obj;
        return hasStorageConfigs() == other.hasStorageConfigs() && Objects.equals(storageConfigs(), other.storageConfigs())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListInstanceStorageConfigsResponse")
                .add("StorageConfigs", hasStorageConfigs() ? storageConfigs() : null).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StorageConfigs":
            return Optional.ofNullable(clazz.cast(storageConfigs()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListInstanceStorageConfigsResponse, T> g) {
        return obj -> g.apply((ListInstanceStorageConfigsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListInstanceStorageConfigsResponse> {
        /**
         * <p>
         * A valid storage type.
         * </p>
         * 
         * @param storageConfigs
         *        A valid storage type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageConfigs(Collection<InstanceStorageConfig> storageConfigs);

        /**
         * <p>
         * A valid storage type.
         * </p>
         * 
         * @param storageConfigs
         *        A valid storage type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageConfigs(InstanceStorageConfig... storageConfigs);

        /**
         * <p>
         * A valid storage type.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InstanceStorageConfig>.Builder} avoiding
         * the need to create one manually via {@link List<InstanceStorageConfig>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InstanceStorageConfig>.Builder#build()} is called
         * immediately and its result is passed to {@link #storageConfigs(List<InstanceStorageConfig>)}.
         * 
         * @param storageConfigs
         *        a consumer that will call methods on {@link List<InstanceStorageConfig>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storageConfigs(List<InstanceStorageConfig>)
         */
        Builder storageConfigs(Consumer<InstanceStorageConfig.Builder>... storageConfigs);

        /**
         * <p>
         * If there are additional results, this is the token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        If there are additional results, this is the token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private List<InstanceStorageConfig> storageConfigs = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInstanceStorageConfigsResponse model) {
            super(model);
            storageConfigs(model.storageConfigs);
            nextToken(model.nextToken);
        }

        public final Collection<InstanceStorageConfig.Builder> getStorageConfigs() {
            if (storageConfigs instanceof SdkAutoConstructList) {
                return null;
            }
            return storageConfigs != null ? storageConfigs.stream().map(InstanceStorageConfig::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder storageConfigs(Collection<InstanceStorageConfig> storageConfigs) {
            this.storageConfigs = InstanceStorageConfigsCopier.copy(storageConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageConfigs(InstanceStorageConfig... storageConfigs) {
            storageConfigs(Arrays.asList(storageConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageConfigs(Consumer<InstanceStorageConfig.Builder>... storageConfigs) {
            storageConfigs(Stream.of(storageConfigs).map(c -> InstanceStorageConfig.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setStorageConfigs(Collection<InstanceStorageConfig.BuilderImpl> storageConfigs) {
            this.storageConfigs = InstanceStorageConfigsCopier.copyFromBuilder(storageConfigs);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListInstanceStorageConfigsResponse build() {
            return new ListInstanceStorageConfigsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
