/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPhoneNumbersResponse extends ConnectResponse implements
        ToCopyableBuilder<ListPhoneNumbersResponse.Builder, ListPhoneNumbersResponse> {
    private static final SdkField<List<PhoneNumberSummary>> PHONE_NUMBER_SUMMARY_LIST_FIELD = SdkField
            .<List<PhoneNumberSummary>> builder(MarshallingType.LIST)
            .memberName("PhoneNumberSummaryList")
            .getter(getter(ListPhoneNumbersResponse::phoneNumberSummaryList))
            .setter(setter(Builder::phoneNumberSummaryList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumberSummaryList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PhoneNumberSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(PhoneNumberSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListPhoneNumbersResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PHONE_NUMBER_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));

    private final List<PhoneNumberSummary> phoneNumberSummaryList;

    private final String nextToken;

    private ListPhoneNumbersResponse(BuilderImpl builder) {
        super(builder);
        this.phoneNumberSummaryList = builder.phoneNumberSummaryList;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the PhoneNumberSummaryList property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasPhoneNumberSummaryList() {
        return phoneNumberSummaryList != null && !(phoneNumberSummaryList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the phone numbers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPhoneNumberSummaryList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the phone numbers.
     */
    public List<PhoneNumberSummary> phoneNumberSummaryList() {
        return phoneNumberSummaryList;
    }

    /**
     * <p>
     * If there are additional results, this is the token for the next set of results.
     * </p>
     * 
     * @return If there are additional results, this is the token for the next set of results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPhoneNumberSummaryList() ? phoneNumberSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPhoneNumbersResponse)) {
            return false;
        }
        ListPhoneNumbersResponse other = (ListPhoneNumbersResponse) obj;
        return hasPhoneNumberSummaryList() == other.hasPhoneNumberSummaryList()
                && Objects.equals(phoneNumberSummaryList(), other.phoneNumberSummaryList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListPhoneNumbersResponse")
                .add("PhoneNumberSummaryList", hasPhoneNumberSummaryList() ? phoneNumberSummaryList() : null)
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PhoneNumberSummaryList":
            return Optional.ofNullable(clazz.cast(phoneNumberSummaryList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPhoneNumbersResponse, T> g) {
        return obj -> g.apply((ListPhoneNumbersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListPhoneNumbersResponse> {
        /**
         * <p>
         * Information about the phone numbers.
         * </p>
         * 
         * @param phoneNumberSummaryList
         *        Information about the phone numbers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumberSummaryList(Collection<PhoneNumberSummary> phoneNumberSummaryList);

        /**
         * <p>
         * Information about the phone numbers.
         * </p>
         * 
         * @param phoneNumberSummaryList
         *        Information about the phone numbers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumberSummaryList(PhoneNumberSummary... phoneNumberSummaryList);

        /**
         * <p>
         * Information about the phone numbers.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PhoneNumberSummary>.Builder} avoiding the
         * need to create one manually via {@link List<PhoneNumberSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PhoneNumberSummary>.Builder#build()} is called immediately
         * and its result is passed to {@link #phoneNumberSummaryList(List<PhoneNumberSummary>)}.
         * 
         * @param phoneNumberSummaryList
         *        a consumer that will call methods on {@link List<PhoneNumberSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #phoneNumberSummaryList(List<PhoneNumberSummary>)
         */
        Builder phoneNumberSummaryList(Consumer<PhoneNumberSummary.Builder>... phoneNumberSummaryList);

        /**
         * <p>
         * If there are additional results, this is the token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        If there are additional results, this is the token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private List<PhoneNumberSummary> phoneNumberSummaryList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPhoneNumbersResponse model) {
            super(model);
            phoneNumberSummaryList(model.phoneNumberSummaryList);
            nextToken(model.nextToken);
        }

        public final Collection<PhoneNumberSummary.Builder> getPhoneNumberSummaryList() {
            if (phoneNumberSummaryList instanceof SdkAutoConstructList) {
                return null;
            }
            return phoneNumberSummaryList != null ? phoneNumberSummaryList.stream().map(PhoneNumberSummary::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder phoneNumberSummaryList(Collection<PhoneNumberSummary> phoneNumberSummaryList) {
            this.phoneNumberSummaryList = PhoneNumberSummaryListCopier.copy(phoneNumberSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumberSummaryList(PhoneNumberSummary... phoneNumberSummaryList) {
            phoneNumberSummaryList(Arrays.asList(phoneNumberSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumberSummaryList(Consumer<PhoneNumberSummary.Builder>... phoneNumberSummaryList) {
            phoneNumberSummaryList(Stream.of(phoneNumberSummaryList)
                    .map(c -> PhoneNumberSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPhoneNumberSummaryList(Collection<PhoneNumberSummary.BuilderImpl> phoneNumberSummaryList) {
            this.phoneNumberSummaryList = PhoneNumberSummaryListCopier.copyFromBuilder(phoneNumberSummaryList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListPhoneNumbersResponse build() {
            return new ListPhoneNumbersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
