/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the queue and channel for which priority and delay can be set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RoutingProfileQueueConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<RoutingProfileQueueConfig.Builder, RoutingProfileQueueConfig> {
    private static final SdkField<RoutingProfileQueueReference> QUEUE_REFERENCE_FIELD = SdkField
            .<RoutingProfileQueueReference> builder(MarshallingType.SDK_POJO).memberName("QueueReference")
            .getter(getter(RoutingProfileQueueConfig::queueReference)).setter(setter(Builder::queueReference))
            .constructor(RoutingProfileQueueReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueReference").build()).build();

    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Priority").getter(getter(RoutingProfileQueueConfig::priority)).setter(setter(Builder::priority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority").build()).build();

    private static final SdkField<Integer> DELAY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Delay")
            .getter(getter(RoutingProfileQueueConfig::delay)).setter(setter(Builder::delay))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Delay").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUEUE_REFERENCE_FIELD,
            PRIORITY_FIELD, DELAY_FIELD));

    private static final long serialVersionUID = 1L;

    private final RoutingProfileQueueReference queueReference;

    private final Integer priority;

    private final Integer delay;

    private RoutingProfileQueueConfig(BuilderImpl builder) {
        this.queueReference = builder.queueReference;
        this.priority = builder.priority;
        this.delay = builder.delay;
    }

    /**
     * <p>
     * Contains information about a queue resource.
     * </p>
     * 
     * @return Contains information about a queue resource.
     */
    public RoutingProfileQueueReference queueReference() {
        return queueReference;
    }

    /**
     * <p>
     * The order in which contacts are to be handled for the queue. For more information, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing-profiles-priority.html">Queues:
     * priority and delay</a>.
     * </p>
     * 
     * @return The order in which contacts are to be handled for the queue. For more information, see <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing-profiles-priority.html"
     *         >Queues: priority and delay</a>.
     */
    public Integer priority() {
        return priority;
    }

    /**
     * <p>
     * The delay, in seconds, a contact should be in the queue before they are routed to an available agent. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing-profiles-priority.html">Queues:
     * priority and delay</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * 
     * @return The delay, in seconds, a contact should be in the queue before they are routed to an available agent. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing-profiles-priority.html"
     *         >Queues: priority and delay</a> in the <i>Amazon Connect Administrator Guide</i>.
     */
    public Integer delay() {
        return delay;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(queueReference());
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        hashCode = 31 * hashCode + Objects.hashCode(delay());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoutingProfileQueueConfig)) {
            return false;
        }
        RoutingProfileQueueConfig other = (RoutingProfileQueueConfig) obj;
        return Objects.equals(queueReference(), other.queueReference()) && Objects.equals(priority(), other.priority())
                && Objects.equals(delay(), other.delay());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RoutingProfileQueueConfig").add("QueueReference", queueReference()).add("Priority", priority())
                .add("Delay", delay()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QueueReference":
            return Optional.ofNullable(clazz.cast(queueReference()));
        case "Priority":
            return Optional.ofNullable(clazz.cast(priority()));
        case "Delay":
            return Optional.ofNullable(clazz.cast(delay()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RoutingProfileQueueConfig, T> g) {
        return obj -> g.apply((RoutingProfileQueueConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RoutingProfileQueueConfig> {
        /**
         * <p>
         * Contains information about a queue resource.
         * </p>
         * 
         * @param queueReference
         *        Contains information about a queue resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueReference(RoutingProfileQueueReference queueReference);

        /**
         * <p>
         * Contains information about a queue resource.
         * </p>
         * This is a convenience that creates an instance of the {@link RoutingProfileQueueReference.Builder} avoiding
         * the need to create one manually via {@link RoutingProfileQueueReference#builder()}.
         *
         * When the {@link Consumer} completes, {@link RoutingProfileQueueReference.Builder#build()} is called
         * immediately and its result is passed to {@link #queueReference(RoutingProfileQueueReference)}.
         * 
         * @param queueReference
         *        a consumer that will call methods on {@link RoutingProfileQueueReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queueReference(RoutingProfileQueueReference)
         */
        default Builder queueReference(Consumer<RoutingProfileQueueReference.Builder> queueReference) {
            return queueReference(RoutingProfileQueueReference.builder().applyMutation(queueReference).build());
        }

        /**
         * <p>
         * The order in which contacts are to be handled for the queue. For more information, see <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing-profiles-priority.html">Queues:
         * priority and delay</a>.
         * </p>
         * 
         * @param priority
         *        The order in which contacts are to be handled for the queue. For more information, see <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing-profiles-priority.html"
         *        >Queues: priority and delay</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Integer priority);

        /**
         * <p>
         * The delay, in seconds, a contact should be in the queue before they are routed to an available agent. For
         * more information, see <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing-profiles-priority.html">Queues:
         * priority and delay</a> in the <i>Amazon Connect Administrator Guide</i>.
         * </p>
         * 
         * @param delay
         *        The delay, in seconds, a contact should be in the queue before they are routed to an available agent.
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing-profiles-priority.html"
         *        >Queues: priority and delay</a> in the <i>Amazon Connect Administrator Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder delay(Integer delay);
    }

    static final class BuilderImpl implements Builder {
        private RoutingProfileQueueReference queueReference;

        private Integer priority;

        private Integer delay;

        private BuilderImpl() {
        }

        private BuilderImpl(RoutingProfileQueueConfig model) {
            queueReference(model.queueReference);
            priority(model.priority);
            delay(model.delay);
        }

        public final RoutingProfileQueueReference.Builder getQueueReference() {
            return queueReference != null ? queueReference.toBuilder() : null;
        }

        @Override
        public final Builder queueReference(RoutingProfileQueueReference queueReference) {
            this.queueReference = queueReference;
            return this;
        }

        public final void setQueueReference(RoutingProfileQueueReference.BuilderImpl queueReference) {
            this.queueReference = queueReference != null ? queueReference.build() : null;
        }

        public final Integer getPriority() {
            return priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        public final Integer getDelay() {
            return delay;
        }

        @Override
        public final Builder delay(Integer delay) {
            this.delay = delay;
            return this;
        }

        public final void setDelay(Integer delay) {
            this.delay = delay;
        }

        @Override
        public RoutingProfileQueueConfig build() {
            return new RoutingProfileQueueConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
