/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LexBot
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LexBot> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(LexBot.getter(LexBot::name)).setter(LexBot.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> LEX_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LexRegion").getter(LexBot.getter(LexBot::lexRegion)).setter(LexBot.setter(Builder::lexRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LexRegion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, LEX_REGION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String lexRegion;

    private LexBot(BuilderImpl builder) {
        this.name = builder.name;
        this.lexRegion = builder.lexRegion;
    }

    public String name() {
        return this.name;
    }

    public String lexRegion() {
        return this.lexRegion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.lexRegion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LexBot)) {
            return false;
        }
        LexBot other = (LexBot)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.lexRegion(), other.lexRegion());
    }

    public String toString() {
        return ToString.builder((String)"LexBot").add("Name", (Object)this.name()).add("LexRegion", (Object)this.lexRegion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "LexRegion": {
                return Optional.ofNullable(clazz.cast(this.lexRegion()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LexBot, T> g) {
        return obj -> g.apply((LexBot)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String lexRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(LexBot model) {
            this.name(model.name);
            this.lexRegion(model.lexRegion);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getLexRegion() {
            return this.lexRegion;
        }

        @Override
        public final Builder lexRegion(String lexRegion) {
            this.lexRegion = lexRegion;
            return this;
        }

        public final void setLexRegion(String lexRegion) {
            this.lexRegion = lexRegion;
        }

        public LexBot build() {
            return new LexBot(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LexBot> {
        public Builder name(String var1);

        public Builder lexRegion(String var1);
    }
}

