/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connect.model.AttributesCopier;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.ContactReferencesCopier;
import software.amazon.awssdk.services.connect.model.Reference;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartTaskContactRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, StartTaskContactRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(StartTaskContactRequest.getter(StartTaskContactRequest::instanceId)).setter(StartTaskContactRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()}).build();
    private static final SdkField<String> PREVIOUS_CONTACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreviousContactId").getter(StartTaskContactRequest.getter(StartTaskContactRequest::previousContactId)).setter(StartTaskContactRequest.setter(Builder::previousContactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreviousContactId").build()}).build();
    private static final SdkField<String> CONTACT_FLOW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContactFlowId").getter(StartTaskContactRequest.getter(StartTaskContactRequest::contactFlowId)).setter(StartTaskContactRequest.setter(Builder::contactFlowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactFlowId").build()}).build();
    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Attributes").getter(StartTaskContactRequest.getter(StartTaskContactRequest::attributes)).setter(StartTaskContactRequest.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(StartTaskContactRequest.getter(StartTaskContactRequest::name)).setter(StartTaskContactRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Map<String, Reference>> REFERENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("References").getter(StartTaskContactRequest.getter(StartTaskContactRequest::references)).setter(StartTaskContactRequest.setter(Builder::references)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("References").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Reference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(StartTaskContactRequest.getter(StartTaskContactRequest::description)).setter(StartTaskContactRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(StartTaskContactRequest.getter(StartTaskContactRequest::clientToken)).setter(StartTaskContactRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, PREVIOUS_CONTACT_ID_FIELD, CONTACT_FLOW_ID_FIELD, ATTRIBUTES_FIELD, NAME_FIELD, REFERENCES_FIELD, DESCRIPTION_FIELD, CLIENT_TOKEN_FIELD));
    private final String instanceId;
    private final String previousContactId;
    private final String contactFlowId;
    private final Map<String, String> attributes;
    private final String name;
    private final Map<String, Reference> references;
    private final String description;
    private final String clientToken;

    private StartTaskContactRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.previousContactId = builder.previousContactId;
        this.contactFlowId = builder.contactFlowId;
        this.attributes = builder.attributes;
        this.name = builder.name;
        this.references = builder.references;
        this.description = builder.description;
        this.clientToken = builder.clientToken;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String previousContactId() {
        return this.previousContactId;
    }

    public String contactFlowId() {
        return this.contactFlowId;
    }

    public boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructMap);
    }

    public Map<String, String> attributes() {
        return this.attributes;
    }

    public String name() {
        return this.name;
    }

    public boolean hasReferences() {
        return this.references != null && !(this.references instanceof SdkAutoConstructMap);
    }

    public Map<String, Reference> references() {
        return this.references;
    }

    public String description() {
        return this.description;
    }

    public String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.previousContactId());
        hashCode = 31 * hashCode + Objects.hashCode(this.contactFlowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReferences() ? this.references() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartTaskContactRequest)) {
            return false;
        }
        StartTaskContactRequest other = (StartTaskContactRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.previousContactId(), other.previousContactId()) && Objects.equals(this.contactFlowId(), other.contactFlowId()) && this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributes(), other.attributes()) && Objects.equals(this.name(), other.name()) && this.hasReferences() == other.hasReferences() && Objects.equals(this.references(), other.references()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public String toString() {
        return ToString.builder((String)"StartTaskContactRequest").add("InstanceId", (Object)this.instanceId()).add("PreviousContactId", (Object)this.previousContactId()).add("ContactFlowId", (Object)this.contactFlowId()).add("Attributes", this.hasAttributes() ? this.attributes() : null).add("Name", (Object)this.name()).add("References", this.hasReferences() ? this.references() : null).add("Description", (Object)this.description()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "PreviousContactId": {
                return Optional.ofNullable(clazz.cast(this.previousContactId()));
            }
            case "ContactFlowId": {
                return Optional.ofNullable(clazz.cast(this.contactFlowId()));
            }
            case "Attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "References": {
                return Optional.ofNullable(clazz.cast(this.references()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartTaskContactRequest, T> g) {
        return obj -> g.apply((StartTaskContactRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private String previousContactId;
        private String contactFlowId;
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();
        private String name;
        private Map<String, Reference> references = DefaultSdkAutoConstructMap.getInstance();
        private String description;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StartTaskContactRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.previousContactId(model.previousContactId);
            this.contactFlowId(model.contactFlowId);
            this.attributes(model.attributes);
            this.name(model.name);
            this.references(model.references);
            this.description(model.description);
            this.clientToken(model.clientToken);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getPreviousContactId() {
            return this.previousContactId;
        }

        @Override
        public final Builder previousContactId(String previousContactId) {
            this.previousContactId = previousContactId;
            return this;
        }

        public final void setPreviousContactId(String previousContactId) {
            this.previousContactId = previousContactId;
        }

        public final String getContactFlowId() {
            return this.contactFlowId;
        }

        @Override
        public final Builder contactFlowId(String contactFlowId) {
            this.contactFlowId = contactFlowId;
            return this;
        }

        public final void setContactFlowId(String contactFlowId) {
            this.contactFlowId = contactFlowId;
        }

        public final Map<String, String> getAttributes() {
            if (this.attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Map<String, Reference.Builder> getReferences() {
            if (this.references instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.references != null ? CollectionUtils.mapValues(this.references, Reference::toBuilder) : null;
        }

        @Override
        public final Builder references(Map<String, Reference> references) {
            this.references = ContactReferencesCopier.copy(references);
            return this;
        }

        public final void setReferences(Map<String, Reference.BuilderImpl> references) {
            this.references = ContactReferencesCopier.copyFromBuilder(references);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartTaskContactRequest build() {
            return new StartTaskContactRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartTaskContactRequest> {
        public Builder instanceId(String var1);

        public Builder previousContactId(String var1);

        public Builder contactFlowId(String var1);

        public Builder attributes(Map<String, String> var1);

        public Builder name(String var1);

        public Builder references(Map<String, Reference> var1);

        public Builder description(String var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

