/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateUseCaseRequest extends ConnectRequest implements
        ToCopyableBuilder<CreateUseCaseRequest.Builder, CreateUseCaseRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(CreateUseCaseRequest::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final SdkField<String> INTEGRATION_ASSOCIATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IntegrationAssociationId").getter(getter(CreateUseCaseRequest::integrationAssociationId))
            .setter(setter(Builder::integrationAssociationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("IntegrationAssociationId").build())
            .build();

    private static final SdkField<String> USE_CASE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UseCaseType").getter(getter(CreateUseCaseRequest::useCaseTypeAsString))
            .setter(setter(Builder::useCaseType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseCaseType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            INTEGRATION_ASSOCIATION_ID_FIELD, USE_CASE_TYPE_FIELD));

    private final String instanceId;

    private final String integrationAssociationId;

    private final String useCaseType;

    private CreateUseCaseRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.integrationAssociationId = builder.integrationAssociationId;
        this.useCaseType = builder.useCaseType;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The identifier for the AppIntegration association.
     * </p>
     * 
     * @return The identifier for the AppIntegration association.
     */
    public String integrationAssociationId() {
        return integrationAssociationId;
    }

    /**
     * <p>
     * The type of use case to associate to the AppIntegration association. Each AppIntegration association can have
     * only one of each use case type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #useCaseType} will
     * return {@link UseCaseType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #useCaseTypeAsString}.
     * </p>
     * 
     * @return The type of use case to associate to the AppIntegration association. Each AppIntegration association can
     *         have only one of each use case type.
     * @see UseCaseType
     */
    public UseCaseType useCaseType() {
        return UseCaseType.fromValue(useCaseType);
    }

    /**
     * <p>
     * The type of use case to associate to the AppIntegration association. Each AppIntegration association can have
     * only one of each use case type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #useCaseType} will
     * return {@link UseCaseType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #useCaseTypeAsString}.
     * </p>
     * 
     * @return The type of use case to associate to the AppIntegration association. Each AppIntegration association can
     *         have only one of each use case type.
     * @see UseCaseType
     */
    public String useCaseTypeAsString() {
        return useCaseType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(integrationAssociationId());
        hashCode = 31 * hashCode + Objects.hashCode(useCaseTypeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateUseCaseRequest)) {
            return false;
        }
        CreateUseCaseRequest other = (CreateUseCaseRequest) obj;
        return Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(integrationAssociationId(), other.integrationAssociationId())
                && Objects.equals(useCaseTypeAsString(), other.useCaseTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateUseCaseRequest").add("InstanceId", instanceId())
                .add("IntegrationAssociationId", integrationAssociationId()).add("UseCaseType", useCaseTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "IntegrationAssociationId":
            return Optional.ofNullable(clazz.cast(integrationAssociationId()));
        case "UseCaseType":
            return Optional.ofNullable(clazz.cast(useCaseTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateUseCaseRequest, T> g) {
        return obj -> g.apply((CreateUseCaseRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateUseCaseRequest> {
        /**
         * <p>
         * The identifier of the Amazon Connect instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The identifier for the AppIntegration association.
         * </p>
         * 
         * @param integrationAssociationId
         *        The identifier for the AppIntegration association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integrationAssociationId(String integrationAssociationId);

        /**
         * <p>
         * The type of use case to associate to the AppIntegration association. Each AppIntegration association can have
         * only one of each use case type.
         * </p>
         * 
         * @param useCaseType
         *        The type of use case to associate to the AppIntegration association. Each AppIntegration association
         *        can have only one of each use case type.
         * @see UseCaseType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UseCaseType
         */
        Builder useCaseType(String useCaseType);

        /**
         * <p>
         * The type of use case to associate to the AppIntegration association. Each AppIntegration association can have
         * only one of each use case type.
         * </p>
         * 
         * @param useCaseType
         *        The type of use case to associate to the AppIntegration association. Each AppIntegration association
         *        can have only one of each use case type.
         * @see UseCaseType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UseCaseType
         */
        Builder useCaseType(UseCaseType useCaseType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String integrationAssociationId;

        private String useCaseType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateUseCaseRequest model) {
            super(model);
            instanceId(model.instanceId);
            integrationAssociationId(model.integrationAssociationId);
            useCaseType(model.useCaseType);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getIntegrationAssociationId() {
            return integrationAssociationId;
        }

        @Override
        public final Builder integrationAssociationId(String integrationAssociationId) {
            this.integrationAssociationId = integrationAssociationId;
            return this;
        }

        public final void setIntegrationAssociationId(String integrationAssociationId) {
            this.integrationAssociationId = integrationAssociationId;
        }

        public final String getUseCaseType() {
            return useCaseType;
        }

        @Override
        public final Builder useCaseType(String useCaseType) {
            this.useCaseType = useCaseType;
            return this;
        }

        @Override
        public final Builder useCaseType(UseCaseType useCaseType) {
            this.useCaseType(useCaseType == null ? null : useCaseType.toString());
            return this;
        }

        public final void setUseCaseType(String useCaseType) {
            this.useCaseType = useCaseType;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateUseCaseRequest build() {
            return new CreateUseCaseRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
