/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListIntegrationAssociationsResponse extends ConnectResponse implements
        ToCopyableBuilder<ListIntegrationAssociationsResponse.Builder, ListIntegrationAssociationsResponse> {
    private static final SdkField<List<IntegrationAssociationSummary>> INTEGRATION_ASSOCIATION_SUMMARY_LIST_FIELD = SdkField
            .<List<IntegrationAssociationSummary>> builder(MarshallingType.LIST)
            .memberName("IntegrationAssociationSummaryList")
            .getter(getter(ListIntegrationAssociationsResponse::integrationAssociationSummaryList))
            .setter(setter(Builder::integrationAssociationSummaryList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegrationAssociationSummaryList")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IntegrationAssociationSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(IntegrationAssociationSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListIntegrationAssociationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            INTEGRATION_ASSOCIATION_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));

    private final List<IntegrationAssociationSummary> integrationAssociationSummaryList;

    private final String nextToken;

    private ListIntegrationAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.integrationAssociationSummaryList = builder.integrationAssociationSummaryList;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the IntegrationAssociationSummaryList property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public boolean hasIntegrationAssociationSummaryList() {
        return integrationAssociationSummaryList != null && !(integrationAssociationSummaryList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The AppIntegration associations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasIntegrationAssociationSummaryList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The AppIntegration associations.
     */
    public List<IntegrationAssociationSummary> integrationAssociationSummaryList() {
        return integrationAssociationSummaryList;
    }

    /**
     * <p>
     * If there are additional results, this is the token for the next set of results.
     * </p>
     * 
     * @return If there are additional results, this is the token for the next set of results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode
                + Objects.hashCode(hasIntegrationAssociationSummaryList() ? integrationAssociationSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIntegrationAssociationsResponse)) {
            return false;
        }
        ListIntegrationAssociationsResponse other = (ListIntegrationAssociationsResponse) obj;
        return hasIntegrationAssociationSummaryList() == other.hasIntegrationAssociationSummaryList()
                && Objects.equals(integrationAssociationSummaryList(), other.integrationAssociationSummaryList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString
                .builder("ListIntegrationAssociationsResponse")
                .add("IntegrationAssociationSummaryList",
                        hasIntegrationAssociationSummaryList() ? integrationAssociationSummaryList() : null)
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IntegrationAssociationSummaryList":
            return Optional.ofNullable(clazz.cast(integrationAssociationSummaryList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListIntegrationAssociationsResponse, T> g) {
        return obj -> g.apply((ListIntegrationAssociationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListIntegrationAssociationsResponse> {
        /**
         * <p>
         * The AppIntegration associations.
         * </p>
         * 
         * @param integrationAssociationSummaryList
         *        The AppIntegration associations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integrationAssociationSummaryList(Collection<IntegrationAssociationSummary> integrationAssociationSummaryList);

        /**
         * <p>
         * The AppIntegration associations.
         * </p>
         * 
         * @param integrationAssociationSummaryList
         *        The AppIntegration associations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integrationAssociationSummaryList(IntegrationAssociationSummary... integrationAssociationSummaryList);

        /**
         * <p>
         * The AppIntegration associations.
         * </p>
         * This is a convenience that creates an instance of the {@link List<IntegrationAssociationSummary>.Builder}
         * avoiding the need to create one manually via {@link List<IntegrationAssociationSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<IntegrationAssociationSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #integrationAssociationSummaryList(List<IntegrationAssociationSummary>)}.
         * 
         * @param integrationAssociationSummaryList
         *        a consumer that will call methods on {@link List<IntegrationAssociationSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #integrationAssociationSummaryList(List<IntegrationAssociationSummary>)
         */
        Builder integrationAssociationSummaryList(
                Consumer<IntegrationAssociationSummary.Builder>... integrationAssociationSummaryList);

        /**
         * <p>
         * If there are additional results, this is the token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        If there are additional results, this is the token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private List<IntegrationAssociationSummary> integrationAssociationSummaryList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIntegrationAssociationsResponse model) {
            super(model);
            integrationAssociationSummaryList(model.integrationAssociationSummaryList);
            nextToken(model.nextToken);
        }

        public final Collection<IntegrationAssociationSummary.Builder> getIntegrationAssociationSummaryList() {
            if (integrationAssociationSummaryList instanceof SdkAutoConstructList) {
                return null;
            }
            return integrationAssociationSummaryList != null ? integrationAssociationSummaryList.stream()
                    .map(IntegrationAssociationSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder integrationAssociationSummaryList(
                Collection<IntegrationAssociationSummary> integrationAssociationSummaryList) {
            this.integrationAssociationSummaryList = IntegrationAssociationSummaryListCopier
                    .copy(integrationAssociationSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder integrationAssociationSummaryList(IntegrationAssociationSummary... integrationAssociationSummaryList) {
            integrationAssociationSummaryList(Arrays.asList(integrationAssociationSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder integrationAssociationSummaryList(
                Consumer<IntegrationAssociationSummary.Builder>... integrationAssociationSummaryList) {
            integrationAssociationSummaryList(Stream.of(integrationAssociationSummaryList)
                    .map(c -> IntegrationAssociationSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIntegrationAssociationSummaryList(
                Collection<IntegrationAssociationSummary.BuilderImpl> integrationAssociationSummaryList) {
            this.integrationAssociationSummaryList = IntegrationAssociationSummaryListCopier
                    .copyFromBuilder(integrationAssociationSummaryList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListIntegrationAssociationsResponse build() {
            return new ListIntegrationAssociationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
