/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListQueuesResponse extends ConnectResponse implements
        ToCopyableBuilder<ListQueuesResponse.Builder, ListQueuesResponse> {
    private static final SdkField<List<QueueSummary>> QUEUE_SUMMARY_LIST_FIELD = SdkField
            .<List<QueueSummary>> builder(MarshallingType.LIST)
            .memberName("QueueSummaryList")
            .getter(getter(ListQueuesResponse::queueSummaryList))
            .setter(setter(Builder::queueSummaryList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueSummaryList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<QueueSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(QueueSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListQueuesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUEUE_SUMMARY_LIST_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<QueueSummary> queueSummaryList;

    private final String nextToken;

    private ListQueuesResponse(BuilderImpl builder) {
        super(builder);
        this.queueSummaryList = builder.queueSummaryList;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the QueueSummaryList property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasQueueSummaryList() {
        return queueSummaryList != null && !(queueSummaryList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the queues.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasQueueSummaryList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the queues.
     */
    public List<QueueSummary> queueSummaryList() {
        return queueSummaryList;
    }

    /**
     * <p>
     * If there are additional results, this is the token for the next set of results.
     * </p>
     * 
     * @return If there are additional results, this is the token for the next set of results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasQueueSummaryList() ? queueSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListQueuesResponse)) {
            return false;
        }
        ListQueuesResponse other = (ListQueuesResponse) obj;
        return hasQueueSummaryList() == other.hasQueueSummaryList()
                && Objects.equals(queueSummaryList(), other.queueSummaryList()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListQueuesResponse").add("QueueSummaryList", hasQueueSummaryList() ? queueSummaryList() : null)
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QueueSummaryList":
            return Optional.ofNullable(clazz.cast(queueSummaryList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListQueuesResponse, T> g) {
        return obj -> g.apply((ListQueuesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListQueuesResponse> {
        /**
         * <p>
         * Information about the queues.
         * </p>
         * 
         * @param queueSummaryList
         *        Information about the queues.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueSummaryList(Collection<QueueSummary> queueSummaryList);

        /**
         * <p>
         * Information about the queues.
         * </p>
         * 
         * @param queueSummaryList
         *        Information about the queues.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueSummaryList(QueueSummary... queueSummaryList);

        /**
         * <p>
         * Information about the queues.
         * </p>
         * This is a convenience that creates an instance of the {@link List<QueueSummary>.Builder} avoiding the need to
         * create one manually via {@link List<QueueSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<QueueSummary>.Builder#build()} is called immediately and its
         * result is passed to {@link #queueSummaryList(List<QueueSummary>)}.
         * 
         * @param queueSummaryList
         *        a consumer that will call methods on {@link List<QueueSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queueSummaryList(List<QueueSummary>)
         */
        Builder queueSummaryList(Consumer<QueueSummary.Builder>... queueSummaryList);

        /**
         * <p>
         * If there are additional results, this is the token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        If there are additional results, this is the token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private List<QueueSummary> queueSummaryList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListQueuesResponse model) {
            super(model);
            queueSummaryList(model.queueSummaryList);
            nextToken(model.nextToken);
        }

        public final Collection<QueueSummary.Builder> getQueueSummaryList() {
            if (queueSummaryList instanceof SdkAutoConstructList) {
                return null;
            }
            return queueSummaryList != null ? queueSummaryList.stream().map(QueueSummary::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder queueSummaryList(Collection<QueueSummary> queueSummaryList) {
            this.queueSummaryList = QueueSummaryListCopier.copy(queueSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queueSummaryList(QueueSummary... queueSummaryList) {
            queueSummaryList(Arrays.asList(queueSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queueSummaryList(Consumer<QueueSummary.Builder>... queueSummaryList) {
            queueSummaryList(Stream.of(queueSummaryList).map(c -> QueueSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setQueueSummaryList(Collection<QueueSummary.BuilderImpl> queueSummaryList) {
            this.queueSummaryList = QueueSummaryListCopier.copyFromBuilder(queueSummaryList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListQueuesResponse build() {
            return new ListQueuesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
