/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRoutingProfilesResponse extends ConnectResponse implements
        ToCopyableBuilder<ListRoutingProfilesResponse.Builder, ListRoutingProfilesResponse> {
    private static final SdkField<List<RoutingProfileSummary>> ROUTING_PROFILE_SUMMARY_LIST_FIELD = SdkField
            .<List<RoutingProfileSummary>> builder(MarshallingType.LIST)
            .memberName("RoutingProfileSummaryList")
            .getter(getter(ListRoutingProfilesResponse::routingProfileSummaryList))
            .setter(setter(Builder::routingProfileSummaryList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingProfileSummaryList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RoutingProfileSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(RoutingProfileSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListRoutingProfilesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ROUTING_PROFILE_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));

    private final List<RoutingProfileSummary> routingProfileSummaryList;

    private final String nextToken;

    private ListRoutingProfilesResponse(BuilderImpl builder) {
        super(builder);
        this.routingProfileSummaryList = builder.routingProfileSummaryList;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the RoutingProfileSummaryList property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasRoutingProfileSummaryList() {
        return routingProfileSummaryList != null && !(routingProfileSummaryList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the routing profiles.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRoutingProfileSummaryList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the routing profiles.
     */
    public List<RoutingProfileSummary> routingProfileSummaryList() {
        return routingProfileSummaryList;
    }

    /**
     * <p>
     * If there are additional results, this is the token for the next set of results.
     * </p>
     * 
     * @return If there are additional results, this is the token for the next set of results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRoutingProfileSummaryList() ? routingProfileSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRoutingProfilesResponse)) {
            return false;
        }
        ListRoutingProfilesResponse other = (ListRoutingProfilesResponse) obj;
        return hasRoutingProfileSummaryList() == other.hasRoutingProfileSummaryList()
                && Objects.equals(routingProfileSummaryList(), other.routingProfileSummaryList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListRoutingProfilesResponse")
                .add("RoutingProfileSummaryList", hasRoutingProfileSummaryList() ? routingProfileSummaryList() : null)
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RoutingProfileSummaryList":
            return Optional.ofNullable(clazz.cast(routingProfileSummaryList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRoutingProfilesResponse, T> g) {
        return obj -> g.apply((ListRoutingProfilesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListRoutingProfilesResponse> {
        /**
         * <p>
         * Information about the routing profiles.
         * </p>
         * 
         * @param routingProfileSummaryList
         *        Information about the routing profiles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingProfileSummaryList(Collection<RoutingProfileSummary> routingProfileSummaryList);

        /**
         * <p>
         * Information about the routing profiles.
         * </p>
         * 
         * @param routingProfileSummaryList
         *        Information about the routing profiles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingProfileSummaryList(RoutingProfileSummary... routingProfileSummaryList);

        /**
         * <p>
         * Information about the routing profiles.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RoutingProfileSummary>.Builder} avoiding
         * the need to create one manually via {@link List<RoutingProfileSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RoutingProfileSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #routingProfileSummaryList(List<RoutingProfileSummary>)}.
         * 
         * @param routingProfileSummaryList
         *        a consumer that will call methods on {@link List<RoutingProfileSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routingProfileSummaryList(List<RoutingProfileSummary>)
         */
        Builder routingProfileSummaryList(Consumer<RoutingProfileSummary.Builder>... routingProfileSummaryList);

        /**
         * <p>
         * If there are additional results, this is the token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        If there are additional results, this is the token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private List<RoutingProfileSummary> routingProfileSummaryList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRoutingProfilesResponse model) {
            super(model);
            routingProfileSummaryList(model.routingProfileSummaryList);
            nextToken(model.nextToken);
        }

        public final Collection<RoutingProfileSummary.Builder> getRoutingProfileSummaryList() {
            if (routingProfileSummaryList instanceof SdkAutoConstructList) {
                return null;
            }
            return routingProfileSummaryList != null ? routingProfileSummaryList.stream().map(RoutingProfileSummary::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder routingProfileSummaryList(Collection<RoutingProfileSummary> routingProfileSummaryList) {
            this.routingProfileSummaryList = RoutingProfileSummaryListCopier.copy(routingProfileSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routingProfileSummaryList(RoutingProfileSummary... routingProfileSummaryList) {
            routingProfileSummaryList(Arrays.asList(routingProfileSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routingProfileSummaryList(Consumer<RoutingProfileSummary.Builder>... routingProfileSummaryList) {
            routingProfileSummaryList(Stream.of(routingProfileSummaryList)
                    .map(c -> RoutingProfileSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRoutingProfileSummaryList(Collection<RoutingProfileSummary.BuilderImpl> routingProfileSummaryList) {
            this.routingProfileSummaryList = RoutingProfileSummaryListCopier.copyFromBuilder(routingProfileSummaryList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListRoutingProfilesResponse build() {
            return new ListRoutingProfilesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
