/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains summary information about a phone number for a contact center.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PhoneNumberSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<PhoneNumberSummary.Builder, PhoneNumberSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(PhoneNumberSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(PhoneNumberSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PhoneNumber").getter(getter(PhoneNumberSummary::phoneNumber)).setter(setter(Builder::phoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumber").build()).build();

    private static final SdkField<String> PHONE_NUMBER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PhoneNumberType").getter(getter(PhoneNumberSummary::phoneNumberTypeAsString))
            .setter(setter(Builder::phoneNumberType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumberType").build()).build();

    private static final SdkField<String> PHONE_NUMBER_COUNTRY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PhoneNumberCountryCode").getter(getter(PhoneNumberSummary::phoneNumberCountryCodeAsString))
            .setter(setter(Builder::phoneNumberCountryCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumberCountryCode").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            PHONE_NUMBER_FIELD, PHONE_NUMBER_TYPE_FIELD, PHONE_NUMBER_COUNTRY_CODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String arn;

    private final String phoneNumber;

    private final String phoneNumberType;

    private final String phoneNumberCountryCode;

    private PhoneNumberSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.phoneNumber = builder.phoneNumber;
        this.phoneNumberType = builder.phoneNumberType;
        this.phoneNumberCountryCode = builder.phoneNumberCountryCode;
    }

    /**
     * <p>
     * The identifier of the phone number.
     * </p>
     * 
     * @return The identifier of the phone number.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the phone number.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the phone number.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The phone number.
     * </p>
     * 
     * @return The phone number.
     */
    public String phoneNumber() {
        return phoneNumber;
    }

    /**
     * <p>
     * The type of phone number.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #phoneNumberType}
     * will return {@link PhoneNumberType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #phoneNumberTypeAsString}.
     * </p>
     * 
     * @return The type of phone number.
     * @see PhoneNumberType
     */
    public PhoneNumberType phoneNumberType() {
        return PhoneNumberType.fromValue(phoneNumberType);
    }

    /**
     * <p>
     * The type of phone number.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #phoneNumberType}
     * will return {@link PhoneNumberType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #phoneNumberTypeAsString}.
     * </p>
     * 
     * @return The type of phone number.
     * @see PhoneNumberType
     */
    public String phoneNumberTypeAsString() {
        return phoneNumberType;
    }

    /**
     * <p>
     * The ISO country code.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #phoneNumberCountryCode} will return {@link PhoneNumberCountryCode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #phoneNumberCountryCodeAsString}.
     * </p>
     * 
     * @return The ISO country code.
     * @see PhoneNumberCountryCode
     */
    public PhoneNumberCountryCode phoneNumberCountryCode() {
        return PhoneNumberCountryCode.fromValue(phoneNumberCountryCode);
    }

    /**
     * <p>
     * The ISO country code.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #phoneNumberCountryCode} will return {@link PhoneNumberCountryCode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #phoneNumberCountryCodeAsString}.
     * </p>
     * 
     * @return The ISO country code.
     * @see PhoneNumberCountryCode
     */
    public String phoneNumberCountryCodeAsString() {
        return phoneNumberCountryCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(phoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(phoneNumberTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(phoneNumberCountryCodeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PhoneNumberSummary)) {
            return false;
        }
        PhoneNumberSummary other = (PhoneNumberSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn())
                && Objects.equals(phoneNumber(), other.phoneNumber())
                && Objects.equals(phoneNumberTypeAsString(), other.phoneNumberTypeAsString())
                && Objects.equals(phoneNumberCountryCodeAsString(), other.phoneNumberCountryCodeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PhoneNumberSummary").add("Id", id()).add("Arn", arn()).add("PhoneNumber", phoneNumber())
                .add("PhoneNumberType", phoneNumberTypeAsString())
                .add("PhoneNumberCountryCode", phoneNumberCountryCodeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "PhoneNumber":
            return Optional.ofNullable(clazz.cast(phoneNumber()));
        case "PhoneNumberType":
            return Optional.ofNullable(clazz.cast(phoneNumberTypeAsString()));
        case "PhoneNumberCountryCode":
            return Optional.ofNullable(clazz.cast(phoneNumberCountryCodeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PhoneNumberSummary, T> g) {
        return obj -> g.apply((PhoneNumberSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PhoneNumberSummary> {
        /**
         * <p>
         * The identifier of the phone number.
         * </p>
         * 
         * @param id
         *        The identifier of the phone number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the phone number.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the phone number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The phone number.
         * </p>
         * 
         * @param phoneNumber
         *        The phone number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumber(String phoneNumber);

        /**
         * <p>
         * The type of phone number.
         * </p>
         * 
         * @param phoneNumberType
         *        The type of phone number.
         * @see PhoneNumberType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PhoneNumberType
         */
        Builder phoneNumberType(String phoneNumberType);

        /**
         * <p>
         * The type of phone number.
         * </p>
         * 
         * @param phoneNumberType
         *        The type of phone number.
         * @see PhoneNumberType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PhoneNumberType
         */
        Builder phoneNumberType(PhoneNumberType phoneNumberType);

        /**
         * <p>
         * The ISO country code.
         * </p>
         * 
         * @param phoneNumberCountryCode
         *        The ISO country code.
         * @see PhoneNumberCountryCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PhoneNumberCountryCode
         */
        Builder phoneNumberCountryCode(String phoneNumberCountryCode);

        /**
         * <p>
         * The ISO country code.
         * </p>
         * 
         * @param phoneNumberCountryCode
         *        The ISO country code.
         * @see PhoneNumberCountryCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PhoneNumberCountryCode
         */
        Builder phoneNumberCountryCode(PhoneNumberCountryCode phoneNumberCountryCode);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String phoneNumber;

        private String phoneNumberType;

        private String phoneNumberCountryCode;

        private BuilderImpl() {
        }

        private BuilderImpl(PhoneNumberSummary model) {
            id(model.id);
            arn(model.arn);
            phoneNumber(model.phoneNumber);
            phoneNumberType(model.phoneNumberType);
            phoneNumberCountryCode(model.phoneNumberCountryCode);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getPhoneNumber() {
            return phoneNumber;
        }

        @Override
        public final Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public final void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        public final String getPhoneNumberType() {
            return phoneNumberType;
        }

        @Override
        public final Builder phoneNumberType(String phoneNumberType) {
            this.phoneNumberType = phoneNumberType;
            return this;
        }

        @Override
        public final Builder phoneNumberType(PhoneNumberType phoneNumberType) {
            this.phoneNumberType(phoneNumberType == null ? null : phoneNumberType.toString());
            return this;
        }

        public final void setPhoneNumberType(String phoneNumberType) {
            this.phoneNumberType = phoneNumberType;
        }

        public final String getPhoneNumberCountryCode() {
            return phoneNumberCountryCode;
        }

        @Override
        public final Builder phoneNumberCountryCode(String phoneNumberCountryCode) {
            this.phoneNumberCountryCode = phoneNumberCountryCode;
            return this;
        }

        @Override
        public final Builder phoneNumberCountryCode(PhoneNumberCountryCode phoneNumberCountryCode) {
            this.phoneNumberCountryCode(phoneNumberCountryCode == null ? null : phoneNumberCountryCode.toString());
            return this;
        }

        public final void setPhoneNumberCountryCode(String phoneNumberCountryCode) {
            this.phoneNumberCountryCode = phoneNumberCountryCode;
        }

        @Override
        public PhoneNumberSummary build() {
            return new PhoneNumberSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
