/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartOutboundVoiceContactRequest extends ConnectRequest implements
        ToCopyableBuilder<StartOutboundVoiceContactRequest.Builder, StartOutboundVoiceContactRequest> {
    private static final SdkField<String> DESTINATION_PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationPhoneNumber").getter(getter(StartOutboundVoiceContactRequest::destinationPhoneNumber))
            .setter(setter(Builder::destinationPhoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPhoneNumber").build())
            .build();

    private static final SdkField<String> CONTACT_FLOW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactFlowId").getter(getter(StartOutboundVoiceContactRequest::contactFlowId))
            .setter(setter(Builder::contactFlowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactFlowId").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(StartOutboundVoiceContactRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(StartOutboundVoiceContactRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> SOURCE_PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourcePhoneNumber").getter(getter(StartOutboundVoiceContactRequest::sourcePhoneNumber))
            .setter(setter(Builder::sourcePhoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourcePhoneNumber").build()).build();

    private static final SdkField<String> QUEUE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueueId").getter(getter(StartOutboundVoiceContactRequest::queueId)).setter(setter(Builder::queueId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueId").build()).build();

    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Attributes")
            .getter(getter(StartOutboundVoiceContactRequest::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DESTINATION_PHONE_NUMBER_FIELD, CONTACT_FLOW_ID_FIELD, INSTANCE_ID_FIELD, CLIENT_TOKEN_FIELD,
            SOURCE_PHONE_NUMBER_FIELD, QUEUE_ID_FIELD, ATTRIBUTES_FIELD));

    private final String destinationPhoneNumber;

    private final String contactFlowId;

    private final String instanceId;

    private final String clientToken;

    private final String sourcePhoneNumber;

    private final String queueId;

    private final Map<String, String> attributes;

    private StartOutboundVoiceContactRequest(BuilderImpl builder) {
        super(builder);
        this.destinationPhoneNumber = builder.destinationPhoneNumber;
        this.contactFlowId = builder.contactFlowId;
        this.instanceId = builder.instanceId;
        this.clientToken = builder.clientToken;
        this.sourcePhoneNumber = builder.sourcePhoneNumber;
        this.queueId = builder.queueId;
        this.attributes = builder.attributes;
    }

    /**
     * <p>
     * The phone number of the customer, in E.164 format.
     * </p>
     * 
     * @return The phone number of the customer, in E.164 format.
     */
    public String destinationPhoneNumber() {
        return destinationPhoneNumber;
    }

    /**
     * <p>
     * The identifier of the contact flow for the outbound call. To see the ContactFlowId in the Amazon Connect console
     * user interface, on the navigation menu go to <b>Routing</b>, <b>Contact Flows</b>. Choose the contact flow. On
     * the contact flow page, under the name of the contact flow, choose <b>Show additional flow information</b>. The
     * ContactFlowId is the last part of the ARN, shown here in bold:
     * </p>
     * <p>
     * arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow/<b>
     * 846ec553-a005-41c0-8341-xxxxxxxxxxxx</b>
     * </p>
     * 
     * @return The identifier of the contact flow for the outbound call. To see the ContactFlowId in the Amazon Connect
     *         console user interface, on the navigation menu go to <b>Routing</b>, <b>Contact Flows</b>. Choose the
     *         contact flow. On the contact flow page, under the name of the contact flow, choose <b>Show additional
     *         flow information</b>. The ContactFlowId is the last part of the ARN, shown here in bold: </p>
     *         <p>
     *         arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow/<b>
     *         846ec553-a005-41c0-8341-xxxxxxxxxxxx</b>
     */
    public String contactFlowId() {
        return contactFlowId;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. The token is valid
     * for 7 days after creation. If a contact is already started, the contact ID is returned. If the contact is
     * disconnected, a new contact is started.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. The token
     *         is valid for 7 days after creation. If a contact is already started, the contact ID is returned. If the
     *         contact is disconnected, a new contact is started.
     */
    public String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The phone number associated with the Amazon Connect instance, in E.164 format. If you do not specify a source
     * phone number, you must specify a queue.
     * </p>
     * 
     * @return The phone number associated with the Amazon Connect instance, in E.164 format. If you do not specify a
     *         source phone number, you must specify a queue.
     */
    public String sourcePhoneNumber() {
        return sourcePhoneNumber;
    }

    /**
     * <p>
     * The queue for the call. If you specify a queue, the phone displayed for caller ID is the phone number specified
     * in the queue. If you do not specify a queue, the queue defined in the contact flow is used. If you do not specify
     * a queue, you must specify a source phone number.
     * </p>
     * 
     * @return The queue for the call. If you specify a queue, the phone displayed for caller ID is the phone number
     *         specified in the queue. If you do not specify a queue, the queue defined in the contact flow is used. If
     *         you do not specify a queue, you must specify a source phone number.
     */
    public String queueId() {
        return queueId;
    }

    /**
     * Returns true if the Attributes property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes, and can be
     * accessed in contact flows just like any other contact attributes.
     * </p>
     * <p>
     * There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can include only
     * alphanumeric, dash, and underscore characters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAttributes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes,
     *         and can be accessed in contact flows just like any other contact attributes.</p>
     *         <p>
     *         There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can include
     *         only alphanumeric, dash, and underscore characters.
     */
    public Map<String, String> attributes() {
        return attributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(destinationPhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(contactFlowId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(sourcePhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(queueId());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributes() ? attributes() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartOutboundVoiceContactRequest)) {
            return false;
        }
        StartOutboundVoiceContactRequest other = (StartOutboundVoiceContactRequest) obj;
        return Objects.equals(destinationPhoneNumber(), other.destinationPhoneNumber())
                && Objects.equals(contactFlowId(), other.contactFlowId()) && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(sourcePhoneNumber(), other.sourcePhoneNumber()) && Objects.equals(queueId(), other.queueId())
                && hasAttributes() == other.hasAttributes() && Objects.equals(attributes(), other.attributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("StartOutboundVoiceContactRequest").add("DestinationPhoneNumber", destinationPhoneNumber())
                .add("ContactFlowId", contactFlowId()).add("InstanceId", instanceId()).add("ClientToken", clientToken())
                .add("SourcePhoneNumber", sourcePhoneNumber()).add("QueueId", queueId())
                .add("Attributes", hasAttributes() ? attributes() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DestinationPhoneNumber":
            return Optional.ofNullable(clazz.cast(destinationPhoneNumber()));
        case "ContactFlowId":
            return Optional.ofNullable(clazz.cast(contactFlowId()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "SourcePhoneNumber":
            return Optional.ofNullable(clazz.cast(sourcePhoneNumber()));
        case "QueueId":
            return Optional.ofNullable(clazz.cast(queueId()));
        case "Attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartOutboundVoiceContactRequest, T> g) {
        return obj -> g.apply((StartOutboundVoiceContactRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartOutboundVoiceContactRequest> {
        /**
         * <p>
         * The phone number of the customer, in E.164 format.
         * </p>
         * 
         * @param destinationPhoneNumber
         *        The phone number of the customer, in E.164 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPhoneNumber(String destinationPhoneNumber);

        /**
         * <p>
         * The identifier of the contact flow for the outbound call. To see the ContactFlowId in the Amazon Connect
         * console user interface, on the navigation menu go to <b>Routing</b>, <b>Contact Flows</b>. Choose the contact
         * flow. On the contact flow page, under the name of the contact flow, choose <b>Show additional flow
         * information</b>. The ContactFlowId is the last part of the ARN, shown here in bold:
         * </p>
         * <p>
         * arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow/<b>
         * 846ec553-a005-41c0-8341-xxxxxxxxxxxx</b>
         * </p>
         * 
         * @param contactFlowId
         *        The identifier of the contact flow for the outbound call. To see the ContactFlowId in the Amazon
         *        Connect console user interface, on the navigation menu go to <b>Routing</b>, <b>Contact Flows</b>.
         *        Choose the contact flow. On the contact flow page, under the name of the contact flow, choose <b>Show
         *        additional flow information</b>. The ContactFlowId is the last part of the ARN, shown here in bold:
         *        </p>
         *        <p>
         *        arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow/<b>
         *        846ec553-a005-41c0-8341-xxxxxxxxxxxx</b>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactFlowId(String contactFlowId);

        /**
         * <p>
         * The identifier of the Amazon Connect instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. The token is
         * valid for 7 days after creation. If a contact is already started, the contact ID is returned. If the contact
         * is disconnected, a new contact is started.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. The
         *        token is valid for 7 days after creation. If a contact is already started, the contact ID is returned.
         *        If the contact is disconnected, a new contact is started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The phone number associated with the Amazon Connect instance, in E.164 format. If you do not specify a source
         * phone number, you must specify a queue.
         * </p>
         * 
         * @param sourcePhoneNumber
         *        The phone number associated with the Amazon Connect instance, in E.164 format. If you do not specify a
         *        source phone number, you must specify a queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourcePhoneNumber(String sourcePhoneNumber);

        /**
         * <p>
         * The queue for the call. If you specify a queue, the phone displayed for caller ID is the phone number
         * specified in the queue. If you do not specify a queue, the queue defined in the contact flow is used. If you
         * do not specify a queue, you must specify a source phone number.
         * </p>
         * 
         * @param queueId
         *        The queue for the call. If you specify a queue, the phone displayed for caller ID is the phone number
         *        specified in the queue. If you do not specify a queue, the queue defined in the contact flow is used.
         *        If you do not specify a queue, you must specify a source phone number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueId(String queueId);

        /**
         * <p>
         * A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes, and
         * can be accessed in contact flows just like any other contact attributes.
         * </p>
         * <p>
         * There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can include only
         * alphanumeric, dash, and underscore characters.
         * </p>
         * 
         * @param attributes
         *        A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes,
         *        and can be accessed in contact flows just like any other contact attributes.</p>
         *        <p>
         *        There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can
         *        include only alphanumeric, dash, and underscore characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String destinationPhoneNumber;

        private String contactFlowId;

        private String instanceId;

        private String clientToken;

        private String sourcePhoneNumber;

        private String queueId;

        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartOutboundVoiceContactRequest model) {
            super(model);
            destinationPhoneNumber(model.destinationPhoneNumber);
            contactFlowId(model.contactFlowId);
            instanceId(model.instanceId);
            clientToken(model.clientToken);
            sourcePhoneNumber(model.sourcePhoneNumber);
            queueId(model.queueId);
            attributes(model.attributes);
        }

        public final String getDestinationPhoneNumber() {
            return destinationPhoneNumber;
        }

        @Override
        public final Builder destinationPhoneNumber(String destinationPhoneNumber) {
            this.destinationPhoneNumber = destinationPhoneNumber;
            return this;
        }

        public final void setDestinationPhoneNumber(String destinationPhoneNumber) {
            this.destinationPhoneNumber = destinationPhoneNumber;
        }

        public final String getContactFlowId() {
            return contactFlowId;
        }

        @Override
        public final Builder contactFlowId(String contactFlowId) {
            this.contactFlowId = contactFlowId;
            return this;
        }

        public final void setContactFlowId(String contactFlowId) {
            this.contactFlowId = contactFlowId;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getSourcePhoneNumber() {
            return sourcePhoneNumber;
        }

        @Override
        public final Builder sourcePhoneNumber(String sourcePhoneNumber) {
            this.sourcePhoneNumber = sourcePhoneNumber;
            return this;
        }

        public final void setSourcePhoneNumber(String sourcePhoneNumber) {
            this.sourcePhoneNumber = sourcePhoneNumber;
        }

        public final String getQueueId() {
            return queueId;
        }

        @Override
        public final Builder queueId(String queueId) {
            this.queueId = queueId;
            return this;
        }

        public final void setQueueId(String queueId) {
            this.queueId = queueId;
        }

        public final Map<String, String> getAttributes() {
            if (attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartOutboundVoiceContactRequest build() {
            return new StartOutboundVoiceContactRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
