/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the level hierarchy to update.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HierarchyStructureUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<HierarchyStructureUpdate.Builder, HierarchyStructureUpdate> {
    private static final SdkField<HierarchyLevelUpdate> LEVEL_ONE_FIELD = SdkField
            .<HierarchyLevelUpdate> builder(MarshallingType.SDK_POJO).memberName("LevelOne")
            .getter(getter(HierarchyStructureUpdate::levelOne)).setter(setter(Builder::levelOne))
            .constructor(HierarchyLevelUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LevelOne").build()).build();

    private static final SdkField<HierarchyLevelUpdate> LEVEL_TWO_FIELD = SdkField
            .<HierarchyLevelUpdate> builder(MarshallingType.SDK_POJO).memberName("LevelTwo")
            .getter(getter(HierarchyStructureUpdate::levelTwo)).setter(setter(Builder::levelTwo))
            .constructor(HierarchyLevelUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LevelTwo").build()).build();

    private static final SdkField<HierarchyLevelUpdate> LEVEL_THREE_FIELD = SdkField
            .<HierarchyLevelUpdate> builder(MarshallingType.SDK_POJO).memberName("LevelThree")
            .getter(getter(HierarchyStructureUpdate::levelThree)).setter(setter(Builder::levelThree))
            .constructor(HierarchyLevelUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LevelThree").build()).build();

    private static final SdkField<HierarchyLevelUpdate> LEVEL_FOUR_FIELD = SdkField
            .<HierarchyLevelUpdate> builder(MarshallingType.SDK_POJO).memberName("LevelFour")
            .getter(getter(HierarchyStructureUpdate::levelFour)).setter(setter(Builder::levelFour))
            .constructor(HierarchyLevelUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LevelFour").build()).build();

    private static final SdkField<HierarchyLevelUpdate> LEVEL_FIVE_FIELD = SdkField
            .<HierarchyLevelUpdate> builder(MarshallingType.SDK_POJO).memberName("LevelFive")
            .getter(getter(HierarchyStructureUpdate::levelFive)).setter(setter(Builder::levelFive))
            .constructor(HierarchyLevelUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LevelFive").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LEVEL_ONE_FIELD,
            LEVEL_TWO_FIELD, LEVEL_THREE_FIELD, LEVEL_FOUR_FIELD, LEVEL_FIVE_FIELD));

    private static final long serialVersionUID = 1L;

    private final HierarchyLevelUpdate levelOne;

    private final HierarchyLevelUpdate levelTwo;

    private final HierarchyLevelUpdate levelThree;

    private final HierarchyLevelUpdate levelFour;

    private final HierarchyLevelUpdate levelFive;

    private HierarchyStructureUpdate(BuilderImpl builder) {
        this.levelOne = builder.levelOne;
        this.levelTwo = builder.levelTwo;
        this.levelThree = builder.levelThree;
        this.levelFour = builder.levelFour;
        this.levelFive = builder.levelFive;
    }

    /**
     * <p>
     * The update for level one.
     * </p>
     * 
     * @return The update for level one.
     */
    public final HierarchyLevelUpdate levelOne() {
        return levelOne;
    }

    /**
     * <p>
     * The update for level two.
     * </p>
     * 
     * @return The update for level two.
     */
    public final HierarchyLevelUpdate levelTwo() {
        return levelTwo;
    }

    /**
     * <p>
     * The update for level three.
     * </p>
     * 
     * @return The update for level three.
     */
    public final HierarchyLevelUpdate levelThree() {
        return levelThree;
    }

    /**
     * <p>
     * The update for level four.
     * </p>
     * 
     * @return The update for level four.
     */
    public final HierarchyLevelUpdate levelFour() {
        return levelFour;
    }

    /**
     * <p>
     * The update for level five.
     * </p>
     * 
     * @return The update for level five.
     */
    public final HierarchyLevelUpdate levelFive() {
        return levelFive;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(levelOne());
        hashCode = 31 * hashCode + Objects.hashCode(levelTwo());
        hashCode = 31 * hashCode + Objects.hashCode(levelThree());
        hashCode = 31 * hashCode + Objects.hashCode(levelFour());
        hashCode = 31 * hashCode + Objects.hashCode(levelFive());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HierarchyStructureUpdate)) {
            return false;
        }
        HierarchyStructureUpdate other = (HierarchyStructureUpdate) obj;
        return Objects.equals(levelOne(), other.levelOne()) && Objects.equals(levelTwo(), other.levelTwo())
                && Objects.equals(levelThree(), other.levelThree()) && Objects.equals(levelFour(), other.levelFour())
                && Objects.equals(levelFive(), other.levelFive());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HierarchyStructureUpdate").add("LevelOne", levelOne()).add("LevelTwo", levelTwo())
                .add("LevelThree", levelThree()).add("LevelFour", levelFour()).add("LevelFive", levelFive()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LevelOne":
            return Optional.ofNullable(clazz.cast(levelOne()));
        case "LevelTwo":
            return Optional.ofNullable(clazz.cast(levelTwo()));
        case "LevelThree":
            return Optional.ofNullable(clazz.cast(levelThree()));
        case "LevelFour":
            return Optional.ofNullable(clazz.cast(levelFour()));
        case "LevelFive":
            return Optional.ofNullable(clazz.cast(levelFive()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HierarchyStructureUpdate, T> g) {
        return obj -> g.apply((HierarchyStructureUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HierarchyStructureUpdate> {
        /**
         * <p>
         * The update for level one.
         * </p>
         * 
         * @param levelOne
         *        The update for level one.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder levelOne(HierarchyLevelUpdate levelOne);

        /**
         * <p>
         * The update for level one.
         * </p>
         * This is a convenience that creates an instance of the {@link HierarchyLevelUpdate.Builder} avoiding the need
         * to create one manually via {@link HierarchyLevelUpdate#builder()}.
         *
         * When the {@link Consumer} completes, {@link HierarchyLevelUpdate.Builder#build()} is called immediately and
         * its result is passed to {@link #levelOne(HierarchyLevelUpdate)}.
         * 
         * @param levelOne
         *        a consumer that will call methods on {@link HierarchyLevelUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #levelOne(HierarchyLevelUpdate)
         */
        default Builder levelOne(Consumer<HierarchyLevelUpdate.Builder> levelOne) {
            return levelOne(HierarchyLevelUpdate.builder().applyMutation(levelOne).build());
        }

        /**
         * <p>
         * The update for level two.
         * </p>
         * 
         * @param levelTwo
         *        The update for level two.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder levelTwo(HierarchyLevelUpdate levelTwo);

        /**
         * <p>
         * The update for level two.
         * </p>
         * This is a convenience that creates an instance of the {@link HierarchyLevelUpdate.Builder} avoiding the need
         * to create one manually via {@link HierarchyLevelUpdate#builder()}.
         *
         * When the {@link Consumer} completes, {@link HierarchyLevelUpdate.Builder#build()} is called immediately and
         * its result is passed to {@link #levelTwo(HierarchyLevelUpdate)}.
         * 
         * @param levelTwo
         *        a consumer that will call methods on {@link HierarchyLevelUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #levelTwo(HierarchyLevelUpdate)
         */
        default Builder levelTwo(Consumer<HierarchyLevelUpdate.Builder> levelTwo) {
            return levelTwo(HierarchyLevelUpdate.builder().applyMutation(levelTwo).build());
        }

        /**
         * <p>
         * The update for level three.
         * </p>
         * 
         * @param levelThree
         *        The update for level three.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder levelThree(HierarchyLevelUpdate levelThree);

        /**
         * <p>
         * The update for level three.
         * </p>
         * This is a convenience that creates an instance of the {@link HierarchyLevelUpdate.Builder} avoiding the need
         * to create one manually via {@link HierarchyLevelUpdate#builder()}.
         *
         * When the {@link Consumer} completes, {@link HierarchyLevelUpdate.Builder#build()} is called immediately and
         * its result is passed to {@link #levelThree(HierarchyLevelUpdate)}.
         * 
         * @param levelThree
         *        a consumer that will call methods on {@link HierarchyLevelUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #levelThree(HierarchyLevelUpdate)
         */
        default Builder levelThree(Consumer<HierarchyLevelUpdate.Builder> levelThree) {
            return levelThree(HierarchyLevelUpdate.builder().applyMutation(levelThree).build());
        }

        /**
         * <p>
         * The update for level four.
         * </p>
         * 
         * @param levelFour
         *        The update for level four.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder levelFour(HierarchyLevelUpdate levelFour);

        /**
         * <p>
         * The update for level four.
         * </p>
         * This is a convenience that creates an instance of the {@link HierarchyLevelUpdate.Builder} avoiding the need
         * to create one manually via {@link HierarchyLevelUpdate#builder()}.
         *
         * When the {@link Consumer} completes, {@link HierarchyLevelUpdate.Builder#build()} is called immediately and
         * its result is passed to {@link #levelFour(HierarchyLevelUpdate)}.
         * 
         * @param levelFour
         *        a consumer that will call methods on {@link HierarchyLevelUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #levelFour(HierarchyLevelUpdate)
         */
        default Builder levelFour(Consumer<HierarchyLevelUpdate.Builder> levelFour) {
            return levelFour(HierarchyLevelUpdate.builder().applyMutation(levelFour).build());
        }

        /**
         * <p>
         * The update for level five.
         * </p>
         * 
         * @param levelFive
         *        The update for level five.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder levelFive(HierarchyLevelUpdate levelFive);

        /**
         * <p>
         * The update for level five.
         * </p>
         * This is a convenience that creates an instance of the {@link HierarchyLevelUpdate.Builder} avoiding the need
         * to create one manually via {@link HierarchyLevelUpdate#builder()}.
         *
         * When the {@link Consumer} completes, {@link HierarchyLevelUpdate.Builder#build()} is called immediately and
         * its result is passed to {@link #levelFive(HierarchyLevelUpdate)}.
         * 
         * @param levelFive
         *        a consumer that will call methods on {@link HierarchyLevelUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #levelFive(HierarchyLevelUpdate)
         */
        default Builder levelFive(Consumer<HierarchyLevelUpdate.Builder> levelFive) {
            return levelFive(HierarchyLevelUpdate.builder().applyMutation(levelFive).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private HierarchyLevelUpdate levelOne;

        private HierarchyLevelUpdate levelTwo;

        private HierarchyLevelUpdate levelThree;

        private HierarchyLevelUpdate levelFour;

        private HierarchyLevelUpdate levelFive;

        private BuilderImpl() {
        }

        private BuilderImpl(HierarchyStructureUpdate model) {
            levelOne(model.levelOne);
            levelTwo(model.levelTwo);
            levelThree(model.levelThree);
            levelFour(model.levelFour);
            levelFive(model.levelFive);
        }

        public final HierarchyLevelUpdate.Builder getLevelOne() {
            return levelOne != null ? levelOne.toBuilder() : null;
        }

        @Override
        public final Builder levelOne(HierarchyLevelUpdate levelOne) {
            this.levelOne = levelOne;
            return this;
        }

        public final void setLevelOne(HierarchyLevelUpdate.BuilderImpl levelOne) {
            this.levelOne = levelOne != null ? levelOne.build() : null;
        }

        public final HierarchyLevelUpdate.Builder getLevelTwo() {
            return levelTwo != null ? levelTwo.toBuilder() : null;
        }

        @Override
        public final Builder levelTwo(HierarchyLevelUpdate levelTwo) {
            this.levelTwo = levelTwo;
            return this;
        }

        public final void setLevelTwo(HierarchyLevelUpdate.BuilderImpl levelTwo) {
            this.levelTwo = levelTwo != null ? levelTwo.build() : null;
        }

        public final HierarchyLevelUpdate.Builder getLevelThree() {
            return levelThree != null ? levelThree.toBuilder() : null;
        }

        @Override
        public final Builder levelThree(HierarchyLevelUpdate levelThree) {
            this.levelThree = levelThree;
            return this;
        }

        public final void setLevelThree(HierarchyLevelUpdate.BuilderImpl levelThree) {
            this.levelThree = levelThree != null ? levelThree.build() : null;
        }

        public final HierarchyLevelUpdate.Builder getLevelFour() {
            return levelFour != null ? levelFour.toBuilder() : null;
        }

        @Override
        public final Builder levelFour(HierarchyLevelUpdate levelFour) {
            this.levelFour = levelFour;
            return this;
        }

        public final void setLevelFour(HierarchyLevelUpdate.BuilderImpl levelFour) {
            this.levelFour = levelFour != null ? levelFour.build() : null;
        }

        public final HierarchyLevelUpdate.Builder getLevelFive() {
            return levelFive != null ? levelFive.toBuilder() : null;
        }

        @Override
        public final Builder levelFive(HierarchyLevelUpdate levelFive) {
            this.levelFive = levelFive;
            return this;
        }

        public final void setLevelFive(HierarchyLevelUpdate.BuilderImpl levelFive) {
            this.levelFive = levelFive != null ? levelFive.build() : null;
        }

        @Override
        public HierarchyStructureUpdate build() {
            return new HierarchyStructureUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
