/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListUserHierarchyGroupsResponse extends ConnectResponse implements
        ToCopyableBuilder<ListUserHierarchyGroupsResponse.Builder, ListUserHierarchyGroupsResponse> {
    private static final SdkField<List<HierarchyGroupSummary>> USER_HIERARCHY_GROUP_SUMMARY_LIST_FIELD = SdkField
            .<List<HierarchyGroupSummary>> builder(MarshallingType.LIST)
            .memberName("UserHierarchyGroupSummaryList")
            .getter(getter(ListUserHierarchyGroupsResponse::userHierarchyGroupSummaryList))
            .setter(setter(Builder::userHierarchyGroupSummaryList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserHierarchyGroupSummaryList")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HierarchyGroupSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(HierarchyGroupSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListUserHierarchyGroupsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            USER_HIERARCHY_GROUP_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));

    private final List<HierarchyGroupSummary> userHierarchyGroupSummaryList;

    private final String nextToken;

    private ListUserHierarchyGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.userHierarchyGroupSummaryList = builder.userHierarchyGroupSummaryList;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the UserHierarchyGroupSummaryList property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public final boolean hasUserHierarchyGroupSummaryList() {
        return userHierarchyGroupSummaryList != null && !(userHierarchyGroupSummaryList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the hierarchy groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUserHierarchyGroupSummaryList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the hierarchy groups.
     */
    public final List<HierarchyGroupSummary> userHierarchyGroupSummaryList() {
        return userHierarchyGroupSummaryList;
    }

    /**
     * <p>
     * If there are additional results, this is the token for the next set of results.
     * </p>
     * 
     * @return If there are additional results, this is the token for the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasUserHierarchyGroupSummaryList() ? userHierarchyGroupSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListUserHierarchyGroupsResponse)) {
            return false;
        }
        ListUserHierarchyGroupsResponse other = (ListUserHierarchyGroupsResponse) obj;
        return hasUserHierarchyGroupSummaryList() == other.hasUserHierarchyGroupSummaryList()
                && Objects.equals(userHierarchyGroupSummaryList(), other.userHierarchyGroupSummaryList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ListUserHierarchyGroupsResponse")
                .add("UserHierarchyGroupSummaryList", hasUserHierarchyGroupSummaryList() ? userHierarchyGroupSummaryList() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserHierarchyGroupSummaryList":
            return Optional.ofNullable(clazz.cast(userHierarchyGroupSummaryList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListUserHierarchyGroupsResponse, T> g) {
        return obj -> g.apply((ListUserHierarchyGroupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListUserHierarchyGroupsResponse> {
        /**
         * <p>
         * Information about the hierarchy groups.
         * </p>
         * 
         * @param userHierarchyGroupSummaryList
         *        Information about the hierarchy groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userHierarchyGroupSummaryList(Collection<HierarchyGroupSummary> userHierarchyGroupSummaryList);

        /**
         * <p>
         * Information about the hierarchy groups.
         * </p>
         * 
         * @param userHierarchyGroupSummaryList
         *        Information about the hierarchy groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userHierarchyGroupSummaryList(HierarchyGroupSummary... userHierarchyGroupSummaryList);

        /**
         * <p>
         * Information about the hierarchy groups.
         * </p>
         * This is a convenience that creates an instance of the {@link List<HierarchyGroupSummary>.Builder} avoiding
         * the need to create one manually via {@link List<HierarchyGroupSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<HierarchyGroupSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #userHierarchyGroupSummaryList(List<HierarchyGroupSummary>)}.
         * 
         * @param userHierarchyGroupSummaryList
         *        a consumer that will call methods on {@link List<HierarchyGroupSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userHierarchyGroupSummaryList(List<HierarchyGroupSummary>)
         */
        Builder userHierarchyGroupSummaryList(Consumer<HierarchyGroupSummary.Builder>... userHierarchyGroupSummaryList);

        /**
         * <p>
         * If there are additional results, this is the token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        If there are additional results, this is the token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private List<HierarchyGroupSummary> userHierarchyGroupSummaryList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListUserHierarchyGroupsResponse model) {
            super(model);
            userHierarchyGroupSummaryList(model.userHierarchyGroupSummaryList);
            nextToken(model.nextToken);
        }

        public final List<HierarchyGroupSummary.Builder> getUserHierarchyGroupSummaryList() {
            List<HierarchyGroupSummary.Builder> result = HierarchyGroupSummaryListCopier
                    .copyToBuilder(this.userHierarchyGroupSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder userHierarchyGroupSummaryList(Collection<HierarchyGroupSummary> userHierarchyGroupSummaryList) {
            this.userHierarchyGroupSummaryList = HierarchyGroupSummaryListCopier.copy(userHierarchyGroupSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userHierarchyGroupSummaryList(HierarchyGroupSummary... userHierarchyGroupSummaryList) {
            userHierarchyGroupSummaryList(Arrays.asList(userHierarchyGroupSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userHierarchyGroupSummaryList(
                Consumer<HierarchyGroupSummary.Builder>... userHierarchyGroupSummaryList) {
            userHierarchyGroupSummaryList(Stream.of(userHierarchyGroupSummaryList)
                    .map(c -> HierarchyGroupSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUserHierarchyGroupSummaryList(
                Collection<HierarchyGroupSummary.BuilderImpl> userHierarchyGroupSummaryList) {
            this.userHierarchyGroupSummaryList = HierarchyGroupSummaryListCopier.copyFromBuilder(userHierarchyGroupSummaryList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListUserHierarchyGroupsResponse build() {
            return new ListUserHierarchyGroupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
