/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListQueueQuickConnectsResponse extends ConnectResponse implements
        ToCopyableBuilder<ListQueueQuickConnectsResponse.Builder, ListQueueQuickConnectsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListQueueQuickConnectsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<QuickConnectSummary>> QUICK_CONNECT_SUMMARY_LIST_FIELD = SdkField
            .<List<QuickConnectSummary>> builder(MarshallingType.LIST)
            .memberName("QuickConnectSummaryList")
            .getter(getter(ListQueueQuickConnectsResponse::quickConnectSummaryList))
            .setter(setter(Builder::quickConnectSummaryList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuickConnectSummaryList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<QuickConnectSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(QuickConnectSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            QUICK_CONNECT_SUMMARY_LIST_FIELD));

    private final String nextToken;

    private final List<QuickConnectSummary> quickConnectSummaryList;

    private ListQueueQuickConnectsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.quickConnectSummaryList = builder.quickConnectSummaryList;
    }

    /**
     * <p>
     * If there are additional results, this is the token for the next set of results.
     * </p>
     * 
     * @return If there are additional results, this is the token for the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the QuickConnectSummaryList property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasQuickConnectSummaryList() {
        return quickConnectSummaryList != null && !(quickConnectSummaryList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the quick connects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasQuickConnectSummaryList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the quick connects.
     */
    public final List<QuickConnectSummary> quickConnectSummaryList() {
        return quickConnectSummaryList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasQuickConnectSummaryList() ? quickConnectSummaryList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListQueueQuickConnectsResponse)) {
            return false;
        }
        ListQueueQuickConnectsResponse other = (ListQueueQuickConnectsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && hasQuickConnectSummaryList() == other.hasQuickConnectSummaryList()
                && Objects.equals(quickConnectSummaryList(), other.quickConnectSummaryList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListQueueQuickConnectsResponse").add("NextToken", nextToken())
                .add("QuickConnectSummaryList", hasQuickConnectSummaryList() ? quickConnectSummaryList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "QuickConnectSummaryList":
            return Optional.ofNullable(clazz.cast(quickConnectSummaryList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListQueueQuickConnectsResponse, T> g) {
        return obj -> g.apply((ListQueueQuickConnectsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListQueueQuickConnectsResponse> {
        /**
         * <p>
         * If there are additional results, this is the token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        If there are additional results, this is the token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Information about the quick connects.
         * </p>
         * 
         * @param quickConnectSummaryList
         *        Information about the quick connects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quickConnectSummaryList(Collection<QuickConnectSummary> quickConnectSummaryList);

        /**
         * <p>
         * Information about the quick connects.
         * </p>
         * 
         * @param quickConnectSummaryList
         *        Information about the quick connects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quickConnectSummaryList(QuickConnectSummary... quickConnectSummaryList);

        /**
         * <p>
         * Information about the quick connects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<QuickConnectSummary>.Builder} avoiding the
         * need to create one manually via {@link List<QuickConnectSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<QuickConnectSummary>.Builder#build()} is called immediately
         * and its result is passed to {@link #quickConnectSummaryList(List<QuickConnectSummary>)}.
         * 
         * @param quickConnectSummaryList
         *        a consumer that will call methods on {@link List<QuickConnectSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #quickConnectSummaryList(List<QuickConnectSummary>)
         */
        Builder quickConnectSummaryList(Consumer<QuickConnectSummary.Builder>... quickConnectSummaryList);
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<QuickConnectSummary> quickConnectSummaryList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListQueueQuickConnectsResponse model) {
            super(model);
            nextToken(model.nextToken);
            quickConnectSummaryList(model.quickConnectSummaryList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final List<QuickConnectSummary.Builder> getQuickConnectSummaryList() {
            List<QuickConnectSummary.Builder> result = QuickConnectSummaryListCopier.copyToBuilder(this.quickConnectSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder quickConnectSummaryList(Collection<QuickConnectSummary> quickConnectSummaryList) {
            this.quickConnectSummaryList = QuickConnectSummaryListCopier.copy(quickConnectSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder quickConnectSummaryList(QuickConnectSummary... quickConnectSummaryList) {
            quickConnectSummaryList(Arrays.asList(quickConnectSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder quickConnectSummaryList(Consumer<QuickConnectSummary.Builder>... quickConnectSummaryList) {
            quickConnectSummaryList(Stream.of(quickConnectSummaryList)
                    .map(c -> QuickConnectSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setQuickConnectSummaryList(Collection<QuickConnectSummary.BuilderImpl> quickConnectSummaryList) {
            this.quickConnectSummaryList = QuickConnectSummaryListCopier.copyFromBuilder(quickConnectSummaryList);
        }

        @Override
        public ListQueueQuickConnectsResponse build() {
            return new ListQueueQuickConnectsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
