/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateBotRequest extends ConnectRequest implements
        ToCopyableBuilder<AssociateBotRequest.Builder, AssociateBotRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(AssociateBotRequest::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final SdkField<LexBot> LEX_BOT_FIELD = SdkField.<LexBot> builder(MarshallingType.SDK_POJO)
            .memberName("LexBot").getter(getter(AssociateBotRequest::lexBot)).setter(setter(Builder::lexBot))
            .constructor(LexBot::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LexBot").build()).build();

    private static final SdkField<LexV2Bot> LEX_V2_BOT_FIELD = SdkField.<LexV2Bot> builder(MarshallingType.SDK_POJO)
            .memberName("LexV2Bot").getter(getter(AssociateBotRequest::lexV2Bot)).setter(setter(Builder::lexV2Bot))
            .constructor(LexV2Bot::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LexV2Bot").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            LEX_BOT_FIELD, LEX_V2_BOT_FIELD));

    private final String instanceId;

    private final LexBot lexBot;

    private final LexV2Bot lexV2Bot;

    private AssociateBotRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.lexBot = builder.lexBot;
        this.lexV2Bot = builder.lexV2Bot;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * Returns the value of the LexBot property for this object.
     * 
     * @return The value of the LexBot property for this object.
     */
    public final LexBot lexBot() {
        return lexBot;
    }

    /**
     * <p>
     * The Amazon Lex V2 bot to associate with the instance.
     * </p>
     * 
     * @return The Amazon Lex V2 bot to associate with the instance.
     */
    public final LexV2Bot lexV2Bot() {
        return lexV2Bot;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(lexBot());
        hashCode = 31 * hashCode + Objects.hashCode(lexV2Bot());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateBotRequest)) {
            return false;
        }
        AssociateBotRequest other = (AssociateBotRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(lexBot(), other.lexBot())
                && Objects.equals(lexV2Bot(), other.lexV2Bot());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateBotRequest").add("InstanceId", instanceId()).add("LexBot", lexBot())
                .add("LexV2Bot", lexV2Bot()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "LexBot":
            return Optional.ofNullable(clazz.cast(lexBot()));
        case "LexV2Bot":
            return Optional.ofNullable(clazz.cast(lexV2Bot()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateBotRequest, T> g) {
        return obj -> g.apply((AssociateBotRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, AssociateBotRequest> {
        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * Sets the value of the LexBot property for this object.
         *
         * @param lexBot
         *        The new value for the LexBot property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lexBot(LexBot lexBot);

        /**
         * Sets the value of the LexBot property for this object.
         *
         * This is a convenience that creates an instance of the {@link LexBot.Builder} avoiding the need to create one
         * manually via {@link LexBot#builder()}.
         *
         * When the {@link Consumer} completes, {@link LexBot.Builder#build()} is called immediately and its result is
         * passed to {@link #lexBot(LexBot)}.
         * 
         * @param lexBot
         *        a consumer that will call methods on {@link LexBot.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lexBot(LexBot)
         */
        default Builder lexBot(Consumer<LexBot.Builder> lexBot) {
            return lexBot(LexBot.builder().applyMutation(lexBot).build());
        }

        /**
         * <p>
         * The Amazon Lex V2 bot to associate with the instance.
         * </p>
         * 
         * @param lexV2Bot
         *        The Amazon Lex V2 bot to associate with the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lexV2Bot(LexV2Bot lexV2Bot);

        /**
         * <p>
         * The Amazon Lex V2 bot to associate with the instance.
         * </p>
         * This is a convenience that creates an instance of the {@link LexV2Bot.Builder} avoiding the need to create
         * one manually via {@link LexV2Bot#builder()}.
         *
         * When the {@link Consumer} completes, {@link LexV2Bot.Builder#build()} is called immediately and its result is
         * passed to {@link #lexV2Bot(LexV2Bot)}.
         * 
         * @param lexV2Bot
         *        a consumer that will call methods on {@link LexV2Bot.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lexV2Bot(LexV2Bot)
         */
        default Builder lexV2Bot(Consumer<LexV2Bot.Builder> lexV2Bot) {
            return lexV2Bot(LexV2Bot.builder().applyMutation(lexV2Bot).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private LexBot lexBot;

        private LexV2Bot lexV2Bot;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateBotRequest model) {
            super(model);
            instanceId(model.instanceId);
            lexBot(model.lexBot);
            lexV2Bot(model.lexV2Bot);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final LexBot.Builder getLexBot() {
            return lexBot != null ? lexBot.toBuilder() : null;
        }

        @Override
        public final Builder lexBot(LexBot lexBot) {
            this.lexBot = lexBot;
            return this;
        }

        public final void setLexBot(LexBot.BuilderImpl lexBot) {
            this.lexBot = lexBot != null ? lexBot.build() : null;
        }

        public final LexV2Bot.Builder getLexV2Bot() {
            return lexV2Bot != null ? lexV2Bot.toBuilder() : null;
        }

        @Override
        public final Builder lexV2Bot(LexV2Bot lexV2Bot) {
            this.lexV2Bot = lexV2Bot;
            return this;
        }

        public final void setLexV2Bot(LexV2Bot.BuilderImpl lexV2Bot) {
            this.lexV2Bot = lexV2Bot != null ? lexV2Bot.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateBotRequest build() {
            return new AssociateBotRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
