/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateQueueRequest extends ConnectRequest implements
        ToCopyableBuilder<CreateQueueRequest.Builder, CreateQueueRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(CreateQueueRequest::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateQueueRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateQueueRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<OutboundCallerConfig> OUTBOUND_CALLER_CONFIG_FIELD = SdkField
            .<OutboundCallerConfig> builder(MarshallingType.SDK_POJO).memberName("OutboundCallerConfig")
            .getter(getter(CreateQueueRequest::outboundCallerConfig)).setter(setter(Builder::outboundCallerConfig))
            .constructor(OutboundCallerConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutboundCallerConfig").build())
            .build();

    private static final SdkField<String> HOURS_OF_OPERATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HoursOfOperationId").getter(getter(CreateQueueRequest::hoursOfOperationId))
            .setter(setter(Builder::hoursOfOperationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HoursOfOperationId").build())
            .build();

    private static final SdkField<Integer> MAX_CONTACTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxContacts").getter(getter(CreateQueueRequest::maxContacts)).setter(setter(Builder::maxContacts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxContacts").build()).build();

    private static final SdkField<List<String>> QUICK_CONNECT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("QuickConnectIds")
            .getter(getter(CreateQueueRequest::quickConnectIds))
            .setter(setter(Builder::quickConnectIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuickConnectIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateQueueRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, OUTBOUND_CALLER_CONFIG_FIELD, HOURS_OF_OPERATION_ID_FIELD, MAX_CONTACTS_FIELD,
            QUICK_CONNECT_IDS_FIELD, TAGS_FIELD));

    private final String instanceId;

    private final String name;

    private final String description;

    private final OutboundCallerConfig outboundCallerConfig;

    private final String hoursOfOperationId;

    private final Integer maxContacts;

    private final List<String> quickConnectIds;

    private final Map<String, String> tags;

    private CreateQueueRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.name = builder.name;
        this.description = builder.description;
        this.outboundCallerConfig = builder.outboundCallerConfig;
        this.hoursOfOperationId = builder.hoursOfOperationId;
        this.maxContacts = builder.maxContacts;
        this.quickConnectIds = builder.quickConnectIds;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The name of the queue.
     * </p>
     * 
     * @return The name of the queue.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the queue.
     * </p>
     * 
     * @return The description of the queue.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The outbound caller ID name, number, and outbound whisper flow.
     * </p>
     * 
     * @return The outbound caller ID name, number, and outbound whisper flow.
     */
    public final OutboundCallerConfig outboundCallerConfig() {
        return outboundCallerConfig;
    }

    /**
     * <p>
     * The identifier for the hours of operation.
     * </p>
     * 
     * @return The identifier for the hours of operation.
     */
    public final String hoursOfOperationId() {
        return hoursOfOperationId;
    }

    /**
     * <p>
     * The maximum number of contacts that can be in the queue before it is considered full.
     * </p>
     * 
     * @return The maximum number of contacts that can be in the queue before it is considered full.
     */
    public final Integer maxContacts() {
        return maxContacts;
    }

    /**
     * Returns true if the QuickConnectIds property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasQuickConnectIds() {
        return quickConnectIds != null && !(quickConnectIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The quick connects available to agents who are working the queue.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasQuickConnectIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The quick connects available to agents who are working the queue.
     */
    public final List<String> quickConnectIds() {
        return quickConnectIds;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * One or more tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more tags.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(outboundCallerConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hoursOfOperationId());
        hashCode = 31 * hashCode + Objects.hashCode(maxContacts());
        hashCode = 31 * hashCode + Objects.hashCode(hasQuickConnectIds() ? quickConnectIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateQueueRequest)) {
            return false;
        }
        CreateQueueRequest other = (CreateQueueRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description())
                && Objects.equals(outboundCallerConfig(), other.outboundCallerConfig())
                && Objects.equals(hoursOfOperationId(), other.hoursOfOperationId())
                && Objects.equals(maxContacts(), other.maxContacts()) && hasQuickConnectIds() == other.hasQuickConnectIds()
                && Objects.equals(quickConnectIds(), other.quickConnectIds()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateQueueRequest").add("InstanceId", instanceId()).add("Name", name())
                .add("Description", description()).add("OutboundCallerConfig", outboundCallerConfig())
                .add("HoursOfOperationId", hoursOfOperationId()).add("MaxContacts", maxContacts())
                .add("QuickConnectIds", hasQuickConnectIds() ? quickConnectIds() : null).add("Tags", hasTags() ? tags() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "OutboundCallerConfig":
            return Optional.ofNullable(clazz.cast(outboundCallerConfig()));
        case "HoursOfOperationId":
            return Optional.ofNullable(clazz.cast(hoursOfOperationId()));
        case "MaxContacts":
            return Optional.ofNullable(clazz.cast(maxContacts()));
        case "QuickConnectIds":
            return Optional.ofNullable(clazz.cast(quickConnectIds()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateQueueRequest, T> g) {
        return obj -> g.apply((CreateQueueRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateQueueRequest> {
        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The name of the queue.
         * </p>
         * 
         * @param name
         *        The name of the queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the queue.
         * </p>
         * 
         * @param description
         *        The description of the queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The outbound caller ID name, number, and outbound whisper flow.
         * </p>
         * 
         * @param outboundCallerConfig
         *        The outbound caller ID name, number, and outbound whisper flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outboundCallerConfig(OutboundCallerConfig outboundCallerConfig);

        /**
         * <p>
         * The outbound caller ID name, number, and outbound whisper flow.
         * </p>
         * This is a convenience that creates an instance of the {@link OutboundCallerConfig.Builder} avoiding the need
         * to create one manually via {@link OutboundCallerConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link OutboundCallerConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #outboundCallerConfig(OutboundCallerConfig)}.
         * 
         * @param outboundCallerConfig
         *        a consumer that will call methods on {@link OutboundCallerConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outboundCallerConfig(OutboundCallerConfig)
         */
        default Builder outboundCallerConfig(Consumer<OutboundCallerConfig.Builder> outboundCallerConfig) {
            return outboundCallerConfig(OutboundCallerConfig.builder().applyMutation(outboundCallerConfig).build());
        }

        /**
         * <p>
         * The identifier for the hours of operation.
         * </p>
         * 
         * @param hoursOfOperationId
         *        The identifier for the hours of operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hoursOfOperationId(String hoursOfOperationId);

        /**
         * <p>
         * The maximum number of contacts that can be in the queue before it is considered full.
         * </p>
         * 
         * @param maxContacts
         *        The maximum number of contacts that can be in the queue before it is considered full.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxContacts(Integer maxContacts);

        /**
         * <p>
         * The quick connects available to agents who are working the queue.
         * </p>
         * 
         * @param quickConnectIds
         *        The quick connects available to agents who are working the queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quickConnectIds(Collection<String> quickConnectIds);

        /**
         * <p>
         * The quick connects available to agents who are working the queue.
         * </p>
         * 
         * @param quickConnectIds
         *        The quick connects available to agents who are working the queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quickConnectIds(String... quickConnectIds);

        /**
         * <p>
         * One or more tags.
         * </p>
         * 
         * @param tags
         *        One or more tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String name;

        private String description;

        private OutboundCallerConfig outboundCallerConfig;

        private String hoursOfOperationId;

        private Integer maxContacts;

        private List<String> quickConnectIds = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateQueueRequest model) {
            super(model);
            instanceId(model.instanceId);
            name(model.name);
            description(model.description);
            outboundCallerConfig(model.outboundCallerConfig);
            hoursOfOperationId(model.hoursOfOperationId);
            maxContacts(model.maxContacts);
            quickConnectIds(model.quickConnectIds);
            tags(model.tags);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final OutboundCallerConfig.Builder getOutboundCallerConfig() {
            return outboundCallerConfig != null ? outboundCallerConfig.toBuilder() : null;
        }

        @Override
        public final Builder outboundCallerConfig(OutboundCallerConfig outboundCallerConfig) {
            this.outboundCallerConfig = outboundCallerConfig;
            return this;
        }

        public final void setOutboundCallerConfig(OutboundCallerConfig.BuilderImpl outboundCallerConfig) {
            this.outboundCallerConfig = outboundCallerConfig != null ? outboundCallerConfig.build() : null;
        }

        public final String getHoursOfOperationId() {
            return hoursOfOperationId;
        }

        @Override
        public final Builder hoursOfOperationId(String hoursOfOperationId) {
            this.hoursOfOperationId = hoursOfOperationId;
            return this;
        }

        public final void setHoursOfOperationId(String hoursOfOperationId) {
            this.hoursOfOperationId = hoursOfOperationId;
        }

        public final Integer getMaxContacts() {
            return maxContacts;
        }

        @Override
        public final Builder maxContacts(Integer maxContacts) {
            this.maxContacts = maxContacts;
            return this;
        }

        public final void setMaxContacts(Integer maxContacts) {
            this.maxContacts = maxContacts;
        }

        public final Collection<String> getQuickConnectIds() {
            if (quickConnectIds instanceof SdkAutoConstructList) {
                return null;
            }
            return quickConnectIds;
        }

        @Override
        public final Builder quickConnectIds(Collection<String> quickConnectIds) {
            this.quickConnectIds = QuickConnectsListCopier.copy(quickConnectIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder quickConnectIds(String... quickConnectIds) {
            quickConnectIds(Arrays.asList(quickConnectIds));
            return this;
        }

        public final void setQuickConnectIds(Collection<String> quickConnectIds) {
            this.quickConnectIds = QuickConnectsListCopier.copy(quickConnectIds);
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateQueueRequest build() {
            return new CreateQueueRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
