/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisassociateRoutingProfileQueuesRequest extends ConnectRequest implements
        ToCopyableBuilder<DisassociateRoutingProfileQueuesRequest.Builder, DisassociateRoutingProfileQueuesRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(DisassociateRoutingProfileQueuesRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final SdkField<String> ROUTING_PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoutingProfileId").getter(getter(DisassociateRoutingProfileQueuesRequest::routingProfileId))
            .setter(setter(Builder::routingProfileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("RoutingProfileId").build()).build();

    private static final SdkField<List<RoutingProfileQueueReference>> QUEUE_REFERENCES_FIELD = SdkField
            .<List<RoutingProfileQueueReference>> builder(MarshallingType.LIST)
            .memberName("QueueReferences")
            .getter(getter(DisassociateRoutingProfileQueuesRequest::queueReferences))
            .setter(setter(Builder::queueReferences))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueReferences").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RoutingProfileQueueReference> builder(MarshallingType.SDK_POJO)
                                            .constructor(RoutingProfileQueueReference::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            ROUTING_PROFILE_ID_FIELD, QUEUE_REFERENCES_FIELD));

    private final String instanceId;

    private final String routingProfileId;

    private final List<RoutingProfileQueueReference> queueReferences;

    private DisassociateRoutingProfileQueuesRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.routingProfileId = builder.routingProfileId;
        this.queueReferences = builder.queueReferences;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The identifier of the routing profile.
     * </p>
     * 
     * @return The identifier of the routing profile.
     */
    public final String routingProfileId() {
        return routingProfileId;
    }

    /**
     * Returns true if the QueueReferences property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasQueueReferences() {
        return queueReferences != null && !(queueReferences instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The queues to disassociate from this routing profile.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasQueueReferences()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The queues to disassociate from this routing profile.
     */
    public final List<RoutingProfileQueueReference> queueReferences() {
        return queueReferences;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(routingProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(hasQueueReferences() ? queueReferences() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateRoutingProfileQueuesRequest)) {
            return false;
        }
        DisassociateRoutingProfileQueuesRequest other = (DisassociateRoutingProfileQueuesRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(routingProfileId(), other.routingProfileId())
                && hasQueueReferences() == other.hasQueueReferences()
                && Objects.equals(queueReferences(), other.queueReferences());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DisassociateRoutingProfileQueuesRequest").add("InstanceId", instanceId())
                .add("RoutingProfileId", routingProfileId())
                .add("QueueReferences", hasQueueReferences() ? queueReferences() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "RoutingProfileId":
            return Optional.ofNullable(clazz.cast(routingProfileId()));
        case "QueueReferences":
            return Optional.ofNullable(clazz.cast(queueReferences()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DisassociateRoutingProfileQueuesRequest, T> g) {
        return obj -> g.apply((DisassociateRoutingProfileQueuesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DisassociateRoutingProfileQueuesRequest> {
        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The identifier of the routing profile.
         * </p>
         * 
         * @param routingProfileId
         *        The identifier of the routing profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingProfileId(String routingProfileId);

        /**
         * <p>
         * The queues to disassociate from this routing profile.
         * </p>
         * 
         * @param queueReferences
         *        The queues to disassociate from this routing profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueReferences(Collection<RoutingProfileQueueReference> queueReferences);

        /**
         * <p>
         * The queues to disassociate from this routing profile.
         * </p>
         * 
         * @param queueReferences
         *        The queues to disassociate from this routing profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueReferences(RoutingProfileQueueReference... queueReferences);

        /**
         * <p>
         * The queues to disassociate from this routing profile.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RoutingProfileQueueReference>.Builder}
         * avoiding the need to create one manually via {@link List<RoutingProfileQueueReference>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RoutingProfileQueueReference>.Builder#build()} is called
         * immediately and its result is passed to {@link #queueReferences(List<RoutingProfileQueueReference>)}.
         * 
         * @param queueReferences
         *        a consumer that will call methods on {@link List<RoutingProfileQueueReference>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queueReferences(List<RoutingProfileQueueReference>)
         */
        Builder queueReferences(Consumer<RoutingProfileQueueReference.Builder>... queueReferences);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String routingProfileId;

        private List<RoutingProfileQueueReference> queueReferences = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateRoutingProfileQueuesRequest model) {
            super(model);
            instanceId(model.instanceId);
            routingProfileId(model.routingProfileId);
            queueReferences(model.queueReferences);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getRoutingProfileId() {
            return routingProfileId;
        }

        @Override
        public final Builder routingProfileId(String routingProfileId) {
            this.routingProfileId = routingProfileId;
            return this;
        }

        public final void setRoutingProfileId(String routingProfileId) {
            this.routingProfileId = routingProfileId;
        }

        public final List<RoutingProfileQueueReference.Builder> getQueueReferences() {
            List<RoutingProfileQueueReference.Builder> result = RoutingProfileQueueReferenceListCopier
                    .copyToBuilder(this.queueReferences);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder queueReferences(Collection<RoutingProfileQueueReference> queueReferences) {
            this.queueReferences = RoutingProfileQueueReferenceListCopier.copy(queueReferences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queueReferences(RoutingProfileQueueReference... queueReferences) {
            queueReferences(Arrays.asList(queueReferences));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queueReferences(Consumer<RoutingProfileQueueReference.Builder>... queueReferences) {
            queueReferences(Stream.of(queueReferences).map(c -> RoutingProfileQueueReference.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setQueueReferences(Collection<RoutingProfileQueueReference.BuilderImpl> queueReferences) {
            this.queueReferences = RoutingProfileQueueReferenceListCopier.copyFromBuilder(queueReferences);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisassociateRoutingProfileQueuesRequest build() {
            return new DisassociateRoutingProfileQueuesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
